/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.PackBitsDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.nio.ByteOrder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00011;Q!\u0001\u0002\t\u00025\tA\u0003U1dW\nKGo\u001d#fG>l\u0007O]3tg>\u0014(BA\u0002\u0005\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011aB4f_RLgM\u001a\u0006\u0003\u000f!\t!![8\u000b\u0005%Q\u0011A\u0002:bgR,'OC\u0001\f\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005Q\u0001\u0016mY6CSR\u001cH)Z2p[B\u0014Xm]:peN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\t\u0019\u0012$\u0003\u0002\u001b)\ta1+\u001a:jC2L'0\u00192mK\")Ad\u0004C\u0001;\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\u0006?=!\t\u0001I\u0001\u0006CB\u0004H.\u001f\u000b\u0003C\u0001\u0003\"A\u0004\u0012\u0007\tA\u0011\u0001aI\n\u0004EI!\u0003C\u0001\b&\u0013\t1#A\u0001\u0007EK\u000e|W\u000e\u001d:fgN|'\u000f\u0003\u0005)E\t\u0005\t\u0015!\u0003*\u00031\u0019XmZ7f]R\u001c\u0016N_3t!\r\u0019\"\u0006L\u0005\u0003WQ\u0011Q!\u0011:sCf\u0004\"aE\u0017\n\u00059\"\"aA%oi\")AD\tC\u0001aQ\u0011\u0011%\r\u0005\u0006Q=\u0002\r!\u000b\u0005\u0006g\t\"\t\u0001N\u0001\u0005G>$W-F\u0001-\u0011\u00151$\u0005\"\u00018\u0003)!WmY8naJ,7o\u001d\u000b\u0004qqr\u0004cA\n+sA\u00111CO\u0005\u0003wQ\u0011AAQ=uK\")Q(\u000ea\u0001q\u000591/Z4nK:$\b\"B 6\u0001\u0004a\u0013\u0001D:fO6,g\u000e^%oI\u0016D\b\"\u0002\u0015\u001f\u0001\u0004I\u0003b\u0002\"\u0010\u0003\u0003%IaQ\u0001\fe\u0016\fGMU3t_24X\rF\u0001E!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u0003mC:<'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013aa\u00142kK\u000e$\b")
public class PackBitsDecompressor
implements Decompressor {
    private final int[] segmentSizes;

    public static PackBitsDecompressor apply(int[] nArray) {
        return PackBitsDecompressor$.MODULE$.apply(nArray);
    }

    @Override
    public int predictorCode() {
        return Decompressor.predictorCode$(this);
    }

    @Override
    public ByteOrder byteOrder() {
        return Decompressor.byteOrder$(this);
    }

    @Override
    public Decompressor flipEndian(int bytesPerFlip) {
        return Decompressor.flipEndian$(this, bytesPerFlip);
    }

    @Override
    public Decompressor withPredictor(Predictor predictor) {
        return Decompressor.withPredictor$(this, predictor);
    }

    @Override
    public int code() {
        return CompressionType$.MODULE$.PackBitsCoded();
    }

    @Override
    public byte[] decompress(byte[] segment, int segmentIndex) {
        int size = this.segmentSizes[segmentIndex];
        byte[] rowArray = new byte[size];
        int j = 0;
        int total = 0;
        int len = segment.length;
        while (total != size && j < len) {
            byte headerByte = segment[j];
            ++j;
            if (0 <= headerByte) {
                int limit = total + headerByte + 1;
                while (total < limit) {
                    rowArray[total] = segment[j];
                    ++total;
                    ++j;
                }
                continue;
            }
            if (-128 >= headerByte || headerByte >= 0) continue;
            byte b = segment[j];
            ++j;
            int limit = total + (1 - headerByte);
            while (total < limit) {
                rowArray[total] = b;
                ++total;
            }
        }
        return rowArray;
    }

    public PackBitsDecompressor(int[] segmentSizes) {
        this.segmentSizes = segmentSizes;
        Decompressor.$init$(this);
    }
}

