/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.reader;

import geotrellis.proj4.CSVFileConstants$;
import geotrellis.proj4.EPSGCSVReader;
import geotrellis.proj4.EPSGCSVReader$;
import geotrellis.raster.io.geotiff.reader.GeoTiffCSParameters;
import geotrellis.raster.io.geotiff.reader.GeoTiffCSParameters$;
import geotrellis.raster.io.geotiff.reader.GeoTiffCSParser$;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.tags.AngularUnitTypes$;
import geotrellis.raster.io.geotiff.tags.CommonPublicValues$;
import geotrellis.raster.io.geotiff.tags.ConfigKeys$;
import geotrellis.raster.io.geotiff.tags.CoordinateTransformTypes$;
import geotrellis.raster.io.geotiff.tags.DatumTypes$;
import geotrellis.raster.io.geotiff.tags.EPSGProjectionTypes$;
import geotrellis.raster.io.geotiff.tags.EllipsoidTypes$;
import geotrellis.raster.io.geotiff.tags.GDALEPSGProjectionTypes$;
import geotrellis.raster.io.geotiff.tags.GeoKeyDirectory;
import geotrellis.raster.io.geotiff.tags.GeoKeyDirectory$;
import geotrellis.raster.io.geotiff.tags.GeoKeys$;
import geotrellis.raster.io.geotiff.tags.GeogCSParameterKeys$;
import geotrellis.raster.io.geotiff.tags.GeographicCSTypes$;
import geotrellis.raster.io.geotiff.tags.MapSystems$;
import geotrellis.raster.io.geotiff.tags.ModelTypes$;
import geotrellis.raster.io.geotiff.tags.PrimeMeridianTypes$;
import geotrellis.raster.io.geotiff.tags.ProjectedCSParameterKeys$;
import geotrellis.raster.io.geotiff.tags.ProjectedFalsings$;
import geotrellis.raster.io.geotiff.tags.ProjectedLinearUnits$;
import geotrellis.raster.io.geotiff.tags.ProjectionTypesMap$;
import java.io.Serializable;
import monocle.syntax.apply$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Unit$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ew!B\u0001\u0003\u0011\u0003i\u0011aD$f_RKgMZ\"T!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011A\u0002:fC\u0012,'O\u0003\u0002\u0006\r\u00059q-Z8uS\u001a4'BA\u0004\t\u0003\tIwN\u0003\u0002\n\u0015\u00051!/Y:uKJT\u0011aC\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003\u001d=i\u0011A\u0001\u0004\u0006!\tA\t!\u0005\u0002\u0010\u000f\u0016|G+\u001b4g\u0007N\u0003\u0016M]:feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001\"\u0002\u000f\u0010\t\u0003i\u0012!B1qa2LHc\u0001\u0010\u0002NB\u0011ab\b\u0004\u0005!\t\u0001\u0001e\u0005\u0002 %!A!e\bB\u0001B\u0003%1%A\bhK>\\U-\u001f#je\u0016\u001cGo\u001c:z!\t!s%D\u0001&\u0015\t1C!\u0001\u0003uC\u001e\u001c\u0018B\u0001\u0015&\u0005=9Um\\&fs\u0012K'/Z2u_JL\b\"B\r \t\u0003QCC\u0001\u0010,\u0011\u0015\u0011\u0013\u00061\u0001$\u0011\u001disD1A\u0005\n9\n\u0011bY:w%\u0016\fG-\u001a:\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0006\u0002\u000bA\u0014xN\u001b\u001b\n\u0005Q\n$!D#Q'\u001e\u001b5K\u0016*fC\u0012,'\u000f\u0003\u00047?\u0001\u0006IaL\u0001\u000bGN4(+Z1eKJ\u0004\u0003\"\u0002\u001d \t\u0003I\u0014AD4fiB\u0013xN\u001b\u001bTiJLgnZ\u000b\u0002uA\u00191cO\u001f\n\u0005q\"\"AB(qi&|g\u000e\u0005\u0002?\u000b:\u0011qh\u0011\t\u0003\u0001Ri\u0011!\u0011\u0006\u0003\u00052\ta\u0001\u0010:p_Rt\u0014B\u0001#\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011#\u0002\u0002C% \u0011\u000b\u0007I\u0011\u0001&\u0002'\u001d,w\u000eV5gM\u000e\u001b\u0006+\u0019:b[\u0016$XM]:\u0016\u0003-\u0003\"A\u0004'\n\u00055\u0013!aE$f_RKgMZ\"T!\u0006\u0014\u0018-\\3uKJ\u001c\b\"B( \t\u0003\u0001\u0016!B7pI\u0016dW#A)\u0011\u0005M\u0011\u0016BA*\u0015\u0005\rIe\u000e\u001e\u0005\u0006+~!\t\u0001U\u0001\u0004a\u000e\u001c\b\"B, \t\u0003\u0001\u0016aA4dg\")\u0011l\bC\u0005\u0015\u0006I2M]3bi\u0016<Um\u001c+jM\u001a\u001c5\u000bU1sC6,G/\u001a:t\u0011\u0015Yv\u0004\"\u0003]\u0003)9W\r\u001e)D'\u0012\u000bG/\u0019\u000b\u0004;\u0002\f\u0007CA\n_\u0013\tyFC\u0001\u0003V]&$\b\"B+[\u0001\u0004\t\u0006\"\u00022[\u0001\u0004Y\u0015\u0001B4uOBDQ\u0001Z\u0010\u0005\n\u0015\f!\u0004]2t)>$\u0015\r^;n5>tW-\u00118e\u001b\u0006\u00048+_:uK6$\"A\u001a6\u0011\u000bM9\u0017.[5\n\u0005!$\"A\u0002+va2,7\u0007E\u0002\u0014wECQ!V2A\u0002ECQ\u0001\\\u0010\u0005\n5\fQ#\\1q'f\u001cH/Z7U_B\u0013xN[3di&|g\u000eF\u0002R]BDQa\\6A\u0002E\u000b\u0011\"\\1q'f\u001cH/Z7\t\u000bE\\\u0007\u0019A)\u0002\ti|g.\u001a\u0005\u0006g~!I\u0001^\u0001$O\u0016$\bK]8kK\u000e$\u0018n\u001c8Ge>lGK]1og\u001a|'/\\1uS>t7i\u001c3f)\r)\u0018\u0011\u0001\t\u0005'YL\u00070\u0003\u0002x)\t1A+\u001e9mKJ\u00022aE\u001ez!\r\u0019\"\u0010`\u0005\u0003wR\u0011Q!\u0011:sCf\u0004Ba\u0005<R{B\u00111C`\u0005\u0003\u007fR\u0011a\u0001R8vE2,\u0007BBA\u0002e\u0002\u0007\u0011+A\u0004ue\u001a\u001cu\u000eZ3\t\u000f\u0005\u001dq\u0004\"\u0003\u0002\n\u0005aR\r]:h!J|'.T3uQ>$Gk\\\"U!J|'.T3uQ>$GcA)\u0002\f!9\u0011QBA\u0003\u0001\u0004\t\u0016\u0001B3qg\u001eDq!!\u0005 \t\u0013\t\u0019\"\u0001\rtKR<E\u000bU1sC6,G/\u001a:JI\u0016tG/\u001b;jKN$b!!\u0006\u0002\u001c\u0005}\u0001cA\n\u0002\u0018%\u0019\u0011\u0011\u0004\u000b\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u001e\u0005=\u0001\u0019A)\u0002\u0019\r$\bK]8kK\u000e$\u0018n\u001c8\t\u000f\u0005\u0005\u0012q\u0002a\u0001s\u0006I\u0001O]8k!\u0006\u0014Xn\u001d\u0005\b\u0003KyB\u0011BA\u0014\u0003E9W\r\u001e,bYV,\u0017J\u001a(pi:+H\u000e\u001c\u000b\u0004{\u0006%\u0002bBA\u0016\u0003G\u0001\r\u0001`\u0001\u0006iV\u0004H.\u001a\u0005\b\u0003_yB\u0011BA\u0019\u0003)9W\r^$D'&sgm\u001c\u000b\u0004M\u0006M\u0002BB,\u0002.\u0001\u0007\u0011\u000bC\u0004\u00028}!I!!\u000f\u0002\u0019\u001d,G/\u00118hY\u0016LeNZ8\u0015\t\u0005m\u0012Q\b\t\u0004'mj\bbBA \u0003k\u0001\r!U\u0001\nC:<G.Z\"pI\u0016Dq!a\u0011 \t\u0013\t)%\u0001\u0007hKR$\u0015\r^;n\u0013:4w\u000eF\u0002j\u0003\u000fBq!!\u0013\u0002B\u0001\u0007\u0011+A\u0003eCR,X\u000eC\u0004\u0002N}!I!a\u0014\u0002\u001bM,W.['j]>\u00148i\\7q)\u0015i\u0018\u0011KA+\u0011\u001d\t\u0019&a\u0013A\u0002u\f\u0011b]3nS6\u000b'n\u001c:\t\u000f\u0005]\u00131\na\u0001{\u0006i\u0011N\u001c<GY\u0006$H/\u001a8j]\u001eDq!a\u0017 \t\u0013\ti&\u0001\thKR,E\u000e\\5qg>LG-\u00138g_R!\u0011qLA1!\u0019\u0019b/a\u000f\u0002<!9\u00111MA-\u0001\u0004\t\u0016!C3mY&\u00048o\\5e\u0011\u001d\t9g\bC\u0005\u0003S\nQbZ3u\u0019\u0016tw\r\u001e5J]\u001a|G\u0003BA\u001e\u0003WBq!!\u001c\u0002f\u0001\u0007\u0011+\u0001\u0006mK:<G\u000f[\"pI\u0016Dq!!\u001d \t\u0013\t\u0019(\u0001\u000bhKR\u0004&/[7f\u001b\u0016\u0014\u0018\u000eZ5b]&sgm\u001c\u000b\u0005\u0003w\t)\bC\u0004\u0002x\u0005=\u0004\u0019A)\u0002\u0005Al\u0007bBA>?\u0011%\u0011QP\u0001\u0010C:<G.Z*ue&tw\rV8E\tR)Q0a \u0002\u0004\"9\u0011\u0011QA=\u0001\u0004i\u0014aC1oO2,7\u000b\u001e:j]\u001eDq!a\u0010\u0002z\u0001\u0007\u0011\u000bC\u0004\u0002\b~!I!!#\u0002\u0013\u0005tw\r\\3U_\u0012#E#B?\u0002\f\u0006=\u0005bBAG\u0003\u000b\u0003\r!`\u0001\u0006C:<G.\u001a\u0005\b\u0003\u007f\t)\t1\u0001R\u0011\u001d\t\u0019j\bC\u0005\u0003+\u000bqc]3u!J|'.Z2uS>t\u0007+\u0019:b[\u0016$XM]:\u0015\u0007u\u000b9\n\u0003\u0004c\u0003#\u0003\ra\u0013\u0005\b\u00037{B\u0011BAO\u0003E9W\r^(qi\u0012{WO\u00197f-\u0006dW/\u001a\u000b\u0006{\u0006}\u0015Q\u0017\u0005\t\u0003C\u000bI\n1\u0001\u0002$\u0006!q\u000e\u001d;t!\u0019\t)+a,\u0002<9!\u0011qUAV\u001d\r\u0001\u0015\u0011V\u0005\u0002+%\u0019\u0011Q\u0016\u000b\u0002\u000fA\f7m[1hK&!\u0011\u0011WAZ\u0005\u0011a\u0015n\u001d;\u000b\u0007\u00055F\u0003C\u0004\u00028\u0006e\u0005\u0019A?\u0002\u000f\u0011,g-Y;mi\"9\u00111X\u0010\u0005\n\u0005u\u0016aE4fi6\u000b\u0007oU=ti\u0016l\u0017I\u001c3[_:,G\u0003BA`\u0003\u0007\u0004BaE\u001e\u0002BB!1C^)R\u0011\u001d\t)-!/A\u0002E\u000b\u0001\u0002\u001d:pU\u000e{G-\u001a\u0005\u0007q}!I!!3\u0015\u0007i\nY\r\u0003\u0004c\u0003\u000f\u0004\ra\u0013\u0005\u0007\u0003\u001f\\\u0002\u0019A\u0012\u0002\u0013\u0011L'/Z2u_JL\b")
public class GeoTiffCSParser {
    private GeoTiffCSParameters geoTiffCSParameters;
    private final GeoKeyDirectory geoKeyDirectory;
    private final EPSGCSVReader csvReader;
    private volatile boolean bitmap$0;

    public static GeoTiffCSParser apply(GeoKeyDirectory geoKeyDirectory) {
        return GeoTiffCSParser$.MODULE$.apply(geoKeyDirectory);
    }

    private EPSGCSVReader csvReader() {
        return this.csvReader;
    }

    public Option<String> getProj4String() {
        return this.getProj4String(this.geoTiffCSParameters());
    }

    private GeoTiffCSParameters geoTiffCSParameters$lzycompute() {
        GeoTiffCSParser geoTiffCSParser = this;
        synchronized (geoTiffCSParser) {
            if (!this.bitmap$0) {
                this.geoTiffCSParameters = this.createGeoTiffCSParameters();
                this.bitmap$0 = true;
            }
        }
        return this.geoTiffCSParameters;
    }

    public GeoTiffCSParameters geoTiffCSParameters() {
        return !this.bitmap$0 ? this.geoTiffCSParameters$lzycompute() : this.geoTiffCSParameters;
    }

    public int model() {
        return this.geoTiffCSParameters().model();
    }

    public int pcs() {
        return this.geoTiffCSParameters().pcs();
    }

    public int gcs() {
        return this.geoTiffCSParameters().gcs();
    }

    private GeoTiffCSParameters createGeoTiffCSParameters() {
        Unit$ unit$;
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<Object, Object>> option;
        Object object;
        int n;
        int n2;
        GeoTiffCSParameters gtgp = new GeoTiffCSParameters(GeoTiffCSParameters$.MODULE$.apply$default$1(), GeoTiffCSParameters$.MODULE$.apply$default$2(), GeoTiffCSParameters$.MODULE$.apply$default$3(), GeoTiffCSParameters$.MODULE$.apply$default$4(), GeoTiffCSParameters$.MODULE$.apply$default$5(), GeoTiffCSParameters$.MODULE$.apply$default$6(), GeoTiffCSParameters$.MODULE$.apply$default$7(), GeoTiffCSParameters$.MODULE$.apply$default$8(), GeoTiffCSParameters$.MODULE$.apply$default$9(), GeoTiffCSParameters$.MODULE$.apply$default$10(), GeoTiffCSParameters$.MODULE$.apply$default$11(), GeoTiffCSParameters$.MODULE$.apply$default$12(), GeoTiffCSParameters$.MODULE$.apply$default$13(), GeoTiffCSParameters$.MODULE$.apply$default$14(), GeoTiffCSParameters$.MODULE$.apply$default$15(), GeoTiffCSParameters$.MODULE$.apply$default$16(), GeoTiffCSParameters$.MODULE$.apply$default$17(), GeoTiffCSParameters$.MODULE$.apply$default$18(), GeoTiffCSParameters$.MODULE$.apply$default$19(), GeoTiffCSParameters$.MODULE$.apply$default$20());
        int n3 = BoxesRunTime.unboxToInt((Object)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._configKeys()).$up$bar$minus$greater(ConfigKeys$.MODULE$._gtModelType()).get());
        switch (n3) {
            case -1: {
                n2 = CommonPublicValues$.MODULE$.UserDefinedCPV();
                break;
            }
            default: {
                n2 = n3;
                break;
            }
        }
        gtgp.model_$eq(n2);
        int linearUnits = BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogLinearUnits()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 9001));
        int n4 = BoxesRunTime.unboxToInt((Object)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projectedCSType()).get());
        switch (n4) {
            default: 
        }
        if (n4 != -1 && n4 != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            this.getPCSData(n4, gtgp);
            n = n4;
        } else {
            n = CommonPublicValues$.MODULE$.UserDefinedCPV();
        }
        gtgp.pcs_$eq(n);
        if (gtgp.pcs() != CommonPublicValues$.MODULE$.UserDefinedCPV() && gtgp.projCode() == CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            Tuple3<Option<Object>, Option<Object>, Option<Object>> tuple3 = this.pcsToDatumZoneAndMapSystem(gtgp.pcs());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Option optDatum = (Option)tuple3._1();
            Option optZone = (Option)tuple3._2();
            Option optMapSystem = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)optDatum, (Object)optZone, (Object)optMapSystem);
            Tuple3 tuple33 = tuple32;
            Option optDatum2 = (Option)tuple33._1();
            Option optZone2 = (Option)tuple33._2();
            Option optMapSystem2 = (Option)tuple33._3();
            gtgp.zone_$eq(BoxesRunTime.unboxToInt((Object)optZone2.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.zone())));
            if (!optMapSystem2.isEmpty()) {
                gtgp.projCode_$eq(this.mapSystemToProjection(BoxesRunTime.unboxToInt((Object)optMapSystem2.get()), gtgp.zone()));
                gtgp.gcs_$eq(BoxesRunTime.unboxToInt((Object)optDatum2.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.gcs())));
            }
        }
        if (gtgp.projCode() == CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            gtgp.projCode_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projection()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.projCode())));
        }
        if (gtgp.projCode() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            int n5;
            Tuple2<Option<Object>, Option<Tuple2<Object, Object>[]>> tuple22 = this.getProjectionFromTransformationCode(gtgp.projCode());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Option optProjection = (Option)tuple22._1();
            Option optProjectionParameters = (Option)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)optProjection, (Object)optProjectionParameters);
            Tuple2 tuple24 = tuple23;
            Option optProjection2 = (Option)tuple24._1();
            Option optProjectionParameters2 = (Option)tuple24._2();
            Option option2 = optProjection2;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                int projection = BoxesRunTime.unboxToInt((Object)some2.value());
                n5 = this.epsgProjMethodToCTProjMethod(projection);
            } else if (None$.MODULE$.equals(option2)) {
                n5 = gtgp.ctProjection();
            } else {
                throw new MatchError((Object)option2);
            }
            gtgp.ctProjection_$eq(n5);
            gtgp.projectionParameters_$eq((Tuple2<Object, Object>[])(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gtgp.projectionParameters())).size() == 0 ? (Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)) : gtgp.projectionParameters()));
            object = this.setGTParameterIdentities(gtgp.ctProjection(), gtgp.projectionParameters());
        } else {
            object = BoxedUnit.UNIT;
        }
        gtgp.gcs_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogType()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.gcs())));
        if (gtgp.gcs() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            Tuple3<Option<Object>, Option<Object>, Option<Object>> tuple3 = this.getGCSInfo(gtgp.gcs());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Option optPm = (Option)tuple3._1();
            Option optAngle = (Option)tuple3._2();
            Option optDatum = (Option)tuple3._3();
            Tuple3 tuple34 = new Tuple3((Object)optPm, (Object)optAngle, (Object)optDatum);
            Tuple3 tuple35 = tuple34;
            Option optPm2 = (Option)tuple35._1();
            Option optAngle2 = (Option)tuple35._2();
            Option optDatum3 = (Option)tuple35._3();
            gtgp.pm_$eq(BoxesRunTime.unboxToInt((Object)optPm2.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.pm())));
            gtgp.angle_$eq(BoxesRunTime.unboxToInt((Object)optAngle2.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.angle())));
            gtgp.datum_$eq(BoxesRunTime.unboxToInt((Object)optDatum3.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.datum())));
        }
        gtgp.angle_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogAngularUnits()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.angle())));
        if (gtgp.angle() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            Option<Object> optAngleInDegrees = this.getAngleInfo(gtgp.angle());
            gtgp.angleInDegrees_$eq(BoxesRunTime.unboxToDouble((Object)optAngleInDegrees.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> CommonPublicValues$.MODULE$.UserDefinedCPV())));
        }
        gtgp.datum_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogGeodeticDatum()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.datum())));
        if (gtgp.datum() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            gtgp.ellipsoid_$eq(BoxesRunTime.unboxToInt((Object)this.getDatumInfo(gtgp.datum()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.ellipsoid())));
        }
        gtgp.ellipsoid_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogEllipsoid()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.ellipsoid())));
        if (gtgp.ellipsoid() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            Tuple2<Option<Object>, Option<Object>> tuple25 = this.getEllipsoidInfo(gtgp.ellipsoid());
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            Option optSemiMajor = (Option)tuple25._1();
            Option optSemiMinor = (Option)tuple25._2();
            Tuple2 tuple26 = new Tuple2((Object)optSemiMajor, (Object)optSemiMinor);
            Tuple2 tuple27 = tuple26;
            Option optSemiMajor2 = (Option)tuple27._1();
            Option optSemiMinor2 = (Option)tuple27._2();
            gtgp.semiMajor_$eq(BoxesRunTime.unboxToDouble((Object)optSemiMajor2.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.semiMajor())));
            gtgp.semiMinor_$eq(BoxesRunTime.unboxToDouble((Object)optSemiMinor2.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.semiMinor())));
        } else {
            Some some3;
            String s;
            Some some4;
            Option option3;
            Option option4 = ((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogCitation()).get()).map((Function1 & Serializable & scala.Serializable)x -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("Ellipsoid")))).map((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).headOption());
            int n6 = option4 instanceof Some && (option3 = (Option)(some4 = (Some)option4).value()) instanceof Some ? ((s = (String)(some3 = (Some)option3).value()).contains("International") ? 7022 : CommonPublicValues$.MODULE$.UserDefinedCPV()) : CommonPublicValues$.MODULE$.UserDefinedCPV();
            gtgp.ellipsoid_$eq(n6);
        }
        gtgp.semiMajor_$eq(BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogSemiMajorAxis()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.semiMajor())));
        gtgp.semiMinor_$eq(BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogSemiMinorAxis()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.semiMinor())));
        Option optInvFlattening = (Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogInvFlattening()).get();
        if (!optInvFlattening.isEmpty()) {
            double invFlattening = BoxesRunTime.unboxToDouble((Object)optInvFlattening.get());
            gtgp.semiMinor_$eq(invFlattening != 0.0 ? this.semiMinorComp(gtgp.semiMajor(), invFlattening) : gtgp.semiMajor());
        }
        gtgp.pm_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogPrimeMeridian()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.pm())));
        if (gtgp.pm() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            Option<Object> optPMLongToGreenwich = this.getPrimeMeridianInfo(gtgp.pm());
            gtgp.pmLongToGreenwich_$eq(BoxesRunTime.unboxToDouble((Object)optPMLongToGreenwich.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.pmLongToGreenwich())));
        } else {
            gtgp.pmLongToGreenwich_$eq(BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._geogCSParameterKeys()).$up$bar$minus$greater(GeogCSParameterKeys$.MODULE$._geogPrimeMeridianLong()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.pmLongToGreenwich())));
            gtgp.pmLongToGreenwich_$eq(this.angleToDD(gtgp.pmLongToGreenwich(), gtgp.angle()));
        }
        gtgp.length_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projLinearUnits()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CommonPublicValues$.MODULE$.UserDefinedCPV())));
        if (gtgp.length() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            Option<Object> optLengthInMeters = this.getLengthInfo(gtgp.length());
            gtgp.lengthInMeters_$eq(BoxesRunTime.unboxToDouble((Object)optLengthInMeters.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.lengthInMeters())));
        } else {
            gtgp.lengthInMeters_$eq(BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projLinearUnitSize()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> gtgp.lengthInMeters())));
        }
        gtgp.ctProjection_$eq(BoxesRunTime.unboxToInt((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projCoordTrans()).get()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> gtgp.ctProjection())));
        if (gtgp.ctProjection() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            this.setProjectionParameters(gtgp);
        }
        if ((option = this.getMapSystemAndZone(gtgp.projCode())) instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            int mapSystem = tuple2._1$mcI$sp();
            int zone = tuple2._2$mcI$sp();
            gtgp.zone_$eq(zone);
            gtgp.mapSystem_$eq(mapSystem);
            unit$ = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            unit$ = Unit$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        if ((gtgp.mapSystem() == MapSystems$.MODULE$.MapSys_UTM_North() || gtgp.mapSystem() == MapSystems$.MODULE$.MapSys_UTM_South()) && gtgp.ctProjection() == CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            gtgp.ctProjection_$eq(CoordinateTransformTypes$.MODULE$.CT_TransverseMercator());
            gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
            gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), 0.0);
            gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), (double)(gtgp.zone() * 6) - 183.0);
            gtgp.projectionParameters()[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), 0.9996);
            gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), 500000.0);
            gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), gtgp.mapSystem() == MapSystems$.MODULE$.MapSys_UTM_North() ? 0.0 : 1.0E7);
        }
        gtgp.pcsCitation_$eq((Option<String>)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._pcsCitation()).get()).map((Function1 & Serializable & scala.Serializable)strings -> strings[0]));
        return gtgp;
    }

    /*
     * Unable to fully structure code
     */
    private void getPCSData(int pcs, GeoTiffCSParameters gtgp) {
        block27: {
            block21: {
                block23: {
                    block26: {
                        block25: {
                            block24: {
                                block22: {
                                    var11_3 = this.pcsToDatumZoneAndMapSystem(pcs);
                                    if (var11_3 == null) {
                                        throw new MatchError(var11_3);
                                    }
                                    optDatum = (Option)var11_3._1();
                                    optZone = (Option)var11_3._2();
                                    optMapSystem = (Option)var11_3._3();
                                    var9_7 = new Tuple3((Object)optDatum, (Object)optZone, (Object)optMapSystem);
                                    var10_8 = var9_7;
                                    optDatum = (Option)var10_8._1();
                                    optZone = (Option)var10_8._2();
                                    var19_12 = optMapSystem = (Option)var10_8._3();
                                    if (!(var19_12 instanceof Some) || (mapSystem = BoxesRunTime.unboxToInt((Object)(var20_13 = (Some)var19_12).value())) != MapSystems$.MODULE$.MapSys_UTM_North() && mapSystem != MapSystems$.MODULE$.MapSys_UTM_South()) break block21;
                                    var22_15 = false;
                                    var23_16 = null;
                                    var24_17 = optDatum;
                                    if (!(var24_17 instanceof Some)) break block22;
                                    var22_15 = true;
                                    var23_16 = (Some)var24_17;
                                    var25_18 = BoxesRunTime.unboxToInt((Object)var23_16.value());
                                    if (GeographicCSTypes$.MODULE$.GCS_NAD27() != var25_18) break block22;
                                    var8_19 = new Some((Object)"NAD27");
                                    break block23;
                                }
                                if (!var22_15) break block24;
                                var26_20 = BoxesRunTime.unboxToInt((Object)var23_16.value());
                                if (GeographicCSTypes$.MODULE$.GCS_NAD83() != var26_20) break block24;
                                var8_19 = new Some((Object)"NAD83");
                                break block23;
                            }
                            if (!var22_15) break block25;
                            var27_21 = BoxesRunTime.unboxToInt((Object)var23_16.value());
                            if (GeographicCSTypes$.MODULE$.GCS_WGS_72() != var27_21) break block25;
                            var8_19 = new Some((Object)"WGS 72");
                            break block23;
                        }
                        if (!var22_15) break block26;
                        var28_22 = BoxesRunTime.unboxToInt((Object)var23_16.value());
                        if (GeographicCSTypes$.MODULE$.GCS_WGS_72BE() != var28_22) break block26;
                        var8_19 = new Some((Object)"WGS 72BE");
                        break block23;
                    }
                    if (!var22_15) ** GOTO lbl-1000
                    var29_23 = BoxesRunTime.unboxToInt((Object)var23_16.value());
                    if (GeographicCSTypes$.MODULE$.GCS_WGS_84() == var29_23) {
                        var8_19 = new Some((Object)"WGS 84");
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_19 = None$.MODULE$;
                    }
                }
                var7_24 = var8_19;
                break block27;
            }
            var7_24 = None$.MODULE$;
        }
        var30_26 = optDatumName = var7_24;
        if (var30_26 instanceof Some) {
            mapSystem = BoxesRunTime.unboxToInt((Object)optMapSystem.get());
            mapSystemValue = mapSystem == MapSystems$.MODULE$.MapSys_UTM_North() ? GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1N() : GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1S();
            gtgp.projCode_$eq(mapSystemValue - 1 + BoxesRunTime.unboxToInt((Object)optZone.get()));
            gtgp.length_$eq(ProjectedLinearUnits$.MODULE$.LinearMeterCode());
            gtgp.gcs_$eq(BoxesRunTime.unboxToInt((Object)optDatum.get()));
            var3_29 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(var30_26)) {
            optValueMap = this.csvReader().getPCVEPSGValues(pcs);
            if (!optValueMap.isEmpty()) {
                valueMap = (Map)optValueMap.get();
                var35_33 = valueMap.get((Object)CSVFileConstants$.MODULE$.UOMCode());
                if (var35_33 instanceof Some) {
                    var36_34 = (Some)var35_33;
                    v = (String)var36_34.value();
                    var6_36 = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                } else if (None$.MODULE$.equals(var35_33)) {
                    var6_36 = gtgp.length();
                } else {
                    throw new MatchError((Object)var35_33);
                }
                gtgp.length_$eq(var6_36);
                var38_37 = valueMap.get((Object)CSVFileConstants$.MODULE$.CoordOpCode());
                if (var38_37 instanceof Some && new StringOps(Predef$.MODULE$.augmentString(v = (String)(var39_38 = (Some)var38_37).value())).toInt() > 0) {
                    gtgp.projCode_$eq(new StringOps(Predef$.MODULE$.augmentString(v)).toInt());
                    var5_40 = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(var38_37)) {
                    gtgp.length_$eq(CommonPublicValues$.MODULE$.UserDefinedCPV());
                    var5_41 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)var38_37);
                }
                var41_42 = valueMap.get((Object)CSVFileConstants$.MODULE$.SourceGeoCRSCode());
                if (var41_42 instanceof Some && new StringOps(Predef$.MODULE$.augmentString(v = (String)(var42_43 = (Some)var41_42).value())).toInt() > 0) {
                    gtgp.gcs_$eq(new StringOps(Predef$.MODULE$.augmentString(v)).toInt());
                    var4_45 = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(var41_42)) {
                    gtgp.gcs_$eq(CommonPublicValues$.MODULE$.UserDefinedCPV());
                    var4_46 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)var41_42);
                }
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
            var3_30 = v0;
        } else {
            throw new MatchError((Object)var30_26);
        }
    }

    private Tuple3<Option<Object>, Option<Object>, Option<Object>> pcsToDatumZoneAndMapSystem(int pcs) {
        Tuple3 tuple3;
        Tuple3 tuple32 = pcs >= EPSGProjectionTypes$.MODULE$.PCS_NAD27_UTM_zone_3N() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_NAD27_UTM_zone_22N() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_NAD27())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_North())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_NAD27_UTM_zone_3N() + 3)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_NAD83_UTM_zone_3N() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_NAD83_UTM_zone_23N() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_NAD83())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_North())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_NAD83_UTM_zone_3N() + 3)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_WGS72_UTM_zone_1N() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_WGS72_UTM_zone_60N() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_WGS_72())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_North())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_WGS72_UTM_zone_1N() + 1)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_WGS72_UTM_zone_1S() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_WGS72_UTM_zone_60S() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_WGS_72())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_South())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_WGS72_UTM_zone_1S() + 1)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_WGS72BE_UTM_zone_1N() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_WGS72BE_UTM_zone_60N() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_WGS_72BE())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_North())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_WGS72BE_UTM_zone_1N() + 1)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_WGS72BE_UTM_zone_1S() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_WGS72BE_UTM_zone_60S() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_WGS_72BE())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_South())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_WGS72BE_UTM_zone_1S() + 1)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_WGS84_UTM_zone_1N() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_WGS84_UTM_zone_60N() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_WGS_84())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_North())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_WGS84_UTM_zone_1N() + 1)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_WGS84_UTM_zone_1S() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_WGS84_UTM_zone_60S() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)GeographicCSTypes$.MODULE$.GCS_WGS_84())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_South())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_WGS84_UTM_zone_1S() + 1)))) : (pcs >= EPSGProjectionTypes$.MODULE$.PCS_SAD69_UTM_zone_18N() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_SAD69_UTM_zone_22N() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)CommonPublicValues$.MODULE$.UserDefinedCPV())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_North())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_SAD69_UTM_zone_18N() + 18)))) : (tuple3 = pcs >= EPSGProjectionTypes$.MODULE$.PCS_SAD69_UTM_zone_17S() && pcs <= EPSGProjectionTypes$.MODULE$.PCS_SAD69_UTM_zone_25S() ? new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)CommonPublicValues$.MODULE$.UserDefinedCPV())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_UTM_South())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)(pcs - EPSGProjectionTypes$.MODULE$.PCS_SAD69_UTM_zone_17S() + 17)))) : new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$))))))))));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option optDatum = (Option)tuple3._1();
        Option optMapSystem = (Option)tuple3._2();
        Option optZone = (Option)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)optDatum, (Object)optMapSystem, (Object)optZone);
        Tuple3 tuple34 = tuple33;
        Option optDatum2 = (Option)tuple34._1();
        Option optMapSystem2 = (Option)tuple34._2();
        Option optZone2 = (Option)tuple34._3();
        int newPCS = BoxesRunTime.unboxToInt((Object)ProjectionTypesMap$.MODULE$.projectionTypesMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)pcs), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> pcs));
        if (newPCS <= 15900 && newPCS >= 10000) {
            if (newPCS % 100 >= 30) {
                optMapSystem2 = new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_State_Plane_83()));
                optDatum2 = new Some((Object)BoxesRunTime.boxToInteger((int)DatumTypes$.MODULE$.Datum_North_American_Datum_1983()));
                optZone2 = new Some((Object)BoxesRunTime.boxToInteger((int)(newPCS - 10000)));
            } else {
                optMapSystem2 = new Some((Object)BoxesRunTime.boxToInteger((int)MapSystems$.MODULE$.MapSys_State_Plane_27()));
                optDatum2 = new Some((Object)BoxesRunTime.boxToInteger((int)DatumTypes$.MODULE$.Datum_North_American_Datum_1927()));
                optZone2 = new Some((Object)BoxesRunTime.boxToInteger((int)(newPCS - 10000 - 30)));
            }
        }
        return new Tuple3((Object)optDatum2, (Object)optZone2, (Object)optMapSystem2);
    }

    private int mapSystemToProjection(int mapSystem, int zone) {
        return mapSystem == MapSystems$.MODULE$.MapSys_UTM_North() ? GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1N() + zone - 1 : (mapSystem == MapSystems$.MODULE$.MapSys_UTM_South() ? GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1S() + zone - 1 : (mapSystem == MapSystems$.MODULE$.MapSys_State_Plane_27() ? (zone == 4100 ? 15302 : 10000 + zone) : (mapSystem == MapSystems$.MODULE$.MapSys_State_Plane_83() ? (zone == 1601 ? 15303 : 10000 + zone + 30) : CommonPublicValues$.MODULE$.UserDefinedCPV())));
    }

    private Tuple2<Option<Object>, Option<Tuple2<Object, Object>[]>> getProjectionFromTransformationCode(int trfCode) {
        Tuple2 tuple2;
        if (trfCode >= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1N() && trfCode <= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_60N() || trfCode >= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1S() && trfCode <= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_60S()) {
            Tuple2.mcZI.sp sp2;
            Tuple2.mcZI.sp sp3 = sp2 = trfCode <= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_60N() ? new Tuple2.mcZI.sp(true, trfCode - GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1N() + 1) : new Tuple2.mcZI.sp(false, trfCode - GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1S() + 1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            boolean north = sp2._1$mcZ$sp();
            int zone = sp2._2$mcI$sp();
            Tuple2.mcZI.sp sp4 = new Tuple2.mcZI.sp(north, zone);
            Tuple2.mcZI.sp sp5 = sp4;
            boolean north2 = sp5._1$mcZ$sp();
            int zone2 = sp5._2$mcI$sp();
            Tuple2[] projectionParameters = (Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class));
            projectionParameters[0] = new Tuple2.mcID.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), 0.0);
            projectionParameters[1] = new Tuple2.mcID.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), (double)(-183 + 6 * zone2));
            projectionParameters[2] = new Tuple2.mcID.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), 0.0);
            projectionParameters[3] = new Tuple2.mcID.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), 0.0);
            projectionParameters[4] = new Tuple2.mcID.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), 0.9996);
            projectionParameters[5] = new Tuple2.mcID.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), 500000.0);
            projectionParameters[6] = new Tuple2.mcID.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), north2 ? 0.0 : 1.0E7);
            tuple2 = new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)9807)), (Object)new Some((Object)projectionParameters));
        } else {
            Tuple2 tuple22;
            Option option = this.csvReader().getProjOpWParmValues(trfCode);
            if (option instanceof Some) {
                Some some = (Some)option;
                Map map = (Map)some.value();
                tuple22 = new Tuple2((Object)map.get((Object)CSVFileConstants$.MODULE$.CoordOpMethodCode()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)GeoTiffCSParser.$anonfun$getProjectionFromTransformationCode$1(x$10))), (Object)None$.MODULE$);
            } else if (None$.MODULE$.equals(option)) {
                tuple22 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            tuple2 = tuple22;
        }
        return tuple2;
    }

    private int epsgProjMethodToCTProjMethod(int epsg) {
        return BoxesRunTime.unboxToInt((Object)CoordinateTransformTypes$.MODULE$.projMethodToCTProjMethodMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)epsg), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> epsg));
    }

    private Object setGTParameterIdentities(int ctProjection, Tuple2<Object, Object>[] projParms) {
        Unit$ unit$;
        int n = ctProjection;
        boolean bl = CoordinateTransformTypes$.MODULE$.CT_CassiniSoldner() == n ? true : CoordinateTransformTypes$.MODULE$.CT_NewZealandMapGrid() == n;
        if (bl) {
            projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getValueIfNotNull(projParms[0]));
            projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getValueIfNotNull(projParms[1]));
            projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
            projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
            unit$ = BoxedUnit.UNIT;
        } else {
            boolean bl2 = CoordinateTransformTypes$.MODULE$.CT_ObliqueMercator() == n ? true : CoordinateTransformTypes$.MODULE$.CT_HotineObliqueMercatorAzimuthCenter() == n;
            if (bl2) {
                projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLatGeoKey(), this.getValueIfNotNull(projParms[0]));
                projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), this.getValueIfNotNull(projParms[1]));
                projParms[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjAzimuthAngleGeoKey(), this.getValueIfNotNull(projParms[2]));
                projParms[3] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjRectifiedGridAngleGeoKey(), this.getValueIfNotNull(projParms[3]));
                projParms[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtCenterGeoKey(), this.getValueIfNotNull(projParms[4]));
                projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
                projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
                unit$ = BoxedUnit.UNIT;
            } else if (CoordinateTransformTypes$.MODULE$.CT_ObliqueMercator_Laborde() == n) {
                projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLatGeoKey(), this.getValueIfNotNull(projParms[0]));
                projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), this.getValueIfNotNull(projParms[1]));
                projParms[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjAzimuthAngleGeoKey(), this.getValueIfNotNull(projParms[2]));
                projParms[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtCenterGeoKey(), this.getValueIfNotNull(projParms[4]));
                projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
                projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
                unit$ = BoxedUnit.UNIT;
            } else {
                boolean bl3 = CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_1SP() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_Mercator() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_ObliqueStereographic() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_PolarStereographic() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_TransverseMercator() == n ? true : CoordinateTransformTypes$.MODULE$.CT_TransvMercator_SouthOriented() == n))));
                if (bl3) {
                    projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getValueIfNotNull(projParms[0]));
                    projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getValueIfNotNull(projParms[1]));
                    projParms[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), this.getValueIfNotNull(projParms[4]));
                    projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
                    projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
                    unit$ = BoxedUnit.UNIT;
                } else if (CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_2SP() == n) {
                    projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseOriginLatGeoKey(), this.getValueIfNotNull(projParms[0]));
                    projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseOriginLongGeoKey(), this.getValueIfNotNull(projParms[1]));
                    projParms[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), this.getValueIfNotNull(projParms[2]));
                    projParms[3] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel2GeoKey(), this.getValueIfNotNull(projParms[3]));
                    projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
                    projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
                    unit$ = BoxedUnit.UNIT;
                } else if (CoordinateTransformTypes$.MODULE$.CT_AlbersEqualArea() == n) {
                    projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), this.getValueIfNotNull(projParms[0]));
                    projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel2GeoKey(), this.getValueIfNotNull(projParms[1]));
                    projParms[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getValueIfNotNull(projParms[2]));
                    projParms[3] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getValueIfNotNull(projParms[3]));
                    projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
                    projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
                    unit$ = BoxedUnit.UNIT;
                } else {
                    boolean bl4 = CoordinateTransformTypes$.MODULE$.CT_SwissObliqueCylindrical() == n ? true : CoordinateTransformTypes$.MODULE$.CT_LambertAzimEqualArea() == n;
                    if (bl4) {
                        projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLatGeoKey(), this.getValueIfNotNull(projParms[0]));
                        projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), this.getValueIfNotNull(projParms[1]));
                        projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
                        projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
                        unit$ = BoxedUnit.UNIT;
                    } else if (CoordinateTransformTypes$.MODULE$.CT_CylindricalEqualArea() == n) {
                        projParms[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), this.getValueIfNotNull(projParms[0]));
                        projParms[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getValueIfNotNull(projParms[1]));
                        projParms[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getValueIfNotNull(projParms[5]));
                        projParms[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getValueIfNotNull(projParms[6]));
                        unit$ = BoxedUnit.UNIT;
                    } else {
                        unit$ = Unit$.MODULE$;
                    }
                }
            }
        }
        return unit$;
    }

    private double getValueIfNotNull(Tuple2<Object, Object> tuple) {
        return tuple == null ? Double.NaN : tuple._2$mcD$sp();
    }

    private Tuple3<Option<Object>, Option<Object>, Option<Object>> getGCSInfo(int gcs) {
        Tuple3 tuple3;
        int n = gcs;
        Object object = GeographicCSTypes$.MODULE$.GCS_NAD27() == n ? new Some((Object)BoxesRunTime.boxToInteger((int)DatumTypes$.MODULE$.Datum_North_American_Datum_1927())) : (GeographicCSTypes$.MODULE$.GCS_NAD83() == n ? new Some((Object)BoxesRunTime.boxToInteger((int)DatumTypes$.MODULE$.Datum_North_American_Datum_1983())) : (GeographicCSTypes$.MODULE$.GCS_WGS_84() == n ? new Some((Object)BoxesRunTime.boxToInteger((int)DatumTypes$.MODULE$.Datum_WGS84())) : (GeographicCSTypes$.MODULE$.GCS_WGS_72() == n ? new Some((Object)BoxesRunTime.boxToInteger((int)DatumTypes$.MODULE$.Datum_WGS72())) : (GeographicCSTypes$.MODULE$.GCS_WGS_72BE() == n ? new Some((Object)BoxesRunTime.boxToInteger((int)DatumTypes$.MODULE$.Datum_WGS72_Transit_Broadcast_Ephemeris())) : None$.MODULE$))));
        Some datum = object;
        Some some = datum;
        if (some instanceof Some) {
            Some some2 = some;
            int d = BoxesRunTime.unboxToInt((Object)some2.value());
            tuple3 = new Tuple3((Object)new Some((Object)BoxesRunTime.boxToInteger((int)PrimeMeridianTypes$.MODULE$.PM_Greenwich())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)AngularUnitTypes$.MODULE$.Angular_DMS_Hemisphere())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)d)));
        } else if (None$.MODULE$.equals(some)) {
            Tuple3 tuple32;
            Option option = this.csvReader().getGCSEPSGValues(gcs);
            if (option instanceof Some) {
                Some some3 = (Some)option;
                Map map = (Map)some3.value();
                tuple32 = new Tuple3((Object)map.get((Object)CSVFileConstants$.MODULE$.PrimeMeridianCode()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)GeoTiffCSParser.$anonfun$getGCSInfo$1(x$11))), (Object)map.get((Object)CSVFileConstants$.MODULE$.PrimeMeridianCode()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)GeoTiffCSParser.$anonfun$getGCSInfo$2(x$12))), (Object)map.get((Object)CSVFileConstants$.MODULE$.UOMCode()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)GeoTiffCSParser.$anonfun$getGCSInfo$3(x$13))));
            } else if (None$.MODULE$.equals(option)) {
                tuple32 = new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            tuple3 = tuple32;
        } else {
            throw new MatchError((Object)some);
        }
        return tuple3;
    }

    /*
     * Unable to fully structure code
     */
    private Option<Object> getAngleInfo(int angleCode) {
        var5_2 = angleCode;
        switch (var5_2) {
            case 9101: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)57.29577951308232));
                break;
            }
            case 9102: 
            case 9107: 
            case 9108: 
            case 9110: 
            case 9122: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
                break;
            }
            case 9103: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)0.16666666666666666));
                break;
            }
            case 9104: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)2.777777777777778E-4));
                break;
            }
            case 9105: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)0.9));
                break;
            }
            case 9106: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)0.9));
                break;
            }
            case 9109: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)5.7295779513082324E-5));
                break;
            }
            default: {
                var6_3 = this.csvReader().getUnitOfMeasureValues(angleCode);
                if (!(var6_3 instanceof Some)) ** GOTO lbl51
                var7_4 = (Some)var6_3;
                map = (Map)var7_4.value();
                var9_6 = map.get((Object)CSVFileConstants$.MODULE$.FactorBCode());
                if (!(var9_6 instanceof Some)) ** GOTO lbl45
                var10_7 = (Some)var9_6;
                v1 = factorB = (String)var10_7.value();
                var12_9 = "";
                if (!(v1 == null ? var12_9 != null : v1.equals(var12_9) == false)) ** GOTO lbl45
                var13_10 = map.get((Object)CSVFileConstants$.MODULE$.FactorCCode());
                if (!(var13_10 instanceof Some)) ** GOTO lbl41
                var14_11 = (Some)var13_10;
                v2 = factorC = (String)var14_11.value();
                var16_13 = "";
                if ((v2 == null ? var16_13 != null : v2.equals(var16_13) == false) && new StringOps(Predef$.MODULE$.augmentString(factorC)).toDouble() != 0.0) ** GOTO lbl42
lbl41:
                // 2 sources

                throw new MatchError((Object)var13_10);
lbl42:
                // 1 sources

                var4_14 = new Some((Object)BoxesRunTime.boxToDouble((double)(new StringOps(Predef$.MODULE$.augmentString(factorB)).toDouble() / new StringOps(Predef$.MODULE$.augmentString(factorC)).toDouble() * 180.0 / 3.141592653589793)));
                var3_15 = var4_14;
                ** GOTO lbl49
lbl45:
                // 2 sources

                if (None$.MODULE$.equals(var9_6)) {
                    var3_15 = None$.MODULE$;
                } else {
                    throw new MatchError((Object)var9_6);
                }
lbl49:
                // 2 sources

                var2_16 = var3_15;
                ** GOTO lbl55
lbl51:
                // 1 sources

                if (None$.MODULE$.equals(var6_3)) {
                    var2_16 = None$.MODULE$;
                } else {
                    throw new MatchError((Object)var6_3);
                }
lbl55:
                // 2 sources

                v0 = var2_16;
                break;
            }
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private Option<Object> getDatumInfo(int datum) {
        block5: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    var5_2 = datum;
                                    if (DatumTypes$.MODULE$.Datum_North_American_Datum_1927() != var5_2) break block4;
                                    var2_3 = new Some((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_Clarke_1866()));
                                    break block5;
                                }
                                if (DatumTypes$.MODULE$.Datum_North_American_Datum_1983() != var5_2) break block6;
                                var2_3 = new Some((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_GRS_1980()));
                                break block5;
                            }
                            if (DatumTypes$.MODULE$.Datum_WGS84() != var5_2) break block7;
                            var2_3 = new Some((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_WGS_84()));
                            break block5;
                        }
                        if (DatumTypes$.MODULE$.Datum_WGS72() != var5_2) break block8;
                        var2_3 = new Some((Object)BoxesRunTime.boxToInteger((int)7043));
                        break block5;
                    }
                    var6_4 = this.csvReader().getDatumValues(datum);
                    if (!(var6_4 instanceof Some)) break block9;
                    var7_5 = (Some)var6_4;
                    map = (Map)var7_5.value();
                    var9_7 = map.get((Object)CSVFileConstants$.MODULE$.EllipsoidCode());
                    if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
                    var10_8 = (Some)var9_7;
                    v0 = ellipsoidStr = (String)var10_8.value();
                    var12_10 = "";
                    if (v0 == null ? var12_10 != null : v0.equals(var12_10) == false) {
                        var4_11 = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(ellipsoidStr)).toInt()));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var4_11 = None$.MODULE$;
                    }
                    var3_12 = var4_11;
                    break block10;
                }
                if (None$.MODULE$.equals(var6_4)) {
                    var3_12 = None$.MODULE$;
                } else {
                    throw new MatchError((Object)var6_4);
                }
            }
            var2_3 = var3_12;
        }
        return var2_3;
    }

    private double semiMinorComp(double semiMajor, double invFlattening) {
        return semiMajor * (1.0 - 1.0 / invFlattening);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Tuple2<Option<Object>, Option<Object>> getEllipsoidInfo(int ellipsoid) {
        block17: {
            block18: {
                block29: {
                    block19: {
                        block28: {
                            block20: {
                                block23: {
                                    block21: {
                                        block27: {
                                            block24: {
                                                block26: {
                                                    block25: {
                                                        block22: {
                                                            block16: {
                                                                var13_2 = ellipsoid;
                                                                var11_3 /* !! */  = EllipsoidTypes$.MODULE$.Ellipse_Clarke_1866() == var13_2 ? new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)6378206.4), (Object)BoxesRunTime.boxToDouble((double)6356583.8), (Object)BoxesRunTime.boxToDouble((double)0.0))) : (EllipsoidTypes$.MODULE$.Ellipse_GRS_1980() == var13_2 ? new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)6378137.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)298.257222101))) : (EllipsoidTypes$.MODULE$.Ellipse_WGS_84() == var13_2 ? new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)6378137.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)298.257223563))) : (7043 == var13_2 ? new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)6378135.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)298.26))) : None$.MODULE$)));
                                                                ellipsoidTuple = var11_3 /* !! */ ;
                                                                var14_5 = ellipsoidTuple;
                                                                if (!(var14_5 instanceof Some) || (var16_7 = (Tuple3)(var15_6 = var14_5).value()) == null) break block16;
                                                                semiMajor = BoxesRunTime.unboxToDouble((Object)var16_7._1());
                                                                semiMinor = BoxesRunTime.unboxToDouble((Object)var16_7._2());
                                                                invFlattening = BoxesRunTime.unboxToDouble((Object)var16_7._3());
                                                                var2_11 = semiMinor == 0.0 ? new Tuple2((Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMajor)), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)this.semiMinorComp(semiMajor, invFlattening)))) : new Tuple2((Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMajor)), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMinor)));
                                                                break block17;
                                                            }
                                                            if (!None$.MODULE$.equals(var14_5)) break block18;
                                                            var23_12 = this.csvReader().getEllipsoidValues(ellipsoid);
                                                            if (!(var23_12 instanceof Some)) break block19;
                                                            var24_13 = (Some)var23_12;
                                                            map = (Map)var24_13.value();
                                                            var26_15 = map.get((Object)CSVFileConstants$.MODULE$.SemiMajorAxisCode());
                                                            if (!(var26_15 instanceof Some)) break block20;
                                                            var27_16 = (Some)var26_15;
                                                            v0 = semiMajorStr = (String)var27_16.value();
                                                            var29_18 = "";
                                                            if (!(v0 == null ? var29_18 != null : v0.equals(var29_18) == false) || new StringOps(Predef$.MODULE$.augmentString(semiMajorStr)).toDouble() == 0.0) break block21;
                                                            var32_19 = map.get((Object)CSVFileConstants$.MODULE$.UOMCode());
                                                            if (!(var32_19 instanceof Some)) ** GOTO lbl-1000
                                                            var33_20 = (Some)var32_19;
                                                            v1 = code = (String)var33_20.value();
                                                            var35_22 = "";
                                                            if (v1 == null ? var35_22 != null : v1.equals(var35_22) == false) {
                                                                var36_23 = this.getLengthInfo(new StringOps(Predef$.MODULE$.augmentString(code)).toInt());
                                                                if (var36_23 instanceof Some) {
                                                                    var37_24 = (Some)var36_23;
                                                                    conv = BoxesRunTime.unboxToDouble((Object)var37_24.value());
                                                                    var9_26 = new StringOps(Predef$.MODULE$.augmentString(semiMajorStr)).toDouble() * conv;
                                                                } else if (None$.MODULE$.equals(var36_23)) {
                                                                    var9_26 = new StringOps(Predef$.MODULE$.augmentString(semiMajorStr)).toDouble();
                                                                } else {
                                                                    throw new MatchError(var36_23);
                                                                }
                                                                var7_27 = var9_26;
                                                            } else if (None$.MODULE$.equals(var32_19)) {
                                                                var7_27 = NaN;
                                                            } else {
                                                                throw new MatchError((Object)var32_19);
                                                            }
                                                            semiMajor = var7_27;
                                                            if (semiMajor != NaN) break block22;
                                                            v2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                                                            break block23;
                                                        }
                                                        var40_29 = map.get((Object)CSVFileConstants$.MODULE$.SemiMinorAxisCode());
                                                        if (!(var40_29 instanceof Some)) break block24;
                                                        var41_30 = (Some)var40_29;
                                                        v3 = semiMinorStr = (String)var41_30.value();
                                                        var43_32 = "";
                                                        if (!(v3 == null ? var43_32 != null : v3.equals(var43_32) == false)) break block24;
                                                        semiMinor = new StringOps(Predef$.MODULE$.augmentString(semiMinorStr)).toDouble();
                                                        if (semiMinor != 0.0) break block25;
                                                        var46_34 = map.get((Object)CSVFileConstants$.MODULE$.InvFlatteningCode());
                                                        if (!(var46_34 instanceof Some)) ** GOTO lbl-1000
                                                        var47_35 = (Some)var46_34;
                                                        v4 = invFlatteningStr = (String)var47_35.value();
                                                        var49_37 = "";
                                                        if (v4 == null ? var49_37 != null : v4.equals(var49_37) == false) {
                                                            var6_38 = new Tuple2((Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMajor)), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)this.semiMinorComp(semiMajor, new StringOps(Predef$.MODULE$.augmentString(invFlatteningStr)).toDouble()))));
                                                        } else if (None$.MODULE$.equals(var46_34)) {
                                                            var6_38 = new Tuple2((Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMajor)), (Object)None$.MODULE$);
                                                        } else {
                                                            throw new MatchError((Object)var46_34);
                                                        }
                                                        v5 = var6_38;
                                                        break block26;
                                                    }
                                                    v5 = new Tuple2((Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMajor)), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMinor)));
                                                }
                                                var5_39 = v5;
                                                break block27;
                                            }
                                            var5_39 = new Tuple2((Object)new Some((Object)BoxesRunTime.boxToDouble((double)semiMajor)), (Object)None$.MODULE$);
                                        }
                                        v2 = var5_39;
                                        break block23;
                                    }
                                    v2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                                }
                                var4_40 = v2;
                                break block28;
                            }
                            if (None$.MODULE$.equals(var26_15)) {
                                var4_40 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                            } else {
                                throw new MatchError((Object)var26_15);
                            }
                        }
                        var3_41 = var4_40;
                        break block29;
                    }
                    if (None$.MODULE$.equals(var23_12)) {
                        var3_41 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                    } else {
                        throw new MatchError((Object)var23_12);
                    }
                }
                var2_11 = var3_41;
                break block17;
            }
            throw new MatchError((Object)var14_5);
        }
        return var2_11;
    }

    /*
     * Unable to fully structure code
     */
    private Option<Object> getLengthInfo(int lengthCode) {
        var4_2 = lengthCode;
        switch (var4_2) {
            case 9001: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
                break;
            }
            case 9002: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)0.3048));
                break;
            }
            case 9003: {
                v0 = new Some((Object)BoxesRunTime.boxToDouble((double)0.30480060960121924));
                break;
            }
            default: {
                var5_3 = this.csvReader().getUnitOfMeasureValues(lengthCode);
                if (!(var5_3 instanceof Some)) ** GOTO lbl36
                var6_4 = (Some)var5_3;
                map = (Map)var6_4.value();
                var8_6 = new Tuple2((Object)map.get((Object)CSVFileConstants$.MODULE$.FactorBCode()), (Object)map.get((Object)CSVFileConstants$.MODULE$.FactorCCode()));
                if (var8_6 == null) ** GOTO lbl-1000
                var9_7 = (Option)var8_6._1();
                var10_8 = (Option)var8_6._2();
                if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
                var11_9 = (Some)var9_7;
                factorB = (String)var11_9.value();
                if (!(var10_8 instanceof Some)) ** GOTO lbl-1000
                var13_11 = (Some)var10_8;
                v1 = factorC = (String)var13_11.value();
                var15_13 = "";
                if (!(v1 == null ? var15_13 != null : v1.equals(var15_13) == false)) ** GOTO lbl-1000
                v2 = new StringOps(Predef$.MODULE$.augmentString(factorC));
                if (v2.toDouble() > 0.0) {
                    var3_14 = new Some((Object)BoxesRunTime.boxToDouble((double)(new StringOps(Predef$.MODULE$.augmentString(factorB)).toDouble() / new StringOps(Predef$.MODULE$.augmentString(factorC)).toDouble())));
                } else lbl-1000:
                // 5 sources

                {
                    var3_14 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                }
                var2_15 = var3_14;
                ** GOTO lbl40
lbl36:
                // 1 sources

                if (None$.MODULE$.equals(var5_3)) {
                    var2_15 = None$.MODULE$;
                } else {
                    throw new MatchError((Object)var5_3);
                }
lbl40:
                // 2 sources

                v0 = var2_15;
                break;
            }
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private Option<Object> getPrimeMeridianInfo(int pm) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        var6_2 = pm;
                        if (PrimeMeridianTypes$.MODULE$.PM_Greenwich() != var6_2) break block10;
                        var2_3 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                        break block11;
                    }
                    var7_4 = this.csvReader().getPrimeMeridianValues(pm);
                    if (!(var7_4 instanceof Some)) break block12;
                    var8_5 = (Some)var7_4;
                    map = (Map)var8_5.value();
                    var10_7 = map.get((Object)CSVFileConstants$.MODULE$.UOMCode());
                    if (!(var10_7 instanceof Some)) ** GOTO lbl-1000
                    var11_8 = (Some)var10_7;
                    v0 = uomAngleStr = (String)var11_8.value();
                    var13_10 = "";
                    if (v0 == null ? var13_10 != null : v0.equals(var13_10) == false) {
                        var14_11 = map.get((Object)CSVFileConstants$.MODULE$.GreenwichLongitudeCode());
                        if (var14_11 instanceof Some) {
                            var15_12 = (Some)var14_11;
                            angleString = (String)var15_12.value();
                            var5_14 = new Some((Object)BoxesRunTime.boxToDouble((double)this.angleStringToDD(angleString, new StringOps(Predef$.MODULE$.augmentString(uomAngleStr)).toInt())));
                        } else if (None$.MODULE$.equals(var14_11)) {
                            var5_14 = None$.MODULE$;
                        } else {
                            throw new MatchError((Object)var14_11);
                        }
                        var4_15 = var5_14;
                    } else if (None$.MODULE$.equals(var10_7)) {
                        var4_15 = None$.MODULE$;
                    } else {
                        throw new MatchError((Object)var10_7);
                    }
                    var3_16 = var4_15;
                    break block13;
                }
                if (None$.MODULE$.equals(var7_4)) {
                    var3_16 = None$.MODULE$;
                } else {
                    throw new MatchError((Object)var7_4);
                }
            }
            var2_3 = var3_16;
        }
        return var2_3;
    }

    private double angleStringToDD(String angleString, int angleCode) {
        double d;
        if (angleCode == 9110) {
            double angle = package$.MODULE$.abs(new StringOps(Predef$.MODULE$.augmentString(angleString)).toInt());
            String decimals = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(angleString)).dropWhile((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)GeoTiffCSParser.$anonfun$angleStringToDD$1(BoxesRunTime.unboxToChar((Object)x$14)))))).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)GeoTiffCSParser.$anonfun$angleStringToDD$2(BoxesRunTime.unboxToChar((Object)x$15))));
            if (!decimals.isEmpty()) {
                StringBuilder minutes = new StringBuilder();
                minutes.append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(decimals), 0));
                Object object = new StringOps(Predef$.MODULE$.augmentString(decimals)).size() > 1 ? minutes.append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(decimals), 1)) : BoxedUnit.UNIT;
                angle += new StringOps(Predef$.MODULE$.augmentString(minutes.toString())).toDouble() / 60.0;
                if (new StringOps(Predef$.MODULE$.augmentString(decimals)).size() > 2) {
                    StringBuilder stringBuilder;
                    StringBuilder seconds = new StringBuilder();
                    seconds.append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(decimals), 3));
                    if (new StringOps(Predef$.MODULE$.augmentString(decimals)).size() > 3 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(decimals), 4) >= '0' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(decimals), 4) <= '9') {
                        seconds.append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(decimals), 4));
                        seconds.append('.');
                        stringBuilder = seconds.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(decimals), 5, new StringOps(Predef$.MODULE$.augmentString(decimals)).size()));
                    } else {
                        stringBuilder = seconds.append('0');
                    }
                    angle += new StringOps(Predef$.MODULE$.augmentString(seconds.toString())).toDouble() / 3600.0;
                }
            }
            d = package$.MODULE$.abs(angle);
        } else if (angleCode == 9105 || angleCode == 9106) {
            d = (double)180 * (new StringOps(Predef$.MODULE$.augmentString(angleString)).toDouble() / (double)200);
        } else if (angleCode == 9101) {
            d = (double)180 * (new StringOps(Predef$.MODULE$.augmentString(angleString)).toDouble() / Math.PI);
        } else if (angleCode == 9103) {
            d = new StringOps(Predef$.MODULE$.augmentString(angleString)).toDouble() / (double)60;
        } else if (angleCode == 9104) {
            d = new StringOps(Predef$.MODULE$.augmentString(angleString)).toDouble() / (double)3600;
        } else {
            if (angleCode == 0 || angleCode == CommonPublicValues$.MODULE$.UserDefinedCPV() || angleCode == 0) {
                throw new MalformedGeoTiffException("Angle must be set.");
            }
            d = new StringOps(Predef$.MODULE$.augmentString(angleString)).toDouble();
        }
        return d;
    }

    private double angleToDD(double angle, int angleCode) {
        double d;
        if (angleCode == 9110) {
            d = this.angleStringToDD(((Object)BoxesRunTime.boxToDouble((double)angle)).toString(), angleCode);
        } else if (angleCode != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
            Option<Object> option = this.getAngleInfo(angleCode);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new MalformedGeoTiffException("Angle must be set.");
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            double pm = BoxesRunTime.unboxToDouble((Object)some.value());
            double d2 = pm * angle;
            d = d2;
        } else {
            d = angle;
        }
        return d;
    }

    private void setProjectionParameters(GeoTiffCSParameters gtgp) {
        BoxedUnit boxedUnit;
        DoubleRef originLong = DoubleRef.create((double)0.0);
        DoubleRef originLat = DoubleRef.create((double)0.0);
        double rectGridAngle = 0.0;
        double falseEasting = 0.0;
        double falseNorthing = 0.0;
        DoubleRef originScale = DoubleRef.create((double)1.0);
        double stdParallel1 = 0.0;
        double stdParallel2 = 0.0;
        double azimuth = 0.0;
        .colon.colon eastingList = new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projectedFalsings()).$up$bar$minus$greater(ProjectedFalsings$.MODULE$._projFalseEasting()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projCenterEasting()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projectedFalsings()).$up$bar$minus$greater(ProjectedFalsings$.MODULE$._projFalseOriginEasting()).get()), (List)Nil$.MODULE$)));
        falseEasting = this.getOptDoubleValue((List<Option<Object>>)eastingList, 0.0);
        .colon.colon northingList = new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projectedFalsings()).$up$bar$minus$greater(ProjectedFalsings$.MODULE$._projFalseNorthing()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projCenterNorthing()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projectedFalsings()).$up$bar$minus$greater(ProjectedFalsings$.MODULE$._projFalseOriginNorthing()).get()), (List)Nil$.MODULE$)));
        falseNorthing = this.getOptDoubleValue((List<Option<Object>>)northingList, 0.0);
        int n = gtgp.ctProjection();
        if (CoordinateTransformTypes$.MODULE$.CT_Stereographic() == n) {
            this.setOriginLong$1(originLong);
            this.setOriginLat$1(originLat);
            this.setOriginScaleNatOrigin$1(originScale);
            gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
            gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLatGeoKey(), originLat.elem);
            gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), originLong.elem);
            gtgp.projectionParameters()[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), originScale.elem);
            gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
            gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_1SP() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_Mercator() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_ObliqueStereographic() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_TransverseMercator() == n ? true : CoordinateTransformTypes$.MODULE$.CT_TransvMercator_SouthOriented() == n)));
            if (bl) {
                this.setOriginLong$1(originLong);
                this.setOriginLat$1(originLat);
                this.setOriginScaleNatOrigin$1(originScale);
                gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), originLat.elem);
                gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), originLong.elem);
                gtgp.projectionParameters()[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), originScale.elem);
                gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = CoordinateTransformTypes$.MODULE$.CT_ObliqueMercator() == n ? true : CoordinateTransformTypes$.MODULE$.CT_HotineObliqueMercatorAzimuthCenter() == n;
                if (bl2) {
                    this.setOriginLong$1(originLong);
                    this.setOriginLat$1(originLat);
                    azimuth = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projAzimuthAngle()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                    rectGridAngle = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projRectifiedGridAngle()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 90.0));
                    this.setOriginScale$1(originScale);
                    gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                    gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLatGeoKey(), originLat.elem);
                    gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), originLong.elem);
                    gtgp.projectionParameters()[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjAzimuthAngleGeoKey(), azimuth);
                    gtgp.projectionParameters()[3] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjRectifiedGridAngleGeoKey(), rectGridAngle);
                    gtgp.projectionParameters()[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), originScale.elem);
                    gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                    gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl3 = CoordinateTransformTypes$.MODULE$.CT_CassiniSoldner() == n ? true : CoordinateTransformTypes$.MODULE$.CT_Polyconic() == n;
                    if (bl3) {
                        this.setOriginLong$1(originLong);
                        this.setOriginLat$1(originLat);
                        this.setOriginScale$1(originScale);
                        gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                        gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), originLat.elem);
                        gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), originLong.elem);
                        gtgp.projectionParameters()[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), originScale.elem);
                        gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                        gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boolean bl4 = CoordinateTransformTypes$.MODULE$.CT_AzimuthalEquidistant() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_MillerCylindrical() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_Gnomonic() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_LambertAzimEqualArea() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_Orthographic() == n ? true : CoordinateTransformTypes$.MODULE$.CT_NewZealandMapGrid() == n))));
                        if (bl4) {
                            this.setOriginLong$1(originLong);
                            this.setOriginLat$1(originLat);
                            gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                            gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLatGeoKey(), originLat.elem);
                            gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), originLong.elem);
                            gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                            gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (CoordinateTransformTypes$.MODULE$.CT_Equirectangular() == n) {
                            this.setOriginLong$1(originLong);
                            this.setOriginLat$1(originLat);
                            stdParallel1 = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projStdParallel1()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                            gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                            gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLatGeoKey(), originLat.elem);
                            gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), originLong.elem);
                            gtgp.projectionParameters()[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), stdParallel1);
                            gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                            gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boolean bl5 = CoordinateTransformTypes$.MODULE$.CT_Robinson() == n ? true : (CoordinateTransformTypes$.MODULE$.CT_Sinusoidal() == n ? true : CoordinateTransformTypes$.MODULE$.CT_VanDerGrinten() == n);
                            if (bl5) {
                                this.setOriginLong$1(originLong);
                                gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                                gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjCenterLongGeoKey(), originLong.elem);
                                gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                                gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (CoordinateTransformTypes$.MODULE$.CT_PolarStereographic() == n) {
                                originLong.elem = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projStraightVertPoleLong()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                                if (originLong.elem == 0.0) {
                                    this.setOriginLong$1(originLong);
                                }
                                this.setOriginLat$1(originLat);
                                this.setOriginScale$1(originScale);
                                gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                                gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), originLat.elem);
                                gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStraightVertPoleLongGeoKey(), originLong.elem);
                                gtgp.projectionParameters()[4] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), originScale.elem);
                                gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                                gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_2SP() == n) {
                                stdParallel1 = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projStdParallel1()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                                stdParallel2 = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projStdParallel2()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                                this.setOriginLong$1(originLong);
                                this.setOriginLat$1(originLat);
                                gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                                gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseOriginLatGeoKey(), originLat.elem);
                                gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseOriginLongGeoKey(), originLong.elem);
                                gtgp.projectionParameters()[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), stdParallel1);
                                gtgp.projectionParameters()[3] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel2GeoKey(), stdParallel2);
                                gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                                gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boolean bl6 = CoordinateTransformTypes$.MODULE$.CT_AlbersEqualArea() == n ? true : CoordinateTransformTypes$.MODULE$.CT_EquidistantConic() == n;
                                if (bl6) {
                                    stdParallel1 = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projStdParallel1()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                                    stdParallel2 = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projStdParallel2()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                                    this.setOriginLong$1(originLong);
                                    this.setOriginLat$1(originLat);
                                    gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                                    gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), stdParallel1);
                                    gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel2GeoKey(), stdParallel2);
                                    gtgp.projectionParameters()[2] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), originLat.elem);
                                    gtgp.projectionParameters()[3] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), originLong.elem);
                                    gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                                    gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else if (CoordinateTransformTypes$.MODULE$.CT_CylindricalEqualArea() == n) {
                                    stdParallel1 = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projStdParallel1()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                                    this.setOriginLong$1(originLong);
                                    gtgp.projectionParameters_$eq((Tuple2[])Array$.MODULE$.ofDim(7, ClassTag$.MODULE$.apply(Tuple2.class)));
                                    gtgp.projectionParameters()[0] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), stdParallel1);
                                    gtgp.projectionParameters()[1] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), originLong.elem);
                                    gtgp.projectionParameters()[5] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), falseEasting);
                                    gtgp.projectionParameters()[6] = new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), falseNorthing);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = Unit$.MODULE$;
                                }
                            }
                        }
                    }
                }
            }
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gtgp.projectionParameters())).size()).foreach((Function1 & Serializable & scala.Serializable)i -> GeoTiffCSParser.$anonfun$setProjectionParameters$12(gtgp, BoxesRunTime.unboxToInt((Object)i)));
    }

    private double getOptDoubleValue(List<Option<Object>> opts, double d) {
        double d2;
        Some some;
        Option head;
        Option option = ((TraversableLike)opts.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)GeoTiffCSParser.$anonfun$getOptDoubleValue$1(x$16)))).headOption();
        if (option instanceof Some && !(head = (Option)(some = (Some)option).value()).isEmpty()) {
            d2 = BoxesRunTime.unboxToDouble((Object)head.get());
        } else if (None$.MODULE$.equals(option)) {
            d2 = d;
        } else {
            throw new MatchError((Object)option);
        }
        return d2;
    }

    private Option<Tuple2<Object, Object>> getMapSystemAndZone(int projCode) {
        return projCode >= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1N() && projCode <= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_60N() ? new Some((Object)new Tuple2.mcII.sp(MapSystems$.MODULE$.MapSys_UTM_North(), projCode - GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1N() + 1)) : (projCode >= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1S() && projCode <= GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_60S() ? new Some((Object)new Tuple2.mcII.sp(MapSystems$.MODULE$.MapSys_UTM_South(), projCode - GDALEPSGProjectionTypes$.MODULE$.Proj_UTM_zone_1S() + 1)) : (projCode >= 10101 && projCode <= 15299 ? (projCode % 100 >= 30 ? new Some((Object)new Tuple2.mcII.sp(MapSystems$.MODULE$.MapSys_State_Plane_83(), projCode - 10030)) : new Some((Object)new Tuple2.mcII.sp(MapSystems$.MODULE$.MapSys_State_Plane_27(), projCode - 10000))) : None$.MODULE$));
    }

    private Option<String> getProj4String(GeoTiffCSParameters gtgp) {
        StringBuilder stringBuilder;
        double d;
        double d2;
        String string;
        StringBuilder proj4SB = new StringBuilder();
        Option option = ProjectedLinearUnits$.MODULE$.projectedLinearUnitsMap().get((Object)BoxesRunTime.boxToInteger((int)gtgp.length()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String unit = (String)some.value();
            string = new java.lang.StringBuilder(8).append(" +units=").append(unit).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new java.lang.StringBuilder(11).append(" +to_meter=").append(gtgp.lengthInMeters()).toString();
        } else {
            throw new MatchError((Object)option);
        }
        String units = string;
        None$ falseEastingParams = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gtgp.projectionParameters())).size() >= 6 ? new Some(gtgp.projectionParameters()[5]) : None$.MODULE$;
        None$ falseNorthingParams = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gtgp.projectionParameters())).size() >= 7 ? new Some(gtgp.projectionParameters()[6]) : None$.MODULE$;
        None$ none$ = falseEastingParams;
        if (none$ instanceof Some) {
            Some some = (Some)none$;
            Tuple2 tup = (Tuple2)some.value();
            d2 = tup._2$mcD$sp();
        } else if (None$.MODULE$.equals(none$)) {
            d2 = 0.0;
        } else {
            throw new MatchError((Object)none$);
        }
        double falseEasting = d2;
        None$ none$2 = falseNorthingParams;
        if (none$2 instanceof Some) {
            Some some = (Some)none$2;
            Tuple2 tup = (Tuple2)some.value();
            d = tup._2$mcD$sp();
        } else if (None$.MODULE$.equals(none$2)) {
            d = 0.0;
        } else {
            throw new MatchError((Object)none$2);
        }
        double falseNorthing = d;
        if (gtgp.model() == ModelTypes$.MODULE$.ModelTypeGeographic()) {
            stringBuilder = proj4SB.append("+proj=latlong");
        } else if (gtgp.mapSystem() == MapSystems$.MODULE$.MapSys_UTM_North()) {
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(16).append("+proj=utm +zone=").append(gtgp.zone()).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_TransverseMercator()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double k = gtgp.projectionParameters()[4]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(43).append("+proj=tmerc +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +k=").append(k).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Mercator()) {
            double lat_ts = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double k = gtgp.projectionParameters()[4]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(43).append("+proj=merc +lat_ts=").append(lat_ts).append(" +lon_0=").append(lon_0).append(" +k=").append(k).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_CassiniSoldner()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=cass +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_ObliqueStereographic()) {
            double lat_ts = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double k = gtgp.projectionParameters()[4]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(44).append("+proj=stere +lat_ts=").append(lat_ts).append(" +lon_0=").append(lon_0).append(" +k=").append(k).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Stereographic()) {
            double lat_ts = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(40).append("+proj=stere +lat_ts=").append(lat_ts).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_PolarStereographic()) {
            double lat_ts = gtgp.projectionParameters()[0]._2$mcD$sp();
            String lat_0 = lat_ts > 0.0 ? "90" : "-90";
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double k = gtgp.projectionParameters()[4]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(52).append("+proj=stere +lat_0=").append(lat_0).append(" +lat_ts=").append(lat_ts).append(" +lon_0=").append(lon_0).append(" +k=").append(k).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Equirectangular()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double lat_ts = gtgp.projectionParameters()[2]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(46).append("+proj=eqc +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +lat_ts=").append(lat_ts).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Gnomonic()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=gnom +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Orthographic()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=orth +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_LambertAzimEqualArea()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=laea +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_AzimuthalEquidistant()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=aeqd +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_MillerCylindrical()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=mill +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Polyconic()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=poly +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_AlbersEqualArea()) {
            double lat_1 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lat_2 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double lat_0 = gtgp.projectionParameters()[2]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[3]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(53).append("+proj=aea +lat_1=").append(lat_1).append(" +lat_2=").append(lat_2).append(" +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_EquidistantConic()) {
            double lat_1 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lat_2 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double lat_0 = gtgp.projectionParameters()[2]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[3]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(54).append("+proj=eqdc +lat_1=").append(lat_1).append(" +lat_2=").append(lat_2).append(" +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Robinson()) {
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(31).append("+proj=robin +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_VanDerGrinten()) {
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(31).append("+proj=vandg +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_Sinusoidal()) {
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(30).append("+proj=sinu +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_2SP()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double lat_1 = gtgp.projectionParameters()[2]._2$mcD$sp();
            double lat_2 = gtgp.projectionParameters()[3]._2$mcD$sp();
            double x_0 = falseEasting;
            double y_0 = falseNorthing;
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(53).append("+proj=lcc +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +lat_1=").append(lat_1).append(" +lat_2=").append(lat_2).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_1SP()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lat_1 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double k = gtgp.projectionParameters()[4]._2$mcD$sp();
            double x_0 = gtgp.projectionParameters()[5]._2$mcD$sp();
            double y_0 = gtgp.projectionParameters()[6]._2$mcD$sp();
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(49).append("+proj=lcc +lat_0=").append(lat_0).append(" +lat_1=").append(lat_1).append(" +lon_0=").append(lon_0).append(" +k=").append(k).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_CylindricalEqualArea()) {
            double lat_ts = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = gtgp.projectionParameters()[5]._2$mcD$sp();
            double y_0 = gtgp.projectionParameters()[6]._2$mcD$sp();
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=cea +lat_ts=").append(lat_ts).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_NewZealandMapGrid()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lon_0 = gtgp.projectionParameters()[1]._2$mcD$sp();
            double x_0 = gtgp.projectionParameters()[5]._2$mcD$sp();
            double y_0 = gtgp.projectionParameters()[6]._2$mcD$sp();
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(38).append("+proj=nzmg +lat_0=").append(lat_0).append(" +lon_0=").append(lon_0).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else if (gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_ObliqueMercator()) {
            double lat_0 = gtgp.projectionParameters()[0]._2$mcD$sp();
            double lonc = gtgp.projectionParameters()[1]._2$mcD$sp();
            double alpha = gtgp.projectionParameters()[2]._2$mcD$sp();
            double k = gtgp.projectionParameters()[4]._2$mcD$sp();
            double x_0 = gtgp.projectionParameters()[5]._2$mcD$sp();
            double y_0 = gtgp.projectionParameters()[6]._2$mcD$sp();
            stringBuilder = proj4SB.append(new java.lang.StringBuilder(50).append("+proj=omerc +lat_0=").append(lat_0).append(" +lonc=").append(lonc).append(" +alpha=").append(alpha).append(" +k=").append(k).append(" +x_0=").append(x_0).append(" +y_0=").append(y_0).toString());
        } else {
            stringBuilder = BoxedUnit.UNIT;
        }
        Object object = gtgp.datum() == DatumTypes$.MODULE$.Datum_WGS84() ? proj4SB.append(" +datum=WGS84") : (gtgp.datum() == DatumTypes$.MODULE$.Datum_WGS72_Transit_Broadcast_Ephemeris() ? proj4SB.append(" +datum=WGS72BE") : (gtgp.datum() == DatumTypes$.MODULE$.Datum_WGS72() ? proj4SB.append(" +datum=WGS72") : (gtgp.datum() == DatumTypes$.MODULE$.Datum_North_American_Datum_1927() ? proj4SB.append(" +datum=NAD27") : (gtgp.datum() == DatumTypes$.MODULE$.Datum_North_American_Datum_1983() ? proj4SB.append(" +datum=NAD83") : (gtgp.ellipsoid() == EllipsoidTypes$.MODULE$.Ellipse_WGS_84() ? proj4SB.append(" +ellps=WGS84") : (gtgp.ellipsoid() == EllipsoidTypes$.MODULE$.Ellipse_Clarke_1866() ? proj4SB.append(" +ellps=clrk66") : (gtgp.ellipsoid() == EllipsoidTypes$.MODULE$.Ellipse_Clarke_1880() ? proj4SB.append(" +ellps=clrk80") : (gtgp.ellipsoid() == EllipsoidTypes$.MODULE$.Ellipse_Clarke_1880() ? proj4SB.append(" +ellps=clrk80") : (gtgp.ellipsoid() == EllipsoidTypes$.MODULE$.Ellipse_GRS_1980() ? proj4SB.append(" +ellps=GRS80") : (gtgp.ellipsoid() == EllipsoidTypes$.MODULE$.Ellipse_International_1924() ? proj4SB.append(" +ellps=intl") : (gtgp.semiMinor() != 0.0 && gtgp.semiMajor() != 0.0 ? proj4SB.append(new java.lang.StringBuilder(8).append(" +a=").append(gtgp.semiMajor()).append(" +b=").append(gtgp.semiMinor()).toString()) : BoxedUnit.UNIT)))))))))));
        return proj4SB.length() == 0 || gtgp.ctProjection() == CoordinateTransformTypes$.MODULE$.CT_TransvMercator_SouthOriented() || !proj4SB.toString().contains("+proj") ? gtgp.pcsCitation().flatMap((Function1 & Serializable & scala.Serializable)citation -> citation.contains("PROJCS[\"WGS_1984_Web_Mercator_Auxiliary_Sphere\"") ? new Some((Object)"+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs") : None$.MODULE$) : new Some((Object)proj4SB.append(units).toString());
    }

    public static final /* synthetic */ int $anonfun$getProjectionFromTransformationCode$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ int $anonfun$getGCSInfo$1(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toInt();
    }

    public static final /* synthetic */ int $anonfun$getGCSInfo$2(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
    }

    public static final /* synthetic */ int $anonfun$getGCSInfo$3(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$angleStringToDD$1(char x$14) {
        return x$14 != '.';
    }

    public static final /* synthetic */ boolean $anonfun$angleStringToDD$2(char x$15) {
        return x$15 != '.';
    }

    private final void setOriginLong$1(DoubleRef originLong$1) {
        .colon.colon originLongList = new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projNatOriginLong()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projectedFalsings()).$up$bar$minus$greater(ProjectedFalsings$.MODULE$._projFalseOriginLong()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projCenterLong()).get()), (List)Nil$.MODULE$)));
        originLong$1.elem = this.getOptDoubleValue((List<Option<Object>>)originLongList, 0.0);
    }

    private final void setOriginLat$1(DoubleRef originLat$1) {
        .colon.colon originLatList = new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projNatOriginLat()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projectedFalsings()).$up$bar$minus$greater(ProjectedFalsings$.MODULE$._projFalseOriginLat()).get()), (List)new .colon.colon((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projCenterLat()).get()), (List)Nil$.MODULE$)));
        originLat$1.elem = this.getOptDoubleValue((List<Option<Object>>)originLatList, 0.0);
    }

    private final void setOriginScaleNatOrigin$1(DoubleRef originScale$1) {
        originScale$1.elem = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projScaleAtNatOrigin()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
    }

    private final void setOriginScale$1(DoubleRef originScale$1) {
        block0: {
            this.setOriginScaleNatOrigin$1(originScale$1);
            if (originScale$1.elem != 1.0) break block0;
            originScale$1.elem = BoxesRunTime.unboxToDouble((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)this.geoKeyDirectory).$amp$bar$minus$greater(GeoKeyDirectory$.MODULE$._projectedCSParameterKeys()).$up$bar$minus$greater(ProjectedCSParameterKeys$.MODULE$._projScaleAtCenter()).get()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
        }
    }

    public static final /* synthetic */ Object $anonfun$setProjectionParameters$12(GeoTiffCSParameters gtgp$2, int i) {
        BoxedUnit boxedUnit;
        Tuple2<Object, Object> v = gtgp$2.projectionParameters()[i];
        if (v != null) {
            Unit$ unit$;
            int n = v._1$mcI$sp();
            boolean bl = GeoKeys$.MODULE$.ProjFalseEastingGeoKey() == n ? true : (GeoKeys$.MODULE$.ProjFalseNorthingGeoKey() == n ? true : (GeoKeys$.MODULE$.ProjFalseOriginEastingGeoKey() == n ? true : (GeoKeys$.MODULE$.ProjFalseOriginNorthingGeoKey() == n ? true : (GeoKeys$.MODULE$.ProjCenterEastingGeoKey() == n ? true : GeoKeys$.MODULE$.ProjCenterNorthingGeoKey() == n))));
            if (bl) {
                BoxedUnit boxedUnit2;
                if (gtgp$2.lengthInMeters() != 0.0 && gtgp$2.lengthInMeters() != 1.0) {
                    gtgp$2.projectionParameters()[i] = new Tuple2.mcID.sp(v._1$mcI$sp(), v._2$mcD$sp() * gtgp$2.lengthInMeters());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                unit$ = boxedUnit2;
            } else {
                unit$ = Unit$.MODULE$;
            }
            boxedUnit = unit$;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$getOptDoubleValue$1(Option x$16) {
        Option option = x$16;
        None$ none$ = None$.MODULE$;
        return option == null ? none$ != null : !option.equals(none$);
    }

    public GeoTiffCSParser(GeoKeyDirectory geoKeyDirectory) {
        this.geoKeyDirectory = geoKeyDirectory;
        this.csvReader = EPSGCSVReader$.MODULE$.apply();
    }
}

