/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.reader;

import geotrellis.raster.CellGrid;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.ArraySegmentBytes$;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile$;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffTile$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.LazySegmentBytes$;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.NewSubfileType;
import geotrellis.raster.io.geotiff.NewSubfileType$;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Striped$;
import geotrellis.raster.io.geotiff.Tiff$;
import geotrellis.raster.io.geotiff.TiffType;
import geotrellis.raster.io.geotiff.TiffType$;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.Decompressor$;
import geotrellis.raster.io.geotiff.compression.DeflateCompression$;
import geotrellis.raster.io.geotiff.compression.NoCompression$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.reader.TiffTagsReader$;
import geotrellis.raster.io.geotiff.tags.BasicTags$;
import geotrellis.raster.io.geotiff.tags.GeoTiffTags$;
import geotrellis.raster.io.geotiff.tags.NonBasicTags$;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.TiffTags$;
import geotrellis.raster.io.geotiff.tags.TileTags$;
import geotrellis.raster.io.geotiff.tags.codes.ColorSpace$;
import geotrellis.raster.io.geotiff.util.IntTiffTagOffsetSize$;
import geotrellis.raster.io.geotiff.util.LongTiffTagOffsetSize$;
import geotrellis.raster.render.IndexedColorMap;
import geotrellis.raster.render.IndexedColorMap$;
import geotrellis.util.ByteReader;
import geotrellis.util.ByteReader$;
import geotrellis.util.FileRangeReader$;
import geotrellis.util.Filesystem$;
import geotrellis.util.RangeReader;
import geotrellis.util.StreamingByteReader$;
import geotrellis.vector.Extent;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import monocle.syntax.apply$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GeoTiffReader$
implements scala.Serializable {
    public static GeoTiffReader$ MODULE$;
    private final GeoTiffReader<Tile> singlebandGeoTiffReader;
    private final GeoTiffReader<MultibandTile> multibandGeoTiffReader;

    static {
        new GeoTiffReader$();
    }

    public SinglebandGeoTiff readSingleband(String path) {
        return this.readSingleband(path, false);
    }

    public SinglebandGeoTiff readSingleband(String path, Extent e) {
        return this.readSingleband(path, (Option<Extent>)new Some((Object)e));
    }

    public SinglebandGeoTiff readSingleband(String path, Option<Extent> e) {
        SinglebandGeoTiff singlebandGeoTiff;
        Option<Extent> option = e;
        if (option instanceof Some) {
            Some some = (Some)option;
            Extent x = (Extent)some.value();
            singlebandGeoTiff = this.readSingleband(path, true).crop(x);
        } else if (None$.MODULE$.equals(option)) {
            singlebandGeoTiff = this.readSingleband(path);
        } else {
            throw new MatchError(option);
        }
        return singlebandGeoTiff;
    }

    public SinglebandGeoTiff readSingleband(String path, boolean streaming) {
        String ovrPath = new StringBuilder(4).append(path).append(".ovr").toString();
        boolean ovrPathExists = new File(ovrPath).isFile();
        return streaming ? this.readSingleband((ByteReader)StreamingByteReader$.MODULE$.apply((RangeReader)FileRangeReader$.MODULE$.apply(path)), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)StreamingByteReader$.MODULE$.apply((RangeReader)FileRangeReader$.MODULE$.apply(ovrPath))) : None$.MODULE$)) : this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()))), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(ovrPath, Filesystem$.MODULE$.slurp$default$2())))) : None$.MODULE$));
    }

    public SinglebandGeoTiff readSingleband(byte[] bytes) {
        return this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), false);
    }

    public SinglebandGeoTiff readSingleband(byte[] bytes, boolean streaming) {
        return this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), streaming);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader) {
        return this.readSingleband(byteReader, false);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, Extent e) {
        return this.readSingleband(byteReader, (Option<Extent>)new Some((Object)e));
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, Option<Extent> e) {
        SinglebandGeoTiff singlebandGeoTiff;
        Option<Extent> option = e;
        if (option instanceof Some) {
            Some some = (Some)option;
            Extent x = (Extent)some.value();
            singlebandGeoTiff = this.readSingleband(byteReader, true).crop(x);
        } else if (None$.MODULE$.equals(option)) {
            singlebandGeoTiff = this.readSingleband(byteReader);
        } else {
            throw new MatchError(option);
        }
        return singlebandGeoTiff;
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, boolean streaming) {
        return this.readSingleband(byteReader, streaming, true, (Option<ByteReader>)None$.MODULE$);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, boolean streaming, boolean withOverviews, Option<ByteReader> byteReaderExternal) {
        GeoTiffReader.GeoTiffInfo info = this.readGeoTiffInfo(byteReader, streaming, withOverviews, byteReaderExternal);
        GeoTiffTile geoTiffTile = this.geoTiffSinglebandTile(info);
        return GeoTiffReader$.getSingleband$1(geoTiffTile, info);
    }

    public GeoTiffTile geoTiffSinglebandTile(GeoTiffReader.GeoTiffInfo info2) {
        return info2.bandCount() == 1 ? GeoTiffTile$.MODULE$.apply(info2.segmentBytes(), info2.decompressor(), info2.segmentLayout(), info2.compression(), info2.cellType(), (Option<BandType>)new Some((Object)info2.bandType()), (List<GeoTiffTile>)((List)info2.overviews().map((Function1 & Serializable & scala.Serializable)info -> MODULE$.geoTiffSinglebandTile((GeoTiffReader.GeoTiffInfo)info), List$.MODULE$.canBuildFrom()))) : GeoTiffMultibandTile$.MODULE$.apply(info2.segmentBytes(), info2.decompressor(), info2.segmentLayout(), info2.compression(), info2.bandCount(), info2.cellType(), (Option<BandType>)new Some((Object)info2.bandType()), (List<GeoTiffMultibandTile>)((List)info2.overviews().map((Function1 & Serializable & scala.Serializable)info -> MODULE$.geoTiffMultibandTile((GeoTiffReader.GeoTiffInfo)info), List$.MODULE$.canBuildFrom()))).band(0);
    }

    public MultibandGeoTiff readMultiband(String path) {
        return this.readMultiband(path, false);
    }

    public MultibandGeoTiff readMultiband(String path, Extent e) {
        return this.readMultiband(path, (Option<Extent>)new Some((Object)e));
    }

    public MultibandGeoTiff readMultiband(String path, Option<Extent> e) {
        MultibandGeoTiff multibandGeoTiff;
        Option<Extent> option = e;
        if (option instanceof Some) {
            Some some = (Some)option;
            Extent x = (Extent)some.value();
            multibandGeoTiff = this.readMultiband(path, true).crop(x);
        } else if (None$.MODULE$.equals(option)) {
            multibandGeoTiff = this.readMultiband(path);
        } else {
            throw new MatchError(option);
        }
        return multibandGeoTiff;
    }

    public MultibandGeoTiff readMultiband(String path, boolean streaming) {
        String ovrPath = new StringBuilder(4).append(path).append(".ovr").toString();
        boolean ovrPathExists = new File(ovrPath).isFile();
        return streaming ? this.readMultiband((ByteReader)StreamingByteReader$.MODULE$.apply((RangeReader)FileRangeReader$.MODULE$.apply(path)), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)StreamingByteReader$.MODULE$.apply((RangeReader)FileRangeReader$.MODULE$.apply(ovrPath))) : None$.MODULE$)) : this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()))), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(ovrPath, Filesystem$.MODULE$.slurp$default$2())))) : None$.MODULE$));
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, Extent e) {
        return this.readMultiband(byteReader, (Option<Extent>)new Some((Object)e));
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, Option<Extent> e) {
        MultibandGeoTiff multibandGeoTiff;
        Option<Extent> option = e;
        if (option instanceof Some) {
            Some some = (Some)option;
            Extent x = (Extent)some.value();
            multibandGeoTiff = this.readMultiband(byteReader, true).crop(x);
        } else if (None$.MODULE$.equals(option)) {
            multibandGeoTiff = this.readMultiband(byteReader);
        } else {
            throw new MatchError(option);
        }
        return multibandGeoTiff;
    }

    public MultibandGeoTiff readMultiband(byte[] bytes) {
        return this.readMultiband(bytes, false);
    }

    public MultibandGeoTiff readMultiband(byte[] bytes, boolean streaming) {
        return this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), streaming);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader) {
        return this.readMultiband(byteReader, false);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, boolean streaming) {
        return this.readMultiband(byteReader, streaming, true, (Option<ByteReader>)None$.MODULE$);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, boolean streaming, boolean withOverviews, Option<ByteReader> byteReaderExternal) {
        GeoTiffReader.GeoTiffInfo info = this.readGeoTiffInfo(byteReader, streaming, withOverviews, byteReaderExternal);
        GeoTiffMultibandTile geoTiffTile = this.geoTiffMultibandTile(info);
        return GeoTiffReader$.getMultiband$1(geoTiffTile, info);
    }

    public GeoTiffMultibandTile geoTiffMultibandTile(GeoTiffReader.GeoTiffInfo info2) {
        return GeoTiffMultibandTile$.MODULE$.apply(info2.segmentBytes(), info2.decompressor(), info2.segmentLayout(), info2.compression(), info2.bandCount(), info2.cellType(), (Option<BandType>)new Some((Object)info2.bandType()), (List<GeoTiffMultibandTile>)((List)info2.overviews().map((Function1 & Serializable & scala.Serializable)info -> MODULE$.geoTiffMultibandTile((GeoTiffReader.GeoTiffInfo)info), List$.MODULE$.canBuildFrom())));
    }

    public GeoTiffReader.GeoTiffInfo readGeoTiffInfo(ByteReader byteReader, boolean streaming, boolean withOverviews) {
        return this.readGeoTiffInfo(byteReader, streaming, withOverviews, (Option<ByteReader>)None$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    public GeoTiffReader.GeoTiffInfo readGeoTiffInfo(ByteReader byteReader, boolean streaming, boolean withOverviews, Option<ByteReader> byteReaderExternal) {
        oldPos = byteReader.position();
        try {
            block15: {
                block14: {
                    byteReader.position(0L);
                    var10_6 = new Tuple2.mcCC.sp((char)byteReader.get(), (char)byteReader.get());
                    if (var10_6 == null) break block14;
                    var11_7 = var10_6._1$mcC$sp();
                    var12_8 = var10_6._2$mcC$sp();
                    if ('I' != var11_7 || 'I' != var12_8) break block14;
                    byteReader.order(ByteOrder.LITTLE_ENDIAN);
                    var7_9 = BoxedUnit.UNIT;
                    break block15;
                }
                if (var10_6 == null) ** GOTO lbl-1000
                var13_10 = var10_6._1$mcC$sp();
                var14_11 = var10_6._2$mcC$sp();
                if ('M' == var13_10 && 'M' == var14_11) {
                    byteReader.order(ByteOrder.BIG_ENDIAN);
                    var7_9 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    throw new MalformedGeoTiffException("incorrect byte order");
                }
            }
            byteReader.position(oldPos + 2L);
            tiffIdNumber = byteReader.getChar();
            if (tiffIdNumber != '*' && tiffIdNumber != '+') {
                throw new MalformedGeoTiffException(new StringBuilder(53).append("bad identification number (must be 42 or 43, was ").append(tiffIdNumber).append(" (").append((int)tiffIdNumber).append("))").toString());
            }
            tiffType = TiffType$.MODULE$.fromCode(tiffIdNumber);
            var18_14 = tiffType;
            if (Tiff$.MODULE$.equals(var18_14)) {
                smallStart = byteReader.getInt();
                var6_16 = TiffTagsReader$.MODULE$.read(byteReader, smallStart, IntTiffTagOffsetSize$.MODULE$);
            } else {
                byteReader.position(8L);
                bigStart = byteReader.getLong();
                var6_16 = TiffTagsReader$.MODULE$.read(byteReader, bigStart, LongTiffTagOffsetSize$.MODULE$);
            }
            baseTiffTags = var6_16;
            tiffTagsBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (withOverviews) {
                var24_20 = tiffType;
                if (Tiff$.MODULE$.equals(var24_20)) {
                    ifdOffset = byteReader.getInt();
                    while (ifdOffset > 0) {
                        tiffTagsBuffer.$plus$eq((Object)TiffTagsReader$.MODULE$.read(byteReader, ifdOffset, IntTiffTagOffsetSize$.MODULE$));
                        ifdOffset = byteReader.getInt();
                    }
                    var5_22 = BoxedUnit.UNIT;
                } else {
                    ifdOffset = byteReader.getLong();
                    while (ifdOffset > 0L) {
                        tiffTagsBuffer.$plus$eq((Object)TiffTagsReader$.MODULE$.read(byteReader, ifdOffset, LongTiffTagOffsetSize$.MODULE$));
                        ifdOffset = byteReader.getLong();
                    }
                    var5_23 = BoxedUnit.UNIT;
                }
            }
            tiffTagsList = tiffTagsBuffer.toList();
            list = (List)tiffTagsList.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readGeoTiffInfo$2(geotrellis.util.ByteReader boolean geotrellis.raster.io.geotiff.TiffType geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.raster.io.geotiff.tags.TiffTags ), (Lgeotrellis/raster/io/geotiff/tags/TiffTags;)Lgeotrellis/raster/io/geotiff/reader/GeoTiffReader$GeoTiffInfo;)((ByteReader)byteReader, (boolean)streaming, (TiffType)tiffType, (TiffTags)baseTiffTags), List$.MODULE$.canBuildFrom());
            overviews = tiffTagsList.isEmpty() != false && withOverviews != false ? (List)byteReaderExternal.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readGeoTiffInfo$3(boolean boolean geotrellis.raster.io.geotiff.tags.TiffTags geotrellis.util.ByteReader ), (Lgeotrellis/util/ByteReader;)Lscala/collection/immutable/List;)((boolean)streaming, (boolean)withOverviews, (TiffTags)baseTiffTags)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$readGeoTiffInfo$5(scala.collection.immutable.List ), ()Lscala/collection/immutable/List;)((List)list)) : list;
            v0 = GeoTiffReader$.getGeoTiffInfo$1(baseTiffTags, overviews, byteReader, streaming, tiffType, baseTiffTags);
        }
        finally {
            byteReader.position(oldPos);
        }
        return v0;
    }

    public GeoTiffReader<Tile> singlebandGeoTiffReader() {
        return this.singlebandGeoTiffReader;
    }

    public GeoTiffReader<MultibandTile> multibandGeoTiffReader() {
        return this.multibandGeoTiffReader;
    }

    public <V extends CellGrid> GeoTiffReader<V> apply(GeoTiffReader<V> ev) {
        return ev;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final SinglebandGeoTiff getSingleband$1(GeoTiffTile geoTiffTile, GeoTiffReader.GeoTiffInfo info) {
        return new SinglebandGeoTiff(geoTiffTile, info.extent(), info.crs(), info.tags(), info.options(), (List<GeoTiff<Tile>>)((List)info.overviews().map((Function1 & Serializable & scala.Serializable)i -> GeoTiffReader$.getSingleband$1(MODULE$.geoTiffSinglebandTile((GeoTiffReader.GeoTiffInfo)i), i), List$.MODULE$.canBuildFrom())));
    }

    private static final MultibandGeoTiff getMultiband$1(GeoTiffMultibandTile geoTiffTile, GeoTiffReader.GeoTiffInfo info) {
        return new MultibandGeoTiff(geoTiffTile, info.extent(), info.crs(), info.tags(), info.options(), (List<GeoTiff<MultibandTile>>)((List)info.overviews().map((Function1 & Serializable & scala.Serializable)i -> GeoTiffReader$.getMultiband$1(MODULE$.geoTiffMultibandTile((GeoTiffReader.GeoTiffInfo)i), i), List$.MODULE$.canBuildFrom())));
    }

    private static final GeoTiffReader.GeoTiffInfo getGeoTiffInfo$1(TiffTags tiffTags, List overviews, ByteReader byteReader$1, boolean streaming$1, TiffType tiffType$1, TiffTags baseTiffTags$1) {
        StorageMethod storageMethod;
        InterleaveMethod interleaveMethod = tiffTags.interleaveMethod();
        Decompressor decompressor = Decompressor$.MODULE$.apply(tiffTags, byteReader$1.order());
        if (tiffTags.hasStripStorage()) {
            int rowsPerStrip = (int)BoxesRunTime.unboxToLong((Object)apply$.MODULE$.toApplyLensOps((Object)tiffTags).$amp$bar$minus$greater(TiffTags$.MODULE$._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._rowsPerStrip()).get());
            storageMethod = Striped$.MODULE$.apply(rowsPerStrip);
        } else {
            int blockCols = (int)BoxesRunTime.unboxToLong((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)tiffTags).$amp$bar$minus$greater(TiffTags$.MODULE$._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileWidth()).get()).get());
            int blockRows = (int)BoxesRunTime.unboxToLong((Object)((Option)apply$.MODULE$.toApplyLensOps((Object)tiffTags).$amp$bar$minus$greater(TiffTags$.MODULE$._tileTags()).$up$bar$minus$greater(TileTags$.MODULE$._tileLength()).get()).get());
            storageMethod = new Tiled(blockCols, blockRows);
        }
        Striped storageMethod2 = storageMethod;
        int cols = tiffTags.cols();
        int rows = tiffTags.rows();
        BandType bandType = tiffTags.bandType();
        int bandCount = tiffTags.bandCount();
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(cols, rows, storageMethod2, interleaveMethod, bandType);
        SegmentBytes segmentBytes = streaming$1 ? LazySegmentBytes$.MODULE$.apply(byteReader$1, tiffTags) : ArraySegmentBytes$.MODULE$.apply(byteReader$1, tiffTags);
        Option noDataValue = (Option)apply$.MODULE$.toApplyLensOps((Object)tiffTags).$amp$bar$minus$greater(TiffTags$.MODULE$._geoTiffTags()).$up$bar$minus$greater(GeoTiffTags$.MODULE$._gdalInternalNoData()).get();
        Option subfileType = ((Option)apply$.MODULE$.toApplyLensOps((Object)tiffTags).$amp$bar$minus$greater(TiffTags$.MODULE$._nonBasicTags()).$up$bar$minus$greater(NonBasicTags$.MODULE$._newSubfileType()).get()).flatMap((Function1 & Serializable & scala.Serializable)code -> NewSubfileType$.MODULE$.fromCode(BoxesRunTime.unboxToLong((Object)code)));
        Decompressor decompressor2 = decompressor;
        Compression compression = NoCompression$.MODULE$.equals(decompressor2) ? NoCompression$.MODULE$ : DeflateCompression$.MODULE$;
        Compression compression2 = compression;
        int colorSpace = tiffTags.basicTags().photometricInterp();
        None$ colorMap = colorSpace == ColorSpace$.MODULE$.Palette() && tiffTags.basicTags().colorMap().nonEmpty() ? Option$.MODULE$.apply((Object)IndexedColorMap$.MODULE$.fromTiffPalette(tiffTags.basicTags().colorMap())) : None$.MODULE$;
        return new GeoTiffReader.GeoTiffInfo(baseTiffTags$1.extent(), baseTiffTags$1.crs(), tiffTags.tags(), new GeoTiffOptions(storageMethod2, compression2, colorSpace, (Option<IndexedColorMap>)colorMap, interleaveMethod, (Option<NewSubfileType>)subfileType, tiffType$1), bandType, segmentBytes, decompressor, segmentLayout, compression2, bandCount, (Option<Object>)noDataValue, (List<GeoTiffReader.GeoTiffInfo>)overviews);
    }

    private static final List getGeoTiffInfo$default$2$1() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ GeoTiffReader.GeoTiffInfo $anonfun$readGeoTiffInfo$2(ByteReader byteReader$1, boolean streaming$1, TiffType tiffType$1, TiffTags baseTiffTags$1, TiffTags x$2) {
        return GeoTiffReader$.getGeoTiffInfo$1(x$2, GeoTiffReader$.getGeoTiffInfo$default$2$1(), byteReader$1, streaming$1, tiffType$1, baseTiffTags$1);
    }

    public static final /* synthetic */ List $anonfun$readGeoTiffInfo$3(boolean streaming$1, boolean withOverviews$1, TiffTags baseTiffTags$1, ByteReader reader) {
        return (List)MODULE$.readGeoTiffInfo(reader, streaming$1, withOverviews$1, (Option<ByteReader>)None$.MODULE$).toList().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.copy(baseTiffTags$1.extent(), baseTiffTags$1.crs(), x$3.copy$default$3(), x$3.copy$default$4(), x$3.copy$default$5(), x$3.copy$default$6(), x$3.copy$default$7(), x$3.copy$default$8(), x$3.copy$default$9(), x$3.copy$default$10(), x$3.copy$default$11(), x$3.copy$default$12()), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ List $anonfun$readGeoTiffInfo$5(List list$1) {
        return list$1;
    }

    private GeoTiffReader$() {
        MODULE$ = this;
        this.singlebandGeoTiffReader = new GeoTiffReader<Tile>(){

            public GeoTiff<Tile> read(byte[] bytes) {
                return GeoTiffReader.read$(this, bytes);
            }

            public GeoTiff<Tile> read(ByteReader byteReader, boolean streaming) {
                return GeoTiffReader$.MODULE$.readSingleband(byteReader, streaming);
            }
            {
                GeoTiffReader.$init$(this);
            }
        };
        this.multibandGeoTiffReader = new GeoTiffReader<MultibandTile>(){

            public GeoTiff<MultibandTile> read(byte[] bytes) {
                return GeoTiffReader.read$(this, bytes);
            }

            public GeoTiff<MultibandTile> read(ByteReader byteReader, boolean streaming) {
                return GeoTiffReader$.MODULE$.readMultiband(byteReader, streaming);
            }
            {
                GeoTiffReader.$init$(this);
            }
        };
    }
}

