/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.reader;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.reader.TiffTagsReader$ByteReaderTagReaderWrapper$;
import geotrellis.raster.io.geotiff.tags.BasicTags$;
import geotrellis.raster.io.geotiff.tags.TiffTagMetadata;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.TiffTags$;
import geotrellis.raster.io.geotiff.tags.codes.TagCodes$;
import geotrellis.raster.io.geotiff.tags.codes.TiffFieldType$;
import geotrellis.raster.io.geotiff.util.IntTiffTagOffsetSize$;
import geotrellis.raster.io.geotiff.util.LongTiffTagOffsetSize$;
import geotrellis.raster.io.geotiff.util.TiffTagOffsetSize;
import geotrellis.raster.io.geotiff.util.package$;
import geotrellis.util.ByteReader;
import geotrellis.util.ByteReader$;
import geotrellis.util.Filesystem$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import monocle.syntax.apply$;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TiffTagsReader$
implements LazyLogging {
    public static TiffTagsReader$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new TiffTagsReader$();
    }

    private Logger logger$lzycompute() {
        TiffTagsReader$ tiffTagsReader$ = this;
        synchronized (tiffTagsReader$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public TiffTags read(String path) {
        return this.read(ByteReader$.MODULE$.byteBuffer2ByteReader(Filesystem$.MODULE$.toMappedByteBuffer(path)));
    }

    public TiffTags read(byte[] bytes) {
        return this.read(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)));
    }

    /*
     * Unable to fully structure code
     */
    public TiffTags read(ByteReader byteReader) {
        block7: {
            block6: {
                var3_2 = new Tuple2.mcCC.sp((char)byteReader.get(), (char)byteReader.get());
                if (var3_2 == null) break block6;
                var4_3 = var3_2._1$mcC$sp();
                var5_4 = var3_2._2$mcC$sp();
                if ('I' != var4_3 || 'I' != var5_4) break block6;
                byteReader.order(ByteOrder.LITTLE_ENDIAN);
                var2_5 = BoxedUnit.UNIT;
                break block7;
            }
            if (var3_2 == null) ** GOTO lbl-1000
            var6_7 = var3_2._1$mcC$sp();
            var7_8 = var3_2._2$mcC$sp();
            if ('M' == var6_7 && 'M' == var7_8) {
                byteReader.order(ByteOrder.BIG_ENDIAN);
                var2_6 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                throw new MalformedGeoTiffException("incorrect byte order");
            }
        }
        var8_9 = byteReader.getChar();
        switch (var8_9) {
            case '*': {
                v0 = this.read(byteReader, byteReader.getInt(), IntTiffTagOffsetSize$.MODULE$);
                break;
            }
            case '+': {
                byteReader.position(8L);
                v0 = this.read(byteReader, byteReader.getLong(), LongTiffTagOffsetSize$.MODULE$);
                break;
            }
            default: {
                throw new MalformedGeoTiffException(new StringBuilder(50).append("bad identification number (must be 42 or 43, was ").append(var8_9).append(")").toString());
            }
        }
        return v0;
    }

    public TiffTags read(ByteReader byteReader, long tagsStartPosition, TiffTagOffsetSize ttos) {
        TiffTags tiffTags;
        long l;
        TiffTagOffsetSize tiffTagOffsetSize = ttos;
        if (IntTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize)) {
            byteReader.position((long)((int)tagsStartPosition));
            l = byteReader.getShort();
        } else if (LongTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize)) {
            byteReader.position(tagsStartPosition);
            l = byteReader.getLong();
        } else {
            throw new MatchError((Object)tiffTagOffsetSize);
        }
        long tagCount = l;
        TiffTags tiffTags2 = new TiffTags(TiffTags$.MODULE$.apply$default$1(), TiffTags$.MODULE$.apply$default$2(), TiffTags$.MODULE$.apply$default$3(), TiffTags$.MODULE$.apply$default$4(), TiffTags$.MODULE$.apply$default$5(), TiffTags$.MODULE$.apply$default$6(), TiffTags$.MODULE$.apply$default$7(), TiffTags$.MODULE$.apply$default$8(), TiffTags$.MODULE$.apply$default$9(), TiffTags$.MODULE$.apply$default$10(), TiffTags$.MODULE$.apply$default$11(), TiffTags$.MODULE$.apply$default$12(), TiffTags$.MODULE$.apply$default$13(), TiffTags$.MODULE$.apply$default$14());
        None$ geoTags = None$.MODULE$;
        int index$macro$386 = 0;
        while ((long)index$macro$386 < tagCount) {
            TiffTagMetadata tiffTagMetadata;
            TiffTagOffsetSize tiffTagOffsetSize2 = ttos;
            if (IntTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize2)) {
                tiffTagMetadata = new TiffTagMetadata(package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), byteReader.getInt(), byteReader.getInt());
            } else if (LongTiffTagOffsetSize$.MODULE$.equals(tiffTagOffsetSize2)) {
                tiffTagMetadata = new TiffTagMetadata(package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), package$.MODULE$.ByteReaderUtilities(byteReader).getUnsignedShort(), byteReader.getLong(), byteReader.getLong());
            } else {
                throw new MatchError((Object)tiffTagOffsetSize2);
            }
            TiffTagMetadata tagMetadata = tiffTagMetadata;
            if (tagMetadata.tag() == TagCodes$.MODULE$.GeoKeyDirectoryTag()) {
                geoTags = new Some((Object)tagMetadata);
            } else {
                tiffTags2 = this.readTag(byteReader, tiffTags2, tagMetadata, ttos);
            }
            ++index$macro$386;
        }
        None$ none$ = geoTags;
        if (none$ instanceof Some) {
            Some some = (Some)none$;
            TiffTagMetadata t = (TiffTagMetadata)some.value();
            tiffTags2 = this.readTag(byteReader, tiffTags2, t, ttos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(none$)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)none$);
        }
        if (tiffTags2.hasStripStorage()) {
            int rowsPerStrip = (int)BoxesRunTime.unboxToLong((Object)apply$.MODULE$.toApplyLensOps((Object)tiffTags2).$amp$bar$minus$greater(TiffTags$.MODULE$._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._rowsPerStrip()).get());
            if (rowsPerStrip < 0) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("RowsPerStrip tag is not not defined, interpreting TIFF as a single strip.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                tiffTags = (TiffTags)apply$.MODULE$.toApplyLensOps((Object)tiffTags2).$amp$bar$minus$greater(TiffTags$.MODULE$._basicTags()).$up$bar$minus$greater(BasicTags$.MODULE$._rowsPerStrip()).set((Object)BoxesRunTime.boxToLong((long)tiffTags2.rows()));
            } else {
                tiffTags = tiffTags2;
            }
        } else {
            tiffTags = tiffTags2;
        }
        return tiffTags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TiffTags readTag(ByteReader byteReader, TiffTags tiffTags, TiffTagMetadata tagMetadata, TiffTagOffsetSize ttos) {
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tagMetadata.tag(), tagMetadata.fieldType());
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            if (TagCodes$.MODULE$.ModelPixelScaleTag() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readModelPixelScaleTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            if (TagCodes$.MODULE$.ModelTiePointsTag() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readModelTiePointsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._1$mcI$sp();
            if (TagCodes$.MODULE$.GeoKeyDirectoryTag() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readGeoKeyDirectoryTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.BytesFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readBytesTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.AsciisFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readAsciisTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.ShortsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readShortsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.IntsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readIntsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.FractionalsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readFractionalsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedBytesFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedBytesTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.UndefinedFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readUndefinedTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedShortsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedShortsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedIntsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedIntsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedFractionalsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readSignedFractionalsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.FloatsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readFloatsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.DoublesFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readDoublesTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.LongsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readLongsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 != null) {
            int n = sp2._2$mcI$sp();
            if (TiffFieldType$.MODULE$.SignedLongsFieldType() == n) {
                return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readLongsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        int n = sp2._2$mcI$sp();
        if (TiffFieldType$.MODULE$.IFDOffset() != n) throw new MatchError((Object)sp2);
        return TiffTagsReader$ByteReaderTagReaderWrapper$.MODULE$.readLongsTag$extension(this.ByteReaderTagReaderWrapper(byteReader), tiffTags, tagMetadata, ttos);
    }

    public ByteReader ByteReaderTagReaderWrapper(ByteReader byteReader) {
        return byteReader;
    }

    private TiffTagsReader$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

