/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.writer;

import geotrellis.proj4.CRS;
import geotrellis.raster.PixelIsPoint$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.io.geotiff.tags.AngularUnitTypes$;
import geotrellis.raster.io.geotiff.tags.CommonPublicValues$;
import geotrellis.raster.io.geotiff.tags.CoordinateTransformTypes$;
import geotrellis.raster.io.geotiff.tags.DatumTypes$;
import geotrellis.raster.io.geotiff.tags.EllipsoidTypes$;
import geotrellis.raster.io.geotiff.tags.GeoKeys$;
import geotrellis.raster.io.geotiff.tags.GeographicCSTypes$;
import geotrellis.raster.io.geotiff.tags.ModelTypes$;
import geotrellis.raster.io.geotiff.tags.ProjectedLinearUnits$;
import geotrellis.raster.io.geotiff.tags.ProjectionTypesMap$;
import geotrellis.raster.io.geotiff.writer.CoordinateSystemParser$;
import geotrellis.raster.io.geotiff.writer.GeoTiffWriterLimitationException;
import geotrellis.raster.io.geotiff.writer.MalformedProj4Exception;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Uv!B\u0001\u0003\u0011\u0003i\u0011AF\"p_J$\u0017N\\1uKNK8\u000f^3n!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011AB<sSR,'O\u0003\u0002\u0006\r\u00059q-Z8uS\u001a4'BA\u0004\t\u0003\tIwN\u0003\u0002\n\u0015\u00051!/Y:uKJT\u0011aC\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003\u001d=i\u0011A\u0001\u0004\u0006!\tA\t!\u0005\u0002\u0017\u0007>|'\u000fZ5oCR,7+_:uK6\u0004\u0016M]:feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%\t!H\u0001\u0011\u000f\u0016|G+\u001b4g\t>,(\r\\3UC\u001e,\u0012A\b\t\u0003'}I!\u0001\t\u000b\u0003\u0007%sG\u000f\u0003\u0004#\u001f\u0001\u0006IAH\u0001\u0012\u000f\u0016|G+\u001b4g\t>,(\r\\3UC\u001e\u0004\u0003\"\u0002\u0013\u0010\t\u0003)\u0013!B1qa2LH#\u0002\u0014\u0002$\u0006\u0015\u0006C\u0001\b(\r\u0011\u0001\"\u0001\u0001\u0015\u0014\u0005\u001d\u0012\u0002\u0002\u0003\u0016(\u0005\u000b\u0007I\u0011A\u0016\u0002\u0007\r\u00148/F\u0001-!\ti\u0003'D\u0001/\u0015\ty#\"A\u0003qe>TG'\u0003\u00022]\t\u00191IU*\t\u0011M:#\u0011!Q\u0001\n1\nAa\u0019:tA!AQg\nBC\u0002\u0013\u0005a'A\bqSb,GnU1na2,G+\u001f9f+\u00059\u0004cA\n9u%\u0011\u0011\b\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005mbT\"\u0001\u0005\n\u0005uB!a\u0004)jq\u0016d7+Y7qY\u0016$\u0016\u0010]3\t\u0011}:#\u0011!Q\u0001\n]\n\u0001\u0003]5yK2\u001c\u0016-\u001c9mKRK\b/\u001a\u0011\t\u000be9C\u0011A!\u0015\u0007\u0019\u00125\tC\u0003+\u0001\u0002\u0007A\u0006C\u00036\u0001\u0002\u0007q\u0007C\u0004FO\t\u0007I\u0011\u0002$\u0002\u0017A\u0014xN\u001b\u001bTiJLgnZ\u000b\u0002\u000fB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u000b\u000e\u0003-S!\u0001\u0014\u0007\u0002\rq\u0012xn\u001c;?\u0013\tqE#\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(\u0015\u0011\u0019\u0019v\u0005)A\u0005\u000f\u0006a\u0001O]8kiM#(/\u001b8hA!9Qk\nb\u0001\n\u00131\u0016\u0001\u00039s_*$T*\u00199\u0016\u0003]\u0003B\u0001W/H\u000f6\t\u0011L\u0003\u0002[7\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u00039R\t!bY8mY\u0016\u001cG/[8o\u0013\tq\u0016LA\u0002NCBDa\u0001Y\u0014!\u0002\u00139\u0016!\u00039s_*$T*\u00199!\u0011)\u0011w\u0005%A\t\b\u0004&IaY\u0001\u0004q\u00122T#\u00013\u0011\tM)gdZ\u0005\u0003MR\u0011a\u0001V;qY\u0016\u0014\u0004cA\n9QB)1#[6lW&\u0011!\u000e\u0006\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005Ma\u0017BA7\u0015\u0005\u0019!u.\u001e2mK\"Aqn\nEC\u0002\u0013%Q$A\u0005fY2L\u0007o]8jI\"A\u0011o\nEC\u0002\u0013%!/\u0001\u0005paR\u001cV-\\5t+\u00059\u0007B\u0003;(!\u0003E9\u0019)C\u0005k\u0006\u0019\u0001\u0010J\u001c\u0016\u0003Y\u0004BaE3\u001f=!A\u0001p\nEC\u0002\u0013%Q$A\u0002hGND\u0001B_\u0014\t\u0006\u0004%I!H\u0001\u0006I\u0006$X/\u001c\u0005\ty\u001eB)\u0019!C\u0001{\u0006)\u0001/\u0019:tKV\ta\u0010E\u0003\u0014K~\fY\u0001E\u0003\u0014\u0003\u0003\t)!C\u0002\u0002\u0004Q\u0011Q!\u0011:sCf\u0004raEA\u0004=yqb$C\u0002\u0002\nQ\u0011a\u0001V;qY\u0016$\u0004\u0003B\n\u0002\u0002-D!\"a\u0004(\u0011\u000b\u0007I\u0011BA\t\u0003%\u0001(o\u001c6Qe>\u00048/\u0006\u0002\u0002\u0014A11#ZA\u000b\u00037\u0001B\u0001WA\fm&\u0019\u0011\u0011D-\u0003\t1K7\u000f\u001e\t\u00061\u0006]\u0011Q\u0004\t\u0005'\u0015t2\u000e\u0003\u0006\u0002\"\u001dB)\u0019!C\u0005\u0003#\t!\u0002^7fe\u000e\u0004&o\u001c9t\u0011)\t)c\nEC\u0002\u0013%\u0011\u0011C\u0001\tkRl\u0007K]8qg\"Q\u0011\u0011F\u0014\t\u0006\u0004%I!!\u0005\u0002\u00111\u001c7\r\u0015:paND!\"!\f(\u0011\u000b\u0007I\u0011BA\u0018\u00031awN\\4MCR\u0004&o\u001c9t+\t\t\t\u0004\u0005\u0004\u0014K\u0006U\u00111\u0007\b\u00041\u0006U\u0012bAA\u001c3\u0006\u0019a*\u001b7\t\u0015\u0005mr\u0005#b\u0001\n\u0013\ty#A\bhGN|%\u000fR1uk6\u0004&o\u001c9t\u0011)\tyd\nEC\u0002\u0013%\u0011\u0011C\u0001\u000fK2d\u0017\u000e]:pS\u0012\u0004&o\u001c9t\u0011)\t\u0019e\nEC\u0002\u0013%\u0011\u0011C\u0001\ng&tW\u000f\u0015:paND!\"a\u0012(\u0011\u000b\u0007I\u0011BA\t\u0003=a\u0017N\\3beVs\u0017\u000e\u001e)s_B\u001c\bBCA&O!\u0015\r\u0011\"\u0003\u0002\u0012\u0005A\u0011-Z1Qe>\u00048\u000fC\u0004\u0002P\u001d\"I!!\u0015\u0002\u0013%\u001cH)\u001a4j]\u0016$G\u0003BA*\u00033\u00022aEA+\u0013\r\t9\u0006\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\tY&!\u0014A\u0002\u001d\u000b1a[3z\u0011\u001d\tyf\nC\u0005\u0003C\n\u0011bZ3u'R\u0014\u0018N\\4\u0015\u000b\u001d\u000b\u0019'!\u001a\t\u000f\u0005m\u0013Q\fa\u0001\u000f\"9\u0011qMA/\u0001\u00049\u0015\u0001\u00023fMZCq!a\u001b(\t\u0013\ti'\u0001\u0004hKRLe\u000e\u001e\u000b\u0006=\u0005=\u0014\u0011\u000f\u0005\b\u00037\nI\u00071\u0001H\u0011%\t9'!\u001b\u0011\u0002\u0003\u0007q\tC\u0004\u0002v\u001d\"I!a\u001e\u0002\u0013\u001d,G\u000fR8vE2,G#B6\u0002z\u0005m\u0004bBA.\u0003g\u0002\ra\u0012\u0005\n\u0003O\n\u0019\b%AA\u0002\u001dCq!a (\t\u0013\t\t)\u0001\u0003hKR\\EcA6\u0002\u0004\"9\u0011qMA?\u0001\u0004Y\u0007\"CADOE\u0005I\u0011BAE\u0003M9W\r\u001e#pk\ndW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tYIK\u0002H\u0003\u001b[#!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033#\u0012AC1o]>$\u0018\r^5p]&!\u0011QTAJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003C;\u0013\u0013!C\u0005\u0003\u0013\u000b\u0001cZ3u\u0013:$H\u0005Z3gCVdG\u000f\n\u001a\t\u000b)\u001a\u0003\u0019\u0001\u0017\t\u000bU\u001a\u0003\u0019A\u001c\t\rq|A\u0011AAU)\u0019\tY+!-\u00024B\u0019a\"!,\n\u0007\u0005=&A\u0001\tHK>$\u0015N]3di>\u0014\u0018\u0010V1hg\"1!&a*A\u00021Ba!NAT\u0001\u00049\u0004")
public class CoordinateSystemParser {
    private Tuple2<Object, Option<Tuple3<Object, Object, Object>>> x$6;
    private int ellipsoid;
    private Option<Tuple3<Object, Object, Object>> optSemis;
    private Tuple2<Object, Object> x$7;
    private int gcs;
    private int datum;
    private Tuple2<Tuple4<Object, Object, Object, Object>[], double[]> parse;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> projProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tmercProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> utmProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> lccProps;
    private Tuple2<List<Tuple2<Object, Object>>, Nil$> longLatProps;
    private Tuple2<List<Tuple2<Object, Object>>, Nil$> gcsOrDatumProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> ellipsoidProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> sinuProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> linearUnitProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> aeaProps;
    private final CRS crs;
    private final Option<PixelSampleType> pixelSampleType;
    private final String proj4String;
    private final Map<String, String> proj4Map;
    private volatile int bitmap$0;

    public static CoordinateSystemParser apply(CRS cRS, Option<PixelSampleType> option) {
        return CoordinateSystemParser$.MODULE$.apply(cRS, option);
    }

    public static int GeoTiffDoubleTag() {
        return CoordinateSystemParser$.MODULE$.GeoTiffDoubleTag();
    }

    public CRS crs() {
        return this.crs;
    }

    public Option<PixelSampleType> pixelSampleType() {
        return this.pixelSampleType;
    }

    private String proj4String() {
        return this.proj4String;
    }

    private Map<String, String> proj4Map() {
        return this.proj4Map;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Object, Option<Tuple3<Object, Object, Object>>> x$6$lzycompute() {
        block12: {
            var3_1 = this;
            synchronized (var3_1) {
                if ((this.bitmap$0 & 1) != 0) break block12;
                var5_2 = false;
                var6_3 = null;
                var7_4 = this.proj4Map().get((Object)"ellps");
                if (!(var7_4 instanceof Some)) ** GOTO lbl-1000
                var5_2 = true;
                var6_3 = (Some)var7_4;
                var8_5 = (String)var6_3.value();
                if ("WGS84".equals(var8_5)) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_WGS_84()), (Object)None$.MODULE$);
                } else if (var5_2 && "clrk66".equals(var9_7 = (String)var6_3.value())) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_Clarke_1866()), (Object)None$.MODULE$);
                } else if (var5_2 && "clrk80".equals(var10_8 = (String)var6_3.value())) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_Clarke_1880()), (Object)None$.MODULE$);
                } else if (var5_2 && "GRS80".equals(var11_9 = (String)var6_3.value())) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_GRS_1980()), (Object)None$.MODULE$);
                } else {
                    ellps = CommonPublicValues$.MODULE$.UserDefinedCPV();
                    major = this.getDouble("a", this.getDouble$default$2());
                    minor = this.getDouble("b", this.getDouble$default$2());
                    invFlattening = this.getDouble("rf", this.getDouble$default$2());
                    var2_6 = invFlattening == 0.0 && minor != 0.0 ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)ellps), (Object)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)major), (Object)BoxesRunTime.boxToDouble((double)minor), (Object)BoxesRunTime.boxToDouble((double)((double)-1 / (minor / major - (double)true)))))) : new Tuple2((Object)BoxesRunTime.boxToInteger((int)ellps), (Object)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)major), (Object)BoxesRunTime.boxToDouble((double)minor), (Object)BoxesRunTime.boxToDouble((double)invFlattening))));
                }
                var4_14 = var2_6;
                if (var4_14 == null) {
                    throw new MatchError((Object)var4_14);
                }
                ellipsoid = var4_14._1$mcI$sp();
                optSemis = (Option)var4_14._2();
                var1_17 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ellipsoid), (Object)optSemis);
                this.x$6 = var1_17;
                this.bitmap$0 |= 1;
            }
        }
        return this.x$6;
    }

    private /* synthetic */ Tuple2 x$6() {
        return (this.bitmap$0 & 1) == 0 ? this.x$6$lzycompute() : this.x$6;
    }

    private int ellipsoid$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 2) == 0) {
                this.ellipsoid = this.x$6()._1$mcI$sp();
                this.bitmap$0 |= 2;
            }
        }
        return this.ellipsoid;
    }

    private int ellipsoid() {
        return (this.bitmap$0 & 2) == 0 ? this.ellipsoid$lzycompute() : this.ellipsoid;
    }

    private Option<Tuple3<Object, Object, Object>> optSemis$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 4) == 0) {
                this.optSemis = (Option)this.x$6()._2();
                this.bitmap$0 |= 4;
            }
        }
        return this.optSemis;
    }

    private Option<Tuple3<Object, Object, Object>> optSemis() {
        return (this.bitmap$0 & 4) == 0 ? this.optSemis$lzycompute() : this.optSemis;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Object, Object> x$7$lzycompute() {
        block6: {
            var3_1 = this;
            synchronized (var3_1) {
                if ((this.bitmap$0 & 8) != 0) break block6;
                var5_2 = false;
                var6_3 = null;
                var7_4 = this.proj4Map().get((Object)"datum");
                if (!(var7_4 instanceof Some)) ** GOTO lbl-1000
                var5_2 = true;
                var6_3 = (Some)var7_4;
                var8_5 = (String)var6_3.value();
                if ("WGS84".equals(var8_5)) {
                    var2_6 = new Tuple2.mcII.sp(GeographicCSTypes$.MODULE$.GCS_WGS_84(), DatumTypes$.MODULE$.Datum_WGS84());
                } else lbl-1000:
                // 2 sources

                {
                    var2_6 = var5_2 != false && "NAD83".equals(var9_7 = (String)var6_3.value()) != false ? new Tuple2.mcII.sp(GeographicCSTypes$.MODULE$.GCS_NAD83(), DatumTypes$.MODULE$.Datum_North_American_Datum_1983()) : (var5_2 != false && "NAD27".equals(var10_8 = (String)var6_3.value()) != false ? new Tuple2.mcII.sp(GeographicCSTypes$.MODULE$.GCS_NAD27(), DatumTypes$.MODULE$.Datum_North_American_Datum_1927()) : new Tuple2.mcII.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), CommonPublicValues$.MODULE$.UserDefinedCPV()));
                }
                var4_9 = var2_6;
                if (var4_9 == null) {
                    throw new MatchError((Object)var4_9);
                }
                gcs = var4_9._1$mcI$sp();
                datum = var4_9._2$mcI$sp();
                var1_12 = new Tuple2.mcII.sp(gcs, datum);
                this.x$7 = var1_12;
                this.bitmap$0 |= 8;
            }
        }
        return this.x$7;
    }

    private /* synthetic */ Tuple2 x$7() {
        return (this.bitmap$0 & 8) == 0 ? this.x$7$lzycompute() : this.x$7;
    }

    private int gcs$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.gcs = this.x$7()._1$mcI$sp();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.gcs;
    }

    private int gcs() {
        return (this.bitmap$0 & 0x10) == 0 ? this.gcs$lzycompute() : this.gcs;
    }

    private int datum$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.datum = this.x$7()._2$mcI$sp();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.datum;
    }

    private int datum() {
        return (this.bitmap$0 & 0x20) == 0 ? this.datum$lzycompute() : this.datum;
    }

    private Tuple2<Tuple4<Object, Object, Object, Object>[], double[]> parse$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x40) == 0) {
                ListBuffer listBuffer;
                Some some;
                PixelSampleType pixelSampleType;
                ListBuffer geoKeysIntBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                ListBuffer doublesBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                Option<PixelSampleType> option = this.pixelSampleType();
                ListBuffer listBuffer2 = option instanceof Some && PixelIsPoint$.MODULE$.equals(pixelSampleType = (PixelSampleType)(some = (Some)option).value()) ? geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTRasterTypeGeoKey(), 2), (List)Nil$.MODULE$)) : geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTRasterTypeGeoKey(), 1), (List)Nil$.MODULE$));
                int epsgCode = BoxesRunTime.unboxToInt((Object)this.crs().epsgCode().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ProjectionTypesMap$.MODULE$.UserDefinedProjectionType()));
                if (epsgCode != ProjectionTypesMap$.MODULE$.UserDefinedProjectionType()) {
                    .colon.colon projPropsGeoKeysInt = this.crs().isGeographic() ? new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeGeographic()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogTypeGeoKey(), epsgCode), (List)Nil$.MODULE$)) : new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogAngularUnitsGeoKey(), 9102), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), epsgCode), (List)Nil$.MODULE$)));
                    listBuffer = geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)projPropsGeoKeysInt);
                } else {
                    Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tuple2 = this.projProps();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    List projPropsGeoKeysInt = (List)tuple2._1();
                    List projPropsDoubles = (List)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)projPropsGeoKeysInt, (Object)projPropsDoubles);
                    Tuple2 tuple23 = tuple22;
                    List projPropsGeoKeysInt2 = (List)tuple23._1();
                    List projPropsDoubles2 = (List)tuple23._2();
                    geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)projPropsGeoKeysInt2);
                    doublesBuffer.$plus$plus$eq((TraversableOnce)projPropsDoubles2);
                    Tuple2<List<Tuple2<Object, Object>>, Nil$> tuple24 = this.gcsOrDatumProps();
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    List gcsOrDatumGeoKeysInt = (List)tuple24._1();
                    Nil$ gcsOrDatumDoubles = (Nil$)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)gcsOrDatumGeoKeysInt, (Object)gcsOrDatumDoubles);
                    Tuple2 tuple26 = tuple25;
                    List gcsOrDatumGeoKeysInt2 = (List)tuple26._1();
                    Nil$ gcsOrDatumDoubles2 = (Nil$)tuple26._2();
                    geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)gcsOrDatumGeoKeysInt2);
                    doublesBuffer.$plus$plus$eq((TraversableOnce)gcsOrDatumDoubles2);
                    Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tuple27 = this.ellipsoidProps();
                    if (tuple27 == null) {
                        throw new MatchError(tuple27);
                    }
                    List ellipsoidGeoKeysInt = (List)tuple27._1();
                    List ellipsoidDoubles = (List)tuple27._2();
                    Tuple2 tuple28 = new Tuple2((Object)ellipsoidGeoKeysInt, (Object)ellipsoidDoubles);
                    Tuple2 tuple29 = tuple28;
                    List ellipsoidGeoKeysInt2 = (List)tuple29._1();
                    List ellipsoidDoubles2 = (List)tuple29._2();
                    geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)ellipsoidGeoKeysInt2);
                    listBuffer = doublesBuffer.$plus$plus$eq((TraversableOnce)ellipsoidDoubles2);
                }
                Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tuple2 = this.linearUnitProps();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                List linearUnitsGeoKeysInt = (List)tuple2._1();
                List linearUnitsDoubles = (List)tuple2._2();
                Tuple2 tuple210 = new Tuple2((Object)linearUnitsGeoKeysInt, (Object)linearUnitsDoubles);
                Tuple2 tuple211 = tuple210;
                List linearUnitsGeoKeysInt2 = (List)tuple211._1();
                List linearUnitsDoubles2 = (List)tuple211._2();
                geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)linearUnitsGeoKeysInt2);
                doublesBuffer.$plus$plus$eq((TraversableOnce)linearUnitsDoubles2);
                List doubles = (List)doublesBuffer.toList().sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
                List geoKeysInt = (List)geoKeysIntBuffer.toList().map((Function1 & Serializable & scala.Serializable)x -> new Tuple4((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())), List$.MODULE$.canBuildFrom());
                List geoKeys = (List)((SeqLike)geoKeysInt.$plus$plus((GenTraversableOnce)((List)doubles.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4((Object)BoxesRunTime.boxToInteger((int)((Tuple2)x._1())._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)CoordinateSystemParser$.MODULE$.GeoTiffDoubleTag()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)CoordinateSystemParser.$anonfun$parse$5(x$13)), (Ordering)Ordering.Int$.MODULE$);
                this.parse = new Tuple2(geoKeys.toArray(ClassTag$.MODULE$.apply(Tuple4.class)), ((TraversableOnce)doubles.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14._2$mcD$sp()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.parse;
    }

    public Tuple2<Tuple4<Object, Object, Object, Object>[], double[]> parse() {
        return (this.bitmap$0 & 0x40) == 0 ? this.parse$lzycompute() : this.parse;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> projProps$lzycompute() {
        block17: {
            var3_1 = this;
            synchronized (var3_1) {
                if ((this.bitmap$0 & 128) != 0) break block17;
                var4_2 = false;
                var5_3 = null;
                var6_4 = this.proj4Map().get((Object)"proj");
                if (!(var6_4 instanceof Some)) ** GOTO lbl-1000
                var4_2 = true;
                var5_3 = (Some)var6_4;
                var7_5 = (String)var5_3.value();
                if ("tmerc".equals(var7_5)) {
                    var1_6 = this.tmercProps();
                } else if (var4_2 && "utm".equals(var8_7 = (String)var5_3.value())) {
                    var1_6 = this.utmProps();
                } else if (var4_2 && "lcc".equals(var9_8 = (String)var5_3.value())) {
                    var1_6 = this.lccProps();
                } else {
                    var2_11 = var6_4 instanceof Some != false && "longlat".equals(var11_10 = (String)(var10_9 = (Some)var6_4).value()) != false ? true : var6_4 instanceof Some != false && "latlong".equals(var13_13 = (String)(var12_12 = (Some)var6_4).value()) != false;
                    if (var2_11) {
                        var1_6 = this.longLatProps();
                    } else if (var4_2 && "sinu".equals(var14_14 = (String)var5_3.value())) {
                        var1_6 = this.sinuProps();
                    } else if (var4_2 && "aea".equals(var15_15 = (String)var5_3.value())) {
                        var1_6 = this.aeaProps();
                    } else {
                        if (var4_2) {
                            throw new GeoTiffWriterLimitationException(new StringBuilder(196).append("This GeoTiff writer does not currently support the projection ").append(this.proj4String()).append(" without an EPSG code associated with the CRS. You'll need to use a CRS that has an EPSG code, or reproject before writing to GeoTIFF.").toString());
                        }
                        if (None$.MODULE$.equals(var6_4)) {
                            throw new MalformedProj4Exception("No +proj flag specified.");
                        }
                        throw new MatchError((Object)var6_4);
                    }
                }
                this.projProps = var1_6;
                this.bitmap$0 |= 128;
            }
        }
        return this.projProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> projProps() {
        return (this.bitmap$0 & 0x80) == 0 ? this.projProps$lzycompute() : this.projProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tmercProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x100) == 0) {
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_TransverseMercator()), (List)Nil$.MODULE$)));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getDouble("lat_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getDouble("lon_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), this.getK(1.0)), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getDouble("x_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getDouble("y_0", this.getDouble$default$2())), (List)Nil$.MODULE$)))));
                this.tmercProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.tmercProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tmercProps() {
        return (this.bitmap$0 & 0x100) == 0 ? this.tmercProps$lzycompute() : this.tmercProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> utmProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x200) == 0) {
                int zone = this.getInt("zone", this.getInt$default$2());
                boolean south = this.proj4Map().contains((Object)"south");
                int epsgCodeBase = south ? 32700 : 32600;
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_TransverseMercator()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), epsgCodeBase + zone), (List)Nil$.MODULE$))));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), 0.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), (double)(zone * 6) - 183.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), 0.9996), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), 500000.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), south ? 1.0E7 : 0.0), (List)Nil$.MODULE$)))));
                this.utmProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.utmProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> utmProps() {
        return (this.bitmap$0 & 0x200) == 0 ? this.utmProps$lzycompute() : this.utmProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> lccProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x400) == 0) {
                ListBuffer listBuffer;
                double lat0 = this.getDouble("lat_0", this.getDouble$default$2());
                double lat1 = this.getDouble("lat_1", this.getDouble$default$2());
                double lon0 = this.getDouble("lon_0", this.getDouble$default$2());
                ListBuffer geoKeysIntLB = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectionGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV())}));
                ListBuffer doublesLB = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                if (lat0 == lat1 && !this.isDefined("lat_2")) {
                    geoKeysIntLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjCoordTransGeoKey())), (Object)BoxesRunTime.boxToInteger((int)CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_1SP())));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjNatOriginLatGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lat0)));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjNatOriginLongGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lon0)));
                    listBuffer = doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getK(1.0))));
                } else {
                    geoKeysIntLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjCoordTransGeoKey())), (Object)BoxesRunTime.boxToInteger((int)CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_2SP())));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseOriginLatGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lat0)));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseOriginLongGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lon0)));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjStdParallel1GeoKey())), (Object)BoxesRunTime.boxToDouble((double)lat1)));
                    listBuffer = doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjStdParallel2GeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getDouble("lat_2", this.getDouble$default$2()))));
                }
                doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseEastingGeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getDouble("x_0", this.getDouble$default$2()))));
                doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseNorthingGeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getDouble("y_0", this.getDouble$default$2()))));
                this.lccProps = new Tuple2((Object)geoKeysIntLB.toList(), (Object)doublesLB.toList());
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lccProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> lccProps() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lccProps$lzycompute() : this.lccProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> longLatProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.longLatProps = new Tuple2((Object)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeGeographic()), (List)Nil$.MODULE$), (Object)Nil$.MODULE$);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.longLatProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> longLatProps() {
        return (this.bitmap$0 & 0x800) == 0 ? this.longLatProps$lzycompute() : this.longLatProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> gcsOrDatumProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                Tuple2 tuple2;
                if (this.gcs() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
                    tuple2 = new Tuple2((Object)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogTypeGeoKey(), this.gcs()), (List)Nil$.MODULE$), (Object)Nil$.MODULE$);
                } else {
                    .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogGeodeticDatumGeoKey(), this.datum()), (List)Nil$.MODULE$));
                    tuple2 = new Tuple2((Object)geoKeysInt, (Object)Nil$.MODULE$);
                }
                this.gcsOrDatumProps = tuple2;
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.gcsOrDatumProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> gcsOrDatumProps() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.gcsOrDatumProps$lzycompute() : this.gcsOrDatumProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> ellipsoidProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                Tuple2 tuple2;
                if (this.gcs() == CommonPublicValues$.MODULE$.UserDefinedCPV()) {
                    .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogEllipsoidGeoKey(), this.ellipsoid()), (List)Nil$.MODULE$);
                    if (this.optSemis().nonEmpty()) {
                        Tuple3 tuple3 = (Tuple3)this.optSemis().get();
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        double major = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                        double minor = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double invFlattening = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)major), (Object)BoxesRunTime.boxToDouble((double)minor), (Object)BoxesRunTime.boxToDouble((double)invFlattening));
                        Tuple3 tuple33 = tuple32;
                        double major2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                        double minor2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
                        double invFlattening2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
                        .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.GeogSemiMajorAxisGeoKey(), major2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.GeogSemiMinorAxisGeoKey(), minor2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.GeogInvFlatteningGeoKey(), invFlattening2), (List)Nil$.MODULE$)));
                        tuple2 = new Tuple2((Object)geoKeysInt, (Object)doubles);
                    } else {
                        tuple2 = new Tuple2((Object)geoKeysInt, (Object)Nil$.MODULE$);
                    }
                } else {
                    tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
                }
                this.ellipsoidProps = tuple2;
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.ellipsoidProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> ellipsoidProps() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.ellipsoidProps$lzycompute() : this.ellipsoidProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> sinuProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_Sinusoidal()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjLinearUnitsGeoKey(), ProjectedLinearUnits$.MODULE$.LinearMeterCode()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogAngularUnitsGeoKey(), AngularUnitTypes$.MODULE$.Angular_Degree()), (List)Nil$.MODULE$)))));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getDouble("lat_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getDouble("lon_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getDouble("x_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getDouble("y_0", this.getDouble$default$2())), (List)Nil$.MODULE$))));
                this.sinuProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.sinuProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> sinuProps() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.sinuProps$lzycompute() : this.sinuProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> linearUnitProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                String unitString = this.getString("units", "err");
                int code = BoxesRunTime.unboxToInt((Object)ProjectedLinearUnits$.MODULE$.reversedProjectedLinearUnitsMap().getOrElse((Object)unitString, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CommonPublicValues$.MODULE$.UserDefinedCPV()));
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjLinearUnitsGeoKey(), code), (List)Nil$.MODULE$);
                double toMeters = this.getDouble("to_meter", "1.0");
                Nil$ doubles = code == CommonPublicValues$.MODULE$.UserDefinedCPV() ? new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjLinearUnitSizeGeoKey(), toMeters), (List)Nil$.MODULE$) : Nil$.MODULE$;
                this.linearUnitProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.linearUnitProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> linearUnitProps() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.linearUnitProps$lzycompute() : this.linearUnitProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> aeaProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectionGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_AlbersEqualArea()), (List)Nil$.MODULE$))));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), this.getDouble("lat_1", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel2GeoKey(), this.getDouble("lat_2", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getDouble("lat_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getDouble("lon_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getDouble("x_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getDouble("y_0", this.getDouble$default$2())), (List)Nil$.MODULE$))))));
                this.aeaProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.aeaProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> aeaProps() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.aeaProps$lzycompute() : this.aeaProps;
    }

    private boolean isDefined(String key) {
        return this.proj4Map().get((Object)key).isDefined();
    }

    private String getString(String key, String defV) {
        return (String)this.proj4Map().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> defV);
    }

    private int getInt(String key, String defV) {
        return new StringOps(Predef$.MODULE$.augmentString((String)this.proj4Map().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> defV))).toInt();
    }

    private String getInt$default$2() {
        return "0";
    }

    private double getDouble(String key, String defV) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getString(key, defV))).toDouble();
    }

    private String getDouble$default$2() {
        return "0.0";
    }

    private double getK(double defV) {
        double d;
        Option option = this.proj4Map().get((Object)"k");
        if (option instanceof Some) {
            Some some = (Some)option;
            String k = (String)some.value();
            d = new StringOps(Predef$.MODULE$.augmentString(k)).toDouble();
        } else if (None$.MODULE$.equals(option)) {
            double d2;
            Option option2 = this.proj4Map().get((Object)"k_0");
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String k = (String)some.value();
                d2 = new StringOps(Predef$.MODULE$.augmentString(k)).toDouble();
            } else if (None$.MODULE$.equals(option2)) {
                d2 = defV;
            } else {
                throw new MatchError((Object)option2);
            }
            d = d2;
        } else {
            throw new MatchError((Object)option);
        }
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$proj4Map$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).contains((Object)BoxesRunTime.boxToCharacter((char)'='));
    }

    public static final /* synthetic */ boolean $anonfun$proj4Map$4(char x$4) {
        return x$4 != '=';
    }

    public static final /* synthetic */ boolean $anonfun$proj4Map$6(char x$5) {
        return x$5 != '=';
    }

    public static final /* synthetic */ int $anonfun$parse$5(Tuple4 x$13) {
        return BoxesRunTime.unboxToInt((Object)x$13._1());
    }

    public CoordinateSystemParser(CRS crs, Option<PixelSampleType> pixelSampleType) {
        this.crs = crs;
        this.pixelSampleType = pixelSampleType;
        this.proj4String = crs.toProj4String();
        this.proj4Map = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.proj4String())).split('+'))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CoordinateSystemParser.$anonfun$proj4Map$2(x$3))))).groupBy((Function1 & Serializable & scala.Serializable)s -> (String)new StringOps(Predef$.MODULE$.augmentString(s)).takeWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CoordinateSystemParser.$anonfun$proj4Map$4(BoxesRunTime.unboxToChar((Object)x$4))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String a = (String)tuple2._1();
            String[] b = (String[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)a, (Object)((String)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).head())).dropWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CoordinateSystemParser.$anonfun$proj4Map$6(BoxesRunTime.unboxToChar((Object)x$5))))).substring(1));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }
}

