/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.writer;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteUserDefinedNoDataCellType;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatUserDefinedNoDataCellType;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortUserDefinedNoDataCellType;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteUserDefinedNoDataCellType;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import geotrellis.raster.WideIntNoData;
import geotrellis.raster.io.geotiff.BandInterleave$;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.tags.codes.ColorSpace$;
import geotrellis.raster.io.geotiff.tags.codes.PlanarConfigurations$;
import geotrellis.raster.io.geotiff.tags.codes.TagCodes$;
import geotrellis.raster.io.geotiff.tags.codes.TiffFieldType$;
import geotrellis.raster.io.geotiff.writer.BigEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.CoordinateSystemParser$;
import geotrellis.raster.io.geotiff.writer.GeoDirectoryTags;
import geotrellis.raster.io.geotiff.writer.IncompatibleGeoTiffOptionsException;
import geotrellis.raster.io.geotiff.writer.LittleEndianToBytes$;
import geotrellis.raster.io.geotiff.writer.TiffTagFieldValue;
import geotrellis.raster.io.geotiff.writer.ToBytes;
import geotrellis.raster.package$;
import geotrellis.raster.render.ColorMap;
import geotrellis.raster.render.IndexedColorMap$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.PrettyPrinter;

public final class TiffTagFieldValue$
implements scala.Serializable {
    public static TiffTagFieldValue$ MODULE$;

    static {
        new TiffTagFieldValue$();
    }

    public TiffTagFieldValue apply(int tag, int fieldType, int length, int value, ToBytes toBytes) {
        TiffTagFieldValue tiffTagFieldValue;
        int n = fieldType;
        if (TiffFieldType$.MODULE$.ShortsFieldType() == n) {
            tiffTagFieldValue = new TiffTagFieldValue(tag, fieldType, length, toBytes.apply((short)value));
        } else if (TiffFieldType$.MODULE$.IntsFieldType() == n) {
            tiffTagFieldValue = new TiffTagFieldValue(tag, fieldType, length, toBytes.apply(value));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return tiffTagFieldValue;
    }

    public Option<String> createNoDataString(DataType cellType) {
        None$ none$;
        DataType dataType = cellType;
        boolean bl = BitCellType$.MODULE$.equals(dataType) ? true : (ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : (IntCellType$.MODULE$.equals(dataType) ? true : (FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType)))))));
        if (bl) {
            none$ = None$.MODULE$;
        } else if (ByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
            none$ = new Some((Object)((Object)BoxesRunTime.boxToByte((byte)-128)).toString());
        } else if (UByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
            none$ = new Some((Object)((Object)BoxesRunTime.boxToByte((byte)package$.MODULE$.ubyteNODATA())).toString());
        } else if (ShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
            none$ = new Some((Object)((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE)).toString());
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
            none$ = new Some((Object)((Object)BoxesRunTime.boxToShort((short)package$.MODULE$.ushortNODATA())).toString());
        } else if (IntConstantNoDataCellType$.MODULE$.equals(dataType)) {
            none$ = new Some((Object)((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)).toString());
        } else {
            boolean bl2 = FloatConstantNoDataCellType$.MODULE$.equals(dataType) ? true : DoubleConstantNoDataCellType$.MODULE$.equals(dataType);
            if (bl2) {
                none$ = new Some((Object)"nan");
            } else if (dataType instanceof ByteUserDefinedNoDataCellType) {
                ByteUserDefinedNoDataCellType byteUserDefinedNoDataCellType = (ByteUserDefinedNoDataCellType)dataType;
                none$ = new Some((Object)byteUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.ByteIsIntegral$.MODULE$).toString());
            } else if (dataType instanceof UByteUserDefinedNoDataCellType) {
                UByteUserDefinedNoDataCellType uByteUserDefinedNoDataCellType = (UByteUserDefinedNoDataCellType)dataType;
                none$ = new Some((Object)((WideIntNoData)uByteUserDefinedNoDataCellType.widenedNoData((Numeric)Numeric.ByteIsIntegral$.MODULE$)).toString());
            } else if (dataType instanceof ShortUserDefinedNoDataCellType) {
                ShortUserDefinedNoDataCellType shortUserDefinedNoDataCellType = (ShortUserDefinedNoDataCellType)dataType;
                none$ = new Some((Object)shortUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.ShortIsIntegral$.MODULE$).toString());
            } else if (dataType instanceof UShortUserDefinedNoDataCellType) {
                UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)dataType;
                none$ = new Some((Object)((WideIntNoData)uShortUserDefinedNoDataCellType.widenedNoData((Numeric)Numeric.ShortIsIntegral$.MODULE$)).toString());
            } else if (dataType instanceof IntUserDefinedNoDataCellType) {
                IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)dataType;
                none$ = new Some((Object)intUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.IntIsIntegral$.MODULE$).toString());
            } else if (dataType instanceof FloatUserDefinedNoDataCellType) {
                FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)dataType;
                none$ = new Some((Object)floatUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.FloatIsFractional$.MODULE$).toString());
            } else if (dataType instanceof DoubleUserDefinedNoDataCellType) {
                DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)dataType;
                none$ = new Some((Object)doubleUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$).toString());
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return none$;
    }

    public Tuple2<TiffTagFieldValue[], Function1<int[], TiffTagFieldValue>> collect(GeoTiffData geoTiff) {
        Function1 & Serializable & scala.Serializable intersect;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        Option<String> option;
        ListBuffer listBuffer;
        ByteOrder byteOrder = geoTiff.imageData().decompressor().byteOrder();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        ToBytes toBytes = !(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null) ? BigEndianToBytes$.MODULE$ : LittleEndianToBytes$.MODULE$;
        GeoTiffImageData imageData = geoTiff.imageData();
        Extent extent = geoTiff.extent();
        ListBuffer fieldValues = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.ImageWidthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, imageData.cols(), toBytes));
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.ImageLengthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, imageData.rows(), toBytes));
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.BitsPerSampleTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.bandType().bitsPerSample(), toBytes));
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.CompressionTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.decompressor().code(), toBytes));
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.PredictorTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.decompressor().predictorCode(), toBytes));
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.PhotometricInterpTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, geoTiff.options().colorSpace(), toBytes));
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.SamplesPerPixelTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.bandCount(), toBytes));
        fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.SampleFormatTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, imageData.bandType().sampleFormat(), toBytes));
        InterleaveMethod interleaveMethod = imageData.segmentLayout().interleaveMethod();
        if (PixelInterleave$.MODULE$.equals(interleaveMethod)) {
            listBuffer = fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.PlanarConfigurationTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, PlanarConfigurations$.MODULE$.PixelInterleave(), toBytes));
        } else if (BandInterleave$.MODULE$.equals(interleaveMethod)) {
            listBuffer = fieldValues.$plus$eq((Object)this.apply(TagCodes$.MODULE$.PlanarConfigurationTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, PlanarConfigurations$.MODULE$.BandInterleave(), toBytes));
        } else {
            throw new MatchError((Object)interleaveMethod);
        }
        geoTiff.options().subfileType().foreach((Function1 & Serializable & scala.Serializable)sft -> fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.NewSubfileTypeTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, toBytes.apply(sft.code()))));
        if (geoTiff.options().colorSpace() == ColorSpace$.MODULE$.Palette()) {
            int bitsPerSample = imageData.bandType().bitsPerSample();
            if (bitsPerSample > 16 || geoTiff.cellType().isFloatingPoint()) {
                throw new IncompatibleGeoTiffOptionsException("'Palette' color space only supported for 8 or 16 bit integral cell types.");
            }
            int divider = 1 << bitsPerSample;
            geoTiff.options().colorMap().foreach((Function1 & Serializable & scala.Serializable)cmap -> {
                Seq<Tuple3<Object, Object, Object>> palette = IndexedColorMap$.MODULE$.toTiffPalette((ColorMap)cmap);
                int size = scala.math.package$.MODULE$.min(palette.size(), divider);
                short[] flattenedPalette = (short[])Array$.MODULE$.ofDim(divider * 3, ClassTag$.MODULE$.Short());
                for (int index$macro$522 = 0; index$macro$522 < size; ++index$macro$522) {
                    Tuple3 c = (Tuple3)palette.apply(index$macro$522);
                    flattenedPalette[index$macro$522] = BoxesRunTime.unboxToShort((Object)c._1());
                    flattenedPalette[index$macro$522 + divider$1] = BoxesRunTime.unboxToShort((Object)c._2());
                    flattenedPalette[index$macro$522 + divider$1 * 2] = BoxesRunTime.unboxToShort((Object)c._3());
                }
                return fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.ColorMapTag(), TiffFieldType$.MODULE$.ShortsFieldType(), flattenedPalette.length, toBytes.apply(flattenedPalette)));
            });
        }
        if ((option = this.createNoDataString(geoTiff.cellType())) instanceof Some) {
            Some some = (Some)option;
            String noDataString = (String)some.value();
            byte[] bs = toBytes.apply(noDataString);
            boxedUnit3 = fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.GDALInternalNoDataTag(), TiffFieldType$.MODULE$.AsciisFieldType(), bs.length, bs));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        RasterExtent re = RasterExtent$.MODULE$.apply(extent, imageData.cols(), imageData.rows());
        fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.ModelPixelScaleTag(), TiffFieldType$.MODULE$.DoublesFieldType(), 3, toBytes.apply(new double[]{re.cellwidth(), re.cellheight(), 0.0})));
        fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.ModelTiePointsTag(), TiffFieldType$.MODULE$.DoublesFieldType(), 6, toBytes.apply(new double[]{0.0, 0.0, 0.0, extent.xmin(), extent.ymax(), 0.0})));
        GeoDirectoryTags geoDirectoryTags = CoordinateSystemParser$.MODULE$.parse(geoTiff.crs(), geoTiff.pixelSampleType());
        if (geoDirectoryTags == null) {
            throw new MatchError((Object)geoDirectoryTags);
        }
        Tuple4<Object, Object, Object, Object>[] shortGeoKeys = geoDirectoryTags.shortTags();
        double[] doubleGeoKeys = geoDirectoryTags.doubles();
        Tuple2 tuple2 = new Tuple2(shortGeoKeys, (Object)doubleGeoKeys);
        Tuple2 tuple22 = tuple2;
        Tuple4[] shortGeoKeys2 = (Tuple4[])tuple22._1();
        double[] doubleGeoKeys2 = (double[])tuple22._2();
        short[] shortValues = (short[])Array$.MODULE$.ofDim((shortGeoKeys2.length + 1) * 4, ClassTag$.MODULE$.Short());
        shortValues[0] = 1;
        shortValues[1] = 1;
        shortValues[2] = 0;
        shortValues[3] = (short)shortGeoKeys2.length;
        for (int index$macro$523 = 0; index$macro$523 < shortGeoKeys2.length; ++index$macro$523) {
            int start = (index$macro$523 + 1) * 4;
            shortValues[start] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys2[index$macro$523]._1());
            shortValues[start + 1] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys2[index$macro$523]._2());
            shortValues[start + 2] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys2[index$macro$523]._3());
            shortValues[start + 3] = (short)BoxesRunTime.unboxToInt((Object)shortGeoKeys2[index$macro$523]._4());
        }
        Object object = !new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(shortValues)).isEmpty() ? fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.GeoKeyDirectoryTag(), TiffFieldType$.MODULE$.ShortsFieldType(), shortValues.length, toBytes.apply(shortValues))) : BoxedUnit.UNIT;
        Object object2 = !new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleGeoKeys2)).isEmpty() ? fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.GeoDoubleParamsTag(), TiffFieldType$.MODULE$.DoublesFieldType(), doubleGeoKeys2.length, toBytes.apply(doubleGeoKeys2))) : BoxedUnit.UNIT;
        Tags tags = geoTiff.tags();
        if (tags == null) {
            throw new MatchError((Object)tags);
        }
        Map<String, String> headerTags = tags.headTags();
        List<Map<String, String>> bandTags = tags.bandTags();
        Tuple2 tuple23 = new Tuple2(headerTags, bandTags);
        Tuple2 tuple24 = tuple23;
        Map headerTags2 = (Map)tuple24._1();
        List bandTags2 = (List)tuple24._2();
        Map modifiedHeaderTags = headerTags2;
        Option<PixelSampleType> option2 = geoTiff.pixelSampleType();
        if (option2 instanceof Some) {
            modifiedHeaderTags = (Map)modifiedHeaderTags.$minus((Object)"AREA_OR_POINT");
            boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
        Option option3 = modifiedHeaderTags.get((Object)"TIFFTAG_DATETIME");
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String dateTime = (String)some.value();
            byte[] bs = toBytes.apply(dateTime);
            fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.DateTimeTag(), TiffFieldType$.MODULE$.AsciisFieldType(), bs.length, bs));
            modifiedHeaderTags = (Map)modifiedHeaderTags.$minus((Object)"TIFFTAG_DATETIME");
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option3)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option3);
        }
        PrettyPrinter qual$1 = new PrettyPrinter(Integer.MAX_VALUE, 2);
        Elem x$9 = new Tags((Map<String, String>)modifiedHeaderTags, geoTiff.tags().bandTags()).toXml();
        NamespaceBinding x$10 = qual$1.format$default$2();
        byte[] metadata = toBytes.apply(qual$1.format((Node)x$9, x$10));
        fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.MetadataTag(), TiffFieldType$.MODULE$.AsciisFieldType(), metadata.length, metadata));
        int len = imageData.segmentBytes().length();
        int[] arr = (int[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Int());
        for (int index$macro$524 = 0; index$macro$524 < len; ++index$macro$524) {
            arr[index$macro$524] = imageData.segmentBytes().getSegmentByteCount(index$macro$524);
        }
        int[] segmentByteCounts = arr;
        StorageMethod storageMethod = imageData.segmentLayout().storageMethod();
        if (storageMethod instanceof Tiled) {
            Tiled tiled = (Tiled)storageMethod;
            int tileCols = tiled.blockCols();
            int tileRows = tiled.blockRows();
            fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.TileWidthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, toBytes.apply(tileCols)));
            fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.TileLengthTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, toBytes.apply(tileRows)));
            fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.TileByteCountsTag(), TiffFieldType$.MODULE$.IntsFieldType(), segmentByteCounts.length, toBytes.apply(segmentByteCounts)));
            intersect = (Function1 & Serializable & scala.Serializable)offsets -> new TiffTagFieldValue(TagCodes$.MODULE$.TileOffsetsTag(), TiffFieldType$.MODULE$.IntsFieldType(), ((int[])offsets).length, toBytes.apply((int[])offsets));
        } else if (storageMethod instanceof Striped) {
            int rowsPerStrip = imageData.segmentLayout().tileLayout().tileRows();
            fieldValues.$plus$eq((Object)(rowsPerStrip < Short.MAX_VALUE ? this.apply(TagCodes$.MODULE$.RowsPerStripTag(), TiffFieldType$.MODULE$.ShortsFieldType(), 1, rowsPerStrip, toBytes) : this.apply(TagCodes$.MODULE$.RowsPerStripTag(), TiffFieldType$.MODULE$.IntsFieldType(), 1, rowsPerStrip, toBytes)));
            fieldValues.$plus$eq((Object)new TiffTagFieldValue(TagCodes$.MODULE$.StripByteCountsTag(), TiffFieldType$.MODULE$.IntsFieldType(), segmentByteCounts.length, toBytes.apply(segmentByteCounts)));
            intersect = (Function1 & Serializable & scala.Serializable)offsets -> new TiffTagFieldValue(TagCodes$.MODULE$.StripOffsetsTag(), TiffFieldType$.MODULE$.IntsFieldType(), ((int[])offsets).length, toBytes.apply((int[])offsets));
        } else {
            throw new MatchError((Object)storageMethod);
        }
        Function1 & Serializable & scala.Serializable offsetsFieldValueBuilder = intersect;
        return new Tuple2(fieldValues.toArray(ClassTag$.MODULE$.apply(TiffTagFieldValue.class)), (Object)offsetsFieldValueBuilder);
    }

    public TiffTagFieldValue apply(int tag, int fieldType, int length, byte[] value) {
        return new TiffTagFieldValue(tag, fieldType, length, value);
    }

    public Option<Tuple4<Object, Object, Object, byte[]>> unapply(TiffTagFieldValue x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)x$0.tag()), (Object)BoxesRunTime.boxToInteger((int)x$0.fieldType()), (Object)BoxesRunTime.boxToInteger((int)x$0.length()), (Object)x$0.value()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TiffTagFieldValue$() {
        MODULE$ = this;
    }
}

