/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.ArrayTileResult;
import geotrellis.raster.mapalgebra.focal.CellwiseCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import scala.Function4;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u0017\t)2)\u001a7mo&\u001cX\rR8vE2,7+^7DC2\u001c'BA\u0002\u0005\u0003\u00151wnY1m\u0015\t)a!\u0001\u0006nCB\fGnZ3ce\u0006T!a\u0002\u0005\u0002\rI\f7\u000f^3s\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001\r)A\u0019QB\u0004\t\u000e\u0003\tI!a\u0004\u0002\u0003'\r+G\u000e\\<jg\u0016\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0011\u0005E\u0011R\"\u0001\u0004\n\u0005M1!\u0001\u0002+jY\u0016\u0004\"!D\u000b\n\u0005Y\u0011!aD!se\u0006LH+\u001b7f%\u0016\u001cX\u000f\u001c;\t\u0013a\u0001!\u0011!Q\u0001\nAI\u0012!\u0001:\n\u0005aQ\u0012BA\u000e\u0003\u0005A1unY1m\u0007\u0006d7-\u001e7bi&|g\u000e\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0005q\u0007CA\u0007 \u0013\t\u0001#A\u0001\u0007OK&<\u0007NY8sQ>|G\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u0019\u0011w.\u001e8egB\u0019AeJ\u0015\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012aa\u00149uS>t\u0007CA\t+\u0013\tYcA\u0001\u0006He&$'i\\;oIND\u0011\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0019\u0002\rQ\f'oZ3u!\tiq&\u0003\u00021\u0005\tQA+\u0019:hKR\u001cU\r\u001c7\n\u00055R\u0002\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\bF\u00036m]B\u0014\b\u0005\u0002\u000e\u0001!)\u0001D\ra\u0001!!)QD\ra\u0001=!)!E\ra\u0001G!)QF\ra\u0001]!91\b\u0001a\u0001\n\u0003a\u0014!B2pk:$X#A\u001f\u0011\u0005\u0011r\u0014BA &\u0005\rIe\u000e\u001e\u0005\b\u0003\u0002\u0001\r\u0011\"\u0001C\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011A\u0005R\u0005\u0003\u000b\u0016\u0012A!\u00168ji\"9q\tQA\u0001\u0002\u0004i\u0014a\u0001=%c!1\u0011\n\u0001Q!\nu\naaY8v]R\u0004\u0003bB&\u0001\u0001\u0004%\t\u0001T\u0001\u0006i>$\u0018\r\\\u000b\u0002\u001bB\u0011AET\u0005\u0003\u001f\u0016\u0012a\u0001R8vE2,\u0007bB)\u0001\u0001\u0004%\tAU\u0001\ni>$\u0018\r\\0%KF$\"aQ*\t\u000f\u001d\u0003\u0016\u0011!a\u0001\u001b\"1Q\u000b\u0001Q!\n5\u000ba\u0001^8uC2\u0004\u0003\"B,\u0001\t\u0003A\u0016aA1eIR!1)\u0017.]\u0011\u0015Ab\u000b1\u0001\u0011\u0011\u0015Yf\u000b1\u0001>\u0003\u0005A\b\"B/W\u0001\u0004i\u0014!A=\t\u000b}\u0003A\u0011\u00011\u0002\rI,Wn\u001c<f)\u0011\u0019\u0015MY2\t\u000baq\u0006\u0019\u0001\t\t\u000bms\u0006\u0019A\u001f\t\u000bus\u0006\u0019A\u001f\t\u000b\u0015\u0004A\u0011\u00014\u0002\u000bI,7/\u001a;\u0015\u0003\rCQ\u0001\u001b\u0001\u0005\u0002%\f\u0001b]3u-\u0006dW/\u001a\u000b\u0004\u0007*\\\u0007\"B.h\u0001\u0004i\u0004\"B/h\u0001\u0004i\u0004")
public class CellwiseDoubleSumCalc
extends CellwiseCalculation<Tile>
implements ArrayTileResult {
    private int count;
    private double total;
    private final int cols;
    private final int rows;
    private final MutableArrayTile resultTile;
    private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

    @Override
    public DataType resultCellType() {
        return ArrayTileResult.resultCellType$(this);
    }

    @Override
    public MutableArrayTile result() {
        return ArrayTileResult.result$(this);
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public MutableArrayTile resultTile() {
        return this.resultTile;
    }

    @Override
    public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
        return this.copyOriginalValue;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$cols_$eq(int x$1) {
        this.cols = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$rows_$eq(int x$1) {
        this.rows = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$resultTile_$eq(MutableArrayTile x$1) {
        this.resultTile = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
        this.copyOriginalValue = x$1;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public double total() {
        return this.total;
    }

    public void total_$eq(double x$1) {
        this.total = x$1;
    }

    @Override
    public void add(Tile r, int x, int y) {
        block2: {
            double v = r.getDouble(x, y);
            if (Double.isNaN(v)) break block2;
            if (!Double.isNaN(this.total())) {
                this.total_$eq(this.total() + v);
                this.count_$eq(this.count() + 1);
            } else {
                this.total_$eq(v);
                this.count_$eq(1);
            }
        }
    }

    @Override
    public void remove(Tile r, int x, int y) {
        block2: {
            double v = r.getDouble(x, y);
            if (Double.isNaN(v)) break block2;
            this.count_$eq(this.count() - 1);
            if (this.count() == 0) {
                this.total_$eq(Double.NaN);
            } else {
                this.total_$eq(this.total() - v);
            }
        }
    }

    @Override
    public void reset() {
        this.total_$eq(Double.NaN);
    }

    @Override
    public void setValue(int x, int y) {
        this.resultTile().setDouble(x, y, this.total());
    }

    public CellwiseDoubleSumCalc(Tile r, Neighborhood n, Option<GridBounds> bounds, TargetCell target) {
        super(r, n, bounds, target);
        ArrayTileResult.$init$(this);
        this.count = 0;
        this.total = Double.NaN;
    }
}

