/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.CellSet;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Cursor$;
import geotrellis.raster.mapalgebra.focal.CursorMask;
import geotrellis.raster.mapalgebra.focal.Movement;
import geotrellis.raster.mapalgebra.focal.Movement$;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t\u0005t!B\u0001\u0003\u0011\u0003Y\u0011AB\"veN|'O\u0003\u0002\u0004\t\u0005)am\\2bY*\u0011QAB\u0001\u000b[\u0006\u0004\u0018\r\\4fEJ\f'BA\u0004\t\u0003\u0019\u0011\u0018m\u001d;fe*\t\u0011\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\u0004DkJ\u001cxN]\n\u0003\u001bA\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\"B\f\u000e\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u0015QR\u0002\"\u0001\u001c\u0003\u0015\t\u0007\u000f\u001d7z)\u001da\"1\tB#\u0005\u001f\u0002\"\u0001D\u000f\u0007\t9\u0011\u0001AH\n\u0003;AA\u0001\u0002I\u000f\u0003\u0002\u0003\u0006I!I\u0001\u0002eB\u0011!eI\u0007\u0002\r%\u0011AE\u0002\u0002\u0005)&dW\r\u0003\u0005';\t\u0005\t\u0015!\u0003(\u00031\tg.\u00197zg&\u001c\u0018I]3b!\t\u0011\u0003&\u0003\u0002*\r\tQqI]5e\u0005>,h\u000eZ:\t\u0011-j\"Q1A\u0005\u00021\na!\u001a=uK:$X#A\u0017\u0011\u0005Eq\u0013BA\u0018\u0013\u0005\rIe\u000e\u001e\u0005\tcu\u0011\t\u0011)A\u0005[\u00059Q\r\u001f;f]R\u0004\u0003\"B\f\u001e\t\u0003\u0019D\u0003\u0002\u000f5kYBQ\u0001\t\u001aA\u0002\u0005BQA\n\u001aA\u0002\u001dBQa\u000b\u001aA\u00025Bq\u0001O\u000fC\u0002\u0013%A&\u0001\u0003s_^\u001c\bB\u0002\u001e\u001eA\u0003%Q&A\u0003s_^\u001c\b\u0005C\u0004=;\t\u0007I\u0011\u0002\u0017\u0002\t\r|Gn\u001d\u0005\u0007}u\u0001\u000b\u0011B\u0017\u0002\u000b\r|Gn\u001d\u0011\t\u000f\u0001k\"\u0019!C\u0001Y\u0005\u0011\u0012M\\1msNL7o\u00144gg\u0016$8i\u001c7t\u0011\u0019\u0011U\u0004)A\u0005[\u0005\u0019\u0012M\\1msNL7o\u00144gg\u0016$8i\u001c7tA!9A)\bb\u0001\n\u0003a\u0013AE1oC2L8/[:PM\u001a\u001cX\r\u001e*poNDaAR\u000f!\u0002\u0013i\u0013aE1oC2L8/[:PM\u001a\u001cX\r\u001e*poN\u0004\u0003b\u0002%\u001e\u0005\u0004%I\u0001L\u0001\u0002I\"1!*\bQ\u0001\n5\n!\u0001\u001a\u0011\t\u000f1k\u0002\u0019!C\u0005\u001b\u0006!Q.Y:l+\u0005q\u0005C\u0001\u0007P\u0013\t\u0001&A\u0001\u0006DkJ\u001cxN]'bg.DqAU\u000fA\u0002\u0013%1+\u0001\u0005nCN\\w\fJ3r)\t!v\u000b\u0005\u0002\u0012+&\u0011aK\u0005\u0002\u0005+:LG\u000fC\u0004Y#\u0006\u0005\t\u0019\u0001(\u0002\u0007a$\u0013\u0007\u0003\u0004[;\u0001\u0006KAT\u0001\u0006[\u0006\u001c8\u000e\t\u0005\b9v\u0001\r\u0011\"\u0003^\u0003\u001dA\u0017m]'bg.,\u0012A\u0018\t\u0003#}K!\u0001\u0019\n\u0003\u000f\t{w\u000e\\3b]\"9!-\ba\u0001\n\u0013\u0019\u0017a\u00035bg6\u000b7o[0%KF$\"\u0001\u00163\t\u000fa\u000b\u0017\u0011!a\u0001=\"1a-\bQ!\ny\u000b\u0001\u0002[1t\u001b\u0006\u001c8\u000e\t\u0005\bQv\u0001\r\u0011\"\u0003-\u0003\u001dy6m\u001c7nS:DqA[\u000fA\u0002\u0013%1.A\u0006`G>dW.\u001b8`I\u0015\fHC\u0001+m\u0011\u001dA\u0016.!AA\u00025BaA\\\u000f!B\u0013i\u0013\u0001C0d_2l\u0017N\u001c\u0011\t\u000fAl\u0002\u0019!C\u0005Y\u00059qlY8m[\u0006D\bb\u0002:\u001e\u0001\u0004%Ia]\u0001\f?\u000e|G.\\1y?\u0012*\u0017\u000f\u0006\u0002Ui\"9\u0001,]A\u0001\u0002\u0004i\u0003B\u0002<\u001eA\u0003&Q&\u0001\u0005`G>dW.\u0019=!\u0011\u001dAX\u00041A\u0005\n1\nqa\u0018:po6Lg\u000eC\u0004{;\u0001\u0007I\u0011B>\u0002\u0017}\u0013xn^7j]~#S-\u001d\u000b\u0003)rDq\u0001W=\u0002\u0002\u0003\u0007Q\u0006\u0003\u0004\u007f;\u0001\u0006K!L\u0001\t?J|w/\\5oA!A\u0011\u0011A\u000fA\u0002\u0013%A&A\u0004`e><X.\u0019=\t\u0013\u0005\u0015Q\u00041A\u0005\n\u0005\u001d\u0011aC0s_^l\u0017\r_0%KF$2\u0001VA\u0005\u0011!A\u00161AA\u0001\u0002\u0004i\u0003bBA\u0007;\u0001\u0006K!L\u0001\t?J|w/\\1yA!1\u0011\u0011C\u000f\u0005\u00121\naaY8m[&t\u0007BBA\u000b;\u0011EA&\u0001\u0004d_2l\u0017\r\u001f\u0005\u0007\u00033iB\u0011\u0003\u0017\u0002\rI|w/\\5o\u0011\u0019\ti\"\bC\tY\u00051!o\\<nCbD\u0001\"!\t\u001e\u0001\u0004%I\u0001L\u0001\tC\u0012$W\rZ\"pY\"I\u0011QE\u000fA\u0002\u0013%\u0011qE\u0001\rC\u0012$W\rZ\"pY~#S-\u001d\u000b\u0004)\u0006%\u0002\u0002\u0003-\u0002$\u0005\u0005\t\u0019A\u0017\t\u000f\u00055R\u0004)Q\u0005[\u0005I\u0011\r\u001a3fI\u000e{G\u000e\t\u0005\t\u0003ci\u0002\u0019!C\u0005Y\u0005Q!/Z7pm\u0016$7i\u001c7\t\u0013\u0005UR\u00041A\u0005\n\u0005]\u0012A\u0004:f[>4X\rZ\"pY~#S-\u001d\u000b\u0004)\u0006e\u0002\u0002\u0003-\u00024\u0005\u0005\t\u0019A\u0017\t\u000f\u0005uR\u0004)Q\u0005[\u0005Y!/Z7pm\u0016$7i\u001c7!\u0011!\t\t%\ba\u0001\n\u0013a\u0013\u0001C1eI\u0016$'k\\<\t\u0013\u0005\u0015S\u00041A\u0005\n\u0005\u001d\u0013\u0001D1eI\u0016$'k\\<`I\u0015\fHc\u0001+\u0002J!A\u0001,a\u0011\u0002\u0002\u0003\u0007Q\u0006C\u0004\u0002Nu\u0001\u000b\u0015B\u0017\u0002\u0013\u0005$G-\u001a3S_^\u0004\u0003\u0002CA);\u0001\u0007I\u0011\u0002\u0017\u0002\u0015I,Wn\u001c<fIJ{w\u000fC\u0005\u0002Vu\u0001\r\u0011\"\u0003\u0002X\u0005q!/Z7pm\u0016$'k\\<`I\u0015\fHc\u0001+\u0002Z!A\u0001,a\u0015\u0002\u0002\u0003\u0007Q\u0006C\u0004\u0002^u\u0001\u000b\u0015B\u0017\u0002\u0017I,Wn\u001c<fIJ{w\u000f\t\u0005\n\u0003Cj\u0002\u0019!C\u0001\u0003G\n\u0001\"\\8wK6,g\u000e^\u000b\u0003\u0003K\u0012R!a\u001a\u0011\u0003g2a!!\u001b\u0001\u0001\u0005\u0015$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014\u0002BA7\u0003_\n1BT8N_Z,W.\u001a8uA)\u0019\u0011\u0011\u000f\u0002\u0002\u00115{g/Z7f]R\u00042\u0001DA;\u0013\r\t9H\u0001\u0002\t\u001b>4X-\\3oi\"I\u00111P\u000fA\u0002\u0013\u0005\u0011QP\u0001\r[>4X-\\3oi~#S-\u001d\u000b\u0004)\u0006}\u0004\"\u0003-\u0002z\u0005\u0005\t\u0019AA3\u0011!\t\u0019)\bQ!\n\u0005\u0015\u0014!C7pm\u0016lWM\u001c;!\u0011!\t9)\ba\u0001\n\u0013a\u0013\u0001B0d_2D\u0011\"a#\u001e\u0001\u0004%I!!$\u0002\u0011}\u001bw\u000e\\0%KF$2\u0001VAH\u0011!A\u0016\u0011RA\u0001\u0002\u0004i\u0003bBAJ;\u0001\u0006K!L\u0001\u0006?\u000e|G\u000e\t\u0005\t\u0003/k\u0002\u0019!C\u0005Y\u0005!qL]8x\u0011%\tY*\ba\u0001\n\u0013\ti*\u0001\u0005`e><x\fJ3r)\r!\u0016q\u0014\u0005\t1\u0006e\u0015\u0011!a\u0001[!9\u00111U\u000f!B\u0013i\u0013!B0s_^\u0004\u0003BBAT;\u0011\u0005A&\u0001\u0005g_\u000e,8oQ8m\u0011\u0019\tY+\bC\u0001Y\u0005Aam\\2vgJ{w\u000f\u0003\u0004\u00020v!\t!X\u0001\bSN\u0014Vm]3u\u0011\u0019\t\u0019,\bC\u0001Y\u0005\u00191m\u001c7\t\r\u0005]V\u0004\"\u0001-\u0003\r\u0011xn\u001e\u0005\b\u0003wkB\u0011AA_\u0003!\u0019WM\u001c;fe>sG#\u0002+\u0002@\u0006\u0005\u0007bBAZ\u0003s\u0003\r!\f\u0005\b\u0003o\u000bI\f1\u0001.\u0011\u001d\t)-\bC\u0001\u0003\u000f\fA!\\8wKR\u0019A+!3\t\u0011\u0005-\u00171\u0019a\u0001\u0003g\n\u0011!\u001c\u0005\b\u0003\u001flB\u0011AAi\u0003\u001d\u0019X\r^'bg.$2\u0001VAj\u0011!\t).!4A\u0002\u0005]\u0017!\u00014\u0011\rE\tI.L\u0017_\u0013\r\tYN\u0005\u0002\n\rVt7\r^5p]JB\u0011\"a8\u001e\u0005\u0004%\t!!9\u0002\u0011\u0005dGnQ3mYN,\"!a9\u0013\u000b\u0005\u0015\b#a;\u0007\u000f\u0005%\u0014q\u001d\u0001\u0002d\"A\u0011\u0011^\u000f!\u0002\u0013\t\u0019/A\u0005bY2\u001cU\r\u001c7tAA\u0019!%!<\n\u0007\u0005=hAA\u0004DK2d7+\u001a;\t\u0013\u0005MXD1A\u0005\u0002\u0005U\u0018AC1eI\u0016$7)\u001a7mgV\u0011\u0011q\u001f\n\u0006\u0003s\u0004\u00121\u001e\u0004\b\u0003S\nY\u0010AA|\u0011!\ti0\bQ\u0001\n\u0005]\u0018aC1eI\u0016$7)\u001a7mg\u0002B\u0011B!\u0001\u001e\u0005\u0004%\tAa\u0001\u0002\u0019I,Wn\u001c<fI\u000e+G\u000e\\:\u0016\u0005\t\u0015!#\u0002B\u0004!\u0005-haBA5\u0005\u0013\u0001!Q\u0001\u0005\t\u0005\u0017i\u0002\u0015!\u0003\u0003\u0006\u0005i!/Z7pm\u0016$7)\u001a7mg\u0002BqAa\u0004\u001e\t#\u0011\t\"A\u0004g_J,\u0017m\u00195\u0015\u0007Q\u0013\u0019\u0002\u0003\u0005\u0002V\n5\u0001\u0019\u0001B\u000b!\u0019\t\u0012\u0011\\\u0017.)\"9!\u0011D\u000f\u0005\u0012\tm\u0011\u0001\u00044pe\u0016\f7\r[!eI\u0016$Gc\u0001+\u0003\u001e!A\u0011Q\u001bB\f\u0001\u0004\u0011)\u0002C\u0004\u0003\"u!\tBa\t\u0002\u001d\u0019|'/Z1dQJ+Wn\u001c<fIR\u0019AK!\n\t\u0011\u0005U'q\u0004a\u0001\u0005+AqA!\u000b\u001e\t\u0003\u0011Y#A\u0005bg\u000eL\u0017\u000e\u0012:boV\u0011!Q\u0006\t\u0005\u0005_\u0011iD\u0004\u0003\u00032\te\u0002c\u0001B\u001a%5\u0011!Q\u0007\u0006\u0004\u0005oQ\u0011A\u0002\u001fs_>$h(C\u0002\u0003<I\ta\u0001\u0015:fI\u00164\u0017\u0002\u0002B \u0005\u0003\u0012aa\u0015;sS:<'b\u0001B\u001e%!)\u0001%\u0007a\u0001C!9!qI\rA\u0002\t%\u0013!\u00018\u0011\u00071\u0011Y%C\u0002\u0003N\t\u0011ABT3jO\"\u0014wN\u001d5p_\u0012DQAJ\rA\u0002\u001dBaAG\u0007\u0005\u0002\tMC#\u0002\u000f\u0003V\t]\u0003B\u0002\u0011\u0003R\u0001\u0007\u0011\u0005\u0003\u0005\u0003H\tE\u0003\u0019\u0001B%\u0011\u0019QR\u0002\"\u0001\u0003\\Q)AD!\u0018\u0003`!1\u0001E!\u0017A\u0002\u0005Baa\u000bB-\u0001\u0004i\u0003")
public class Cursor {
    private final Tile r;
    private final int extent;
    private final int rows;
    private final int cols;
    private final int analysisOffsetCols;
    private final int analysisOffsetRows;
    private final int d;
    private CursorMask mask;
    private boolean hasMask;
    private int _colmin;
    private int _colmax;
    private int _rowmin;
    private int _rowmax;
    private int addedCol;
    private int removedCol;
    private int addedRow;
    private int removedRow;
    private Movement movement;
    private int _col;
    private int _row;
    private final CellSet allCells;
    private final CellSet addedCells;
    private final CellSet removedCells;

    public static Cursor apply(Tile tile, int n) {
        return Cursor$.MODULE$.apply(tile, n);
    }

    public static Cursor apply(Tile tile, Neighborhood neighborhood) {
        return Cursor$.MODULE$.apply(tile, neighborhood);
    }

    public static Cursor apply(Tile tile, Neighborhood neighborhood, GridBounds gridBounds) {
        return Cursor$.MODULE$.apply(tile, neighborhood, gridBounds);
    }

    public int extent() {
        return this.extent;
    }

    private int rows() {
        return this.rows;
    }

    private int cols() {
        return this.cols;
    }

    public int analysisOffsetCols() {
        return this.analysisOffsetCols;
    }

    public int analysisOffsetRows() {
        return this.analysisOffsetRows;
    }

    private int d() {
        return this.d;
    }

    private CursorMask mask() {
        return this.mask;
    }

    private void mask_$eq(CursorMask x$1) {
        this.mask = x$1;
    }

    private boolean hasMask() {
        return this.hasMask;
    }

    private void hasMask_$eq(boolean x$1) {
        this.hasMask = x$1;
    }

    private int _colmin() {
        return this._colmin;
    }

    private void _colmin_$eq(int x$1) {
        this._colmin = x$1;
    }

    private int _colmax() {
        return this._colmax;
    }

    private void _colmax_$eq(int x$1) {
        this._colmax = x$1;
    }

    private int _rowmin() {
        return this._rowmin;
    }

    private void _rowmin_$eq(int x$1) {
        this._rowmin = x$1;
    }

    private int _rowmax() {
        return this._rowmax;
    }

    private void _rowmax_$eq(int x$1) {
        this._rowmax = x$1;
    }

    public int colmin() {
        return this._colmin();
    }

    public int colmax() {
        return this._colmax();
    }

    public int rowmin() {
        return this._rowmin();
    }

    public int rowmax() {
        return this._rowmax();
    }

    private int addedCol() {
        return this.addedCol;
    }

    private void addedCol_$eq(int x$1) {
        this.addedCol = x$1;
    }

    private int removedCol() {
        return this.removedCol;
    }

    private void removedCol_$eq(int x$1) {
        this.removedCol = x$1;
    }

    private int addedRow() {
        return this.addedRow;
    }

    private void addedRow_$eq(int x$1) {
        this.addedRow = x$1;
    }

    private int removedRow() {
        return this.removedRow;
    }

    private void removedRow_$eq(int x$1) {
        this.removedRow = x$1;
    }

    public Movement movement() {
        return this.movement;
    }

    public void movement_$eq(Movement x$1) {
        this.movement = x$1;
    }

    private int _col() {
        return this._col;
    }

    private void _col_$eq(int x$1) {
        this._col = x$1;
    }

    private int _row() {
        return this._row;
    }

    private void _row_$eq(int x$1) {
        this._row = x$1;
    }

    public int focusCol() {
        return this._col();
    }

    public int focusRow() {
        return this._row();
    }

    public boolean isReset() {
        Movement movement = this.movement();
        Movement movement2 = Movement$.MODULE$.NoMovement();
        return !(movement != null ? !movement.equals(movement2) : movement2 != null);
    }

    public int col() {
        return this._col() - this.analysisOffsetCols();
    }

    public int row() {
        return this._row() - this.analysisOffsetRows();
    }

    public void centerOn(int col, int row) {
        this.movement_$eq(Movement$.MODULE$.NoMovement());
        this._col_$eq(col);
        this._row_$eq(row);
        this._colmin_$eq(package$.MODULE$.max(0, this._col() - this.extent()));
        this._colmax_$eq(package$.MODULE$.min(this.cols() - 1, this._col() + this.extent()));
        this._rowmin_$eq(package$.MODULE$.max(0, this._row() - this.extent()));
        this._rowmax_$eq(package$.MODULE$.min(this.rows() - 1, this._row() + this.extent()));
    }

    public void move(Movement m) {
        this.movement_$eq(m);
        Movement movement = m;
        Movement movement2 = Movement$.MODULE$.Up();
        Movement movement3 = movement;
        if (!(movement2 != null ? !movement2.equals(movement3) : movement3 != null)) {
            this.addedRow_$eq(this._rowmin() - 1);
            this.removedRow_$eq(this._row() + this.extent());
            this._row_$eq(this._row() - 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Movement movement4 = Movement$.MODULE$.Down();
            Movement movement5 = movement;
            if (!(movement4 != null ? !movement4.equals(movement5) : movement5 != null)) {
                this.addedRow_$eq(this._rowmax() + 1);
                this.removedRow_$eq(this._row() - this.extent());
                this._row_$eq(this._row() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Movement movement6 = Movement$.MODULE$.Left();
                Movement movement7 = movement;
                if (!(movement6 != null ? !movement6.equals(movement7) : movement7 != null)) {
                    this.addedCol_$eq(this._colmin() - 1);
                    this.removedCol_$eq(this._col() + this.extent());
                    this._col_$eq(this._col() - 1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Movement movement8 = Movement$.MODULE$.Right();
                    Movement movement9 = movement;
                    if (!(movement8 != null ? !movement8.equals(movement9) : movement9 != null)) {
                        this.addedCol_$eq(this._colmax() + 1);
                        this.removedCol_$eq(this._col() - this.extent());
                        this._col_$eq(this._col() + 1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
        this._colmin_$eq(package$.MODULE$.max(0, this._col() - this.extent()));
        this._colmax_$eq(package$.MODULE$.min(this.cols() - 1, this._col() + this.extent()));
        this._rowmin_$eq(package$.MODULE$.max(0, this._row() - this.extent()));
        this._rowmax_$eq(package$.MODULE$.min(this.rows() - 1, this._row() + this.extent()));
    }

    public void setMask(Function2<Object, Object, Object> f) {
        this.hasMask_$eq(true);
        this.mask_$eq(new CursorMask(this.d(), f));
    }

    public CellSet allCells() {
        return this.allCells;
    }

    public CellSet addedCells() {
        return this.addedCells;
    }

    public CellSet removedCells() {
        return this.removedCells;
    }

    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        if (!this.hasMask()) {
            int x2 = 0;
            for (int y = this._rowmin(); y <= this._rowmax(); ++y) {
                for (x2 = this._colmin(); x2 <= this._colmax(); ++x2) {
                    f.apply$mcVII$sp(x2, y);
                }
            }
        } else {
            IntRef y = IntRef.create((int)0);
            while (y.elem < this.d()) {
                this.mask().foreachX(y.elem, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                    block0: {
                        int xTile = x + (this._col() - this.extent());
                        int yTile = y$1.elem + (this._row() - this.extent());
                        if (this._colmin() > xTile || xTile > this._colmax() || this._rowmin() > yTile || yTile > this._rowmax()) break block0;
                        f.apply$mcVII$sp(xTile, yTile);
                    }
                });
                ++y.elem;
            }
        }
    }

    public void foreachAdded(Function2<Object, Object, BoxedUnit> f) {
        block14: {
            Movement movement = this.movement();
            Movement movement2 = Movement$.MODULE$.NoMovement();
            if (!(movement != null ? !movement.equals(movement2) : movement2 != null)) {
                this.foreach(f);
            } else if (this.movement().isVertical()) {
                if (0 <= this.addedRow() && this.addedRow() < this.rows()) {
                    if (!this.hasMask()) {
                        for (int x2 = this._colmin(); x2 <= this._colmax(); ++x2) {
                            f.apply$mcVII$sp(x2, this.addedRow());
                        }
                    } else {
                        this.mask().foreachX(this.addedRow() - (this._row() - this.extent()), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                            block0: {
                                int xTile = x + (this._col() - this.extent());
                                if (0 > xTile || xTile > this.cols()) break block0;
                                f.apply$mcVII$sp(xTile, this.addedRow());
                            }
                        });
                    }
                }
            } else if (0 <= this.addedCol() && this.addedCol() < this.cols()) {
                if (!this.hasMask()) {
                    for (int y2 = this._rowmin(); y2 <= this._rowmax(); ++y2) {
                        f.apply$mcVII$sp(this.addedCol(), y2);
                    }
                } else {
                    Movement movement3 = this.movement();
                    Movement movement4 = Movement$.MODULE$.Left();
                    if (!(movement3 != null ? !movement3.equals(movement4) : movement4 != null)) {
                        this.mask().foreachWestColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.addedCol(), yTile);
                            }
                        });
                    } else {
                        this.mask().foreachEastColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.addedCol(), yTile);
                            }
                        });
                    }
                }
            }
            if (!this.hasMask()) break block14;
            this.mask().foreachUnmasked(this.movement(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                block0: {
                    int xTile = x + (this._col() - this.extent());
                    int yTile = y + (this._row() - this.extent());
                    if (0 > xTile || xTile >= this.cols() || 0 > yTile || yTile >= this.rows()) break block0;
                    f.apply$mcVII$sp(xTile, yTile);
                }
            });
        }
    }

    public void foreachRemoved(Function2<Object, Object, BoxedUnit> f) {
        block15: {
            Movement movement = this.movement();
            Movement movement2 = Movement$.MODULE$.NoMovement();
            if (!(movement != null ? !movement.equals(movement2) : movement2 != null)) {
                return;
            }
            if (this.movement().isVertical()) {
                if (0 <= this.removedRow() && this.removedRow() < this.rows()) {
                    if (!this.hasMask()) {
                        for (int x2 = this._colmin(); x2 <= this._colmax(); ++x2) {
                            f.apply$mcVII$sp(x2, this.removedRow());
                        }
                    } else {
                        Movement movement3 = this.movement();
                        Movement movement4 = Movement$.MODULE$.Up();
                        if (!(movement3 != null ? !movement3.equals(movement4) : movement4 != null)) {
                            this.mask().foreachX(this.d() - 1, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                                block0: {
                                    int xTile = x + (this._col() - this.extent());
                                    if (0 > xTile || xTile >= this.cols()) break block0;
                                    f.apply$mcVII$sp(xTile, this.removedRow());
                                }
                            });
                        } else {
                            this.mask().foreachX(0, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                                block0: {
                                    int xTile = x + (this._col() - this.extent());
                                    if (0 > xTile || xTile >= this.cols()) break block0;
                                    f.apply$mcVII$sp(xTile, this.removedRow());
                                }
                            });
                        }
                    }
                }
            } else if (0 <= this.removedCol() && this.removedCol() < this.cols()) {
                if (!this.hasMask()) {
                    for (int y2 = this._rowmin(); y2 <= this._rowmax(); ++y2) {
                        f.apply$mcVII$sp(this.removedCol(), y2);
                    }
                } else {
                    Movement movement5 = this.movement();
                    Movement movement6 = Movement$.MODULE$.Left();
                    if (!(movement5 != null ? !movement5.equals(movement6) : movement6 != null)) {
                        this.mask().foreachEastColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.removedCol(), yTile);
                            }
                        });
                    } else {
                        this.mask().foreachWestColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.removedCol(), yTile);
                            }
                        });
                    }
                }
            }
            if (!this.hasMask()) break block15;
            this.mask().foreachMasked(this.movement(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                block0: {
                    int xTile = x + (this._col() - this.extent());
                    int yTile = y + (this._row() - this.extent());
                    if (0 > xTile || xTile >= this.cols() || 0 > yTile || yTile >= this.rows()) break block0;
                    f.apply$mcVII$sp(xTile, yTile);
                }
            });
        }
    }

    public String asciiDraw() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        IntRef row = IntRef.create((int)0);
        this.allCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(cl, rw) -> {
            if (row$1.elem != rw) {
                sb.append("\n");
                ++row$1.elem;
            }
            String s = ((Object)BoxesRunTime.boxToInteger((int)$this.r.get(cl, rw))).toString();
            String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(package$.MODULE$.max(6 - new StringOps(Predef$.MODULE$.augmentString(s)).size(), 0));
            sb.append(new StringBuilder(0).append(pad).append(s).toString());
        });
        return sb.toString();
    }

    public Cursor(Tile r, GridBounds analysisArea, int extent) {
        this.r = r;
        this.extent = extent;
        this.rows = r.rows();
        this.cols = r.cols();
        this.analysisOffsetCols = analysisArea.colMin();
        this.analysisOffsetRows = analysisArea.rowMin();
        this.d = 2 * extent + 1;
        this.mask = null;
        this.hasMask = false;
        this._colmin = 0;
        this._colmax = 0;
        this._rowmin = 0;
        this._rowmax = 0;
        this.addedCol = 0;
        this.removedCol = 0;
        this.addedRow = 0;
        this.removedRow = 0;
        this.movement = Movement$.MODULE$.NoMovement();
        this._col = 0;
        this._row = 0;
        this.allCells = new CellSet(this){
            private final /* synthetic */ Cursor $outer;

            public void foreach(Function2<Object, Object, BoxedUnit> f) {
                this.$outer.foreach(f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.addedCells = new CellSet(this){
            private final /* synthetic */ Cursor $outer;

            public void foreach(Function2<Object, Object, BoxedUnit> f) {
                this.$outer.foreachAdded(f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.removedCells = new CellSet(this){
            private final /* synthetic */ Cursor $outer;

            public void foreach(Function2<Object, Object, BoxedUnit> f) {
                this.$outer.foreachRemoved(f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

