/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.FastMapHistogram;
import geotrellis.raster.histogram.FastMapHistogram$;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.CursorCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.ScalarMoransICalculation$;
import geotrellis.raster.summary.Statistics;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction2;

public final class ScalarMoransICalculation$ {
    public static ScalarMoransICalculation$ MODULE$;

    static {
        new ScalarMoransICalculation$();
    }

    public double apply(Tile tile, Neighborhood n, Option<GridBounds> bounds) {
        return BoxesRunTime.unboxToDouble(new CursorCalculation<Object>(tile, n, bounds){
            private double mean;
            private double stddev$up2;
            private double count;
            private int ws;
            private final FastMapHistogram h;
            private final Option<Statistics<Object>> stats;
            private final /* synthetic */ Tuple2 x$2;
            private final double m;
            private final double s;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public double mean() {
                return this.mean;
            }

            public void mean_$eq(double x$1) {
                this.mean = x$1;
            }

            public double stddev$up2() {
                return this.stddev$up2;
            }

            public void stddev$up2_$eq(double x$1) {
                this.stddev$up2 = x$1;
            }

            public double count() {
                return this.count;
            }

            public void count_$eq(double x$1) {
                this.count = x$1;
            }

            public int ws() {
                return this.ws;
            }

            public void ws_$eq(int x$1) {
                this.ws = x$1;
            }

            public FastMapHistogram h() {
                return this.h;
            }

            public Option<Statistics<Object>> stats() {
                return this.stats;
            }

            public double m() {
                return this.m;
            }

            public double s() {
                return this.s;
            }

            public void calc(Tile r, Cursor cursor) {
                double base = r.getDouble(cursor.col(), cursor.row()) - this.mean();
                DoubleRef z = DoubleRef.create((double)(-base));
                cursor.allCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    z$2.elem += r.getDouble(x, y) - this.mean();
                    this.ws_$eq(this.ws() + 1);
                });
                this.count_$eq(this.count() + base / this.stddev$up2() * z.elem);
                this.ws_$eq(this.ws() - 1);
            }

            public double result() {
                return this.count() / (double)this.ws();
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public static final /* synthetic */ Nothing$ $anonfun$copyOriginalValue$1(int focusCol, int focusRow, int col, int row) {
                return Predef$.MODULE$.$qmark$qmark$qmark();
            }
            {
                this.mean = 0.0;
                this.stddev$up2 = 0.0;
                this.count = 0.0;
                this.ws = 0;
                this.h = FastMapHistogram$.MODULE$.fromTile(this.r());
                this.stats = this.h().statistics();
                Predef$.MODULE$.require(this.stats().nonEmpty());
                Statistics statistics = (Statistics)this.stats().get();
                if (statistics == null) {
                    throw new MatchError((Object)statistics);
                }
                double m = statistics.mean();
                double s = statistics.stddev();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(m, s);
                this.x$2 = sp2;
                this.m = this.x$2._1$mcD$sp();
                this.s = this.x$2._2$mcD$sp();
                this.mean_$eq(this.m());
                this.stddev$up2_$eq(this.s() * this.s());
                this.copyOriginalValue = (Function4 & Serializable & scala.Serializable)(focusCol, focusRow, col, row) -> anon.2.$anonfun$copyOriginalValue$1(BoxesRunTime.unboxToInt((Object)focusCol), BoxesRunTime.unboxToInt((Object)focusRow), BoxesRunTime.unboxToInt((Object)col), BoxesRunTime.unboxToInt((Object)row));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$calc$2(geotrellis.raster.mapalgebra.focal.ScalarMoransICalculation$$anon$2 geotrellis.raster.Tile scala.runtime.DoubleRef int int ), $anonfun$copyOriginalValue$1$adapted(java.lang.Object java.lang.Object java.lang.Object java.lang.Object )}, serializedLambda);
            }
        }.execute());
    }

    private ScalarMoransICalculation$() {
        MODULE$ = this;
    }
}

