/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult;
import geotrellis.raster.mapalgebra.focal.FocalCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function2;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction2;

public final class StandardDeviation$ {
    public static StandardDeviation$ MODULE$;

    static {
        new StandardDeviation$();
    }

    public FocalCalculation<Tile> calculation(Tile tile, Neighborhood n, Option<GridBounds> bounds, TargetCell target) {
        return tile.cellType().isFloatingPoint() ? new DoubleArrayTileResult(tile, n, (Option)bounds, target){
            private int count;
            private double sum;
            private final int cols;
            private final int rows;
            private final DoubleArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public DoubleArrayTile result() {
                return DoubleArrayTileResult.result$(this);
            }

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public DoubleArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
                this.copyOriginalValue = x$1;
            }

            private int count() {
                return this.count;
            }

            private void count_$eq(int x$1) {
                this.count = x$1;
            }

            private double sum() {
                return this.sum;
            }

            private void sum_$eq(double x$1) {
                this.sum = x$1;
            }

            public void calc(Tile r, Cursor c) {
                c.removedCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    block2: {
                        double v = r.getDouble(x, y);
                        if (Double.isNaN(v)) break block2;
                        this.count_$eq(this.count() - 1);
                        if (this.count() == 0) {
                            this.sum_$eq(0.0);
                        } else {
                            this.sum_$eq(this.sum() - v);
                        }
                    }
                });
                c.addedCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    block0: {
                        double v = r.getDouble(x, y);
                        if (Double.isNaN(v)) break block0;
                        this.count_$eq(this.count() + 1);
                        this.sum_$eq(this.sum() + v);
                    }
                });
                double mean = this.sum() / (double)this.count();
                DoubleRef squares = DoubleRef.create((double)0.0);
                c.allCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    block0: {
                        double v = r.getDouble(x, y);
                        if (Double.isNaN(v)) break block0;
                        squares$1.elem += package$.MODULE$.pow(v - mean, 2.0);
                    }
                });
                this.resultTile().setDouble(c.col(), c.row(), package$.MODULE$.sqrt(squares.elem / (double)this.count()));
            }
            {
                DoubleArrayTileResult.$init$(this);
                this.count = 0;
                this.sum = 0.0;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$calc$1(geotrellis.raster.mapalgebra.focal.StandardDeviation$$anon$1 geotrellis.raster.Tile int int ), $anonfun$calc$2(geotrellis.raster.mapalgebra.focal.StandardDeviation$$anon$1 geotrellis.raster.Tile int int ), $anonfun$calc$3(geotrellis.raster.Tile double scala.runtime.DoubleRef int int )}, serializedLambda);
            }
        } : new DoubleArrayTileResult(tile, n, (Option)bounds, target){
            private int count;
            private int sum;
            private final int cols;
            private final int rows;
            private final DoubleArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public DoubleArrayTile result() {
                return DoubleArrayTileResult.result$(this);
            }

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public DoubleArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
                this.copyOriginalValue = x$1;
            }

            private int count() {
                return this.count;
            }

            private void count_$eq(int x$1) {
                this.count = x$1;
            }

            private int sum() {
                return this.sum;
            }

            private void sum_$eq(int x$1) {
                this.sum = x$1;
            }

            public void calc(Tile r, Cursor c) {
                c.removedCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    block0: {
                        int v = r.get(x, y);
                        if (v == Integer.MIN_VALUE) break block0;
                        this.count_$eq(this.count() - 1);
                        this.sum_$eq(this.sum() - v);
                    }
                });
                c.addedCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    block0: {
                        int v = r.get(x, y);
                        if (v == Integer.MIN_VALUE) break block0;
                        this.count_$eq(this.count() + 1);
                        this.sum_$eq(this.sum() + v);
                    }
                });
                double mean = (double)this.sum() / (double)this.count();
                DoubleRef squares = DoubleRef.create((double)0.0);
                c.allCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    block0: {
                        int v = r.get(x, y);
                        if (v == Integer.MIN_VALUE) break block0;
                        squares$2.elem += package$.MODULE$.pow((double)v - mean, 2.0);
                    }
                });
                this.resultTile().setDouble(c.col(), c.row(), package$.MODULE$.sqrt(squares.elem / (double)this.count()));
            }
            {
                DoubleArrayTileResult.$init$(this);
                this.count = 0;
                this.sum = 0;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$calc$4(geotrellis.raster.mapalgebra.focal.StandardDeviation$$anon$2 geotrellis.raster.Tile int int ), $anonfun$calc$5(geotrellis.raster.mapalgebra.focal.StandardDeviation$$anon$2 geotrellis.raster.Tile int int ), $anonfun$calc$6(geotrellis.raster.Tile double scala.runtime.DoubleRef int int )}, serializedLambda);
            }
        };
    }

    public Option<GridBounds> calculation$default$3() {
        return None$.MODULE$;
    }

    public TargetCell calculation$default$4() {
        return TargetCell$All$.MODULE$;
    }

    public Tile apply(Tile tile, Neighborhood n, Option<GridBounds> bounds, TargetCell target) {
        return this.calculation(tile, n, bounds, target).execute();
    }

    public Option<GridBounds> apply$default$3() {
        return None$.MODULE$;
    }

    public TargetCell apply$default$4() {
        return TargetCell$All$.MODULE$;
    }

    private StandardDeviation$() {
        MODULE$ = this;
    }
}

