/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.FastMapHistogram;
import geotrellis.raster.histogram.FastMapHistogram$;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.CursorCalculation;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.summary.Statistics;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction2;

public final class TileMoransICalculation$ {
    public static TileMoransICalculation$ MODULE$;

    static {
        new TileMoransICalculation$();
    }

    public Tile apply(Tile tile, Neighborhood n, Option<GridBounds> bounds, TargetCell target) {
        return (Tile)((CursorCalculation)((Object)new DoubleArrayTileResult(tile, n, (Option)bounds, target){
            private double mean;
            private double stddev$up2;
            private final FastMapHistogram h;
            private final Option<Statistics<Object>> stats;
            private final /* synthetic */ Tuple2 x$1;
            private final double m;
            private final double s;
            private final int cols;
            private final int rows;
            private final DoubleArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public DoubleArrayTile result() {
                return DoubleArrayTileResult.result$(this);
            }

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public DoubleArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
                this.copyOriginalValue = x$1;
            }

            public double mean() {
                return this.mean;
            }

            public void mean_$eq(double x$1) {
                this.mean = x$1;
            }

            public double stddev$up2() {
                return this.stddev$up2;
            }

            public void stddev$up2_$eq(double x$1) {
                this.stddev$up2 = x$1;
            }

            public FastMapHistogram h() {
                return this.h;
            }

            public Option<Statistics<Object>> stats() {
                return this.stats;
            }

            public double m() {
                return this.m;
            }

            public double s() {
                return this.s;
            }

            public void calc(Tile r, Cursor cursor) {
                DoubleRef z = DoubleRef.create((double)0.0);
                IntRef w = IntRef.create((int)0);
                DoubleRef base = DoubleRef.create((double)0.0);
                cursor.allCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                    if (x == cursor.col() && y == cursor.row()) {
                        base$1.elem = r.getDouble(x, y) - this.mean();
                    } else {
                        z$1.elem += r.getDouble(x, y) - this.mean();
                        ++w$1.elem;
                    }
                });
                this.resultTile().setDouble(cursor.col(), cursor.row(), base.elem / this.stddev$up2() * z.elem / (double)w.elem);
            }
            {
                DoubleArrayTileResult.$init$(this);
                this.mean = 0.0;
                this.stddev$up2 = 0.0;
                this.h = FastMapHistogram$.MODULE$.fromTile(this.r());
                this.stats = this.h().statistics();
                Predef$.MODULE$.require(this.stats().nonEmpty());
                Statistics statistics = (Statistics)this.stats().get();
                if (statistics == null) {
                    throw new MatchError((Object)statistics);
                }
                double m = statistics.mean();
                double s = statistics.stddev();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(m, s);
                this.x$1 = sp2;
                this.m = this.x$1._1$mcD$sp();
                this.s = this.x$1._2$mcD$sp();
                this.mean_$eq(this.m());
                this.stddev$up2_$eq(this.s() * this.s());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$calc$1(geotrellis.raster.mapalgebra.focal.TileMoransICalculation$$anon$1 geotrellis.raster.Tile geotrellis.raster.mapalgebra.focal.Cursor scala.runtime.DoubleRef scala.runtime.IntRef scala.runtime.DoubleRef int int )}, serializedLambda);
            }
        })).execute();
    }

    public TargetCell apply$default$4() {
        return TargetCell$All$.MODULE$;
    }

    private TileMoransICalculation$() {
        MODULE$ = this;
    }
}

