/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal.hillshade;

import geotrellis.raster.CellSize;
import geotrellis.raster.GridBounds;
import geotrellis.raster.ShortArrayTile;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Angles$;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.ShortArrayTileResult;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePoint;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePointCalculation;
import scala.Function2;
import scala.Function4;
import scala.Option;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction2;

public final class Hillshade$ {
    public static Hillshade$ MODULE$;

    static {
        new Hillshade$();
    }

    public Tile apply(Tile tile, Neighborhood n, Option<GridBounds> bounds, CellSize cs, double az, double al, double z, TargetCell target) {
        return (Tile)((SurfacePointCalculation)((Object)new ShortArrayTileResult(tile, n, bounds, cs, az, al, z, target){
            private final double azimuth;
            private final double zenith;
            private final double zFactor;
            private final double cosZ;
            private final double sinZ;
            private final double cosAz;
            private final double sinAz;
            private final int cols;
            private final int rows;
            private final ShortArrayTile resultTile;
            private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

            public ShortArrayTile result() {
                return ShortArrayTileResult.result$(this);
            }

            public int cols() {
                return this.cols;
            }

            public int rows() {
                return this.rows;
            }

            public ShortArrayTile resultTile() {
                return this.resultTile;
            }

            public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
                return this.copyOriginalValue;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$cols_$eq(int x$1) {
                this.cols = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$rows_$eq(int x$1) {
                this.rows = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$resultTile_$eq(ShortArrayTile x$1) {
                this.resultTile = x$1;
            }

            public void geotrellis$raster$mapalgebra$focal$ShortArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
                this.copyOriginalValue = x$1;
            }

            public double azimuth() {
                return this.azimuth;
            }

            public double zenith() {
                return this.zenith;
            }

            public double zFactor() {
                return this.zFactor;
            }

            public double cosZ() {
                return this.cosZ;
            }

            public double sinZ() {
                return this.sinZ;
            }

            public double cosAz() {
                return this.cosAz;
            }

            public double sinAz() {
                return this.sinAz;
            }

            public void setValue(int x, int y, SurfacePoint s) {
                double slope = s.slope(this.zFactor());
                double aspect = s.aspect();
                double c = this.cosAz() * s.cosAspect() + this.sinAz() * s.sinAspect();
                double v = this.cosZ() * s.cosSlope() + this.sinZ() * s.sinSlope() * c;
                this.resultTile().set(x, y, (int)package$.MODULE$.round(127.0 * package$.MODULE$.max(0.0, v)));
            }
            {
                ShortArrayTileResult.$init$(this);
                this.azimuth = Angles$.MODULE$.radians(90.0 - az$1);
                this.zenith = Angles$.MODULE$.radians(90.0 - al$1);
                this.zFactor = z$1;
                this.cosZ = package$.MODULE$.cos(this.zenith());
                this.sinZ = package$.MODULE$.sin(this.zenith());
                this.cosAz = package$.MODULE$.cos(this.azimuth());
                this.sinAz = package$.MODULE$.sin(this.azimuth());
            }
        })).execute();
    }

    public TargetCell apply$default$8() {
        return TargetCell$All$.MODULE$;
    }

    public Tile indirect(Tile aspect, Tile slope, double azimuth, double altitude) {
        double az = Angles$.MODULE$.radians(90.0 - azimuth);
        double ze = Angles$.MODULE$.radians(90.0 - altitude);
        double cosZe = package$.MODULE$.cos(ze);
        double sinZe = package$.MODULE$.sin(ze);
        Tile hr = aspect.combineDouble(slope, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & java.io.Serializable & Serializable)(aspectValue, slopeValue) -> {
            double slopeRads = Angles$.MODULE$.radians(slopeValue);
            double aspectRads = Angles$.MODULE$.radians(90.0 - aspectValue);
            double v = cosZe * package$.MODULE$.cos(slopeRads) + sinZe * package$.MODULE$.sin(slopeRads) * package$.MODULE$.cos(az - aspectRads);
            return package$.MODULE$.round(127.0 * package$.MODULE$.max(0.0, v));
        });
        return hr.convert(ShortConstantNoDataCellType$.MODULE$);
    }

    private Hillshade$() {
        MODULE$ = this;
    }
}

