/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal.hillshade;

import geotrellis.raster.CellSize;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.FocalCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.mapalgebra.focal.TargetCell$Data$;
import geotrellis.raster.mapalgebra.focal.TargetCell$NoData$;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePoint;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePointCalculation$;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}e!B\u0001\u0003\u0003\u0003i!aF*ve\u001a\f7-\u001a)pS:$8)\u00197dk2\fG/[8o\u0015\t\u0019A!A\u0005iS2d7\u000f[1eK*\u0011QAB\u0001\u0006M>\u001c\u0017\r\u001c\u0006\u0003\u000f!\t!\"\\1qC2<WM\u0019:b\u0015\tI!\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u0017\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001U\u0011a\"F\n\u0003\u0001=\u00012\u0001E\t\u0014\u001b\u0005!\u0011B\u0001\n\u0005\u0005A1unY1m\u0007\u0006d7-\u001e7bi&|g\u000e\u0005\u0002\u0015+1\u0001A!\u0002\f\u0001\u0005\u00049\"!\u0001+\u0012\u0005aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"a\u0002(pi\"Lgn\u001a\t\u00033}I!\u0001\t\u000e\u0003\u0007\u0005s\u0017\u0010C\u0005#\u0001\t\u0005\t\u0015!\u0003$O\u0005\t!\u000f\u0005\u0002%K5\t\u0001\"\u0003\u0002'\u0011\t!A+\u001b7f\u0013\t\u0011\u0013\u0003\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\u0005q\u0007C\u0001\t,\u0013\taCA\u0001\u0007OK&<\u0007NY8sQ>|G\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u00031\tg.\u00197zg&\u001c\u0018I]3b!\rI\u0002GM\u0005\u0003ci\u0011aa\u00149uS>t\u0007C\u0001\u00134\u0013\t!\u0004B\u0001\u0006He&$'i\\;oIND\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\tG\u0016dGnU5{KV\t\u0001\b\u0005\u0002%s%\u0011!\b\u0003\u0002\t\u0007\u0016dGnU5{K\"AA\b\u0001B\u0001B\u0003%\u0001(A\u0005dK2d7+\u001b>fA!Ia\b\u0001B\u0001B\u0003%qHQ\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0005A\u0001\u0015BA!\u0005\u0005)!\u0016M]4fi\u000e+G\u000e\\\u0005\u0003}EAQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtDC\u0002$I\u0013*[E\nE\u0002H\u0001Mi\u0011A\u0001\u0005\u0006E\r\u0003\ra\t\u0005\u0006S\r\u0003\rA\u000b\u0005\u0006]\r\u0003\ra\f\u0005\u0006m\r\u0003\r\u0001\u000f\u0005\b}\r\u0003\n\u00111\u0001@\r\u001dq\u0005\u0001%A\u0012\n=\u0013\u0001bU3u-\u0006dW/Z\n\u0003\u001bB\u0003\"!G)\n\u0005IS\"AB!osJ+g\rC\u0003U\u001b\u001a\u0005Q+A\u0003baBd\u0017\u0010\u0006\u0003W3z\u001b\u0007CA\rX\u0013\tA&D\u0001\u0003V]&$\b\"\u0002.T\u0001\u0004Y\u0016!\u0001>\u0011\u0005ea\u0016BA/\u001b\u0005\u0019!u.\u001e2mK\")ql\u0015a\u0001A\u0006\t\u0001\u0010\u0005\u0002\u001aC&\u0011!M\u0007\u0002\u0004\u0013:$\b\"\u00023T\u0001\u0004\u0001\u0017!A=\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\u0006)A.Y:u3V\t\u0001\rC\u0004j\u0001\u0001\u0007I\u0011\u00016\u0002\u00131\f7\u000f^-`I\u0015\fHC\u0001,l\u0011\u001da\u0007.!AA\u0002\u0001\f1\u0001\u001f\u00132\u0011\u0019q\u0007\u0001)Q\u0005A\u00061A.Y:u3\u0002Bq\u0001\u001d\u0001A\u0002\u0013\u0005\u0011/A\u0005dK2dw+\u001b3uQV\t1\fC\u0004t\u0001\u0001\u0007I\u0011\u0001;\u0002\u001b\r,G\u000e\\,jIRDw\fJ3r)\t1V\u000fC\u0004me\u0006\u0005\t\u0019A.\t\r]\u0004\u0001\u0015)\u0003\\\u0003)\u0019W\r\u001c7XS\u0012$\b\u000e\t\u0005\bs\u0002\u0001\r\u0011\"\u0001r\u0003)\u0019W\r\u001c7IK&<\u0007\u000e\u001e\u0005\bw\u0002\u0001\r\u0011\"\u0001}\u00039\u0019W\r\u001c7IK&<\u0007\u000e^0%KF$\"AV?\t\u000f1T\u0018\u0011!a\u00017\"1q\u0010\u0001Q!\nm\u000b1bY3mY\"+\u0017n\u001a5uA!I\u00111\u0001\u0001A\u0002\u0013\u0005\u0011QA\u0001\u0005o\u0016\u001cH/\u0006\u0002\u0002\bA!\u0011$!\u0003\\\u0013\r\tYA\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0001\u0003#\t\u0001b^3ti~#S-\u001d\u000b\u0004-\u0006M\u0001\"\u00037\u0002\u000e\u0005\u0005\t\u0019AA\u0004\u0011!\t9\u0002\u0001Q!\n\u0005\u001d\u0011!B<fgR\u0004\u0003\"CA\u000e\u0001\u0001\u0007I\u0011AA\u0003\u0003\u0011\u0011\u0017m]3\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0012\u0001\u00032bg\u0016|F%Z9\u0015\u0007Y\u000b\u0019\u0003C\u0005m\u0003;\t\t\u00111\u0001\u0002\b!A\u0011q\u0005\u0001!B\u0013\t9!A\u0003cCN,\u0007\u0005C\u0005\u0002,\u0001\u0001\r\u0011\"\u0001\u0002\u0006\u0005!Q-Y:u\u0011%\ty\u0003\u0001a\u0001\n\u0003\t\t$\u0001\u0005fCN$x\fJ3r)\r1\u00161\u0007\u0005\nY\u00065\u0012\u0011!a\u0001\u0003\u000fA\u0001\"a\u000e\u0001A\u0003&\u0011qA\u0001\u0006K\u0006\u001cH\u000f\t\u0005\n\u0003w\u0001!\u0019!C\u0001\u0003{\t\u0011a]\u000b\u0003\u0003\u007f\u00012aRA!\u0013\r\t\u0019E\u0001\u0002\r'V\u0014h-Y2f!>Lg\u000e\u001e\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002@\u0005\u00111\u000f\t\u0005\b\u0003\u0017\u0002a\u0011AA'\u0003!\u0019X\r\u001e,bYV,Gc\u0002,\u0002P\u0005E\u00131\u000b\u0005\u0007?\u0006%\u0003\u0019\u00011\t\r\u0011\fI\u00051\u0001a\u0011!\tY$!\u0013A\u0002\u0005}\u0002\"CA,\u0001\t\u0007I\u0011BA-\u0003%y6/\u001a;WC2,X-\u0006\u0002\u0002\\A\u0019\u0011QL'\u000e\u0003\u0001A\u0001\"!\u0019\u0001A\u0003%\u00111L\u0001\u000b?N,GOV1mk\u0016\u0004\u0003bBA3\u0001\u0011\u0005\u0011qM\u0001\n[>4XMU5hQR$\u0012A\u0016\u0005\b\u0003W\u0002A\u0011CA4\u0003-\u0019\u0017\r\\2TkJ4\u0017mY3\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u00059Q\r_3dkR,G#A\n\b\u0013\u0005U$!!A\t\u0002\u0005]\u0014aF*ve\u001a\f7-\u001a)pS:$8)\u00197dk2\fG/[8o!\r9\u0015\u0011\u0010\u0004\t\u0003\t\t\t\u0011#\u0001\u0002|M\u0019\u0011\u0011\u0010)\t\u000f\u0011\u000bI\b\"\u0001\u0002\u0000Q\u0011\u0011q\u000f\u0005\u000b\u0003\u0007\u000bI(%A\u0005\u0002\u0005\u0015\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0002\b\u0006uUCAAEU\ry\u00141R\u0016\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0013\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0006E%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121a#!!C\u0002]\u0001")
public abstract class SurfacePointCalculation<T>
extends FocalCalculation<T> {
    private final CellSize cellSize;
    private int lastY;
    private double cellWidth;
    private double cellHeight;
    private double[] west;
    private double[] base;
    private double[] east;
    private final SurfacePoint s;
    private final SetValue _setValue;

    public static <T> TargetCell $lessinit$greater$default$5() {
        return SurfacePointCalculation$.MODULE$.$lessinit$greater$default$5();
    }

    public CellSize cellSize() {
        return this.cellSize;
    }

    public int lastY() {
        return this.lastY;
    }

    public void lastY_$eq(int x$1) {
        this.lastY = x$1;
    }

    public double cellWidth() {
        return this.cellWidth;
    }

    public void cellWidth_$eq(double x$1) {
        this.cellWidth = x$1;
    }

    public double cellHeight() {
        return this.cellHeight;
    }

    public void cellHeight_$eq(double x$1) {
        this.cellHeight = x$1;
    }

    public double[] west() {
        return this.west;
    }

    public void west_$eq(double[] x$1) {
        this.west = x$1;
    }

    public double[] base() {
        return this.base;
    }

    public void base_$eq(double[] x$1) {
        this.base = x$1;
    }

    public double[] east() {
        return this.east;
    }

    public void east_$eq(double[] x$1) {
        this.east = x$1;
    }

    public SurfacePoint s() {
        return this.s;
    }

    public abstract void setValue(int var1, int var2, SurfacePoint var3);

    private SetValue _setValue() {
        return this._setValue;
    }

    public void moveRight() {
        double[] tmp = this.west();
        this.west_$eq(this.base());
        this.base_$eq(this.east());
        this.east_$eq(tmp);
    }

    public void calcSurface() {
        if (Double.isNaN(this.base()[1])) {
            this.s().dz$divdx_$eq(Double.NaN);
            this.s().dz$divdy_$eq(Double.NaN);
        } else {
            double neValue = !Double.isNaN(this.east()[0]) ? this.east()[0] : this.base()[1];
            double eValue = !Double.isNaN(this.east()[1]) ? this.east()[1] : this.base()[1];
            double seValue = !Double.isNaN(this.east()[2]) ? this.east()[2] : this.base()[1];
            double nValue = !Double.isNaN(this.base()[0]) ? this.base()[0] : this.base()[1];
            double sValue = !Double.isNaN(this.base()[2]) ? this.base()[2] : this.base()[1];
            double nwValue = !Double.isNaN(this.west()[0]) ? this.west()[0] : this.base()[1];
            double wValue = !Double.isNaN(this.west()[1]) ? this.west()[1] : this.base()[1];
            double swValue = !Double.isNaN(this.west()[2]) ? this.west()[2] : this.base()[1];
            this.s().dz$divdx_$eq((neValue + (double)2 * eValue + seValue - nwValue - (double)2 * wValue - swValue) / ((double)8 * this.cellWidth()));
            this.s().dz$divdy_$eq((swValue + (double)2 * sValue + seValue - nwValue - (double)2 * nValue - neValue) / ((double)8 * this.cellHeight()));
        }
    }

    @Override
    public T execute() {
        int row;
        int col;
        int colMin = this.bounds().colMin();
        int colMax = this.bounds().colMax();
        int rowMin = this.bounds().rowMin();
        int rowMax = this.bounds().rowMax();
        int colBorderMax = super.r().cols() - 1;
        int rowBorderMax = super.r().rows() - 1;
        this.cellWidth_$eq(this.cellSize().width());
        this.cellHeight_$eq(this.cellSize().height());
        if (colBorderMax < 2 || rowBorderMax < 2) {
            throw package$.MODULE$.error(new StringBuilder(45).append("Tile is too small to get surface values. (").append(colBorderMax).append(", ").append(rowBorderMax).append(")").toString());
        }
        double focalValue = super.r().getDouble(colMin, rowMin);
        this.west()[0] = this.getValSafe$1(colMin - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.west()[1] = this.getValSafe$1(colMin - 1, rowMin, focalValue, colBorderMax, rowBorderMax);
        this.west()[2] = this.getValSafe$1(colMin - 1, rowMin + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = this.getValSafe$1(colMin, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[1] = focalValue;
        this.base()[2] = super.r().getDouble(colMin, rowMin + 1);
        this.east()[0] = this.getValSafe$1(colMin + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = super.r().getDouble(colMin + 1, rowMin);
        this.east()[2] = super.r().getDouble(colMin + 1, rowMin + 1);
        this._setValue().apply(focalValue, 0, 0);
        for (col = colMin + 1; col < colMax; ++col) {
            this.moveRight();
            focalValue = super.r().getDouble(col, rowMin);
            this.west()[0] = this.getValSafe$1(col - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[0] = this.getValSafe$1(col, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[0] = this.getValSafe$1(col + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[1] = super.r().getDouble(col + 1, rowMin);
            this.east()[2] = super.r().getDouble(col + 1, rowMin + 1);
            this._setValue().apply(focalValue, col - colMin, 0);
        }
        this.moveRight();
        focalValue = super.r().getDouble(col, rowMin);
        this.west()[0] = this.getValSafe$1(col - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = this.getValSafe$1(col, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = this.getValSafe$1(col + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = this.getValSafe$1(col + 1, rowMin, focalValue, colBorderMax, rowBorderMax);
        this.east()[2] = this.getValSafe$1(col + 1, rowMin + 1, focalValue, colBorderMax, rowBorderMax);
        this._setValue().apply(focalValue, col - colMin, 0);
        for (row = rowMin + 1; row < rowMax; ++row) {
            focalValue = super.r().getDouble(colMin, row);
            this.west()[0] = this.getValSafe$1(colMin - 1, row - 1, focalValue, colBorderMax, rowBorderMax);
            this.west()[1] = this.getValSafe$1(colMin - 1, row, focalValue, colBorderMax, rowBorderMax);
            this.west()[2] = this.getValSafe$1(colMin - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[0] = super.r().getDouble(colMin, row - 1);
            this.base()[1] = focalValue;
            this.base()[2] = super.r().getDouble(colMin, row + 1);
            this.east()[0] = super.r().getDouble(colMin + 1, row - 1);
            this.east()[1] = super.r().getDouble(colMin + 1, row);
            this.east()[2] = super.r().getDouble(colMin + 1, row + 1);
            this._setValue().apply(focalValue, 0, row - rowMin);
            for (col = colMin + 1; col < colMax; ++col) {
                this.moveRight();
                focalValue = super.r().getDouble(col, row);
                this.east()[0] = super.r().getDouble(col + 1, row - 1);
                this.east()[1] = super.r().getDouble(col + 1, row);
                this.east()[2] = super.r().getDouble(col + 1, row + 1);
                this._setValue().apply(focalValue, col - colMin, row - rowMin);
            }
            this.moveRight();
            focalValue = super.r().getDouble(col, row);
            this.east()[0] = this.getValSafe$1(col + 1, row - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[1] = this.getValSafe$1(col + 1, row, focalValue, colBorderMax, rowBorderMax);
            this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this._setValue().apply(focalValue, col - colMin, row - rowMin);
        }
        focalValue = super.r().getDouble(colMin, row);
        this.west()[0] = this.getValSafe$1(colMin - 1, row - 1, focalValue, colBorderMax, rowBorderMax);
        this.west()[1] = this.getValSafe$1(colMin - 1, row, focalValue, colBorderMax, rowBorderMax);
        this.west()[2] = this.getValSafe$1(colMin - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = super.r().getDouble(colMin, row - 1);
        this.base()[1] = focalValue;
        this.base()[2] = this.getValSafe$1(colMin, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = super.r().getDouble(colMin + 1, row - 1);
        this.east()[1] = super.r().getDouble(colMin + 1, row);
        this.east()[2] = this.getValSafe$1(colMin + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this._setValue().apply(focalValue, 0, row - rowMin);
        for (col = colMin + 1; col < colMax; ++col) {
            this.moveRight();
            focalValue = super.r().getDouble(col, row);
            this.west()[2] = this.getValSafe$1(col - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[2] = this.getValSafe$1(col, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[0] = super.r().getDouble(col + 1, row - 1);
            this.east()[1] = super.r().getDouble(col + 1, row);
            this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this._setValue().apply(focalValue, col - colMin, row - rowMin);
        }
        this.moveRight();
        focalValue = super.r().getDouble(col, row);
        this.west()[2] = this.getValSafe$1(col - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[2] = this.getValSafe$1(col, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = this.getValSafe$1(col + 1, row - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = this.getValSafe$1(col + 1, row, focalValue, colBorderMax, rowBorderMax);
        this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this._setValue().apply(focalValue, col - colMin, row - rowMin);
        return this.result();
    }

    private final double getValSafe$1(int col, int row, double focalVal, int colBorderMax$1, int rowBorderMax$1) {
        return col < 0 || colBorderMax$1 < col || row < 0 || rowBorderMax$1 < row ? focalVal : super.r().getDouble(col, row);
    }

    public SurfacePointCalculation(Tile r, Neighborhood n, Option<GridBounds> analysisArea, CellSize cellSize, TargetCell target) {
        SetValue setValue;
        this.cellSize = cellSize;
        super(r, n, analysisArea, target);
        this.lastY = -1;
        this.cellWidth = 0.0;
        this.cellHeight = 0.0;
        this.west = new double[3];
        this.base = new double[3];
        this.east = new double[3];
        this.s = new SurfacePoint();
        TargetCell targetCell = super.target();
        if (TargetCell$All$.MODULE$.equals(targetCell)) {
            setValue = new SetValue(this){
                private final /* synthetic */ SurfacePointCalculation $outer;

                public void apply(double z, int x, int y) {
                    this.$outer.calcSurface();
                    this.$outer.setValue(x, y, this.$outer.s());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        } else if (TargetCell$Data$.MODULE$.equals(targetCell)) {
            setValue = new SetValue(this){
                private final /* synthetic */ SurfacePointCalculation $outer;

                public void apply(double z, int x, int y) {
                    block0: {
                        if (Double.isNaN(z)) break block0;
                        this.$outer.calcSurface();
                        this.$outer.setValue(x, y, this.$outer.s());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        } else if (TargetCell$NoData$.MODULE$.equals(targetCell)) {
            setValue = new SetValue(this){
                private final /* synthetic */ SurfacePointCalculation $outer;

                public void apply(double z, int x, int y) {
                    block0: {
                        if (!Double.isNaN(z)) break block0;
                        this.$outer.calcSurface();
                        this.$outer.setValue(x, y, this.$outer.s());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        } else {
            throw new MatchError((Object)targetCell);
        }
        this._setValue = setValue;
    }

    public interface SetValue {
        public void apply(double var1, int var3, int var4);
    }
}

