/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.local;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;

public final class Mean$
implements Serializable {
    public static Mean$ MODULE$;

    static {
        new Mean$();
    }

    public Tile apply(Traversable<Tile> rs) {
        return this.apply((Seq<Tile>)rs.toSeq());
    }

    public Tile apply(Seq<Tile> rs, Predef.DummyImplicit d) {
        return this.apply(rs);
    }

    public Tile apply(Seq<Tile> rs) {
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)rs).assertEqualDimensions();
        int layerCount = rs.length();
        if (layerCount == 0) {
            throw scala.sys.package$.MODULE$.error("Can't compute mean of empty sequence");
        }
        DataType newCellType = (DataType)((TraversableOnce)rs.map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.cellType(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & java.io.Serializable & Serializable)(x$2, x$3) -> x$2.union((DataType)x$3));
        Tuple2<Object, Object> tuple2 = ((Grid)rs.apply(0)).dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(newCellType, cols2, rows2);
        if (newCellType.isFloatingPoint()) {
            for (int index$macro$550 = 0; index$macro$550 < rows2; ++index$macro$550) {
                for (int index$macro$549 = 0; index$macro$549 < cols2; ++index$macro$549) {
                    int count = 0;
                    double sum = 0.0;
                    for (int index$macro$548 = 0; index$macro$548 < layerCount; ++index$macro$548) {
                        double v = ((Tile)rs.apply(index$macro$548)).getDouble(index$macro$549, index$macro$550);
                        if (Double.isNaN(v)) continue;
                        ++count;
                        sum += v;
                    }
                    if (count > 0) {
                        tile.setDouble(index$macro$549, index$macro$550, sum / (double)count);
                        continue;
                    }
                    tile.setDouble(index$macro$549, index$macro$550, Double.NaN);
                }
            }
        } else {
            for (int index$macro$553 = 0; index$macro$553 < rows2; ++index$macro$553) {
                for (int index$macro$552 = 0; index$macro$552 < cols2; ++index$macro$552) {
                    int count = 0;
                    int sum = 0;
                    for (int index$macro$551 = 0; index$macro$551 < layerCount; ++index$macro$551) {
                        int v = ((Tile)rs.apply(index$macro$551)).get(index$macro$552, index$macro$553);
                        if (v == Integer.MIN_VALUE) continue;
                        ++count;
                        sum += v;
                    }
                    if (count > 0) {
                        tile.set(index$macro$552, index$macro$553, sum / count);
                        continue;
                    }
                    tile.set(index$macro$552, index$macro$553, Integer.MIN_VALUE);
                }
            }
        }
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Mean$() {
        MODULE$ = this;
    }
}

