/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.local;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.local.MinN;
import geotrellis.raster.mapalgebra.local.MinN$ArrayView$;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class MinN$
implements scala.Serializable {
    public static MinN$ MODULE$;

    static {
        new MinN$();
    }

    public int findNthIntInPlace(MinN.ArrayView<Object> arr, int n) {
        int n2;
        while (true) {
            if (n >= arr.size()) {
                n2 = Integer.MIN_VALUE;
                break;
            }
            int pivot = BoxesRunTime.unboxToInt((Object)arr.apply(Random$.MODULE$.nextInt(arr.size())));
            Tuple2<MinN.ArrayView<Object>, MinN.ArrayView<Object>> tuple2 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 < pivot);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MinN.ArrayView left = (MinN.ArrayView)tuple2._1();
            MinN.ArrayView right = (MinN.ArrayView)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
            Tuple2 tuple23 = tuple22;
            MinN.ArrayView left2 = (MinN.ArrayView)tuple23._1();
            MinN.ArrayView right2 = (MinN.ArrayView)tuple23._2();
            if (left2.size() == n) {
                n2 = pivot;
                break;
            }
            if (left2.isEmpty()) {
                Tuple2<MinN.ArrayView<Object>, MinN.ArrayView<Object>> tuple24 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 == pivot);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                MinN.ArrayView left3 = (MinN.ArrayView)tuple24._1();
                MinN.ArrayView right3 = (MinN.ArrayView)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)left3, (Object)right3);
                Tuple2 tuple26 = tuple25;
                MinN.ArrayView left4 = (MinN.ArrayView)tuple26._1();
                MinN.ArrayView right4 = (MinN.ArrayView)tuple26._2();
                if (left4.size() > n) {
                    n2 = pivot;
                    break;
                }
                n -= left4.size();
                arr = right4;
                continue;
            }
            if (left2.size() < n) {
                n -= left2.size();
                arr = right2;
                continue;
            }
            arr = left2;
        }
        return n2;
    }

    public double findNthDoubleInPlace(MinN.ArrayView<Object> arr, int n) {
        double d;
        while (true) {
            if (n >= arr.size()) {
                d = Double.NaN;
                break;
            }
            double pivot = BoxesRunTime.unboxToDouble((Object)arr.apply(Random$.MODULE$.nextInt(arr.size())));
            Tuple2<MinN.ArrayView<Object>, MinN.ArrayView<Object>> tuple2 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 < pivot);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MinN.ArrayView left = (MinN.ArrayView)tuple2._1();
            MinN.ArrayView right = (MinN.ArrayView)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
            Tuple2 tuple23 = tuple22;
            MinN.ArrayView left2 = (MinN.ArrayView)tuple23._1();
            MinN.ArrayView right2 = (MinN.ArrayView)tuple23._2();
            if (left2.size() == n) {
                d = pivot;
                break;
            }
            if (left2.isEmpty()) {
                Tuple2<MinN.ArrayView<Object>, MinN.ArrayView<Object>> tuple24 = arr.partitionInPlace((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$7 -> x$7 == pivot);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                MinN.ArrayView left3 = (MinN.ArrayView)tuple24._1();
                MinN.ArrayView right3 = (MinN.ArrayView)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)left3, (Object)right3);
                Tuple2 tuple26 = tuple25;
                MinN.ArrayView left4 = (MinN.ArrayView)tuple26._1();
                MinN.ArrayView right4 = (MinN.ArrayView)tuple26._2();
                if (left4.size() > n) {
                    d = pivot;
                    break;
                }
                n -= left4.size();
                arr = right4;
                continue;
            }
            if (left2.size() < n) {
                n -= left2.size();
                arr = right2;
                continue;
            }
            arr = left2;
        }
        return d;
    }

    public Tile apply(int n, Seq<Tile> rs) {
        return this.apply(n, (Traversable<Tile>)rs, Predef.DummyImplicit$.MODULE$.dummyImplicit());
    }

    public Tile apply(int n, Traversable<Tile> rs, Predef.DummyImplicit d) {
        package$.MODULE$.TraversableTileExtensions(rs).assertEqualDimensions();
        int layerCount = rs.toSeq().length();
        if (layerCount < n) {
            throw scala.sys.package$.MODULE$.error("Not enough values to compute Nth");
        }
        DataType newCellType = (DataType)((TraversableOnce)rs.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.cellType(), Traversable$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$10, x$11) -> x$10.union((DataType)x$11));
        Tuple2<Object, Object> tuple2 = ((Grid)rs.head()).dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(newCellType, cols2, rows2);
        IntRef index$macro$555 = IntRef.create((int)0);
        while (index$macro$555.elem < rows2) {
            IntRef index$macro$554 = IntRef.create((int)0);
            while (index$macro$554.elem < cols2) {
                if (newCellType.isFloatingPoint()) {
                    double minN = this.findNthDoubleInPlace(MinN$ArrayView$.MODULE$.apply((double[])((TraversableOnce)((TraversableLike)rs.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToDouble((double)r.getDouble(index$macro$554.elem, index$macro$555.elem)), Traversable$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)num -> !Double.isNaN(num))).toArray(ClassTag$.MODULE$.Double())), n);
                    tile.setDouble(index$macro$554.elem, index$macro$555.elem, minN);
                } else {
                    int minN = this.findNthIntInPlace(MinN$ArrayView$.MODULE$.apply((int[])((TraversableOnce)((TraversableLike)rs.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)r.get(index$macro$554.elem, index$macro$555.elem)), Traversable$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)num -> num != Integer.MIN_VALUE)).toArray(ClassTag$.MODULE$.Int())), n);
                    tile.set(index$macro$554.elem, index$macro$555.elem, minN);
                }
                ++index$macro$554.elem;
            }
            ++index$macro$555.elem;
        }
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MinN$() {
        MODULE$ = this;
    }
}

