/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.local;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.runtime.RichDouble$;

public final class Variance$
implements scala.Serializable {
    public static Variance$ MODULE$;

    static {
        new Variance$();
    }

    public Tile apply(Traversable<Tile> rs) {
        return this.apply((Seq<Tile>)rs.toSeq());
    }

    public Tile apply(Seq<Tile> rs, Predef.DummyImplicit d) {
        return this.apply(rs);
    }

    public Tile apply(Seq<Tile> rs) {
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)rs).assertEqualDimensions();
        int layerCount = rs.length();
        if (layerCount == 0) {
            throw scala.sys.package$.MODULE$.error("Can't compute variance of empty sequence.");
        }
        DataType newCellType = (DataType)((TraversableOnce)rs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.cellType(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.union((DataType)x$3));
        Tuple2<Object, Object> tuple2 = ((Grid)rs.apply(0)).dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(newCellType, cols2, rows2);
        for (int index$macro$560 = 0; index$macro$560 < rows2; ++index$macro$560) {
            for (int index$macro$559 = 0; index$macro$559 < cols2; ++index$macro$559) {
                int count = 0;
                double mean = 0.0;
                double m2 = 0.0;
                for (int index$macro$558 = 0; index$macro$558 < layerCount; ++index$macro$558) {
                    double v = ((Tile)rs.apply(index$macro$558)).getDouble(index$macro$559, index$macro$560);
                    if (Double.isNaN(v)) continue;
                    double delta = v - mean;
                    m2 += delta * (v - (mean += delta / (double)(++count)));
                }
                if (newCellType.isFloatingPoint()) {
                    if (count > 1) {
                        tile.setDouble(index$macro$559, index$macro$560, m2 / (double)(count - 1));
                        continue;
                    }
                    tile.setDouble(index$macro$559, index$macro$560, Double.NaN);
                    continue;
                }
                if (count > 1) {
                    tile.set(index$macro$559, index$macro$560, (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(m2 / (double)(count - 1))));
                    continue;
                }
                tile.set(index$macro$559, index$macro$560, Integer.MIN_VALUE);
            }
        }
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Variance$() {
        MODULE$ = this;
    }
}

