/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.merge;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.CellSize$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.package$;
import geotrellis.raster.resample.Resample;
import geotrellis.raster.resample.Resample$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.Extent;
import java.io.Serializable;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001y2q!\u0001\u0002\u0011\u0002\u0007\u0005\u0011B\u0001\u000eTS:<G.\u001a2b]\u0012$\u0016\u000e\\3NKJ<W-T3uQ>$7O\u0003\u0002\u0004\t\u0005)Q.\u001a:hK*\u0011QAB\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003\u001d\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001\u0001\u0006\u0011!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0019\u0011C\u0005\u000b\u000e\u0003\tI!a\u0005\u0002\u0003!QKG.Z'fe\u001e,W*\u001a;i_\u0012\u001c\bCA\u000b\u0017\u001b\u0005!\u0011BA\f\u0005\u0005\u0011!\u0016\u000e\\3\t\u000be\u0001A\u0011\u0001\u000e\u0002\r\u0011Jg.\u001b;%)\u0005Y\u0002CA\u0006\u001d\u0013\tiBB\u0001\u0003V]&$\b\"B\u0002\u0001\t\u0003yB\u0003\u0002\u000b!E\u001dBQ!\t\u0010A\u0002Q\tQa\u001c;iKJDQa\t\u0010A\u0002\u0011\nqAY1tK\u000e{G\u000e\u0005\u0002\fK%\u0011a\u0005\u0004\u0002\u0004\u0013:$\b\"\u0002\u0015\u001f\u0001\u0004!\u0013a\u00022bg\u0016\u0014vn\u001e\u0005\u0006\u0007\u0001!\tA\u000b\u000b\u0006)-\u001aTG\u000e\u0005\u0006Y%\u0002\r!L\u0001\u0007Kb$XM\u001c;\u0011\u00059\nT\"A\u0018\u000b\u0005A2\u0011A\u0002<fGR|'/\u0003\u00023_\t1Q\t\u001f;f]RDQ\u0001N\u0015A\u00025\n1b\u001c;iKJ,\u0005\u0010^3oi\")\u0011%\u000ba\u0001)!)q'\u000ba\u0001q\u00051Q.\u001a;i_\u0012\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0003\u0002\u0011I,7/Y7qY\u0016L!!\u0010\u001e\u0003\u001dI+7/Y7qY\u0016lU\r\u001e5pI\u0002")
public interface SinglebandTileMergeMethods
extends TileMergeMethods<Tile> {
    public static /* synthetic */ Tile merge$(SinglebandTileMergeMethods $this, Tile other, int baseCol, int baseRow) {
        return $this.merge(other, baseCol, baseRow);
    }

    @Override
    default public Tile merge(Tile other, int baseCol, int baseRow) {
        MutableArrayTile mutableTile = ((Tile)this.self()).mutable();
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)((Traversable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{(Tile)this.self(), other})))).assertEqualDimensions();
        DataType dataType = ((CellGrid)this.self()).cellType();
        if (BitCellType$.MODULE$.equals(dataType)) {
            for (int index$macro$572 = 0; index$macro$572 < other.rows(); ++index$macro$572) {
                for (int index$macro$571 = 0; index$macro$571 < other.cols(); ++index$macro$571) {
                    if (other.get(index$macro$571, index$macro$572) != 1) continue;
                    mutableTile.set(index$macro$571 + baseCol, index$macro$572 + baseRow, 1);
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType))));
            if (bl) {
                for (int index$macro$574 = 0; index$macro$574 < other.rows(); ++index$macro$574) {
                    for (int index$macro$573 = 0; index$macro$573 < other.cols(); ++index$macro$573) {
                        if (((Tile)this.self()).get(index$macro$573 + baseCol, index$macro$574 + baseRow) != 0) continue;
                        mutableTile.set(index$macro$573 + baseCol, index$macro$574 + baseRow, other.get(index$macro$573, index$macro$574));
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
                if (bl2) {
                    for (int index$macro$576 = 0; index$macro$576 < other.rows(); ++index$macro$576) {
                        for (int index$macro$575 = 0; index$macro$575 < other.cols(); ++index$macro$575) {
                            if (((Tile)this.self()).getDouble(index$macro$575 + baseCol, index$macro$576 + baseRow) != 0.0) continue;
                            mutableTile.setDouble(index$macro$575 + baseCol, index$macro$576 + baseRow, other.getDouble(index$macro$575, index$macro$576));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType.isFloatingPoint()) {
                    for (int index$macro$578 = 0; index$macro$578 < other.rows(); ++index$macro$578) {
                        for (int index$macro$577 = 0; index$macro$577 < other.cols(); ++index$macro$577) {
                            if (!Double.isNaN(((Tile)this.self()).getDouble(index$macro$577 + baseCol, index$macro$578 + baseRow))) continue;
                            mutableTile.setDouble(index$macro$577 + baseCol, index$macro$578 + baseRow, other.getDouble(index$macro$577, index$macro$578));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    for (int index$macro$580 = 0; index$macro$580 < other.rows(); ++index$macro$580) {
                        for (int index$macro$579 = 0; index$macro$579 < other.cols(); ++index$macro$579) {
                            if (((Tile)this.self()).get(index$macro$579 + baseCol, index$macro$580 + baseRow) != Integer.MIN_VALUE) continue;
                            mutableTile.set(index$macro$579 + baseCol, index$macro$580 + baseRow, other.get(index$macro$579, index$macro$580));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return mutableTile;
    }

    public static /* synthetic */ Tile merge$(SinglebandTileMergeMethods $this, Extent extent, Extent otherExtent, Tile other, ResampleMethod method) {
        return $this.merge(extent, otherExtent, other, method);
    }

    @Override
    default public Tile merge(Extent extent, Extent otherExtent, Tile other, ResampleMethod method) {
        Tile tile;
        Option option = otherExtent.$amp(extent);
        if (option instanceof Some) {
            Some some = (Some)option;
            Extent sharedExtent = (Extent)some.value();
            MutableArrayTile mutableTile = ((Tile)this.self()).mutable();
            RasterExtent re = RasterExtent$.MODULE$.apply(extent, ((Grid)this.self()).cols(), ((Grid)this.self()).rows());
            GridBounds gridBounds = re.gridBoundsFor(sharedExtent, re.gridBoundsFor$default$2());
            CellSize targetCS = CellSize$.MODULE$.apply(sharedExtent, gridBounds.width(), gridBounds.height());
            DataType dataType = ((CellGrid)this.self()).cellType();
            boolean bl = BitCellType$.MODULE$.equals(dataType) ? true : (ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType)))));
            if (bl) {
                Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                JFunction2.mcIDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcIDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resample(x, y);
                for (int index$macro$582 = 0; index$macro$582 < ((Grid)this.self()).rows(); ++index$macro$582) {
                    for (int index$macro$581 = 0; index$macro$581 < ((Grid)this.self()).cols(); ++index$macro$581) {
                        if (((Tile)this.self()).get(index$macro$581, index$macro$582) != 0) continue;
                        Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$581, index$macro$582);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        double x2 = tuple2._1$mcD$sp();
                        double y2 = tuple2._2$mcD$sp();
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x2, y2);
                        Tuple2.mcDD.sp sp3 = sp2;
                        double x3 = sp3._1$mcD$sp();
                        double y3 = sp3._2$mcD$sp();
                        int v = interpolate.apply$mcIDD$sp(x3, y3);
                        if (v == Integer.MIN_VALUE) continue;
                        mutableTile.set(index$macro$581, index$macro$582, v);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
                if (bl2) {
                    Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                    JFunction2.mcDDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resampleDouble(x, y);
                    for (int index$macro$584 = 0; index$macro$584 < ((Grid)this.self()).rows(); ++index$macro$584) {
                        for (int index$macro$583 = 0; index$macro$583 < ((Grid)this.self()).cols(); ++index$macro$583) {
                            if (((Tile)this.self()).getDouble(index$macro$583, index$macro$584) != 0.0) continue;
                            Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$583, index$macro$584);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            double x4 = tuple2._1$mcD$sp();
                            double y4 = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(x4, y4);
                            Tuple2.mcDD.sp sp5 = sp4;
                            double x5 = sp5._1$mcD$sp();
                            double y5 = sp5._2$mcD$sp();
                            double v = interpolate.apply$mcDDD$sp(x5, y5);
                            if (Double.isNaN(v)) continue;
                            mutableTile.setDouble(index$macro$583, index$macro$584, v);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType.isFloatingPoint()) {
                    Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                    JFunction2.mcDDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resampleDouble(x, y);
                    for (int index$macro$586 = 0; index$macro$586 < ((Grid)this.self()).rows(); ++index$macro$586) {
                        for (int index$macro$585 = 0; index$macro$585 < ((Grid)this.self()).cols(); ++index$macro$585) {
                            if (!Double.isNaN(((Tile)this.self()).getDouble(index$macro$585, index$macro$586))) continue;
                            Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$585, index$macro$586);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            double x6 = tuple2._1$mcD$sp();
                            double y6 = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(x6, y6);
                            Tuple2.mcDD.sp sp7 = sp6;
                            double x7 = sp7._1$mcD$sp();
                            double y7 = sp7._2$mcD$sp();
                            mutableTile.setDouble(index$macro$585, index$macro$586, interpolate.apply$mcDDD$sp(x7, y7));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Resample resample = Resample$.MODULE$.apply(method, other, otherExtent, targetCS);
                    JFunction2.mcIDD.sp & Serializable & scala.Serializable interpolate = (JFunction2.mcIDD.sp & Serializable & scala.Serializable)(x, y) -> resample.resample(x, y);
                    for (int index$macro$588 = 0; index$macro$588 < ((Grid)this.self()).rows(); ++index$macro$588) {
                        for (int index$macro$587 = 0; index$macro$587 < ((Grid)this.self()).cols(); ++index$macro$587) {
                            if (((Tile)this.self()).get(index$macro$587, index$macro$588) != Integer.MIN_VALUE) continue;
                            Tuple2<Object, Object> tuple2 = re.gridToMap(index$macro$587, index$macro$588);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            double x8 = tuple2._1$mcD$sp();
                            double y8 = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp8 = new Tuple2.mcDD.sp(x8, y8);
                            Tuple2.mcDD.sp sp9 = sp8;
                            double x9 = sp9._1$mcD$sp();
                            double y9 = sp9._2$mcD$sp();
                            mutableTile.set(index$macro$587, index$macro$588, interpolate.apply$mcIDD$sp(x9, y9));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            tile = mutableTile;
        } else {
            tile = (Tile)this.self();
        }
        return tile;
    }

    public static void $init$(SinglebandTileMergeMethods $this) {
    }
}

