/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.rasterize;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.Connectivity;
import geotrellis.raster.EightNeighbors$;
import geotrellis.raster.FourNeighbors$;
import geotrellis.raster.IntConstantNoDataArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import geotrellis.raster.package$IntArrayFiller$;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$Options$;
import geotrellis.raster.rasterize.extent.ExtentRasterizer$;
import geotrellis.raster.rasterize.polygon.PolygonRasterizer$;
import geotrellis.util.Constants$;
import geotrellis.vector.Extent;
import geotrellis.vector.Geometry;
import geotrellis.vector.GeometryCollection;
import geotrellis.vector.Line;
import geotrellis.vector.Line$;
import geotrellis.vector.LineResult;
import geotrellis.vector.MultiLine;
import geotrellis.vector.MultiPoint;
import geotrellis.vector.MultiPolygon;
import geotrellis.vector.NoResult$;
import geotrellis.vector.OneDimension;
import geotrellis.vector.OneDimensionAtLeastOneDimensionIntersectionResult;
import geotrellis.vector.Point;
import geotrellis.vector.Point$;
import geotrellis.vector.PointResult;
import geotrellis.vector.Polygon;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction2;

public final class Rasterizer$ {
    public static Rasterizer$ MODULE$;

    static {
        new Rasterizer$();
    }

    public Tile rasterizeWithValue(Geometry geom, RasterExtent rasterExtent, int value) {
        int cols = rasterExtent.cols();
        int[] array = package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(rasterExtent.cols() * rasterExtent.rows(), ClassTag$.MODULE$.Int())), Integer.MIN_VALUE);
        JFunction2.mcVII.sp & Serializable & scala.Serializable f2 = (JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> {
            array$1[row * cols$1 + col] = value;
        };
        this.foreachCellByGeometry(geom, rasterExtent, (Function2<Object, Object, BoxedUnit>)f2);
        return ArrayTile$.MODULE$.apply(array, rasterExtent.cols(), rasterExtent.rows());
    }

    public IntConstantNoDataArrayTile rasterize(Geometry feature, RasterExtent rasterExtent, Function2<Object, Object, Object> f) {
        int cols = rasterExtent.cols();
        int[] array = package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(rasterExtent.cols() * rasterExtent.rows(), ClassTag$.MODULE$.Int())), Integer.MIN_VALUE);
        JFunction2.mcVII.sp & Serializable & scala.Serializable f2 = (JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> {
            array$2[row * cols$2 + col] = f.apply$mcIII$sp(col, row);
        };
        this.foreachCellByGeometry(feature, rasterExtent, (Function2<Object, Object, BoxedUnit>)f2);
        return ArrayTile$.MODULE$.apply(array, rasterExtent.cols(), rasterExtent.rows());
    }

    public void foreachCellByGeometry(Geometry geom, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        this.foreachCellByGeometry(geom, re, Rasterizer$Options$.MODULE$.DEFAULT(), f);
    }

    public void foreachCellByGeometry(Geometry geom, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.foreachCellByPoint(point, re, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry;
            this.foreachCellByMultiPoint(multiPoint, re, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof MultiLine) {
            MultiLine multiLine = (MultiLine)geometry;
            this.foreachCellByMultiLineString(multiLine, re, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof Line) {
            Line line = (Line)geometry;
            this.foreachCellByLineString(line, re, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            PolygonRasterizer$.MODULE$.foreachCellByPolygon(polygon, re, options, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            this.foreachCellByMultiPolygon(multiPolygon, re, options, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            geometryCollection.geometries().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                Rasterizer$.MODULE$.foreachCellByGeometry(x$1, re, options, (Function2<Object, Object, BoxedUnit>)f);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof Extent) {
            Extent extent = (Extent)geometry;
            ExtentRasterizer$.MODULE$.foreachCellByExtent(extent, re, options, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)geometry);
        }
    }

    public void foreachCellByPoint(Point geom, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        int col = re.mapXToGrid(geom.x());
        int row = re.mapYToGrid(geom.y());
        f.apply$mcVII$sp(col, row);
    }

    public void foreachCellByMultiPoint(MultiPoint p, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.points())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Rasterizer$.MODULE$.foreachCellByPoint(x$2, re, (Function2<Object, Object, BoxedUnit>)f);
            return BoxedUnit.UNIT;
        });
    }

    public void foreachCellByPointSeq(Seq<Point> pSet, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        pSet.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Rasterizer$.MODULE$.foreachCellByPoint(x$3, re, (Function2<Object, Object, BoxedUnit>)f);
            return BoxedUnit.UNIT;
        });
    }

    public void foreachCellByMultiLineString(MultiLine g, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])g.lines())).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Rasterizer$.MODULE$.foreachCellByLineString(x$4, re, (Function2<Object, Object, BoxedUnit>)f);
            return BoxedUnit.UNIT;
        });
    }

    public void foreachCellByMultiLineString(MultiLine g, RasterExtent re, Connectivity c, Function2<Object, Object, BoxedUnit> f) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])g.lines())).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Rasterizer$.MODULE$.foreachCellByLineString(x$5, re, c, (Function2<Object, Object, BoxedUnit>)f);
            return BoxedUnit.UNIT;
        });
    }

    public void foreachCellByPolygon(Polygon p, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        this.foreachCellByPolygon(p, re, Rasterizer$Options$.MODULE$.DEFAULT(), f);
    }

    public void foreachCellByPolygon(Polygon p, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        PolygonRasterizer$.MODULE$.foreachCellByPolygon(p, re, options, f);
    }

    public <D> void foreachCellByMultiPolygon(MultiPolygon p, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        this.foreachCellByMultiPolygon(p, re, Rasterizer$Options$.MODULE$.DEFAULT(), f);
    }

    public <D> void foreachCellByMultiPolygon(MultiPolygon p, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.polygons())).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            PolygonRasterizer$.MODULE$.foreachCellByPolygon(x$6, re, options, (Function2<Object, Object, BoxedUnit>)f);
            return BoxedUnit.UNIT;
        });
    }

    public void foreachCellByLineString(Line line, RasterExtent re, Connectivity c, Function2<Object, Object, BoxedUnit> f) {
        Coordinate[] coords = line.jtsGeom().getCoordinates();
        for (int i = 1; i < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).size(); ++i) {
            int x1 = re.mapXToGrid(coords[i - 1].x);
            int y1 = re.mapYToGrid(coords[i - 1].y);
            int x2 = re.mapXToGrid(coords[i + 0].x);
            int y2 = re.mapYToGrid(coords[i + 0].y);
            this.foreachCellInGridLine(x1, y1, x2, y2, re, i != new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).size() - 1, c, f);
        }
    }

    public void foreachCellByLineString(Line line, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        Coordinate[] coords = line.jtsGeom().getCoordinates();
        for (int i = 1; i < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).size(); ++i) {
            int x1 = re.mapXToGrid(coords[i - 1].x);
            int y1 = re.mapYToGrid(coords[i - 1].y);
            int x2 = re.mapXToGrid(coords[i + 0].x);
            int y2 = re.mapYToGrid(coords[i + 0].y);
            this.foreachCellInGridLine(x1, y1, x2, y2, line, re, i != new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).size() - 1, f);
        }
    }

    public <D> void foreachCellInGridLine(int x0, int y0, int x1, int y1, Line p, RasterExtent re, boolean skipLast, Function2<Object, Object, BoxedUnit> f) {
        this.foreachCellInGridLine(x0, y0, x1, y1, re, skipLast, EightNeighbors$.MODULE$, f);
    }

    public void foreachCellInGridLine(int x0, int y0, int x1, int y1, RasterExtent re, boolean skipLast, Connectivity c, Function2<Object, Object, BoxedUnit> f) {
        block5: {
            int err;
            int dx = scala.math.package$.MODULE$.abs(x1 - x0);
            int sx = x0 < x1 ? 1 : -1;
            int dy = scala.math.package$.MODULE$.abs(y1 - y0);
            int sy = y0 < y1 ? 1 : -1;
            int x = x0;
            int y = y0;
            int e2 = err = (dx > dy ? dx : -dy) / 2;
            while (x != x1 || y != y1) {
                if (0 <= x && x < re.cols() && 0 <= y && y < re.rows()) {
                    f.apply$mcVII$sp(x, y);
                }
                if ((e2 = err) > -dx) {
                    err -= dy;
                    x += sx;
                }
                if (e2 >= dy) continue;
                Connectivity connectivity = c;
                FourNeighbors$ fourNeighbors$ = FourNeighbors$.MODULE$;
                if (!(connectivity != null ? !connectivity.equals(fourNeighbors$) : fourNeighbors$ != null)) {
                    if (e2 > -dx && 0 <= x && x < re.cols() && 0 <= y && y < re.rows()) {
                        f.apply$mcVII$sp(x, y);
                    }
                }
                err += dx;
                y += sy;
            }
            if (skipLast || 0 > x || x >= re.cols() || 0 > y || y >= re.rows()) break block5;
            f.apply$mcVII$sp(x, y);
        }
    }

    public <D> boolean foreachCellInGridLine$default$7() {
        return false;
    }

    public void foreachCellByLineStringDouble(Line line, RasterExtent re, Function2<Object, Object, BoxedUnit> f) {
        Coordinate[] coords = line.jtsGeom().getCoordinates();
        for (int i = 1; i < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).size(); ++i) {
            this.foreachCellInGridLineDouble(coords[i - 1].x, coords[i - 1].y, coords[i + 0].x, coords[i + 0].y, re, line.isClosed() || i != new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).size() - 1, f);
        }
    }

    private void foreachCellInGridLineDouble(double x0, double y0, double x1, double y1, RasterExtent re, boolean skipLast, Function2<Object, Object, BoxedUnit> f) {
        block26: {
            Tuple2 tuple2;
            OneDimensionAtLeastOneDimensionIntersectionResult oneDimensionAtLeastOneDimensionIntersectionResult = re.extent().toPolygon().intersection((OneDimension)Line$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(x0, y0), new Tuple2.mcDD.sp(x1, y1)}), Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            if (NoResult$.MODULE$.equals(oneDimensionAtLeastOneDimensionIntersectionResult)) {
                return;
            }
            if (oneDimensionAtLeastOneDimensionIntersectionResult instanceof PointResult) {
                PointResult pointResult = (PointResult)oneDimensionAtLeastOneDimensionIntersectionResult;
                Point p = pointResult.geom();
                tuple2 = new Tuple2((Object)p, (Object)None$.MODULE$);
            } else if (oneDimensionAtLeastOneDimensionIntersectionResult instanceof LineResult) {
                LineResult lineResult = (LineResult)oneDimensionAtLeastOneDimensionIntersectionResult;
                Line l = lineResult.geom();
                Point p0 = l.vertices()[0];
                Point p1 = l.vertices()[1];
                Point base = Point$.MODULE$.apply(x0, y0);
                tuple2 = base.distance((Geometry)p0) <= base.distance((Geometry)p1) ? new Tuple2((Object)p0, (Object)new Some((Object)p1)) : new Tuple2((Object)p1, (Object)new Some((Object)p0));
            } else {
                throw new RuntimeException("Impossible result of line segment intersection");
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Point initialPoint = (Point)tuple22._1();
            Option finalPoint = (Option)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)initialPoint, (Object)finalPoint);
            Tuple2 tuple24 = tuple23;
            Point initialPoint2 = (Point)tuple24._1();
            Option finalPoint2 = (Option)tuple24._2();
            Tuple2<Object, Object> tuple25 = re.mapToGrid(initialPoint2);
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            int x = tuple25._1$mcI$sp();
            int y = tuple25._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x, y);
            Tuple2.mcII.sp sp3 = sp2;
            int x2 = sp3._1$mcI$sp();
            int y2 = sp3._2$mcI$sp();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(Rasterizer$.clamp$1(0, re.cols() - 1, x2), Rasterizer$.clamp$1(0, re.rows() - 1, y2));
            if (sp4 == null) {
                throw new MatchError((Object)sp4);
            }
            int cellX = sp4._1$mcI$sp();
            int cellY = sp4._2$mcI$sp();
            Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(cellX, cellY);
            Tuple2.mcII.sp sp6 = sp5;
            int cellX2 = sp6._1$mcI$sp();
            int cellY2 = sp6._2$mcI$sp();
            if (finalPoint2.isEmpty()) {
                f.apply$mcVII$sp(cellX2, cellY2);
                return;
            }
            Tuple2<Object, Object> tuple26 = re.mapToGrid((Point)finalPoint2.get());
            if (tuple26 == null) {
                throw new MatchError(tuple26);
            }
            int x3 = tuple26._1$mcI$sp();
            int y3 = tuple26._2$mcI$sp();
            Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(x3, y3);
            Tuple2.mcII.sp sp8 = sp7;
            int x4 = sp8._1$mcI$sp();
            int y4 = sp8._2$mcI$sp();
            Tuple2.mcII.sp sp9 = new Tuple2.mcII.sp(Rasterizer$.clamp$1(0, re.cols() - 1, x4), Rasterizer$.clamp$1(0, re.rows() - 1, y4));
            if (sp9 == null) {
                throw new MatchError((Object)sp9);
            }
            int finalX = sp9._1$mcI$sp();
            int finalY = sp9._2$mcI$sp();
            Tuple2.mcII.sp sp10 = new Tuple2.mcII.sp(finalX, finalY);
            Tuple2.mcII.sp sp11 = sp10;
            int finalX2 = sp11._1$mcI$sp();
            int finalY2 = sp11._2$mcI$sp();
            if (finalX2 == cellX2 && finalY2 == cellY2) {
                f.apply$mcVII$sp(cellX2, cellY2);
                return;
            }
            int stepX = (int)scala.math.package$.MODULE$.signum(x1 - x0);
            int stepY = (int)scala.math.package$.MODULE$.signum(y0 - y1);
            double firstX = stepX == 0 ? Double.POSITIVE_INFINITY : (re.gridColToMap(cellX2) + re.gridColToMap(cellX2 + stepX)) / 2.0;
            double firstY = stepY == 0 ? Double.POSITIVE_INFINITY : (re.gridRowToMap(cellY2) + re.gridRowToMap(cellY2 + stepY)) / 2.0;
            Tuple2.mcDD.sp sp12 = new Tuple2.mcDD.sp(((Point)finalPoint2.get()).x() - initialPoint2.x(), ((Point)finalPoint2.get()).y() - initialPoint2.y());
            if (sp12 == null) {
                throw new MatchError((Object)sp12);
            }
            double dx = sp12._1$mcD$sp();
            double dy = sp12._2$mcD$sp();
            Tuple2.mcDD.sp sp13 = new Tuple2.mcDD.sp(dx, dy);
            Tuple2.mcDD.sp sp14 = sp13;
            double dx2 = sp14._1$mcD$sp();
            double dy2 = sp14._2$mcD$sp();
            Tuple2.mcDD.sp sp15 = new Tuple2.mcDD.sp((firstX - initialPoint2.x()) / dx2, (firstY - initialPoint2.y()) / dy2);
            if (sp15 == null) {
                throw new MatchError((Object)sp15);
            }
            double tMaxX = sp15._1$mcD$sp();
            double tMaxY = sp15._2$mcD$sp();
            Tuple2.mcDD.sp sp16 = new Tuple2.mcDD.sp(tMaxX, tMaxY);
            Tuple2.mcDD.sp sp17 = sp16;
            double tMaxX2 = sp17._1$mcD$sp();
            double tMaxY2 = sp17._2$mcD$sp();
            Tuple2.mcDD.sp sp18 = new Tuple2.mcDD.sp(re.cellwidth() / scala.math.package$.MODULE$.abs(dx2), re.cellheight() / scala.math.package$.MODULE$.abs(dy2));
            if (sp18 == null) {
                throw new MatchError((Object)sp18);
            }
            double tDeltaX = sp18._1$mcD$sp();
            double tDeltaY = sp18._2$mcD$sp();
            Tuple2.mcDD.sp sp19 = new Tuple2.mcDD.sp(tDeltaX, tDeltaY);
            Tuple2.mcDD.sp sp20 = sp19;
            double tDeltaX2 = sp20._1$mcD$sp();
            double tDeltaY2 = sp20._2$mcD$sp();
            do {
                f.apply$mcVII$sp(cellX2, cellY2);
                if (scala.math.package$.MODULE$.abs(tMaxX2 - tMaxY2) < Constants$.MODULE$.DOUBLE_EPSILON()) {
                    BoxedUnit boxedUnit;
                    Tuple2.mcII.sp sp21 = new Tuple2.mcII.sp(stepX, stepY);
                    if (sp21 != null) {
                        int n = sp21._1$mcI$sp();
                        int n2 = sp21._2$mcI$sp();
                        if (1 == n && -1 == n2) {
                            cellX2 += stepX;
                            tMaxX2 += tDeltaX2;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    if (sp21 != null) {
                        int n = sp21._1$mcI$sp();
                        int n3 = sp21._2$mcI$sp();
                        if (1 == n && 1 == n3) {
                            cellX2 += stepX;
                            cellY2 += stepY;
                            tMaxX2 += tDeltaX2;
                            tMaxY2 += tDeltaY2;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    if (sp21 != null) {
                        int n = sp21._1$mcI$sp();
                        int n4 = sp21._2$mcI$sp();
                        if (-1 == n && 1 == n4) {
                            cellY2 += stepY;
                            tMaxY2 += tDeltaY2;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    if (sp21 != null) {
                        int n = sp21._1$mcI$sp();
                        int n5 = sp21._2$mcI$sp();
                        if (-1 == n && -1 == n5) {
                            cellX2 += stepX;
                            cellY2 += stepY;
                            tMaxX2 += tDeltaX2;
                            tMaxY2 += tDeltaY2;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    throw new RuntimeException(new StringBuilder(48).append("Arrived at illegal configuration: stepX=").append(stepX).append(", stepY=").append(stepY).toString());
                }
                if (tMaxX2 < tMaxY2) {
                    tMaxX2 += tDeltaX2;
                    cellX2 += stepX;
                    continue;
                }
                tMaxY2 += tDeltaY2;
                cellY2 += stepY;
            } while (cellX2 != finalX2 || cellY2 != finalY2);
            if (skipLast) break block26;
            f.apply$mcVII$sp(cellX2, cellY2);
        }
    }

    private static final int clamp$1(int lo, int hi, int x) {
        return x < lo ? lo : (x > hi ? hi : x);
    }

    private Rasterizer$() {
        MODULE$ = this;
    }
}

