/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.rasterize.polygon;

import geotrellis.raster.PixelIsPoint$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$Options$;
import geotrellis.vector.Polygon;
import java.io.Serializable;
import java.util.Arrays;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;
import scala.Array$;
import scala.Double$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class PolygonRasterizer$ {
    public static PolygonRasterizer$ MODULE$;

    static {
        new PolygonRasterizer$();
    }

    private List<Tuple2<Object, Object>> intervalIntersection(Tuple2<Object, Object> a, Tuple2<Object, Object> b) {
        double right;
        double left = package$.MODULE$.max(a._1$mcD$sp(), b._1$mcD$sp());
        return left <= (right = package$.MODULE$.min(a._2$mcD$sp(), b._2$mcD$sp())) ? new .colon.colon((Object)new Tuple2.mcDD.sp(left, right), (List)Nil$.MODULE$) : List$.MODULE$.empty();
    }

    private List<Tuple2<Object, Object>> intervalDifference(Tuple2<Object, Object> a, Tuple2<Object, Object> b) {
        Tuple2<Object, Object> tuple2 = a;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double aLeft = tuple2._1$mcD$sp();
        double aRight = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(aLeft, aRight);
        Tuple2.mcDD.sp sp3 = sp2;
        double aLeft2 = sp3._1$mcD$sp();
        double aRight2 = sp3._2$mcD$sp();
        Tuple2<Object, Object> tuple22 = b;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        double bLeft = tuple22._1$mcD$sp();
        double bRight = tuple22._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(bLeft, bRight);
        Tuple2.mcDD.sp sp5 = sp4;
        double bLeft2 = sp5._1$mcD$sp();
        double bRight2 = sp5._2$mcD$sp();
        return aLeft2 <= bLeft2 && bRight2 <= aRight2 ? new .colon.colon((Object)new Tuple2.mcDD.sp(aLeft2, bLeft2), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(bRight2, aRight2), (List)Nil$.MODULE$)) : (bLeft2 <= aLeft2 && aRight2 <= bRight2 ? List$.MODULE$.empty() : (aLeft2 <= bLeft2 && bLeft2 <= aRight2 ? new .colon.colon((Object)new Tuple2.mcDD.sp(aLeft2, bLeft2), (List)Nil$.MODULE$) : (bLeft2 <= aLeft2 && bRight2 <= aRight2 ? new .colon.colon((Object)new Tuple2.mcDD.sp(bRight2, aRight2), (List)Nil$.MODULE$) : List$.MODULE$.empty())));
    }

    private List<Tuple2<Object, Object>> intervalDifference(List<Tuple2<Object, Object>> a, Tuple2<Object, Object> b) {
        return (List)a.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.intervalDifference((Tuple2<Object, Object>)x$3, b), List$.MODULE$.canBuildFrom());
    }

    private double[] mergeIntervals(Seq<Tuple2<Object, Object>> sortedIntervals) {
        double[] dArray;
        if (sortedIntervals.length() > 0) {
            Tuple2 head = (Tuple2)sortedIntervals.head();
            Stack stack = (Stack)Stack$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{head._1$mcD$sp(), head._2$mcD$sp()}));
            ((IterableLike)sortedIntervals.tail()).foreach((Function1 & Serializable & scala.Serializable)interval -> {
                Stack stack;
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)stack.apply(0)), BoxesRunTime.unboxToDouble((Object)stack.apply(1)));
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                double l1 = sp2._1$mcD$sp();
                double r1 = sp2._2$mcD$sp();
                Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(l1, r1);
                Tuple2.mcDD.sp sp4 = sp3;
                double l12 = sp4._1$mcD$sp();
                double r12 = sp4._2$mcD$sp();
                Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(interval._1$mcD$sp(), interval._2$mcD$sp());
                if (sp5 == null) {
                    throw new MatchError((Object)sp5);
                }
                double l2 = sp5._1$mcD$sp();
                double r2 = sp5._2$mcD$sp();
                Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(l2, r2);
                Tuple2.mcDD.sp sp7 = sp6;
                double l22 = sp7._1$mcD$sp();
                double r22 = sp7._2$mcD$sp();
                if (r12 < l22) {
                    stack.push((Object)BoxesRunTime.boxToDouble((double)interval._2$mcD$sp()));
                    stack = stack.push((Object)BoxesRunTime.boxToDouble((double)interval._1$mcD$sp()));
                } else {
                    stack.pop();
                    stack.pop();
                    stack.push((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(r12, r22)));
                    stack = stack.push((Object)BoxesRunTime.boxToDouble((double)l12));
                }
                return stack;
            });
            dArray = (double[])stack.toArray(ClassTag$.MODULE$.Double());
        } else {
            dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
        }
        return dArray;
    }

    private Tuple2<Object, Object> lineAxisIntersection(Tuple4<Object, Object, Object, Object> line, double y) {
        Tuple4<Object, Object, Object, Object> tuple4 = line;
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        double x1 = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double y1 = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double x2 = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double y2 = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)x1), (Object)BoxesRunTime.boxToDouble((double)y1), (Object)BoxesRunTime.boxToDouble((double)x2), (Object)BoxesRunTime.boxToDouble((double)y2));
        Tuple4 tuple43 = tuple42;
        double x12 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double y12 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double x22 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double y22 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        return y == y12 ? new Tuple2.mcDI.sp(x12, 1) : (y == y22 ? new Tuple2.mcDI.sp(x22, -1) : (package$.MODULE$.min(y12, y22) <= y && y <= package$.MODULE$.max(y12, y22) ? new Tuple2.mcDI.sp(((x12 - x22) * y - (x12 * y22 - y12 * x22)) / (y12 - y22), 0) : new Tuple2.mcDI.sp(Double.NEGATIVE_INFINITY, Integer.MAX_VALUE)));
    }

    /*
     * WARNING - void declaration
     */
    public STRtree polygonToEdges(Polygon poly, RasterExtent re) {
        void var3_3;
        STRtree rtree = new STRtree();
        Coordinate[] coords = poly.jtsGeom().getExteriorRing().getCoordinates();
        for (int index$macro$592 = 1; index$macro$592 < coords.length; ++index$macro$592) {
            Coordinate coord1 = coords[index$macro$592 - 1];
            Coordinate coord2 = coords[index$macro$592];
            double col1 = re.mapXToGridDouble(coord1.x);
            double row1 = re.mapYToGridDouble(coord1.y);
            double col2 = re.mapXToGridDouble(coord2.x);
            double row2 = re.mapYToGridDouble(coord2.y);
            Tuple4 segment = row1 < row2 ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1), (Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2), (Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1));
            rtree.insert(new Envelope(package$.MODULE$.min(col1, col2), package$.MODULE$.max(col1, col2), BoxesRunTime.unboxToDouble((Object)segment._2()), BoxesRunTime.unboxToDouble((Object)segment._4())), (Object)segment);
        }
        for (int index$macro$594 = 0; index$macro$594 < poly.numberOfHoles(); ++index$macro$594) {
            Coordinate[] coords2 = poly.jtsGeom().getInteriorRingN(index$macro$594).getCoordinates();
            for (int index$macro$593 = 1; index$macro$593 < coords2.length; ++index$macro$593) {
                Coordinate coord1 = coords2[index$macro$593 - 1];
                Coordinate coord2 = coords2[index$macro$593];
                double col1 = re.mapXToGridDouble(coord1.x);
                double row1 = re.mapYToGridDouble(coord1.y);
                double col2 = re.mapXToGridDouble(coord2.x);
                double row2 = re.mapYToGridDouble(coord2.y);
                Tuple4 segment = row1 < row2 ? new Tuple4((Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1), (Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2)) : new Tuple4((Object)BoxesRunTime.boxToDouble((double)col2), (Object)BoxesRunTime.boxToDouble((double)row2), (Object)BoxesRunTime.boxToDouble((double)col1), (Object)BoxesRunTime.boxToDouble((double)row1));
                rtree.insert(new Envelope(package$.MODULE$.min(col1, col2), package$.MODULE$.max(col1, col2), BoxesRunTime.unboxToDouble((Object)segment._2()), BoxesRunTime.unboxToDouble((Object)segment._4())), (Object)segment);
            }
        }
        return var3_3;
    }

    private double[] runsPoint(STRtree rtree, int y, int maxX) {
        Buffer buffer;
        double row = (double)y + 0.5;
        Map xcoordsMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer xcoordsList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef nonHorizontal = IntRef.create((int)0);
        BooleanRef horizontal = BooleanRef.create((boolean)false);
        Buffer segments = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rtree.query(new Envelope(Double$.MODULE$.MinValue(), Double.MAX_VALUE, row, row))).asScala()).flatMap((Function1 & Serializable & scala.Serializable)edgeObj -> {
            Iterable iterable;
            Tuple4 edge = (Tuple4)edgeObj;
            if (BoxesRunTime.unboxToDouble((Object)edge._2()) != BoxesRunTime.unboxToDouble((Object)edge._4())) {
                Tuple2<Object, Object> tuple2 = MODULE$.lineAxisIntersection((Tuple4<Object, Object, Object, Object>)edge, row);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                double xcoord = tuple2._1$mcD$sp();
                int parity = tuple2._2$mcI$sp();
                Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(xcoord, parity);
                Tuple2.mcDI.sp sp3 = sp2;
                double xcoord2 = sp3._1$mcD$sp();
                int parity2 = sp3._2$mcI$sp();
                ++nonHorizontal$1.elem;
                iterable = parity2 != Integer.MAX_VALUE ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2.mcDI.sp(xcoord2, parity2))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                horizontal$1.elem = true;
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Buffer$.MODULE$.canBuildFrom());
        if (horizontal.elem) {
            int downwardDistance;
            Buffer upward = (Buffer)segments.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PolygonRasterizer$.$anonfun$runsPoint$2(x0$1)));
            Buffer downward = (Buffer)segments.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PolygonRasterizer$.$anonfun$runsPoint$3(x0$2)));
            int upwardDistance = package$.MODULE$.abs(nonHorizontal.elem - upward.length());
            buffer = upwardDistance < (downwardDistance = package$.MODULE$.abs(nonHorizontal.elem - downward.length())) ? upward : downward;
        } else {
            buffer = segments;
        }
        Buffer segments2 = buffer;
        segments2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            PolygonRasterizer$.$anonfun$runsPoint$4(xcoordsMap, x0$3);
            return BoxedUnit.UNIT;
        });
        xcoordsMap.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double xcoord = tuple2._1$mcD$sp();
            int parity = tuple2._2$mcI$sp();
            ListBuffer listBuffer = parity == -1 || parity == 0 || parity == 1 ? xcoordsList.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(xcoord + 0.5))) : BoxedUnit.UNIT;
            return listBuffer;
        });
        double[] xcoords = (double[])xcoordsList.toArray(ClassTag$.MODULE$.Double());
        Arrays.sort(xcoords);
        return xcoords;
    }

    private double[] runsArea(STRtree rtree, int y, int maxX, boolean partial) {
        double[] dArray;
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(y + 1, y + 0);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int top = sp2._1$mcI$sp();
        int bot = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(top, bot);
        Tuple2.mcII.sp sp4 = sp3;
        int top2 = sp4._1$mcI$sp();
        int bot2 = sp4._2$mcI$sp();
        ListBuffer interactions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer intervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer botIntervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer topIntervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer midIntervals = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef botInterval = BooleanRef.create((boolean)false);
        BooleanRef topInterval = BooleanRef.create((boolean)false);
        DoubleRef botIntervalStart = DoubleRef.create((double)0.0);
        DoubleRef topIntervalStart = DoubleRef.create((double)0.0);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rtree.query(new Envelope(Double$.MODULE$.MinValue(), Double.MAX_VALUE, (double)bot2, (double)top2))).asScala()).foreach((Function1 & Serializable & scala.Serializable)edgeObj -> {
            boolean ignore;
            Tuple4 edge = (Tuple4)edgeObj;
            double minY = package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)edge._2()), BoxesRunTime.unboxToDouble((Object)edge._4()));
            double maxY = package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)edge._2()), BoxesRunTime.unboxToDouble((Object)edge._4()));
            boolean bl = ignore = maxY == (double)bot2 || minY == (double)top2;
            return !ignore ? interactions.$plus$eq((Object)(BoxesRunTime.unboxToDouble((Object)edge._1()) <= BoxesRunTime.unboxToDouble((Object)edge._3()) ? edge : new Tuple4(edge._3(), edge._4(), edge._1(), edge._2()))) : BoxedUnit.UNIT;
        });
        ((TraversableForwarder)interactions.sortWith((Function2 & Serializable & scala.Serializable)(x$15, x$16) -> BoxesRunTime.boxToBoolean((boolean)PolygonRasterizer$.$anonfun$runsArea$2(x$15, x$16)))).foreach((Function1 & Serializable & scala.Serializable)edge -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            boolean touchesBot;
            double topIntervalX = MODULE$.lineAxisIntersection((Tuple4<Object, Object, Object, Object>)edge, top2)._1$mcD$sp();
            double botIntervalX = MODULE$.lineAxisIntersection((Tuple4<Object, Object, Object, Object>)edge, bot2)._1$mcD$sp();
            boolean touchesTop = topIntervalX != Double.NEGATIVE_INFINITY;
            boolean bl = touchesBot = botIntervalX != Double.NEGATIVE_INFINITY;
            if (partial) {
                double firstX;
                double d = BoxesRunTime.unboxToDouble((Object)edge._2()) <= (double)bot2 ? botIntervalX : (firstX = BoxesRunTime.unboxToDouble((Object)edge._2()) >= (double)top2 ? topIntervalX : BoxesRunTime.unboxToDouble((Object)edge._1()));
                double secondX = BoxesRunTime.unboxToDouble((Object)edge._4()) <= (double)bot2 ? botIntervalX : (BoxesRunTime.unboxToDouble((Object)edge._4()) >= (double)top2 ? topIntervalX : BoxesRunTime.unboxToDouble((Object)edge._3()));
                double smallerX = package$.MODULE$.min(firstX, secondX);
                double largerX = package$.MODULE$.max(firstX, secondX);
                boxedUnit3 = intervals.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(smallerX), package$.MODULE$.ceil(largerX)));
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (touchesTop) {
                if (!topInterval$1.elem) {
                    topInterval$1.elem = true;
                    topIntervalStart$1.elem = topIntervalX;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (topInterval$1.elem) {
                    topInterval$1.elem = false;
                    double smaller = package$.MODULE$.min(topIntervalStart$1.elem, topIntervalX);
                    double larger = package$.MODULE$.max(topIntervalStart$1.elem, topIntervalX);
                    boxedUnit2 = partial ? intervals.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(smaller), package$.MODULE$.ceil(larger))) : topIntervals.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.ceil(smaller), package$.MODULE$.floor(larger)));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (touchesBot) {
                if (!botInterval$1.elem) {
                    botInterval$1.elem = true;
                    botIntervalStart$1.elem = botIntervalX;
                    boxedUnit = BoxedUnit.UNIT;
                } else if (botInterval$1.elem) {
                    botInterval$1.elem = false;
                    double smaller = package$.MODULE$.min(botIntervalStart$1.elem, botIntervalX);
                    double larger = package$.MODULE$.max(botIntervalStart$1.elem, botIntervalX);
                    boxedUnit = partial ? intervals.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(smaller), package$.MODULE$.ceil(larger))) : botIntervals.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.ceil(smaller), package$.MODULE$.floor(larger)));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return !partial && (!touchesTop || !touchesBot) ? midIntervals.$plus$eq((Object)new Tuple2.mcDD.sp(package$.MODULE$.floor(BoxesRunTime.unboxToDouble((Object)edge._1())), package$.MODULE$.ceil(BoxesRunTime.unboxToDouble((Object)edge._3())))) : BoxedUnit.UNIT;
        });
        if (partial) {
            dArray = this.mergeIntervals((Seq<Tuple2<Object, Object>>)((Seq)intervals.sortWith((Function2 & Serializable & scala.Serializable)(x$17, x$18) -> BoxesRunTime.boxToBoolean((boolean)PolygonRasterizer$.$anonfun$runsArea$4(x$17, x$18)))));
        } else {
            ListBuffer sortedTopIntervals = (ListBuffer)topIntervals.sortWith((Function2 & Serializable & scala.Serializable)(x$19, x$20) -> BoxesRunTime.boxToBoolean((boolean)PolygonRasterizer$.$anonfun$runsArea$5(x$19, x$20)));
            ListBuffer sortedBotIntervals = (ListBuffer)botIntervals.sortWith((Function2 & Serializable & scala.Serializable)(x$21, x$22) -> BoxesRunTime.boxToBoolean((boolean)PolygonRasterizer$.$anonfun$runsArea$6(x$21, x$22)));
            ListBuffer intervals2 = (ListBuffer)ListBuffer$.MODULE$.empty();
            ((TraversableLike)sortedTopIntervals.zip((GenIterable)sortedBotIntervals, ListBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 a2 = (Tuple2)tuple2._1();
                Tuple2 b2 = (Tuple2)tuple2._2();
                List<Tuple2<Object, Object>> intersection = MODULE$.intervalIntersection((Tuple2<Object, Object>)a2, (Tuple2<Object, Object>)b2);
                List differences = (List)midIntervals.foldLeft(intersection, (Function2 & Serializable & scala.Serializable)(a, b) -> MODULE$.intervalDifference((List<Tuple2<Object, Object>>)a, (Tuple2<Object, Object>)b));
                ListBuffer listBuffer = intervals2.$plus$plus$eq((TraversableOnce)differences);
                return listBuffer;
            }, ListBuffer$.MODULE$.canBuildFrom());
            dArray = this.mergeIntervals((Seq<Tuple2<Object, Object>>)intervals2);
        }
        return dArray;
    }

    public void foreachCellByPolygon(Polygon poly, RasterExtent re, Rasterizer.Options options, Function2<Object, Object, BoxedUnit> f) {
        PixelSampleType sampleType = options.sampleType();
        boolean partial = options.includePartial();
        STRtree edges = this.polygonToEdges(poly, re);
        for (int y = 0; y < re.rows(); ++y) {
            double[] rowRuns;
            PixelSampleType pixelSampleType = sampleType;
            PixelIsPoint$ pixelIsPoint$ = PixelIsPoint$.MODULE$;
            double[] dArray = !(pixelSampleType != null ? !pixelSampleType.equals(pixelIsPoint$) : pixelIsPoint$ != null) ? this.runsPoint(edges, y, re.cols()) : (rowRuns = this.runsArea(edges, y, re.cols(), partial));
            if (rowRuns.length % 2 != 0) {
                if (!poly.isValid()) {
                    throw new IllegalArgumentException("Cannot rasterize an invalid polygon");
                }
                throw new IllegalStateException(new StringBuilder(131).append("Rasterizer encountered an error: an odd number of X axis intersections encountered via a horizontal line across the raster at y = ").append(y).append(".").toString());
            }
            for (int i = 0; i < rowRuns.length; i += 2) {
                int stop = package$.MODULE$.min((int)rowRuns[i + 1], re.cols());
                for (int x = package$.MODULE$.max((int)rowRuns[i], 0); x < stop; ++x) {
                    f.apply$mcVII$sp(x, y);
                }
            }
        }
    }

    public Rasterizer.Options foreachCellByPolygon$default$3() {
        return Rasterizer$Options$.MODULE$.DEFAULT();
    }

    public static final /* synthetic */ boolean $anonfun$runsPoint$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int parity = tuple2._2$mcI$sp();
        boolean bl = parity != 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$runsPoint$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int parity = tuple2._2$mcI$sp();
        boolean bl = parity != -1;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$runsPoint$4(Map xcoordsMap$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            double xcoord = tuple2._1$mcD$sp();
            int parity = tuple2._2$mcI$sp();
            if (xcoordsMap$1.contains((Object)BoxesRunTime.boxToDouble((double)xcoord))) {
                xcoordsMap$1.update((Object)BoxesRunTime.boxToDouble((double)xcoord), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)xcoordsMap$1.apply((Object)BoxesRunTime.boxToDouble((double)xcoord))) + parity)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                xcoordsMap$1.update((Object)BoxesRunTime.boxToDouble((double)xcoord), (Object)BoxesRunTime.boxToInteger((int)parity));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$runsArea$2(Tuple4 x$15, Tuple4 x$16) {
        return BoxesRunTime.unboxToDouble((Object)x$15._1()) < BoxesRunTime.unboxToDouble((Object)x$16._1());
    }

    public static final /* synthetic */ boolean $anonfun$runsArea$4(Tuple2 x$17, Tuple2 x$18) {
        return x$17._1$mcD$sp() < x$18._1$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$runsArea$5(Tuple2 x$19, Tuple2 x$20) {
        return x$19._1$mcD$sp() < x$20._1$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$runsArea$6(Tuple2 x$21, Tuple2 x$22) {
        return x$21._1$mcD$sp() < x$22._1$mcD$sp();
    }

    private PolygonRasterizer$() {
        MODULE$ = this;
    }
}

