/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.regiongroup;

import geotrellis.raster.Connectivity;
import geotrellis.raster.FourNeighbors$;
import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.regiongroup.RegionGroupOptions;
import geotrellis.raster.regiongroup.RegionGroupOptions$;
import geotrellis.raster.regiongroup.RegionGroupResult;
import geotrellis.raster.regiongroup.RegionPartition;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class RegionGroup$ {
    public static RegionGroup$ MODULE$;

    static {
        new RegionGroup$();
    }

    public RegionGroupResult apply(Tile r, RegionGroupOptions options) {
        int regionId = -1;
        RegionPartition regions = new RegionPartition();
        Map regionMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int cols = r.cols();
        int rows = r.rows();
        IntArrayTile tile = IntArrayTile$.MODULE$.empty(cols, rows);
        boolean ignoreNoData = options.ignoreNoData();
        Connectivity connectivity = options.connectivity();
        FourNeighbors$ fourNeighbors$ = FourNeighbors$.MODULE$;
        if (!(connectivity != null ? !connectivity.equals(fourNeighbors$) : fourNeighbors$ != null)) {
            for (int index$macro$596 = 0; index$macro$596 < rows; ++index$macro$596) {
                int valueToLeft = Integer.MIN_VALUE;
                for (int index$macro$595 = 0; index$macro$595 < cols; ++index$macro$595) {
                    int v = r.get(index$macro$595, index$macro$596);
                    if (v != Integer.MIN_VALUE || !ignoreNoData) {
                        int top;
                        int n = top = index$macro$596 > 0 ? r.get(index$macro$595, index$macro$596 - 1) : v + 1;
                        if (v == top) {
                            int leftRegion;
                            int topRegion = tile.get(index$macro$595, index$macro$596 - 1);
                            tile.set(index$macro$595, index$macro$596, topRegion);
                            if (v == valueToLeft && index$macro$595 > 0 && (leftRegion = tile.get(index$macro$595 - 1, index$macro$596)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$595 - 1, index$macro$596));
                            }
                        } else if (v == valueToLeft && index$macro$595 > 0) {
                            tile.set(index$macro$595, index$macro$596, tile.get(index$macro$595 - 1, index$macro$596));
                        } else {
                            regions.add(++regionId);
                            tile.set(index$macro$595, index$macro$596, regionId);
                            regionMap.update((Object)BoxesRunTime.boxToInteger((int)regionId), (Object)BoxesRunTime.boxToInteger((int)v));
                        }
                    }
                    valueToLeft = v;
                }
            }
        } else {
            for (int index$macro$598 = 0; index$macro$598 < rows; ++index$macro$598) {
                int valueToLeft = Integer.MIN_VALUE;
                int valueToTopLeft = Integer.MIN_VALUE;
                int valueToTop = Integer.MIN_VALUE;
                for (int index$macro$597 = 0; index$macro$597 < cols; ++index$macro$597) {
                    int topRight;
                    int v = r.get(index$macro$597, index$macro$598);
                    int n = topRight = index$macro$598 > 0 && index$macro$597 < cols - 1 ? r.get(index$macro$597 + 1, index$macro$598 - 1) : v + 1;
                    if (index$macro$597 == 0) {
                        valueToTop = index$macro$598 > 0 ? r.get(index$macro$597, index$macro$598 - 1) : v + 1;
                    }
                    if (v != Integer.MIN_VALUE || !ignoreNoData) {
                        if (v == topRight) {
                            int topRegion;
                            int topLeftRegion;
                            int leftRegion;
                            int topRightRegion = tile.get(index$macro$597 + 1, index$macro$598 - 1);
                            tile.set(index$macro$597, index$macro$598, topRightRegion);
                            if (v == valueToLeft && index$macro$597 > 0 && (leftRegion = tile.get(index$macro$597 - 1, index$macro$598)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$597 - 1, index$macro$598));
                            }
                            if (v == valueToTopLeft && index$macro$597 > 0 && index$macro$598 > 0 && (topLeftRegion = tile.get(index$macro$597 - 1, index$macro$598 - 1)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$597 - 1, index$macro$598 - 1));
                            }
                            if (v == valueToTop && index$macro$598 > 0 && (topRegion = tile.get(index$macro$597, index$macro$598 - 1)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$597, index$macro$598 - 1));
                            }
                        } else if (v == valueToTop) {
                            int topLeftRegion;
                            int leftRegion;
                            int topRegion = tile.get(index$macro$597, index$macro$598 - 1);
                            tile.set(index$macro$597, index$macro$598, topRegion);
                            if (v == valueToLeft && index$macro$597 > 0 && (leftRegion = tile.get(index$macro$597 - 1, index$macro$598)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$597 - 1, index$macro$598));
                            }
                            if (v == valueToTopLeft && index$macro$597 > 0 && index$macro$598 > 0 && (topLeftRegion = tile.get(index$macro$597 - 1, index$macro$598 - 1)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$597 - 1, index$macro$598 - 1));
                            }
                        } else if (v == valueToLeft && index$macro$597 > 0) {
                            int topLeftRegion;
                            int westRegion = tile.get(index$macro$597 - 1, index$macro$598);
                            tile.set(index$macro$597, index$macro$598, westRegion);
                            if (v == valueToTopLeft && index$macro$597 > 0 && index$macro$598 > 0 && (topLeftRegion = tile.get(index$macro$597 - 1, index$macro$598 - 1)) != westRegion) {
                                regions.add(westRegion, tile.get(index$macro$597 - 1, index$macro$598 - 1));
                            }
                        } else if (v == valueToTopLeft && index$macro$597 > 0 && index$macro$598 > 0) {
                            tile.set(index$macro$597, index$macro$598, tile.get(index$macro$597 - 1, index$macro$598 - 1));
                        } else {
                            regions.add(++regionId);
                            tile.set(index$macro$597, index$macro$598, regionId);
                            regionMap.update((Object)BoxesRunTime.boxToInteger((int)regionId), (Object)BoxesRunTime.boxToInteger((int)v));
                        }
                    }
                    valueToLeft = v;
                    valueToTopLeft = valueToTop;
                    valueToTop = topRight;
                }
            }
        }
        for (int index$macro$600 = 0; index$macro$600 < rows; ++index$macro$600) {
            for (int index$macro$599 = 0; index$macro$599 < cols; ++index$macro$599) {
                BoxedUnit boxedUnit;
                int v = tile.get(index$macro$599, index$macro$600);
                if (v == Integer.MIN_VALUE && ignoreNoData) continue;
                int cls = regions.getClass(v);
                if (cls != v && regionMap.contains((Object)BoxesRunTime.boxToInteger((int)v))) {
                    if (!regionMap.contains((Object)BoxesRunTime.boxToInteger((int)cls))) {
                        throw package$.MODULE$.error(new StringBuilder(43).append("Region map should contain class identifier ").append(cls).toString());
                    }
                    boxedUnit = regionMap.remove((Object)BoxesRunTime.boxToInteger((int)v));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                tile.set(index$macro$599, index$macro$600, regions.getClass(v));
            }
        }
        return new RegionGroupResult(tile, (scala.collection.immutable.Map<Object, Object>)regionMap.toMap(Predef$.MODULE$.$conforms()));
    }

    public RegionGroupOptions apply$default$2() {
        return RegionGroupOptions$.MODULE$.default();
    }

    private RegionGroup$() {
        MODULE$ = this;
    }
}

