/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.render.png;

import geotrellis.raster.Tile;
import geotrellis.raster.render.png.Chunk;
import geotrellis.raster.render.png.Filter;
import geotrellis.raster.render.png.GreyPngEncoding;
import geotrellis.raster.render.png.IndexedPngEncoding;
import geotrellis.raster.render.png.NoFilter$;
import geotrellis.raster.render.png.PaethFilter$;
import geotrellis.raster.render.png.PngColorEncoding;
import geotrellis.raster.render.png.PngEncoder$;
import geotrellis.raster.render.png.RgbPngEncoding;
import geotrellis.raster.render.png.Settings;
import geotrellis.raster.render.png.Util$;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0001\u0003\u0001.\u0011!\u0002\u00158h\u000b:\u001cw\u000eZ3s\u0015\t\u0019A!A\u0002q]\u001eT!!\u0002\u0004\u0002\rI,g\u000eZ3s\u0015\t9\u0001\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M!\u0001\u0001\u0004\n\u0016!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u0011QbE\u0005\u0003)9\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u000e-%\u0011qC\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t3\u0001\u0011)\u001a!C\u00015\u0005A1/\u001a;uS:<7/F\u0001\u001c!\taR$D\u0001\u0003\u0013\tq\"A\u0001\u0005TKR$\u0018N\\4t\u0011!\u0001\u0003A!E!\u0002\u0013Y\u0012!C:fiRLgnZ:!\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011A%\n\t\u00039\u0001AQ!G\u0011A\u0002mAqa\n\u0001C\u0002\u0013\u0015\u0001&A\u0005T\u0013\u001es\u0015\tV+S\u000bV\t\u0011\u0006E\u0002\u000eU1J!a\u000b\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00055i\u0013B\u0001\u0018\u000f\u0005\u0011\u0011\u0015\u0010^3\t\rA\u0002\u0001\u0015!\u0004*\u0003)\u0019\u0016j\u0012(B)V\u0013V\t\t\u0005\be\u0001\u0011\r\u0011\"\u00024\u0003\u0011I\u0005\n\u0012*\u0016\u0003Q\u0002\"!D\u001b\n\u0005Yr!aA%oi\"1\u0001\b\u0001Q\u0001\u000eQ\nQ!\u0013%E%\u0002BqA\u000f\u0001C\u0002\u0013\u00151'\u0001\u0003C\u0017\u001e#\u0005B\u0002\u001f\u0001A\u00035A'A\u0003C\u0017\u001e#\u0005\u0005C\u0004?\u0001\t\u0007IQA\u001a\u0002\tAcE+\u0012\u0005\u0007\u0001\u0002\u0001\u000bQ\u0002\u001b\u0002\u000bAcE+\u0012\u0011\t\u000f\t\u0003!\u0019!C\u0003g\u0005!AK\u0015(T\u0011\u0019!\u0005\u0001)A\u0007i\u0005)AK\u0015(TA!9a\t\u0001b\u0001\n\u000b\u0019\u0014\u0001B%E\u0003RCa\u0001\u0013\u0001!\u0002\u001b!\u0014!B%E\u0003R\u0003\u0003b\u0002&\u0001\u0005\u0004%)aM\u0001\u0005\u0013\u0016sE\t\u0003\u0004M\u0001\u0001\u0006i\u0001N\u0001\u0006\u0013\u0016sE\t\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0002P\u0003\u00191\u0015\n\u0014+F%V\tA\u0006\u0003\u0004R\u0001\u0001\u0006i\u0001L\u0001\b\r&cE+\u0012*!\u0011\u001d\u0019\u0006A1A\u0005\u0006M\nQ\u0001R#Q)\"Ca!\u0016\u0001!\u0002\u001b!\u0014A\u0002#F!RC\u0005\u0005C\u0004X\u0001\t\u0007IQA\u001a\u0002\u000bMC\u0015J\u0012+\t\re\u0003\u0001\u0015!\u00045\u0003\u0019\u0019\u0006*\u0013$UA!)1\f\u0001C\u00019\u0006YqO]5uK\"+\u0017\rZ3s)\ri\u0006M\u001b\t\u0003\u001byK!a\u0018\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Cj\u0003\rAY\u0001\u0004I>\u001c\bCA2i\u001b\u0005!'BA3g\u0003\tIwNC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011\u00159!\f1\u0001l!\taW.D\u0001\u0007\u0013\tqgA\u0001\u0003US2,\u0007\"\u00029\u0001\t\u0003\t\u0018aE<sSR,')Y2lOJ|WO\u001c3J]\u001a|GCA/s\u0011\u0015\tw\u000e1\u0001c\u0011\u0015!\b\u0001\"\u0001v\u0003A\u0019'/Z1uK\nKH/\u001a\"vM\u001a,'\u000f\u0006\u0002wyB\u0011qO_\u0007\u0002q*\u0011\u0011PZ\u0001\u0004]&|\u0017BA>y\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006\u000fM\u0004\ra\u001b\u0005\u0006}\u0002!\ta`\u0001\u000foJLG/\u001a)jq\u0016dG)\u0019;b)\u0015i\u0016\u0011AA\u0002\u0011\u0015\tW\u00101\u0001c\u0011\u00159Q\u00101\u0001l\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tac\u001e:ji\u0016\u0004\u0016\u000e_3m\t\u0006$\u0018MT8GS2$XM\u001d\u000b\u0006;\u0006-\u0011Q\u0002\u0005\u0007C\u0006\u0015\u0001\u0019\u00012\t\r\u001d\t)\u00011\u0001l\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\t1c\u001e:ji\u0016\u0004\u0016\u000e_3m\t\u0006$\u0018\rU1fi\"$R!XA\u000b\u0003/Aa!YA\b\u0001\u0004\u0011\u0007BB\u0004\u0002\u0010\u0001\u00071\u000eC\u0004\u0002\u001c\u0001!\t!!\b\u0002\u0011]\u0014\u0018\u000e^3F]\u0012$2!XA\u0010\u0011\u0019\t\u0017\u0011\u0004a\u0001E\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012!E<sSR,w*\u001e;qkR\u001cFO]3b[R)Q,a\n\u00022!A\u0011\u0011FA\u0011\u0001\u0004\tY#\u0001\u0002pgB\u00191-!\f\n\u0007\u0005=BM\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\b\u0003C\u0001\ra\u001b\u0005\b\u0003k\u0001A\u0011AA\u001c\u000399(/\u001b;f\u0005f$X-\u0011:sCf$2!KA\u001d\u0011\u00199\u00111\u0007a\u0001W\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012!C<sSR,\u0007+\u0019;i)\u0015i\u0016\u0011IA.\u0011!\t\u0019%a\u000fA\u0002\u0005\u0015\u0013\u0001\u00029bi\"\u0004B!a\u0012\u0002V9!\u0011\u0011JA)!\r\tYED\u0007\u0003\u0003\u001bR1!a\u0014\u000b\u0003\u0019a$o\\8u}%\u0019\u00111\u000b\b\u0002\rA\u0013X\rZ3g\u0013\u0011\t9&!\u0017\u0003\rM#(/\u001b8h\u0015\r\t\u0019F\u0004\u0005\u0007\u000f\u0005m\u0002\u0019A6\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0014\u0001B2paf$2\u0001JA2\u0011!I\u0012Q\fI\u0001\u0002\u0004Y\u0002\"CA4\u0001E\u0005I\u0011AA5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001b+\u0007m\tig\u000b\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C;oG\",7m[3e\u0015\r\tIHD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\t\tAA\u0001\n\u0003\n\u0019)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000b\u0003B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u00173\u0017\u0001\u00027b]\u001eLA!a\u0016\u0002\n\"A\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u00051'\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002\u0016\u0002\t\t\u0011\"\u0001\u0002\u0018\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAM\u0003?\u00032!DAN\u0013\r\tiJ\u0004\u0002\u0004\u0003:L\b\"CAQ\u0003'\u000b\t\u00111\u00015\u0003\rAH%\r\u0005\n\u0003K\u0003\u0011\u0011!C!\u0003O\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0003b!a+\u00022\u0006eUBAAW\u0015\r\tyKD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAZ\u0003[\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003o\u0003\u0011\u0011!C\u0001\u0003s\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003w\u000b\t\rE\u0002\u000e\u0003{K1!a0\u000f\u0005\u001d\u0011un\u001c7fC:D!\"!)\u00026\u0006\u0005\t\u0019AAM\u0011%\t)\rAA\u0001\n\u0003\n9-\u0001\u0005iCND7i\u001c3f)\u0005!\u0004\"CAf\u0001\u0005\u0005I\u0011IAg\u0003!!xn\u0015;sS:<GCAAC\u0011%\t\t\u000eAA\u0001\n\u0003\n\u0019.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003w\u000b)\u000e\u0003\u0006\u0002\"\u0006=\u0017\u0011!a\u0001\u00033;\u0011\"!7\u0003\u0003\u0003E\t!a7\u0002\u0015Asw-\u00128d_\u0012,'\u000fE\u0002\u001d\u0003;4\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011q\\\n\u0006\u0003;\f\t/\u0006\t\u0007\u0003G\fIo\u0007\u0013\u000e\u0005\u0005\u0015(bAAt\u001d\u00059!/\u001e8uS6,\u0017\u0002BAv\u0003K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82\u0011\u001d\u0011\u0013Q\u001cC\u0001\u0003_$\"!a7\t\u0015\u0005-\u0017Q\\A\u0001\n\u000b\ni\r\u0003\u0006\u0002v\u0006u\u0017\u0011!CA\u0003o\fQ!\u00199qYf$2\u0001JA}\u0011\u0019I\u00121\u001fa\u00017!Q\u0011Q`Ao\u0003\u0003%\t)a@\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0001B\u0004!\u0011i!1A\u000e\n\u0007\t\u0015aB\u0001\u0004PaRLwN\u001c\u0005\n\u0005\u0013\tY0!AA\u0002\u0011\n1\u0001\u001f\u00131\u0011)\u0011i!!8\u0002\u0002\u0013%!qB\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0012A!\u0011q\u0011B\n\u0013\u0011\u0011)\"!#\u0003\r=\u0013'.Z2u\u0001")
public class PngEncoder
implements Product,
scala.Serializable {
    private final Settings settings;
    private final byte[] SIGNATURE;
    private final int IHDR;
    private final int BKGD;
    private final int PLTE;
    private final int TRNS;
    private final int IDAT;
    private final int IEND;
    private final byte FILTER;
    private final int DEPTH;
    private final int SHIFT;

    public static /* bridge */ Object apply(Object object) {
        return PngEncoder$.MODULE$.apply(object);
    }

    public static Option<Settings> unapply(PngEncoder pngEncoder) {
        return PngEncoder$.MODULE$.unapply(pngEncoder);
    }

    public static PngEncoder apply(Settings settings) {
        return PngEncoder$.MODULE$.apply(settings);
    }

    public static <A> Function1<Settings, A> andThen(Function1<PngEncoder, A> function1) {
        return PngEncoder$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PngEncoder> compose(Function1<A, Settings> function1) {
        return PngEncoder$.MODULE$.compose(function1);
    }

    public Settings settings() {
        return this.settings;
    }

    public final byte[] SIGNATURE() {
        return this.SIGNATURE;
    }

    public final int IHDR() {
        return this.IHDR;
    }

    public final int BKGD() {
        return this.BKGD;
    }

    public final int PLTE() {
        return this.PLTE;
    }

    public final int TRNS() {
        return this.TRNS;
    }

    public final int IDAT() {
        return this.IDAT;
    }

    public final int IEND() {
        return this.IEND;
    }

    public final byte FILTER() {
        return this.FILTER;
    }

    public final int DEPTH() {
        return this.DEPTH;
    }

    public final int SHIFT() {
        return this.SHIFT;
    }

    public void writeHeader(DataOutputStream dos, Tile raster) {
        int width = raster.cols();
        int height = raster.rows();
        dos.write(this.SIGNATURE());
        Chunk cIHDR = new Chunk(this.IHDR());
        cIHDR.writeInt(width);
        cIHDR.writeInt(height);
        cIHDR.writeByte((byte)8);
        cIHDR.writeByte(this.settings().colorType().n());
        cIHDR.writeByte((byte)0);
        cIHDR.writeByte((byte)0);
        cIHDR.writeByte((byte)0);
        cIHDR.writeTo(dos);
    }

    public void writeBackgroundInfo(DataOutputStream dos) {
        RgbPngEncoding rgbPngEncoding;
        Option<Object> option;
        GreyPngEncoding greyPngEncoding;
        Option<Object> option2;
        PngColorEncoding pngColorEncoding = this.settings().colorType();
        if (pngColorEncoding instanceof GreyPngEncoding && (option2 = (greyPngEncoding = (GreyPngEncoding)pngColorEncoding).transparent()) instanceof Some) {
            Some some = (Some)option2;
            int ndColor = BoxesRunTime.unboxToInt((Object)some.value());
            Chunk cTRNS = new Chunk(this.TRNS());
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 8));
            cTRNS.writeTo(dos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pngColorEncoding instanceof RgbPngEncoding && (option = (rgbPngEncoding = (RgbPngEncoding)pngColorEncoding).transparent()) instanceof Some) {
            Some some = (Some)option;
            int ndColor = BoxesRunTime.unboxToInt((Object)some.value());
            Chunk cTRNS = new Chunk(this.TRNS());
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 24));
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 16));
            cTRNS.writeByte((byte)0);
            cTRNS.writeByte(Util$.MODULE$.shift(ndColor, 8));
            cTRNS.writeTo(dos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pngColorEncoding instanceof IndexedPngEncoding) {
            IndexedPngEncoding indexedPngEncoding = (IndexedPngEncoding)pngColorEncoding;
            int[] rgbs = indexedPngEncoding.rgbs();
            int[] alphas = indexedPngEncoding.as();
            Chunk cPLTE = new Chunk(this.PLTE());
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rgbs)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)rgb -> {
                cPLTE.writeByte(Util$.MODULE$.shift(rgb, 16));
                cPLTE.writeByte(Util$.MODULE$.shift(rgb, 8));
                cPLTE.writeByte(Util$.MODULE$.byte(rgb));
            });
            cPLTE.writeTo(dos);
            Chunk cTRNS = new Chunk(this.TRNS());
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(alphas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)a -> cTRNS.writeByte(Util$.MODULE$.byte(a)));
            cTRNS.writeTo(dos);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ByteBuffer createByteBuffer(Tile raster) {
        int size = raster.size();
        int[] data = raster.toArray();
        ByteBuffer bb = ByteBuffer.allocate(size * this.DEPTH());
        if (this.DEPTH() == 4) {
            Util$.MODULE$.initByteBuffer32(bb, data, size);
        } else if (this.DEPTH() == 3) {
            Util$.MODULE$.initByteBuffer24(bb, data, size);
        } else if (this.DEPTH() == 2) {
            Util$.MODULE$.initByteBuffer16(bb, data, size);
        } else if (this.DEPTH() == 1) {
            Util$.MODULE$.initByteBuffer8(bb, data, size);
        } else {
            throw package$.MODULE$.error(new StringBuilder(19).append("unsupported depth: ").append(this.DEPTH()).toString());
        }
        return bb;
    }

    public void writePixelData(DataOutputStream dos, Tile raster) {
        Filter filter = this.settings().filter();
        if (PaethFilter$.MODULE$.equals(filter)) {
            this.writePixelDataPaeth(dos, raster);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NoFilter$.MODULE$.equals(filter)) {
            this.writePixelDataNoFilter(dos, raster);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw package$.MODULE$.error("filter %s not supported");
        }
    }

    public void writePixelDataNoFilter(DataOutputStream dos, Tile raster) {
        int cols = raster.cols();
        int size = cols * raster.rows();
        Chunk cIDAT = new Chunk(this.IDAT());
        ByteBuffer bb = this.createByteBuffer(raster);
        DeflaterOutputStream dfos = new DeflaterOutputStream((OutputStream)cIDAT.cos(), new Deflater(1));
        int byteWidth = cols * this.DEPTH();
        byte[] currLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        for (int yspan = 0; yspan < size; yspan += cols) {
            bb.position(yspan * this.DEPTH());
            bb.get(currLine);
            dfos.write(this.FILTER());
            dfos.write(currLine);
        }
        dfos.finish();
        cIDAT.writeTo(dos);
    }

    public void writePixelDataPaeth(DataOutputStream dos, Tile raster) {
        int cols = raster.cols();
        int size = cols * raster.rows();
        Chunk cIDAT = new Chunk(this.IDAT());
        int j = 0;
        ByteBuffer bb = this.createByteBuffer(raster);
        DeflaterOutputStream dfos = new DeflaterOutputStream((OutputStream)cIDAT.cos(), new Deflater(1));
        int byteWidth = cols * this.DEPTH();
        byte[] lineOut = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] prevLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] currLine = (byte[])Array$.MODULE$.ofDim(byteWidth, ClassTag$.MODULE$.Byte());
        byte[] tmp = null;
        for (int yspan = 0; yspan < size; yspan += cols) {
            bb.position(yspan * this.DEPTH());
            bb.get(currLine);
            for (j = 0; j < this.DEPTH(); ++j) {
                lineOut[j] = Util$.MODULE$.byte(currLine[j] - prevLine[j]);
            }
            while (j < byteWidth) {
                int a = currLine[j - this.DEPTH()] & 0xFF;
                int b = prevLine[j] & 0xFF;
                int c = prevLine[j - this.DEPTH()] & 0xFF;
                int pa = b - c;
                int pb = a - c;
                int pc = pa + pb;
                if (pa < 0) {
                    pa = -pa;
                }
                if (pb < 0) {
                    pb = -pb;
                }
                if (pc < 0) {
                    pc = -pc;
                }
                if (pa <= pb && pa <= pc) {
                    c = a;
                } else if (pb <= pc) {
                    c = b;
                }
                lineOut[j] = Util$.MODULE$.byte(currLine[j] - c);
                ++j;
            }
            dfos.write(this.FILTER());
            dfos.write(lineOut);
            tmp = prevLine;
            prevLine = currLine;
            currLine = tmp;
        }
        dfos.finish();
        cIDAT.writeTo(dos);
    }

    public void writeEnd(DataOutputStream dos) {
        Chunk cIEND = new Chunk(this.IEND());
        cIEND.writeTo(dos);
    }

    public void writeOutputStream(OutputStream os, Tile raster) {
        DataOutputStream dos = new DataOutputStream(os);
        this.writeHeader(dos, raster);
        this.writeBackgroundInfo(dos);
        this.writePixelData(dos, raster);
        this.writeEnd(dos);
        dos.flush();
    }

    public byte[] writeByteArray(Tile raster) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeOutputStream(baos, raster);
        return baos.toByteArray();
    }

    public void writePath(String path, Tile raster) {
        FileOutputStream fos = new FileOutputStream(new File(path));
        this.writeOutputStream(fos, raster);
        fos.close();
    }

    public PngEncoder copy(Settings settings) {
        return new PngEncoder(settings);
    }

    public Settings copy$default$1() {
        return this.settings();
    }

    public String productPrefix() {
        return "PngEncoder";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.settings();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PngEncoder;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PngEncoder)) return false;
        boolean bl = true;
        if (!bl) return false;
        PngEncoder pngEncoder = (PngEncoder)x$1;
        Settings settings = this.settings();
        Settings settings2 = pngEncoder.settings();
        if (settings == null) {
            if (settings2 != null) {
                return false;
            }
        } else if (!((Object)settings).equals(settings2)) return false;
        if (!pngEncoder.canEqual(this)) return false;
        return true;
    }

    public PngEncoder(Settings settings) {
        this.settings = settings;
        Product.$init$((Product)this);
        this.SIGNATURE = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)137, 80, 78, 71, 13, 10, 26, 10}), ClassTag$.MODULE$.Byte());
        this.IHDR = 1229472850;
        this.BKGD = 1649100612;
        this.PLTE = 1347179589;
        this.TRNS = 1951551059;
        this.IDAT = 1229209940;
        this.IEND = 1229278788;
        this.FILTER = settings.filter().n();
        this.DEPTH = settings.colorType().depth();
        this.SHIFT = (this.DEPTH() - 1) * 8;
    }
}

