/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.Resample;
import geotrellis.vector.Extent;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0002\u0002%\u0011\u0011#Q4he\u0016<\u0017\r^3SKN\fW\u000e\u001d7f\u0015\t\u0019A!\u0001\u0005sKN\fW\u000e\u001d7f\u0015\t)a!\u0001\u0004sCN$XM\u001d\u0006\u0002\u000f\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00171i\u0011AA\u0005\u0003\u001b\t\u0011\u0001BU3tC6\u0004H.\u001a\u0005\t\u001f\u0001\u0011\t\u0011)A\u0005!\u0005!A/\u001b7f!\t\t\"#D\u0001\u0005\u0013\t\u0019BA\u0001\u0003US2,\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\r\u0015DH/\u001a8u!\t9\"$D\u0001\u0019\u0015\tIb!\u0001\u0004wK\u000e$xN]\u0005\u00037a\u0011a!\u0012=uK:$\b\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0011Q\f'oZ3u\u0007N\u0003\"!E\u0010\n\u0005\u0001\"!\u0001C\"fY2\u001c\u0016N_3\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\u0011!SEJ\u0014\u0011\u0005-\u0001\u0001\"B\b\"\u0001\u0004\u0001\u0002\"B\u000b\"\u0001\u00041\u0002\"B\u000f\"\u0001\u0004q\u0002bB\u0015\u0001\u0005\u0004%\tAK\u0001\rgJ\u001c7)\u001a7m/&$G\u000f[\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1Ai\\;cY\u0016DaA\r\u0001!\u0002\u0013Y\u0013!D:sG\u000e+G\u000e\\,jIRD\u0007\u0005C\u00045\u0001\t\u0007I\u0011\u0001\u0016\u0002\u001bM\u00148mQ3mY\"+\u0017n\u001a5u\u0011\u00191\u0004\u0001)A\u0005W\u0005q1O]2DK2d\u0007*Z5hQR\u0004\u0003b\u0002\u001d\u0001\u0005\u0004%\tAK\u0001\u0011Q\u0006dgm\u0015:d\u0007\u0016dGnV5ei\"DaA\u000f\u0001!\u0002\u0013Y\u0013!\u00055bY\u001a\u001c&oY\"fY2<\u0016\u000e\u001a;iA!9A\b\u0001b\u0001\n\u0003Q\u0013!\u00055bY\u001a\u001c&oY\"fY2DU-[4ii\"1a\b\u0001Q\u0001\n-\n!\u0003[1mMN\u00138mQ3mY\"+\u0017n\u001a5uA!9\u0001\t\u0001b\u0001\n\u0003Q\u0013a\u00045bY\u001a$\u0016M]4fi^KG\r\u001e5\t\r\t\u0003\u0001\u0015!\u0003,\u0003AA\u0017\r\u001c4UCJ<W\r^,jIRD\u0007\u0005C\u0004E\u0001\t\u0007I\u0011\u0001\u0016\u0002!!\fGN\u001a+be\u001e,G\u000fS3jO\"$\bB\u0002$\u0001A\u0003%1&A\tiC24G+\u0019:hKRDU-[4ii\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000b\u0001\u0002_%oI&\u001cWm\u001d\u000b\u0003\u0015B\u0003B\u0001L&N\u001b&\u0011A*\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00051r\u0015BA(.\u0005\rIe\u000e\u001e\u0005\u0006#\u001e\u0003\raK\u0001\u0002q\")1\u000b\u0001C\u0001)\u0006A\u00110\u00138eS\u000e,7\u000f\u0006\u0002K+\")aK\u0015a\u0001W\u0005\t\u0011\u0010C\u0003Y\u0001\u0011\u0005\u0011,A\u0007d_:$(/\u001b2vi&|gn\u001d\u000b\u00045\u001a<\u0007cA.d\u0015:\u0011A,\u0019\b\u0003;\u0002l\u0011A\u0018\u0006\u0003?\"\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u0005\tl\u0013a\u00029bG.\fw-Z\u0005\u0003I\u0016\u00141aU3r\u0015\t\u0011W\u0006C\u0003R/\u0002\u00071\u0006C\u0003W/\u0002\u00071\u0006")
public abstract class AggregateResample
extends Resample {
    private final Tile tile;
    private final Extent extent;
    private final double srcCellWidth;
    private final double srcCellHeight;
    private final double halfSrcCellWidth;
    private final double halfSrcCellHeight;
    private final double halfTargetWidth;
    private final double halfTargetHeight;

    public double srcCellWidth() {
        return this.srcCellWidth;
    }

    public double srcCellHeight() {
        return this.srcCellHeight;
    }

    public double halfSrcCellWidth() {
        return this.halfSrcCellWidth;
    }

    public double halfSrcCellHeight() {
        return this.halfSrcCellHeight;
    }

    public double halfTargetWidth() {
        return this.halfTargetWidth;
    }

    public double halfTargetHeight() {
        return this.halfTargetHeight;
    }

    public Tuple2<Object, Object> xIndices(double x) {
        double dLeftX = x - this.extent.xmin() - this.halfSrcCellWidth();
        double dLeftCellLeft = dLeftX - this.halfTargetWidth();
        double dLeftCellRight = dLeftX + this.halfTargetWidth();
        int leftIndex = dLeftCellLeft > 0.0 ? (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(dLeftCellLeft / this.srcCellWidth())) : 0;
        int rightIndex = dLeftCellRight < this.extent.width() ? (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(dLeftCellRight / this.srcCellWidth())) : this.tile.cols() - 1;
        return new Tuple2.mcII.sp(leftIndex, rightIndex);
    }

    public Tuple2<Object, Object> yIndices(double y) {
        double dTopY = this.extent.ymax() - y - this.halfSrcCellHeight();
        double dTopCellTop = dTopY - this.halfTargetHeight();
        double dTopCellBottom = dTopY + this.halfTargetHeight();
        int topIndex = dTopCellTop > 0.0 ? (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(dTopCellTop / this.srcCellHeight())) : 0;
        int bottomIndex = dTopCellBottom < this.extent.height() ? (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(dTopCellBottom / this.srcCellHeight())) : this.tile.rows() - 1;
        return new Tuple2.mcII.sp(topIndex, bottomIndex);
    }

    public Seq<Tuple2<Object, Object>> contributions(double x, double y) {
        Tuple2<Object, Object> tuple2 = this.xIndices(x);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int xLow = tuple2._1$mcI$sp();
        int xHigh = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(xLow, xHigh);
        Tuple2.mcII.sp sp3 = sp2;
        int xLow2 = sp3._1$mcI$sp();
        int xHigh2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = this.yIndices(y);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int yLow = tuple22._1$mcI$sp();
        int yHigh = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(yLow, yHigh);
        Tuple2.mcII.sp sp5 = sp4;
        int yLow2 = sp5._1$mcI$sp();
        int yHigh2 = sp5._2$mcI$sp();
        return xLow2 > xHigh2 || yLow2 > yHigh2 ? (Seq)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$) : (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(xLow2), xHigh2).flatMap((Function1 & java.io.Serializable & Serializable)xs -> AggregateResample.$anonfun$contributions$1(yLow2, yHigh2, BoxesRunTime.unboxToInt((Object)xs)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$contributions$2(int xs$1, int ys) {
        return new Tuple2.mcII.sp(xs$1, ys);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$contributions$1(int yLow$1, int yHigh$1, int xs) {
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(yLow$1), yHigh$1).map((Function1 & java.io.Serializable & Serializable)ys -> AggregateResample.$anonfun$contributions$2(xs, BoxesRunTime.unboxToInt((Object)ys)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AggregateResample(Tile tile, Extent extent, CellSize targetCS) {
        this.tile = tile;
        this.extent = extent;
        super(tile, extent);
        this.srcCellWidth = extent.width() / (double)tile.cols();
        this.srcCellHeight = extent.height() / (double)tile.rows();
        this.halfSrcCellWidth = this.srcCellWidth() / (double)2;
        this.halfSrcCellHeight = this.srcCellHeight() / (double)2;
        this.halfTargetWidth = targetCS.width() / (double)2;
        this.halfTargetHeight = targetCS.height() / (double)2;
    }
}

