/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.AggregateResample;
import geotrellis.vector.Extent;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u0013\ty\u0011I^3sC\u001e,'+Z:b[BdWM\u0003\u0002\u0004\t\u0005A!/Z:b[BdWM\u0003\u0002\u0006\r\u00051!/Y:uKJT\u0011aB\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0003\u0001)\u0001\"a\u0003\u0007\u000e\u0003\tI!!\u0004\u0002\u0003#\u0005;wM]3hCR,'+Z:b[BdW\r\u0003\u0005\u0010\u0001\t\u0005\t\u0015!\u0003\u0011\u0003\u0011!\u0018\u000e\\3\u0011\u0005E\u0011R\"\u0001\u0003\n\u0005M!!\u0001\u0002+jY\u0016D\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0007Kb$XM\u001c;\u0011\u0005]QR\"\u0001\r\u000b\u0005e1\u0011A\u0002<fGR|'/\u0003\u0002\u001c1\t1Q\t\u001f;f]RD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\ti\u0006\u0014x-\u001a;D'B\u0011\u0011cH\u0005\u0003A\u0011\u0011\u0001bQ3mYNK'0\u001a\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0011*ce\n\t\u0003\u0017\u0001AQaD\u0011A\u0002AAQ!F\u0011A\u0002YAQ!H\u0011A\u0002yAQ!\u000b\u0001\u0005\n)\n\u0001cY1mGVd\u0017\r^3Bm\u0016\u0014\u0018mZ3\u0015\u0005-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#A\u0002#pk\ndW\rC\u00033Q\u0001\u00071'A\u0004j]\u0012L7-Z:\u0011\u0007QbtH\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001\bC\u0001\u0007yI|w\u000e\u001e \n\u00039J!aO\u0017\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\u0004'\u0016\f(BA\u001e.!\u0011a\u0003I\u0011\"\n\u0005\u0005k#A\u0002+va2,'\u0007\u0005\u0002-\u0007&\u0011A)\f\u0002\u0004\u0013:$\b\"\u0002$\u0001\t\u00039\u0015!\u0004:fg\u0006l\u0007\u000f\\3WC2LG\rF\u0002C\u0011*CQ!S#A\u0002-\n\u0011\u0001\u001f\u0005\u0006\u0017\u0016\u0003\raK\u0001\u0002s\")Q\n\u0001C\u0001\u001d\u0006\u0019\"/Z:b[BdW\rR8vE2,g+\u00197jIR\u00191f\u0014)\t\u000b%c\u0005\u0019A\u0016\t\u000b-c\u0005\u0019A\u0016")
public class AverageResample
extends AggregateResample {
    private final Tile tile;

    private double calculateAverage(Seq<Tuple2<Object, Object>> indices) {
        Tuple2 tuple2 = (Tuple2)indices.foldLeft((Object)new Tuple2.mcDI.sp(0.0, 0), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2 coords;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    coords = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double sum = tuple2._1$mcD$sp();
            int count = tuple2._2$mcI$sp();
            double v = $this.tile.getDouble(coords._1$mcI$sp(), coords._2$mcI$sp());
            Tuple2.mcDI.sp sp2 = !Double.isNaN(v) ? new Tuple2.mcDI.sp(sum + v, count + 1) : new Tuple2.mcDI.sp(sum, count);
            return sp2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double sum = tuple2._1$mcD$sp();
        int count = tuple2._2$mcI$sp();
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(sum, count);
        Tuple2.mcDI.sp sp3 = sp2;
        double sum2 = sp3._1$mcD$sp();
        int count2 = sp3._2$mcI$sp();
        return count2 > 0 ? sum2 / (double)count2 : Double.NaN;
    }

    @Override
    public int resampleValid(double x, double y) {
        double doubleAvg = this.calculateAverage(this.contributions(x, y));
        return !Double.isNaN(doubleAvg) ? (int)doubleAvg : Integer.MIN_VALUE;
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        return this.calculateAverage(this.contributions(x, y));
    }

    public AverageResample(Tile tile, Extent extent, CellSize targetCS) {
        this.tile = tile;
        super(tile, extent, targetCS);
    }
}

