/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DoubleConstantNoDataArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.BilinearResample;
import geotrellis.vector.Extent;
import scala.Array$;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple4;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00114Q!\u0001\u0002\u0002\u0002%\u0011QbQ;cS\u000e\u0014Vm]1na2,'BA\u0002\u0005\u0003!\u0011Xm]1na2,'BA\u0003\u0007\u0003\u0019\u0011\u0018m\u001d;fe*\tq!\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111\u0002D\u0007\u0002\u0005%\u0011QB\u0001\u0002\u0011\u0005&d\u0017N\\3beJ+7/Y7qY\u0016D\u0001b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u0001\u0005i&dW\r\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\t!A+\u001b7f\u0011!)\u0002A!A!\u0002\u00131\u0012AB3yi\u0016tG\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\r\u00051a/Z2u_JL!a\u0007\r\u0003\r\u0015CH/\u001a8u\u0011!i\u0002A!A!\u0002\u0013q\u0012!\u00033j[\u0016t7/[8o!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\rIe\u000e\u001e\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dB\u0013F\u000b\t\u0003\u0017\u0001AQa\u0004\u0013A\u0002AAQ!\u0006\u0013A\u0002YAQ!\b\u0013A\u0002yAq\u0001\f\u0001C\u0002\u0013%Q&A\u0005dk\nL7\rV5mKV\ta\u0006\u0005\u0002\u0012_%\u0011\u0001\u0007\u0002\u0002\u001e\t>,(\r\\3D_:\u001cH/\u00198u\u001d>$\u0015\r^1BeJ\f\u0017\u0010V5mK\"1!\u0007\u0001Q\u0001\n9\n!bY;cS\u000e$\u0016\u000e\\3!\u0011\u0015!\u0004A\"\u00056\u00035\u0019WOY5d%\u0016\u001c\u0018-\u001c9mKR!a'O\u001e>!\tyr'\u0003\u00029A\t1Ai\\;cY\u0016DQAO\u001aA\u0002A\t\u0011\u0001\u001e\u0005\u0006yM\u0002\rAN\u0001\u0002q\")ah\ra\u0001m\u0005\t\u0011\u0010C\u0003A\u0001\u0011%\u0011)\u0001\btKR\u001cUOY5d-\u0006dW/Z:\u0015\t\t+u)\u0013\t\u0003?\rK!\u0001\u0012\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r~\u0002\rAH\u0001\bY\u00164GoQ8m\u0011\u0015Au\b1\u0001\u001f\u0003\u0019!x\u000e\u001d*po\")!j\u0010a\u0001\u0017\u0006\ta\rE\u0003 \u0019zqb'\u0003\u0002NA\tIa)\u001e8di&|gN\r\u0005\u0006\u001f\u0002!I\u0001U\u0001\u0007O\u0016$H/\u001a:\u0015\u0007y\t6\u000bC\u0003S\u001d\u0002\u0007a$A\u0002d_2DQ\u0001\u0016(A\u0002y\t1A]8x\u0011\u00151\u0006\u0001\"\u0003X\u000319W\r\u001e;fe\u0012{WO\u00197f)\r1\u0004,\u0017\u0005\u0006%V\u0003\rA\b\u0005\u0006)V\u0003\rA\b\u0005\u00067\u0002!\t\u0005X\u0001\u000ee\u0016\u001c\u0018-\u001c9mKZ\u000bG.\u001b3\u0015\u0007yif\fC\u0003=5\u0002\u0007a\u0007C\u0003?5\u0002\u0007a\u0007C\u0003a\u0001\u0011\u0005\u0013-A\nsKN\fW\u000e\u001d7f\t>,(\r\\3WC2LG\rF\u00027E\u000eDQ\u0001P0A\u0002YBQAP0A\u0002Y\u0002")
public abstract class CubicResample
extends BilinearResample {
    private final Tile tile;
    private final int dimension;
    private final DoubleConstantNoDataArrayTile cubicTile;

    private DoubleConstantNoDataArrayTile cubicTile() {
        return this.cubicTile;
    }

    public abstract double cubicResample(Tile var1, double var2, double var4);

    private void setCubicValues(int leftCol, int topRow, Function2<Object, Object, Object> f) {
        int offset = this.dimension / 2;
        for (int index$macro$638 = 0; index$macro$638 < this.dimension; ++index$macro$638) {
            for (int index$macro$637 = 0; index$macro$637 < this.dimension; ++index$macro$637) {
                double v = f.apply$mcDII$sp(leftCol - offset + 1 + index$macro$637, topRow - offset + 1 + index$macro$638);
                this.cubicTile().setDouble(index$macro$637, index$macro$638, v);
            }
        }
    }

    private int getter(int col, int row) {
        return col >= this.cols() && row >= this.rows() ? this.tile.get(this.cols() - 1, this.rows() - 1) : (col >= this.cols() && row < 0 ? this.tile.get(this.cols() - 1, 0) : (col < 0 && row >= this.rows() ? this.tile.get(0, this.rows() - 1) : (col < 0 && row < 0 ? this.tile.get(0, 0) : (col < 0 ? this.tile.get(0, row) : (col >= this.cols() ? this.tile.get(this.cols() - 1, row) : (row < 0 ? this.tile.get(col, 0) : (row >= this.rows() ? this.tile.get(col, this.rows() - 1) : this.tile.get(col, row))))))));
    }

    private double getterDouble(int col, int row) {
        return col >= this.cols() && row >= this.rows() ? this.tile.getDouble(this.cols() - 1, this.rows() - 1) : (col >= this.cols() && row < 0 ? this.tile.getDouble(this.cols() - 1, 0) : (col < 0 && row >= this.rows() ? this.tile.getDouble(0, this.rows() - 1) : (col < 0 && row < 0 ? this.tile.getDouble(0, 0) : (col < 0 ? this.tile.getDouble(0, row) : (col >= this.cols() ? this.tile.getDouble(this.cols() - 1, row) : (row < 0 ? this.tile.getDouble(col, 0) : (row >= this.rows() ? this.tile.getDouble(col, this.rows() - 1) : this.tile.getDouble(col, row))))))));
    }

    @Override
    public int resampleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int leftCol = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int topRow = BoxesRunTime.unboxToInt((Object)tuple4._2());
        double xRatio = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double yRatio = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
        Tuple4 tuple43 = tuple42;
        int leftCol2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int topRow2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        double xRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double yRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        this.setCubicValues(leftCol2, topRow2, (Function2<Object, Object, Object>)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(col, row) -> this.getter(col, row));
        return (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.cubicResample(this.cubicTile(), xRatio2, yRatio2)));
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int leftCol = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int topRow = BoxesRunTime.unboxToInt((Object)tuple4._2());
        double xRatio = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double yRatio = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
        Tuple4 tuple43 = tuple42;
        int leftCol2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int topRow2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        double xRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double yRatio2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        this.setCubicValues(leftCol2, topRow2, (Function2<Object, Object, Object>)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(col, row) -> this.getterDouble(col, row));
        return this.cubicResample(this.cubicTile(), xRatio2, yRatio2);
    }

    public CubicResample(Tile tile, Extent extent, int dimension) {
        this.tile = tile;
        this.dimension = dimension;
        super(tile, extent);
        this.cubicTile = ArrayTile$.MODULE$.apply((double[])Array$.MODULE$.ofDim(dimension * dimension, ClassTag$.MODULE$.Double()), dimension, dimension);
    }
}

