/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.Tile;
import geotrellis.raster.resample.Resample;
import geotrellis.vector.Extent;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u0013\t9b*Z1sKN$h*Z5hQ\n|'OU3tC6\u0004H.\u001a\u0006\u0003\u0007\u0011\t\u0001B]3tC6\u0004H.\u001a\u0006\u0003\u000b\u0019\taA]1ti\u0016\u0014(\"A\u0004\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005!\u0011Vm]1na2,\u0007\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\tQLG.\u001a\t\u0003#Ii\u0011\u0001B\u0005\u0003'\u0011\u0011A\u0001V5mK\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0004fqR,g\u000e\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0019\taA^3di>\u0014\u0018BA\u000e\u0019\u0005\u0019)\u0005\u0010^3oi\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"2a\b\u0011\"!\tY\u0001\u0001C\u0003\u00109\u0001\u0007\u0001\u0003C\u0003\u00169\u0001\u0007a\u0003C\u0003$\u0001\u0011\u0005C%A\u0007sKN\fW\u000e\u001d7f-\u0006d\u0017\u000e\u001a\u000b\u0004K-\u0002\u0004C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aA%oi\")AF\ta\u0001[\u0005\t\u0001\u0010\u0005\u0002']%\u0011qf\n\u0002\u0007\t>,(\r\\3\t\u000bE\u0012\u0003\u0019A\u0017\u0002\u0003eDQa\r\u0001\u0005BQ\n1C]3tC6\u0004H.\u001a#pk\ndWMV1mS\u0012$2!L\u001b7\u0011\u0015a#\u00071\u0001.\u0011\u0015\t$\u00071\u0001.\u0001")
public class NearestNeighborResample
extends Resample {
    private final Tile tile;

    @Override
    public int resampleValid(double x, double y) {
        int c = this.re().mapXToGrid(x);
        int col = c < this.tile.cols() ? c : this.tile.cols() - 1;
        int r = this.re().mapYToGrid(y);
        int row = r < this.tile.rows() ? r : this.tile.rows() - 1;
        return this.tile.get(col, row);
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        int c = this.re().mapXToGrid(x);
        int col = c < this.tile.cols() ? c : this.tile.cols() - 1;
        int r = this.re().mapYToGrid(y);
        int row = r < this.tile.rows() ? r : this.tile.rows() - 1;
        return this.tile.getDouble(col, row);
    }

    public NearestNeighborResample(Tile tile, Extent extent) {
        this.tile = tile;
        super(tile, extent);
    }
}

