/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.Average$;
import geotrellis.raster.resample.AverageResample;
import geotrellis.raster.resample.BicubicConvolutionResample;
import geotrellis.raster.resample.BicubicSplineResample;
import geotrellis.raster.resample.Bilinear$;
import geotrellis.raster.resample.BilinearResample;
import geotrellis.raster.resample.CubicConvolution$;
import geotrellis.raster.resample.CubicSpline$;
import geotrellis.raster.resample.Lanczos$;
import geotrellis.raster.resample.LanczosResample;
import geotrellis.raster.resample.Max$;
import geotrellis.raster.resample.MaxResample;
import geotrellis.raster.resample.Median$;
import geotrellis.raster.resample.MedianResample;
import geotrellis.raster.resample.Min$;
import geotrellis.raster.resample.MinResample;
import geotrellis.raster.resample.Mode$;
import geotrellis.raster.resample.ModeResample;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.NearestNeighborResample;
import geotrellis.raster.resample.PointResampleMethod;
import geotrellis.raster.resample.Resample;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.Sum$;
import geotrellis.raster.resample.SumResample;
import geotrellis.vector.Extent;
import scala.MatchError;

public final class Resample$ {
    public static Resample$ MODULE$;

    static {
        new Resample$();
    }

    public Resample apply(PointResampleMethod method, Tile tile, Extent extent) {
        Resample resample;
        PointResampleMethod pointResampleMethod = method;
        if (NearestNeighbor$.MODULE$.equals(pointResampleMethod)) {
            resample = new NearestNeighborResample(tile, extent);
        } else if (Bilinear$.MODULE$.equals(pointResampleMethod)) {
            resample = new BilinearResample(tile, extent);
        } else if (CubicConvolution$.MODULE$.equals(pointResampleMethod)) {
            resample = new BicubicConvolutionResample(tile, extent);
        } else if (CubicSpline$.MODULE$.equals(pointResampleMethod)) {
            resample = new BicubicSplineResample(tile, extent);
        } else if (Lanczos$.MODULE$.equals(pointResampleMethod)) {
            resample = new LanczosResample(tile, extent);
        } else {
            throw new MatchError((Object)pointResampleMethod);
        }
        return resample;
    }

    public Resample apply(ResampleMethod method, Tile tile, Extent extent, CellSize cs) {
        Resample resample;
        ResampleMethod resampleMethod = method;
        if (NearestNeighbor$.MODULE$.equals(resampleMethod)) {
            resample = new NearestNeighborResample(tile, extent);
        } else if (Bilinear$.MODULE$.equals(resampleMethod)) {
            resample = new BilinearResample(tile, extent);
        } else if (CubicConvolution$.MODULE$.equals(resampleMethod)) {
            resample = new BicubicConvolutionResample(tile, extent);
        } else if (CubicSpline$.MODULE$.equals(resampleMethod)) {
            resample = new BicubicSplineResample(tile, extent);
        } else if (Lanczos$.MODULE$.equals(resampleMethod)) {
            resample = new LanczosResample(tile, extent);
        } else if (Average$.MODULE$.equals(resampleMethod)) {
            resample = new AverageResample(tile, extent, cs);
        } else if (Mode$.MODULE$.equals(resampleMethod)) {
            resample = new ModeResample(tile, extent, cs);
        } else if (Median$.MODULE$.equals(resampleMethod)) {
            resample = new MedianResample(tile, extent, cs);
        } else if (Max$.MODULE$.equals(resampleMethod)) {
            resample = new MaxResample(tile, extent, cs);
        } else if (Min$.MODULE$.equals(resampleMethod)) {
            resample = new MinResample(tile, extent, cs);
        } else if (Sum$.MODULE$.equals(resampleMethod)) {
            resample = new SumResample(tile, extent, cs);
        } else {
            throw new MatchError((Object)resampleMethod);
        }
        return resample;
    }

    private Resample$() {
        MODULE$ = this;
    }
}

