/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.PointResampleMethod;
import geotrellis.raster.resample.Resample$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.Extent;
import geotrellis.vector.Point;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\u0001\u0003\u0003\u0003I!\u0001\u0003*fg\u0006l\u0007\u000f\\3\u000b\u0005\r!\u0011\u0001\u0003:fg\u0006l\u0007\u000f\\3\u000b\u0005\u00151\u0011A\u0002:bgR,'OC\u0001\b\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u0005!A/\u001b7f!\t\u0019B#D\u0001\u0005\u0013\t)BA\u0001\u0003US2,\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\r\u0015DH/\u001a8u!\tIB$D\u0001\u001b\u0015\tYb!\u0001\u0004wK\u000e$xN]\u0005\u0003;i\u0011a!\u0012=uK:$\b\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0002\"G\u0011\u0002\"A\t\u0001\u000e\u0003\tAQ!\u0005\u0010A\u0002IAQa\u0006\u0010A\u0002aAqA\n\u0001C\u0002\u0013Eq%\u0001\u0002sKV\t\u0001\u0006\u0005\u0002\u0014S%\u0011!\u0006\u0002\u0002\r%\u0006\u001cH/\u001a:FqR,g\u000e\u001e\u0005\u0007Y\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u0007I,\u0007\u0005C\u0004/\u0001\t\u0007I\u0011C\u0018\u0002\t\r|Gn]\u000b\u0002aA\u00111\"M\u0005\u0003e1\u00111!\u00138u\u0011\u0019!\u0004\u0001)A\u0005a\u0005)1m\u001c7tA!9a\u0007\u0001b\u0001\n#y\u0013\u0001\u0002:poNDa\u0001\u000f\u0001!\u0002\u0013\u0001\u0014!\u0002:poN\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%IaO\u0001\no\u0016\u001cHOQ8v]\u0012,\u0012\u0001\u0010\t\u0003\u0017uJ!A\u0010\u0007\u0003\r\u0011{WO\u00197f\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005Qq/Z:u\u0005>,h\u000e\u001a\u0011\t\u000f\t\u0003!\u0019!C\u0005w\u0005IQ-Y:u\u0005>,h\u000e\u001a\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u0015\u0015\f7\u000f\u001e\"pk:$\u0007\u0005C\u0004G\u0001\t\u0007I\u0011B\u001e\u0002\u00159|'\u000f\u001e5C_VtG\r\u0003\u0004I\u0001\u0001\u0006I\u0001P\u0001\f]>\u0014H\u000f\u001b\"pk:$\u0007\u0005C\u0004K\u0001\t\u0007I\u0011B\u001e\u0002\u0015M|W\u000f\u001e5C_VtG\r\u0003\u0004M\u0001\u0001\u0006I\u0001P\u0001\fg>,H\u000f\u001b\"pk:$\u0007\u0005C\u0004O\u0001\t\u0007I\u0011C\u001e\u0002\u0013\r,G\u000e\\<jIRD\u0007B\u0002)\u0001A\u0003%A(\u0001\u0006dK2dw/\u001b3uQ\u0002BqA\u0015\u0001C\u0002\u0013E1(\u0001\u0006dK2d\u0007.Z5hQRDa\u0001\u0016\u0001!\u0002\u0013a\u0014aC2fY2DW-[4ii\u0002BQA\u0016\u0001\u0005\n]\u000bq![:WC2LG\rF\u0002Y7v\u0003\"aC-\n\u0005ic!a\u0002\"p_2,\u0017M\u001c\u0005\u00069V\u0003\r\u0001P\u0001\u0002q\")a,\u0016a\u0001y\u0005\t\u0011\u0010C\u0003\u0004\u0001\u0011\u0015\u0001\r\u0006\u00021C\")!m\u0018a\u0001G\u0006\t\u0001\u000f\u0005\u0002\u001aI&\u0011QM\u0007\u0002\u0006!>Lg\u000e\u001e\u0005\u0006\u0007\u0001!)a\u001a\u000b\u0004a!L\u0007\"\u0002/g\u0001\u0004a\u0004\"\u00020g\u0001\u0004a\u0004\"B6\u0001\t\u000ba\u0017A\u0004:fg\u0006l\u0007\u000f\\3E_V\u0014G.\u001a\u000b\u0003y5DQA\u00196A\u0002\rDQa\u001b\u0001\u0005\u0006=$2\u0001\u00109r\u0011\u0015af\u000e1\u0001=\u0011\u0015qf\u000e1\u0001=\u0011\u0015\u0019\bA\"\u0005u\u00035\u0011Xm]1na2,g+\u00197jIR\u0019\u0001'\u001e<\t\u000bq\u0013\b\u0019\u0001\u001f\t\u000by\u0013\b\u0019\u0001\u001f\t\u000ba\u0004a\u0011C=\u0002'I,7/Y7qY\u0016$u.\u001e2mKZ\u000bG.\u001b3\u0015\u0007qR8\u0010C\u0003]o\u0002\u0007A\bC\u0003_o\u0002\u0007AhB\u0003~\u0005!\u0005a0\u0001\u0005SKN\fW\u000e\u001d7f!\t\u0011sP\u0002\u0004\u0002\u0005!\u0005\u0011\u0011A\n\u0003\u007f*AaaH@\u0005\u0002\u0005\u0015A#\u0001@\t\u000f\u0005%q\u0010\"\u0001\u0002\f\u0005)\u0011\r\u001d9msR9\u0011%!\u0004\u0002\u0018\u0005e\u0001\u0002CA\b\u0003\u000f\u0001\r!!\u0005\u0002\r5,G\u000f[8e!\r\u0011\u00131C\u0005\u0004\u0003+\u0011!a\u0005)pS:$(+Z:b[BdW-T3uQ>$\u0007BB\t\u0002\b\u0001\u0007!\u0003\u0003\u0004\u0018\u0003\u000f\u0001\r\u0001\u0007\u0005\b\u0003\u0013yH\u0011AA\u000f)%\t\u0013qDA\u0014\u0003S\tY\u0003\u0003\u0005\u0002\u0010\u0005m\u0001\u0019AA\u0011!\r\u0011\u00131E\u0005\u0004\u0003K\u0011!A\u0004*fg\u0006l\u0007\u000f\\3NKRDw\u000e\u001a\u0005\u0007#\u0005m\u0001\u0019\u0001\n\t\r]\tY\u00021\u0001\u0019\u0011!\ti#a\u0007A\u0002\u0005=\u0012AA2t!\r\u0019\u0012\u0011G\u0005\u0004\u0003g!!\u0001C\"fY2\u001c\u0016N_3")
public abstract class Resample {
    private final RasterExtent re;
    private final int cols;
    private final int rows;
    private final double westBound;
    private final double eastBound;
    private final double northBound;
    private final double southBound;
    private final double cellwidth;
    private final double cellheight;

    public static Resample apply(ResampleMethod resampleMethod, Tile tile, Extent extent, CellSize cellSize) {
        return Resample$.MODULE$.apply(resampleMethod, tile, extent, cellSize);
    }

    public static Resample apply(PointResampleMethod pointResampleMethod, Tile tile, Extent extent) {
        return Resample$.MODULE$.apply(pointResampleMethod, tile, extent);
    }

    public RasterExtent re() {
        return this.re;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    private double westBound() {
        return this.westBound;
    }

    private double eastBound() {
        return this.eastBound;
    }

    private double northBound() {
        return this.northBound;
    }

    private double southBound() {
        return this.southBound;
    }

    public double cellwidth() {
        return this.cellwidth;
    }

    public double cellheight() {
        return this.cellheight;
    }

    private boolean isValid(double x, double y) {
        return x >= this.westBound() && x <= this.eastBound() && y >= this.southBound() && y <= this.northBound();
    }

    public final int resample(Point p) {
        return this.resample(p.x(), p.y());
    }

    public final int resample(double x, double y) {
        return !this.isValid(x, y) ? Integer.MIN_VALUE : this.resampleValid(x, y);
    }

    public final double resampleDouble(Point p) {
        return this.resampleDouble(p.x(), p.y());
    }

    public final double resampleDouble(double x, double y) {
        return !this.isValid(x, y) ? Double.NaN : this.resampleDoubleValid(x, y);
    }

    public abstract int resampleValid(double var1, double var3);

    public abstract double resampleDoubleValid(double var1, double var3);

    public Resample(Tile tile, Extent extent) {
        this.re = RasterExtent$.MODULE$.apply(tile, extent);
        this.cols = tile.cols();
        this.rows = tile.rows();
        this.westBound = extent.xmin();
        this.eastBound = extent.xmax();
        this.northBound = extent.ymax();
        this.southBound = extent.ymin();
        this.cellwidth = this.re().cellwidth();
        this.cellheight = this.re().cellheight();
    }
}

