/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.AggregateResample;
import geotrellis.vector.Extent;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u0013\tY1+^7SKN\fW\u000e\u001d7f\u0015\t\u0019A!\u0001\u0005sKN\fW\u000e\u001d7f\u0015\t)a!\u0001\u0004sCN$XM\u001d\u0006\u0002\u000f\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00171i\u0011AA\u0005\u0003\u001b\t\u0011\u0011#Q4he\u0016<\u0017\r^3SKN\fW\u000e\u001d7f\u0011!y\u0001A!A!\u0002\u0013\u0001\u0012\u0001\u0002;jY\u0016\u0004\"!\u0005\n\u000e\u0003\u0011I!a\u0005\u0003\u0003\tQKG.\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u00051Q\r\u001f;f]R\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\rY,7\r^8s\u0013\tY\u0002D\u0001\u0004FqR,g\u000e\u001e\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005AA/\u0019:hKR\u001c5\u000b\u0005\u0002\u0012?%\u0011\u0001\u0005\u0002\u0002\t\u0007\u0016dGnU5{K\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"B\u0001J\u0013'OA\u00111\u0002\u0001\u0005\u0006\u001f\u0005\u0002\r\u0001\u0005\u0005\u0006+\u0005\u0002\rA\u0006\u0005\u0006;\u0005\u0002\rA\b\u0005\u0006S\u0001!IAK\u0001\rG\u0006d7-\u001e7bi\u0016l\u0015\r\u001f\u000b\u0003WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u00121!\u00138u\u0011\u0015\u0011\u0004\u00061\u00014\u0003\u001dIg\u000eZ5dKN\u00042\u0001\u000e\u001f@\u001d\t)$H\u0004\u00027s5\tqG\u0003\u00029\u0011\u00051AH]8pizJ\u0011AL\u0005\u0003w5\nq\u0001]1dW\u0006<W-\u0003\u0002>}\t\u00191+Z9\u000b\u0005mj\u0003\u0003\u0002\u0017AW-J!!Q\u0017\u0003\rQ+\b\u000f\\33\u0011\u0015\u0019\u0005\u0001\"\u0003E\u0003I\u0019\u0017\r\\2vY\u0006$X-T1y\t>,(\r\\3\u0015\u0005\u0015C\u0005C\u0001\u0017G\u0013\t9UF\u0001\u0004E_V\u0014G.\u001a\u0005\u0006e\t\u0003\ra\r\u0005\u0006\u0015\u0002!\taS\u0001\u000ee\u0016\u001c\u0018-\u001c9mKZ\u000bG.\u001b3\u0015\u0007-be\nC\u0003N\u0013\u0002\u0007Q)A\u0001y\u0011\u0015y\u0015\n1\u0001F\u0003\u0005I\b\"B)\u0001\t\u0003\u0011\u0016a\u0005:fg\u0006l\u0007\u000f\\3E_V\u0014G.\u001a,bY&$GcA#T)\")Q\n\u0015a\u0001\u000b\")q\n\u0015a\u0001\u000b\u0002")
public class SumResample
extends AggregateResample {
    private final Tile tile;

    private int calculateMax(Seq<Tuple2<Object, Object>> indices) {
        Tuple2 tuple2 = (Tuple2)indices.foldLeft((Object)new Tuple2.mcII.sp(0, 0), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2 coords;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    coords = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int sum = tuple2._1$mcI$sp();
            int count = tuple2._2$mcI$sp();
            int v = $this.tile.get(coords._1$mcI$sp(), coords._2$mcI$sp());
            Tuple2.mcII.sp sp2 = v != Integer.MIN_VALUE ? new Tuple2.mcII.sp(sum + v, count + 1) : new Tuple2.mcII.sp(sum, count);
            return sp2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int sum = tuple2._1$mcI$sp();
        int count = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(sum, count);
        Tuple2.mcII.sp sp3 = sp2;
        int sum2 = sp3._1$mcI$sp();
        int count2 = sp3._2$mcI$sp();
        return count2 > 0 ? sum2 : Integer.MIN_VALUE;
    }

    private double calculateMaxDouble(Seq<Tuple2<Object, Object>> indices) {
        Tuple2 tuple2 = (Tuple2)indices.foldLeft((Object)new Tuple2.mcDI.sp(0.0, 0), (Function2 & java.io.Serializable & Serializable)(x0$2, x1$2) -> {
            Tuple2 coords;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$2);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    coords = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double sum = tuple2._1$mcD$sp();
            int count = tuple2._2$mcI$sp();
            double v = $this.tile.getDouble(coords._1$mcI$sp(), coords._2$mcI$sp());
            Tuple2.mcDI.sp sp2 = !Double.isNaN(v) ? new Tuple2.mcDI.sp(sum + v, count + 1) : new Tuple2.mcDI.sp(sum, count);
            return sp2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double sum = tuple2._1$mcD$sp();
        int count = tuple2._2$mcI$sp();
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(sum, count);
        Tuple2.mcDI.sp sp3 = sp2;
        double sum2 = sp3._1$mcD$sp();
        int count2 = sp3._2$mcI$sp();
        return count2 > 0 ? sum2 : Double.NaN;
    }

    @Override
    public int resampleValid(double x, double y) {
        return this.calculateMax(this.contributions(x, y));
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        return this.calculateMaxDouble(this.contributions(x, y));
    }

    public SumResample(Tile tile, Extent extent, CellSize targetCS) {
        this.tile = tile;
        super(tile, extent, targetCS);
    }
}

