/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.sigmoidal;

import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.IntCells;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import java.io.Serializable;
import scala.Double$;
import scala.Float$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Traversable;
import scala.collection.immutable.Vector$;
import scala.math.package$;
import scala.runtime.java8.JFunction1;

public final class SigmoidalContrast$ {
    public static SigmoidalContrast$ MODULE$;

    static {
        new SigmoidalContrast$();
    }

    private double transform(DataType cellType, double alpha, double beta, double intensity) {
        double d;
        double d2;
        int bits = cellType.bits();
        DataType dataType = cellType;
        if (dataType instanceof FloatCells) {
            d2 = (intensity - (double)Float$.MODULE$.MinValue()) / (double)(Float.MAX_VALUE - Float$.MODULE$.MinValue());
        } else if (dataType instanceof DoubleCells) {
            d2 = (intensity / (double)2 - Double$.MODULE$.MinValue() / (double)2) / (8.988465674311579E307 - Double$.MODULE$.MinValue() / (double)2);
        } else {
            boolean bl = dataType instanceof BitCells ? true : (dataType instanceof UByteCells ? true : dataType instanceof UShortCells);
            if (bl) {
                d2 = intensity / (double)((1 << bits) - 1);
            } else {
                boolean bl2 = dataType instanceof ByteCells ? true : (dataType instanceof ShortCells ? true : dataType instanceof IntCells);
                if (bl2) {
                    d2 = (intensity + (double)(1 << bits - 1)) / (double)((1 << bits) - 1);
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
        double u = d2;
        double numer = 1.0 / (1.0 + package$.MODULE$.exp(beta * (alpha - u))) - 1.0 / (1.0 + package$.MODULE$.exp(beta));
        double denom = 1.0 / (1.0 + package$.MODULE$.exp(beta * (alpha - 1.0))) - 1.0 / (1.0 + package$.MODULE$.exp(beta * alpha));
        double gu = package$.MODULE$.max(0.0, package$.MODULE$.min(1.0, numer / denom));
        DataType dataType2 = cellType;
        if (dataType2 instanceof FloatCells) {
            d = 3.4028234663852886E38 * ((double)2 * gu - 1.0);
        } else if (dataType2 instanceof DoubleCells) {
            d = Double.MAX_VALUE * ((double)2 * gu - 1.0);
        } else {
            boolean bl = dataType2 instanceof BitCells ? true : (dataType2 instanceof UByteCells ? true : dataType2 instanceof UShortCells);
            if (bl) {
                d = (double)((1 << bits) - 1) * gu;
            } else {
                boolean bl3 = dataType2 instanceof ByteCells ? true : (dataType2 instanceof ShortCells ? true : dataType2 instanceof IntCells);
                if (bl3) {
                    d = (double)((1 << bits) - 1) * gu - (double)(1 << bits - 1);
                } else {
                    throw new MatchError((Object)dataType2);
                }
            }
        }
        return d;
    }

    public Tile apply(Tile tile, double alpha, double beta) {
        DataType dataType = tile.cellType();
        JFunction1.mcDD.sp & Serializable & scala.Serializable localTransform = (JFunction1.mcDD.sp & Serializable & scala.Serializable)intensity -> MODULE$.transform(dataType, alpha, beta, intensity);
        return tile.mapDouble((Function1<Object, Object>)localTransform);
    }

    public MultibandTile apply(MultibandTile tile, double alpha, double beta) {
        DataType dataType = tile.cellType();
        JFunction1.mcDD.sp & Serializable & scala.Serializable localTransform = (JFunction1.mcDD.sp & Serializable & scala.Serializable)intensity -> MODULE$.transform(dataType, alpha, beta, intensity);
        return MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)tile.bands().map(arg_0 -> SigmoidalContrast$.$anonfun$apply$3((Function1)localTransform, arg_0), Vector$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ Tile $anonfun$apply$3(Function1 localTransform$1, Tile x$1) {
        return x$1.mapDouble((Function1<Object, Object>)localTransform$1);
    }

    private SigmoidalContrast$() {
        MODULE$ = this;
    }
}

