/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.vectorize;

import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001%\u00111\u0002U8ms\u001e|g.\u001b>fe*\u00111\u0001B\u0001\nm\u0016\u001cGo\u001c:ju\u0016T!!\u0002\u0004\u0002\rI\f7\u000f^3s\u0015\u00059\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001BC\u0002\u0013\u0005!#A\u0001s+\u0005\u0019\u0002C\u0001\u000b\u0016\u001b\u0005!\u0011B\u0001\f\u0005\u0005\u0011!\u0016\u000e\\3\t\u0011a\u0001!\u0011!Q\u0001\nM\t!A\u001d\u0011\t\u0011i\u0001!\u0011!Q\u0001\nm\tAB]1ti\u0016\u0014X\t\u001f;f]R\u0004\"\u0001\u0006\u000f\n\u0005u!!\u0001\u0004*bgR,'/\u0012=uK:$\b\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0002\"G\u0011\u0002\"A\t\u0001\u000e\u0003\tAQ!\u0005\u0010A\u0002MAQA\u0007\u0010A\u0002mAqA\n\u0001C\u0002\u0013\u0005q%\u0001\u0003d_2\u001cX#\u0001\u0015\u0011\u0005-I\u0013B\u0001\u0016\r\u0005\rIe\u000e\u001e\u0005\u0007Y\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u000b\r|Gn\u001d\u0011\t\u000f9\u0002!\u0019!C\u0001O\u0005!!o\\<t\u0011\u0019\u0001\u0004\u0001)A\u0005Q\u0005)!o\\<tA!9!\u0007\u0001b\u0001\n\u0003\u0019\u0014!\u00045bY\u001a\u001cU\r\u001c7XS\u0012$\b.F\u00015!\tYQ'\u0003\u00027\u0019\t1Ai\\;cY\u0016Da\u0001\u000f\u0001!\u0002\u0013!\u0014A\u00045bY\u001a\u001cU\r\u001c7XS\u0012$\b\u000e\t\u0005\bu\u0001\u0011\r\u0011\"\u00014\u00039A\u0017\r\u001c4DK2d\u0007*Z5hQRDa\u0001\u0010\u0001!\u0002\u0013!\u0014a\u00045bY\u001a\u001cU\r\u001c7IK&<\u0007\u000e\u001e\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005Q!\u000e^:GC\u000e$xN]=\u0016\u0003\u0001\u0003\"!\u0011&\u000e\u0003\tS!a\u0011#\u0002\t\u001d,w.\u001c\u0006\u0003\u000b\u001a\u000b1A\u001b;t\u0015\t9\u0005*\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001J\u0003\ry'oZ\u0005\u0003\u0017\n\u0013qbR3p[\u0016$(/\u001f$bGR|'/\u001f\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002!\u0002\u0017)$8OR1di>\u0014\u0018\u0010\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001(\u0003!qu\n\u0016$P+:#\u0005BB)\u0001A\u0003%\u0001&A\u0005O\u001fR3u*\u0016(EA!91\u000b\u0001b\u0001\n\u00039\u0013\u0001\u0002'F\rRCa!\u0016\u0001!\u0002\u0013A\u0013!\u0002'F\rR\u0003\u0003bB,\u0001\u0005\u0004%\taJ\u0001\u0005\t>;f\n\u0003\u0004Z\u0001\u0001\u0006I\u0001K\u0001\u0006\t>;f\n\t\u0005\b7\u0002\u0011\r\u0011\"\u0001(\u0003\u0015\u0011\u0016j\u0012%U\u0011\u0019i\u0006\u0001)A\u0005Q\u00051!+S$I)\u0002Bqa\u0018\u0001C\u0002\u0013\u0005q%\u0001\u0002V!\"1\u0011\r\u0001Q\u0001\n!\n1!\u0016)!\u0011\u001d\u0019\u0007A1A\u0005\u0002\u001d\nq\u0001V(Q\u0019\u00163E\u000b\u0003\u0004f\u0001\u0001\u0006I\u0001K\u0001\t)>\u0003F*\u0012$UA!9q\r\u0001b\u0001\n\u00039\u0013A\u0003\"P)R{U\nT#G)\"1\u0011\u000e\u0001Q\u0001\n!\n1BQ(U)>kE*\u0012$UA!91\u000e\u0001b\u0001\n\u00039\u0013a\u0003\"P)R{UJU%H\u0011RCa!\u001c\u0001!\u0002\u0013A\u0013\u0001\u0004\"P)R{UJU%H\u0011R\u0003\u0003bB8\u0001\u0005\u0004%\taJ\u0001\t)>\u0003&+S$I)\"1\u0011\u000f\u0001Q\u0001\n!\n\u0011\u0002V(Q%&;\u0005\n\u0016\u0011\t\u000bM\u0004A\u0011\u0001;\u0002\u0005M$GCA;~!\t180D\u0001x\u0015\tA\u00180\u0001\u0003mC:<'\"\u0001>\u0002\t)\fg/Y\u0005\u0003y^\u0014aa\u0015;sS:<\u0007\"\u0002@s\u0001\u0004A\u0013!\u00013\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005\u00111/\u001c\u000b\u0004k\u0006\u0015\u0001\"\u0002@\u0000\u0001\u0004A\u0003bBA\u0005\u0001\u0011\u0005\u00111B\u0001\u0005[\u0006\u00148\u000e\u0006\u0005\u0002\u000e\u0005M\u0011qCA\u000e!\r\t\u0015qB\u0005\u0004\u0003#\u0011%AC\"p_J$\u0017N\\1uK\"9\u0011QCA\u0004\u0001\u0004A\u0013aA2pY\"9\u0011\u0011DA\u0004\u0001\u0004A\u0013a\u0001:po\"9\u0011QDA\u0004\u0001\u0004A\u0013!A7\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\u0005IQ.Y6f\u001b\u0006\u00148n\u001d\u000b\r\u0003K\tY#a\u0010\u0002B\u0005\r\u0013Q\t\t\u0004\u0017\u0005\u001d\u0012bAA\u0015\u0019\t\u0019\u0011I\\=\t\u0011\u00055\u0012q\u0004a\u0001\u0003_\ta\u0001]8j]R\u001c\bCBA\u0019\u0003w\ti!\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u001diW\u000f^1cY\u0016T1!!\u000f\r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\t\u0019DA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bbBA\u000b\u0003?\u0001\r\u0001\u000b\u0005\b\u00033\ty\u00021\u0001)\u0011\u0019q\u0018q\u0004a\u0001Q!9\u0011qIA\u0010\u0001\u0004A\u0013A\u00019e\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\n\u0011CZ5oI:+\u0007\u0010\u001e#je\u0016\u001cG/[8o)%A\u0013qJA)\u0003'\n)\u0006C\u0004\u0002\u0016\u0005%\u0003\u0019\u0001\u0015\t\u000f\u0005e\u0011\u0011\na\u0001Q!1a0!\u0013A\u0002!Bq!a\u0016\u0002J\u0001\u0007\u0001&A\u0006uCJ<W\r\u001e,bYV,\u0007bBA.\u0001\u0011\u0005\u0011QL\u0001\u000eO\u0016$H*\u001b8fCJ\u0014\u0016N\\4\u0016\t\u0005}\u00131\u000f\u000b\u0007\u0003C\n9'!\u001b\u0011\u0007\u0005\u000b\u0019'C\u0002\u0002f\t\u0013!\u0002T5oK\u0006\u0014(+\u001b8h\u0011\u001d\t9&!\u0017A\u0002!B\u0001\"a\u001b\u0002Z\u0001\u0007\u0011QN\u0001\u000bgR\f'\u000f\u001e)pS:$\b#B\u0006\u0002p!B\u0013bAA9\u0019\t1A+\u001e9mKJ\"\u0001\"!\u001e\u0002Z\t\u0007\u0011q\u000f\u0002\u0002)F!\u0011\u0011PA\u0013!\rY\u00111P\u0005\u0004\u0003{b!a\u0002(pi\"Lgn\u001a")
public class Polygonizer {
    private final Tile r;
    private final RasterExtent rasterExtent;
    private final int cols;
    private final int rows;
    private final double halfCellWidth;
    private final double halfCellHeight;
    private final GeometryFactory jtsFactory;
    private final int NOTFOUND;
    private final int LEFT;
    private final int DOWN;
    private final int RIGHT;
    private final int UP;
    private final int TOPLEFT;
    private final int BOTTOMLEFT;
    private final int BOTTOMRIGHT;
    private final int TOPRIGHT;

    public Tile r() {
        return this.r;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    public double halfCellWidth() {
        return this.halfCellWidth;
    }

    public double halfCellHeight() {
        return this.halfCellHeight;
    }

    public GeometryFactory jtsFactory() {
        return this.jtsFactory;
    }

    public int NOTFOUND() {
        return this.NOTFOUND;
    }

    public int LEFT() {
        return this.LEFT;
    }

    public int DOWN() {
        return this.DOWN;
    }

    public int RIGHT() {
        return this.RIGHT;
    }

    public int UP() {
        return this.UP;
    }

    public int TOPLEFT() {
        return this.TOPLEFT;
    }

    public int BOTTOMLEFT() {
        return this.BOTTOMLEFT;
    }

    public int BOTTOMRIGHT() {
        return this.BOTTOMRIGHT;
    }

    public int TOPRIGHT() {
        return this.TOPRIGHT;
    }

    public String sd(int d) {
        int n = d;
        String string = this.NOTFOUND() == n ? "NOTFOUND" : (this.LEFT() == n ? "LEFT" : (this.DOWN() == n ? "DOWN" : (this.RIGHT() == n ? "RIGHT" : (this.UP() == n ? "UP" : "BAD"))));
        return string;
    }

    public String sm(int d) {
        int n = d;
        String string = this.TOPLEFT() == n ? "TOPLEFT" : (this.BOTTOMLEFT() == n ? "BOTTOMLEFT" : (this.BOTTOMRIGHT() == n ? "BOTTOMRIGHT" : (this.TOPRIGHT() == n ? "TOPRIGHT" : "BAD")));
        return string;
    }

    public Coordinate mark(int col, int row, int m) {
        Coordinate coordinate;
        double mapX = this.rasterExtent.gridColToMap(col);
        double mapY = this.rasterExtent.gridRowToMap(row);
        if (m == this.TOPLEFT()) {
            coordinate = new Coordinate(mapX - this.halfCellWidth(), mapY + this.halfCellHeight());
        } else if (m == this.BOTTOMLEFT()) {
            coordinate = new Coordinate(mapX - this.halfCellWidth(), mapY - this.halfCellHeight());
        } else if (m == this.BOTTOMRIGHT()) {
            coordinate = new Coordinate(mapX + this.halfCellWidth(), mapY - this.halfCellHeight());
        } else if (m == this.TOPRIGHT()) {
            coordinate = new Coordinate(mapX + this.halfCellWidth(), mapY + this.halfCellHeight());
        } else {
            throw package$.MODULE$.error("Bad Mark Integer");
        }
        return coordinate;
    }

    public Object makeMarks(ArrayBuffer<Coordinate> points, int col, int row, int d, int pd) {
        BoxedUnit boxedUnit;
        if (d == this.DOWN()) {
            if (pd != this.DOWN()) {
                if (pd == this.RIGHT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.BOTTOMLEFT()));
                } else if (pd == this.LEFT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.TOPLEFT()));
                } else {
                    points.$plus$eq((Object)this.mark(col, row - 1, this.TOPRIGHT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row - 1, this.TOPLEFT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (d == this.RIGHT()) {
            if (pd != this.RIGHT()) {
                if (pd == this.UP()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMRIGHT()));
                } else if (pd == this.DOWN()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMLEFT()));
                } else {
                    points.$plus$eq((Object)this.mark(col - 1, row, this.TOPLEFT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col - 1, row, this.BOTTOMLEFT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (d == this.UP()) {
            if (pd != this.UP()) {
                if (pd == this.LEFT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.TOPRIGHT()));
                } else if (pd == this.RIGHT()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMRIGHT()));
                } else {
                    points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMLEFT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col, row + 1, this.BOTTOMRIGHT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (d == this.LEFT()) {
            if (pd != this.LEFT()) {
                if (pd == this.DOWN()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPLEFT()));
                } else if (pd == this.UP()) {
                    boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPRIGHT()));
                } else {
                    points.$plus$eq((Object)this.mark(col + 1, row, this.BOTTOMRIGHT()));
                    boxedUnit = points.$plus$eq((Object)this.mark(col + 1, row, this.TOPRIGHT()));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw package$.MODULE$.error(new StringBuilder(18).append("Unknown direction ").append(d).toString());
        }
        return boxedUnit;
    }

    public int findNextDirection(int col, int row, int d, int targetValue) {
        for (int i = d + 3; i < d + 7; ++i) {
            int m = i % 4;
            if (m == 0) {
                if (col <= 0 || this.r().get(col - 1, row) != targetValue) continue;
                return this.LEFT();
            }
            if (m == 1) {
                if (row + 1 >= this.rows() || this.r().get(col, row + 1) != targetValue) continue;
                return this.DOWN();
            }
            if (m == 2) {
                if (col + 1 >= this.cols() || this.r().get(col + 1, row) != targetValue) continue;
                return this.RIGHT();
            }
            if (m != 3 || row <= 0 || this.r().get(col, row - 1) != targetValue) continue;
            return this.UP();
        }
        return this.NOTFOUND();
    }

    public <T> LinearRing getLinearRing(int targetValue, Tuple2<Object, Object> startPoint) {
        ArrayBuffer arrayBuffer;
        ArrayBuffer points = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int startCol = startPoint._1$mcI$sp();
        int startRow = startPoint._2$mcI$sp();
        int direction = this.NOTFOUND();
        if (startRow + 1 < this.rows() && this.r().get(startCol, startRow + 1) == targetValue) {
            direction = this.DOWN();
        }
        if (direction == this.NOTFOUND() && startCol + 1 < this.cols() && this.r().get(startCol + 1, startRow) == targetValue) {
            direction = this.RIGHT();
        }
        if (direction == this.NOTFOUND()) {
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMLEFT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMRIGHT()));
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPRIGHT()));
            arrayBuffer = points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
        } else {
            points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
            Object object = direction == this.RIGHT() ? points.$plus$eq((Object)this.mark(startCol, startRow, this.BOTTOMLEFT())) : BoxedUnit.UNIT;
            int previousDirection = direction;
            int col = startCol;
            int row = startRow;
            boolean bl = false;
            while (!bl) {
                if (direction == this.DOWN()) {
                    ++row;
                } else if (direction == this.RIGHT()) {
                    ++col;
                } else if (direction == this.UP()) {
                    --row;
                } else if (direction == this.LEFT()) {
                    --col;
                }
                this.makeMarks((ArrayBuffer<Coordinate>)points, col, row, direction, previousDirection);
                previousDirection = direction;
                direction = this.findNextDirection(col, row, direction, targetValue);
                if (col != startCol || row != startRow) continue;
                if (previousDirection == this.LEFT() || previousDirection == this.DOWN()) {
                    bl = true;
                    continue;
                }
                if (previousDirection != this.UP() && previousDirection != this.RIGHT() || direction != this.DOWN() && direction != this.LEFT()) continue;
                bl = true;
            }
            Object object2 = previousDirection == this.UP() ? points.$plus$eq((Object)this.mark(col, row, this.TOPRIGHT())) : BoxedUnit.UNIT;
            arrayBuffer = points.$plus$eq((Object)this.mark(startCol, startRow, this.TOPLEFT()));
        }
        return this.jtsFactory().createLinearRing((Coordinate[])points.toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
    }

    public Polygonizer(Tile r, RasterExtent rasterExtent) {
        this.r = r;
        this.rasterExtent = rasterExtent;
        this.cols = r.cols();
        this.rows = r.rows();
        this.halfCellWidth = rasterExtent.cellwidth() / 2.0;
        this.halfCellHeight = rasterExtent.cellheight() / 2.0;
        this.jtsFactory = new GeometryFactory();
        this.NOTFOUND = -1;
        this.LEFT = 0;
        this.DOWN = 1;
        this.RIGHT = 2;
        this.UP = 3;
        this.TOPLEFT = 0;
        this.BOTTOMLEFT = 1;
        this.BOTTOMRIGHT = 2;
        this.TOPRIGHT = 3;
    }
}

