/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.vectorize;

import geotrellis.raster.Connectivity;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.package;
import geotrellis.raster.package$;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.regiongroup.RegionGroup$;
import geotrellis.raster.regiongroup.RegionGroupOptions;
import geotrellis.raster.regiongroup.RegionGroupOptions$;
import geotrellis.raster.regiongroup.RegionGroupResult;
import geotrellis.raster.vectorize.Polygonizer;
import geotrellis.raster.vectorize.Vectorize;
import geotrellis.vector.Extent;
import geotrellis.vector.Feature;
import geotrellis.vector.Line;
import geotrellis.vector.Line$;
import geotrellis.vector.MultiPolygon;
import geotrellis.vector.Polygon;
import geotrellis.vector.Polygon$;
import geotrellis.vector.PolygonFeature$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class Vectorize$ {
    public static Vectorize$ MODULE$;

    static {
        new Vectorize$();
    }

    public List<Feature<Polygon, Object>> apply(Tile tile, Extent extent, Connectivity regionConnectivity) {
        RegionGroupOptions regionGroupOptions = new RegionGroupOptions(regionConnectivity, false);
        RegionGroupResult rgr = RegionGroup$.MODULE$.apply(tile, regionGroupOptions);
        Tile r = rgr.tile();
        Map<Object, Object> regionMap = rgr.regionMap();
        RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(extent, r.cols(), r.rows());
        Polygonizer polyizer = new Polygonizer(r, rasterExtent);
        Set processedValues = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set polygons = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        GeometryFactory jtsFactory = new GeometryFactory();
        for (int col = 0; col < r.cols(); ++col) {
            for (int row = 0; row < r.rows(); ++row) {
                BoxedUnit boxedUnit;
                int v = r.get(col, row);
                if (BoxesRunTime.unboxToInt((Object)regionMap.apply((Object)BoxesRunTime.boxToInteger((int)v))) != Integer.MIN_VALUE) {
                    if (!processedValues.contains((Object)BoxesRunTime.boxToInteger((int)v))) {
                        scala.collection.immutable.Set set;
                        LinearRing linearRing;
                        LinearRing lr = polyizer.getLinearRing(v, (Tuple2<Object, Object>)new Tuple2.mcII.sp(col, row));
                        if (!lr.isValid()) {
                            LinearRing l;
                            Tuple2[] coords = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lr.getCoordinates())).map((Function1 & Serializable & scala.Serializable)coord -> {
                                double x = scala.package$.MODULE$.BigDecimal().apply(coord.x).setScale(12, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
                                double y = scala.package$.MODULE$.BigDecimal().apply(coord.y).setScale(12, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
                                return new Tuple2.mcDD.sp(x, y);
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                            Map coordsToLastIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                            int len = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coords)).size();
                            ListBuffer adjusted = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{coords[0]}));
                            for (int i = 1; i < len; ++i) {
                                Tuple2 p = coords[i];
                                i = BoxesRunTime.unboxToInt((Object)coordsToLastIndex.apply((Object)p));
                                adjusted.$plus$eq((Object)p);
                            }
                            linearRing = l = jtsFactory.createLinearRing((Coordinate[])((TraversableForwarder)adjusted.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                Tuple2 tuple2 = x0$1;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                double x = tuple2._1$mcD$sp();
                                double y = tuple2._2$mcD$sp();
                                Coordinate coordinate = new Coordinate(x, y);
                                return coordinate;
                            }, ListBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
                        } else {
                            linearRing = lr;
                        }
                        LinearRing shell = linearRing;
                        Feature shellPoly = PolygonFeature$.MODULE$.apply(Polygon$.MODULE$.apply(Line$.MODULE$.jtsToLine((LineString)shell)), rgr.regionMap().apply((Object)BoxesRunTime.boxToInteger((int)v)));
                        public class Geotrellis_raster_vectorize_Vectorize$ToVectorCallback$1
                        implements Function2.mcVII.sp {
                            private final Polygonizer polyizer;
                            private final Tile r;
                            private final int v;
                            private final scala.collection.mutable.Map<Object, Tuple2<Object, Object>> geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts;

                            public boolean apply$mcZDD$sp(double v1, double v2) {
                                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
                            }

                            public double apply$mcDDD$sp(double v1, double v2) {
                                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
                            }

                            public float apply$mcFDD$sp(double v1, double v2) {
                                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
                            }

                            public int apply$mcIDD$sp(double v1, double v2) {
                                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
                            }

                            public long apply$mcJDD$sp(double v1, double v2) {
                                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
                            }

                            public void apply$mcVDD$sp(double v1, double v2) {
                                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
                            }

                            public boolean apply$mcZDI$sp(double v1, int v2) {
                                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
                            }

                            public double apply$mcDDI$sp(double v1, int v2) {
                                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
                            }

                            public float apply$mcFDI$sp(double v1, int v2) {
                                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
                            }

                            public int apply$mcIDI$sp(double v1, int v2) {
                                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
                            }

                            public long apply$mcJDI$sp(double v1, int v2) {
                                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
                            }

                            public void apply$mcVDI$sp(double v1, int v2) {
                                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
                            }

                            public boolean apply$mcZDJ$sp(double v1, long v2) {
                                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
                            }

                            public double apply$mcDDJ$sp(double v1, long v2) {
                                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
                            }

                            public float apply$mcFDJ$sp(double v1, long v2) {
                                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
                            }

                            public int apply$mcIDJ$sp(double v1, long v2) {
                                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
                            }

                            public long apply$mcJDJ$sp(double v1, long v2) {
                                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
                            }

                            public void apply$mcVDJ$sp(double v1, long v2) {
                                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
                            }

                            public boolean apply$mcZID$sp(int v1, double v2) {
                                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
                            }

                            public double apply$mcDID$sp(int v1, double v2) {
                                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
                            }

                            public float apply$mcFID$sp(int v1, double v2) {
                                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
                            }

                            public int apply$mcIID$sp(int v1, double v2) {
                                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
                            }

                            public long apply$mcJID$sp(int v1, double v2) {
                                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
                            }

                            public void apply$mcVID$sp(int v1, double v2) {
                                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
                            }

                            public boolean apply$mcZII$sp(int v1, int v2) {
                                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
                            }

                            public double apply$mcDII$sp(int v1, int v2) {
                                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
                            }

                            public float apply$mcFII$sp(int v1, int v2) {
                                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
                            }

                            public int apply$mcIII$sp(int v1, int v2) {
                                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
                            }

                            public long apply$mcJII$sp(int v1, int v2) {
                                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
                            }

                            public boolean apply$mcZIJ$sp(int v1, long v2) {
                                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
                            }

                            public double apply$mcDIJ$sp(int v1, long v2) {
                                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
                            }

                            public float apply$mcFIJ$sp(int v1, long v2) {
                                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
                            }

                            public int apply$mcIIJ$sp(int v1, long v2) {
                                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
                            }

                            public long apply$mcJIJ$sp(int v1, long v2) {
                                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
                            }

                            public void apply$mcVIJ$sp(int v1, long v2) {
                                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
                            }

                            public boolean apply$mcZJD$sp(long v1, double v2) {
                                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
                            }

                            public double apply$mcDJD$sp(long v1, double v2) {
                                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
                            }

                            public float apply$mcFJD$sp(long v1, double v2) {
                                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
                            }

                            public int apply$mcIJD$sp(long v1, double v2) {
                                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
                            }

                            public long apply$mcJJD$sp(long v1, double v2) {
                                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
                            }

                            public void apply$mcVJD$sp(long v1, double v2) {
                                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
                            }

                            public boolean apply$mcZJI$sp(long v1, int v2) {
                                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
                            }

                            public double apply$mcDJI$sp(long v1, int v2) {
                                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
                            }

                            public float apply$mcFJI$sp(long v1, int v2) {
                                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
                            }

                            public int apply$mcIJI$sp(long v1, int v2) {
                                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
                            }

                            public long apply$mcJJI$sp(long v1, int v2) {
                                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
                            }

                            public void apply$mcVJI$sp(long v1, int v2) {
                                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
                            }

                            public boolean apply$mcZJJ$sp(long v1, long v2) {
                                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
                            }

                            public double apply$mcDJJ$sp(long v1, long v2) {
                                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
                            }

                            public float apply$mcFJJ$sp(long v1, long v2) {
                                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
                            }

                            public int apply$mcIJJ$sp(long v1, long v2) {
                                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
                            }

                            public long apply$mcJJJ$sp(long v1, long v2) {
                                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
                            }

                            public void apply$mcVJJ$sp(long v1, long v2) {
                                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
                            }

                            public Function1<Object, Function1<Object, BoxedUnit>> curried() {
                                return Function2.curried$((Function2)this);
                            }

                            public Function1<Tuple2<Object, Object>, BoxedUnit> tupled() {
                                return Function2.tupled$((Function2)this);
                            }

                            public String toString() {
                                return Function2.toString$((Function2)this);
                            }

                            public Polygonizer polyizer() {
                                return this.polyizer;
                            }

                            public Tile r() {
                                return this.r;
                            }

                            public int v() {
                                return this.v;
                            }

                            public scala.collection.mutable.Map<Object, Tuple2<Object, Object>> geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts() {
                                return this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts;
                            }

                            public Iterable<LinearRing> linearRings() {
                                return (Iterable)this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts().keys().map((Function1 & Serializable & scala.Serializable)k -> Geotrellis_raster_vectorize_Vectorize$ToVectorCallback$1.$anonfun$linearRings$1(this, BoxesRunTime.unboxToInt((Object)k)), Iterable$.MODULE$.canBuildFrom());
                            }

                            public void apply(int col, int row) {
                                this.apply$mcVII$sp(col, row);
                            }

                            public void apply$mcVII$sp(int col, int row) {
                                block1: {
                                    int innerV;
                                    block2: {
                                        innerV = this.r().get(col, row);
                                        if (innerV == this.v()) break block1;
                                        if (!this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts().contains((Object)BoxesRunTime.boxToInteger((int)innerV))) break block2;
                                        Tuple2 tuple2 = (Tuple2)this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts().apply((Object)BoxesRunTime.boxToInteger((int)innerV));
                                        if (tuple2 == null) {
                                            throw new MatchError((Object)tuple2);
                                        }
                                        int pcol = tuple2._1$mcI$sp();
                                        int prow = tuple2._2$mcI$sp();
                                        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(pcol, prow);
                                        Tuple2.mcII.sp sp3 = sp2;
                                        int pcol2 = sp3._1$mcI$sp();
                                        int prow2 = sp3._2$mcI$sp();
                                        if (col >= pcol2 && (col != pcol2 || row >= prow2)) break block1;
                                        this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts().update((Object)BoxesRunTime.boxToInteger((int)innerV), (Object)new Tuple2.mcII.sp(col, row));
                                        break block1;
                                    }
                                    this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts().update((Object)BoxesRunTime.boxToInteger((int)innerV), (Object)new Tuple2.mcII.sp(col, row));
                                }
                            }

                            public static final /* synthetic */ LinearRing $anonfun$linearRings$1(Geotrellis_raster_vectorize_Vectorize$ToVectorCallback$1 $this, int k) {
                                return $this.polyizer().getLinearRing(k, (Tuple2<Object, Object>)((Tuple2)$this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts().apply((Object)BoxesRunTime.boxToInteger((int)k))));
                            }

                            public Geotrellis_raster_vectorize_Vectorize$ToVectorCallback$1(Polygonizer polyizer, Tile r, int v) {
                                this.polyizer = polyizer;
                                this.r = r;
                                this.v = v;
                                Function2.$init$((Function2)this);
                                this.geotrellis$raster$vectorize$Vectorize$ToVectorCallback$$innerStarts = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$linearRings$1$adapted(geotrellis.raster.vectorize.Vectorize$ToVectorCallback$1 java.lang.Object )}, serializedLambda);
                            }
                        }
                        Geotrellis_raster_vectorize_Vectorize$ToVectorCallback$1 callback = new Geotrellis_raster_vectorize_Vectorize$ToVectorCallback$1(polyizer, r, v);
                        package.withGeometryRasterizeMethods qual$1 = package$.MODULE$.withGeometryRasterizeMethods(shellPoly.geom());
                        RasterExtent x$4 = rasterExtent;
                        Rasterizer.Options x$5 = qual$1.foreach$default$2();
                        Geotrellis_raster_vectorize_Vectorize$ToVectorCallback$1 x$6 = callback;
                        qual$1.foreach(x$4, x$5, (Function2<Object, Object, BoxedUnit>)x$6);
                        Iterable rings = (Iterable)callback.linearRings().map((Function1 & Serializable & scala.Serializable)jtsGeom -> new Line(jtsGeom), Iterable$.MODULE$.canBuildFrom());
                        if (rings.size() > 1) {
                            Option option = geotrellis.vector.package$.MODULE$.SeqPolygonExtensions((Traversable)rings.map((Function1 & Serializable & scala.Serializable)x$2 -> Polygon$.MODULE$.apply(x$2).buffer(0.0), Iterable$.MODULE$.canBuildFrom())).unionGeometries().asMultiPolygon();
                            if (!(option instanceof Some)) {
                                if (None$.MODULE$.equals(option)) {
                                    throw scala.sys.package$.MODULE$.error(new StringBuilder(46).append("Invalid geometries returned by polygon holes: ").append(geotrellis.vector.package$.MODULE$.SeqPolygonExtensions((Traversable)rings.map((Function1 & Serializable & scala.Serializable)exterior -> Polygon$.MODULE$.apply(exterior), Iterable$.MODULE$.canBuildFrom())).unionGeometries()).toString());
                                }
                                throw new MatchError((Object)option);
                            }
                            Some some = (Some)option;
                            MultiPolygon mp = (MultiPolygon)some.value();
                            scala.collection.immutable.Set set2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mp.polygons())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.exterior(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Line.class))))).toSet();
                            set = set2;
                        } else {
                            set = rings.toSet();
                        }
                        scala.collection.immutable.Set holes = set;
                        polygons.$plus$eq((Object)PolygonFeature$.MODULE$.apply(Polygon$.MODULE$.apply(new Line((LineString)shell), (GenTraversable)holes), rgr.regionMap().apply((Object)BoxesRunTime.boxToInteger((int)v))));
                        boxedUnit = processedValues.$plus$eq((Object)BoxesRunTime.boxToInteger((int)v));
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return polygons.toList();
    }

    public Connectivity apply$default$3() {
        return RegionGroupOptions$.MODULE$.default().connectivity();
    }

    private Vectorize$() {
        MODULE$ = this;
    }
}

