/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.viewshed;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import scala.Double$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.RichDouble$;
import scala.sys.package$;

public final class Viewshed$
implements Serializable {
    public static Viewshed$ MODULE$;

    static {
        new Viewshed$();
    }

    public Tile apply(Tile r, int startCol, int startRow) {
        Tuple2<Object, Object> tuple2 = r.dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(BitCellType$.MODULE$, cols2, rows2);
        double height = r.getDouble(startCol, startRow);
        Tile requiredHeights = this.offsets(r, startCol, startRow);
        for (int index$macro$676 = 0; index$macro$676 < rows2; ++index$macro$676) {
            for (int index$macro$675 = 0; index$macro$675 < cols2; ++index$macro$675) {
                if (height >= requiredHeights.getDouble(index$macro$675, index$macro$676) - 0.5) {
                    tile.set(index$macro$675, index$macro$676, 1);
                    continue;
                }
                tile.set(index$macro$675, index$macro$676, 0);
            }
        }
        return tile;
    }

    public Tile offsets(Tile r, int startCol, int startRow) {
        Tuple2<Object, Object> tuple2 = r.dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        if (startRow >= rows2 || startRow < 0 || startCol >= cols2 || startCol < 0) {
            throw package$.MODULE$.error("Point indices out of bounds");
        }
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(DoubleConstantNoDataCellType$.MODULE$, cols2, rows2);
        for (int index$macro$680 = 0; index$macro$680 < rows2; ++index$macro$680) {
            for (int index$macro$679 = 0; index$macro$679 < cols2; ++index$macro$679) {
                double height = r.getDouble(index$macro$679, index$macro$680);
                if (Double.isNaN(height)) {
                    tile.setDouble(index$macro$679, index$macro$680, Double.NaN);
                    continue;
                }
                double max = Double$.MODULE$.MinValue();
                if (startRow != index$macro$680) {
                    Tuple2.mcII.sp sp4;
                    Tuple2.mcII.sp sp5 = sp4 = startRow < index$macro$680 ? new Tuple2.mcII.sp(startRow + 1, index$macro$680) : new Tuple2.mcII.sp(index$macro$680 + 1, startRow);
                    if (sp4 == null) {
                        throw new MatchError((Object)sp4);
                    }
                    int rowMin = sp4._1$mcI$sp();
                    int rowMax = sp4._2$mcI$sp();
                    Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(rowMin, rowMax);
                    Tuple2.mcII.sp sp7 = sp6;
                    int rowMin2 = sp7._1$mcI$sp();
                    int rowMax2 = sp7._2$mcI$sp();
                    for (int index$macro$677 = rowMin2; index$macro$677 <= rowMax2; ++index$macro$677) {
                        double x = (double)(index$macro$677 - startRow) / (double)(index$macro$680 - startRow) * (double)(index$macro$679 - startCol) + (double)startCol;
                        int xInt = (int)x;
                        double z = RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(x)) ? r.getDouble(xInt, index$macro$677) : ((double)(xInt + 1) - x) * r.getDouble(xInt, index$macro$677) + (x - (double)xInt) * r.getDouble(xInt + 1, index$macro$677);
                        double requiredHeight = (double)(startRow - index$macro$680) / (double)(index$macro$677 - index$macro$680) * (z - height) + height;
                        if (!(requiredHeight > max)) continue;
                        max = requiredHeight;
                    }
                }
                if (startCol != index$macro$679) {
                    Tuple2.mcII.sp sp8;
                    Tuple2.mcII.sp sp9 = sp8 = startCol < index$macro$679 ? new Tuple2.mcII.sp(startCol + 1, index$macro$679) : new Tuple2.mcII.sp(index$macro$679 + 1, startCol);
                    if (sp8 == null) {
                        throw new MatchError((Object)sp8);
                    }
                    int colMin = sp8._1$mcI$sp();
                    int colMax = sp8._2$mcI$sp();
                    Tuple2.mcII.sp sp10 = new Tuple2.mcII.sp(colMin, colMax);
                    Tuple2.mcII.sp sp11 = sp10;
                    int colMin2 = sp11._1$mcI$sp();
                    int colMax2 = sp11._2$mcI$sp();
                    for (int index$macro$678 = colMin2; index$macro$678 <= colMax2; ++index$macro$678) {
                        double y = (double)(index$macro$678 - startCol) / (double)(index$macro$679 - startCol) * (double)(index$macro$680 - startRow) + (double)startRow;
                        int yInt = (int)y;
                        double z = RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(y)) ? r.getDouble(index$macro$678, yInt) : ((double)(yInt + 1) - y) * r.getDouble(index$macro$678, yInt) + (y - (double)yInt) * r.getDouble(index$macro$678, yInt + 1);
                        double requiredHeight = (double)(startCol - index$macro$679) / (double)(index$macro$678 - index$macro$679) * (z - height) + height;
                        if (!(requiredHeight > max)) continue;
                        max = requiredHeight;
                    }
                }
                tile.setDouble(index$macro$679, index$macro$680, max);
            }
        }
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Viewshed$() {
        MODULE$ = this;
    }
}

