/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileCombiner10;
import geotrellis.macros.DoubleTileCombiner3;
import geotrellis.macros.DoubleTileCombiner4;
import geotrellis.macros.DoubleTileCombiner5;
import geotrellis.macros.DoubleTileCombiner6;
import geotrellis.macros.DoubleTileCombiner7;
import geotrellis.macros.DoubleTileCombiner8;
import geotrellis.macros.DoubleTileCombiner9;
import geotrellis.macros.IntTileCombiner10;
import geotrellis.macros.IntTileCombiner3;
import geotrellis.macros.IntTileCombiner4;
import geotrellis.macros.IntTileCombiner5;
import geotrellis.macros.IntTileCombiner6;
import geotrellis.macros.IntTileCombiner7;
import geotrellis.macros.IntTileCombiner8;
import geotrellis.macros.IntTileCombiner9;
import geotrellis.raster.ArrayMultibandTile$;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.MacroMultibandCombiners;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015t!\u0002\u00192\u0011\u00031d!\u0002\u001d2\u0011\u0003I\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031\u0005BB#\u0002\t\u0003\u0011I\u0003\u0003\u0004F\u0003\u0011\u0005!1\u0007\u0005\b\u0005o\tA\u0011\u0001B\u001d\u0011\u001d\u0011)%\u0001C\u0001\u0005\u000fB\u0011B!\u0015\u0002\u0003\u0003%IAa\u0015\u0007\ta\n\u0004\u0001\u0013\u0005\t\u001f&\u0011\t\u0011)A\u0005!\")1)\u0003C\u0001-\"9\u0001,\u0003b\u0001\n\u0003I\u0006BB/\nA\u0003%!\fC\u0003_\u0013\u0011%q\fC\u0004f\u0013\t\u0007I\u0011\u00014\t\r9L\u0001\u0015!\u0003h\u0011\u001dy\u0017B1A\u0005\u0002eCa\u0001]\u0005!\u0002\u0013Q\u0006bB9\n\u0005\u0004%\t!\u0017\u0005\u0007e&\u0001\u000b\u0011\u0002.\t\u000bMLA\u0011\u0001;\t\u000bULA\u0011\u0001<\t\u000beLA\u0011\u0001>\t\u000f\u0005\r\u0011\u0002\"\u0001\u0002\u0006!9\u00111B\u0005\u0005\u0002\u00055\u0001bBA\u0010\u0013\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003KIA\u0011AA\u0014\u0011\u001d\tY%\u0003C\u0001\u0003\u001bBq!!\n\n\t\u0003\t9\u0006C\u0004\u0002L%!\t!a\u0017\t\u000f\u0005\u0015\u0012\u0002\"\u0001\u0002`!9\u00111J\u0005\u0005\u0002\u0005=\u0004bBA=\u0013\u0011\u0005\u00111\u0010\u0005\b\u0003\u0003KA\u0011AAB\u0011\u001d\tI(\u0003C\u0001\u0003\u0013Cq!!!\n\t\u0003\t\u0019\nC\u0004\u0002z%!\t!!(\t\u000f\u0005\u0005\u0015\u0002\"\u0001\u0002&\"9\u0011QV\u0005\u0005\u0002\u0005=\u0006bBA]\u0013\u0011\u0005\u00111\u0018\u0005\b\u0003[KA\u0011AAd\u0011\u001d\ti+\u0003C\u0001\u0003\u001bDq!!/\n\t\u0003\tI\u000eC\u0004\u0002:&!\t!!:\t\u000f\u0005E\u0018\u0002\"\u0001\u0002t\"9\u0011\u0011`\u0005\u0005B\u0005m\bb\u0002B\u0007\u0013\u0011\u0005#qB\u0001\u0013\u0003J\u0014\u0018-_'vYRL'-\u00198e)&dWM\u0003\u00023g\u00051!/Y:uKJT\u0011\u0001N\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003o\u0005i\u0011!\r\u0002\u0013\u0003J\u0014\u0018-_'vYRL'-\u00198e)&dWmE\u0002\u0002u\u0001\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA\u001eB\u0013\t\u0011EH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002m\u0005)\u0011\r\u001d9msR\u0019qI!\t\u0011\u0005]J1cA\u0005J\u0019B\u0011qGS\u0005\u0003\u0017F\u0012Q\"T;mi&\u0014\u0017M\u001c3US2,\u0007CA\u001cN\u0013\tq\u0015GA\fNC\u000e\u0014x.T;mi&\u0014\u0017M\u001c3D_6\u0014\u0017N\\3sg\u00061qLY1oIN\u00042aO)T\u0013\t\u0011FHA\u0003BeJ\f\u0017\u0010\u0005\u00028)&\u0011Q+\r\u0002\u0005)&dW\r\u0006\u0002H/\")qj\u0003a\u0001!\u0006I!-\u00198e\u0007>,h\u000e^\u000b\u00025B\u00111hW\u0005\u00039r\u00121!\u00138u\u0003)\u0011\u0017M\u001c3D_VtG\u000fI\u0001\rm\u0006d\u0017\u000eZ1uK\n\u000bg\u000e\u001a\u000b\u0003A\u000e\u0004\"aO1\n\u0005\td$\u0001B+oSRDQ\u0001\u001a\bA\u0002i\u000b\u0011![\u0001\tG\u0016dG\u000eV=qKV\tq\r\u0005\u0002iW:\u0011q'[\u0005\u0003UF\nq\u0001]1dW\u0006<W-\u0003\u0002m[\nA1)\u001a7m)f\u0004XM\u0003\u0002kc\u0005I1-\u001a7m)f\u0004X\rI\u0001\u0005G>d7/A\u0003d_2\u001c\b%\u0001\u0003s_^\u001c\u0018!\u0002:poN\u0004\u0013a\u0003;p\u0003J\u0014\u0018-\u001f+jY\u0016$\u0012aR\u0001\u0005E\u0006tG\r\u0006\u0002To\")\u0001P\u0006a\u00015\u0006I!-\u00198e\u0013:$W\r_\u0001\u0006E\u0006tGm]\u000b\u0002wB\u0019AP`*\u000f\u0005mj\u0018B\u00016=\u0013\ry\u0018\u0011\u0001\u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0005)d\u0014aB2p]Z,'\u000f\u001e\u000b\u0004\u0013\u0006\u001d\u0001BBA\u00051\u0001\u0007q-A\u0006oK^\u001cU\r\u001c7UsB,\u0017AC<ji\"tu\u000eR1uCR\u0019\u0011*a\u0004\t\u000f\u0005E\u0011\u00041\u0001\u0002\u0014\u0005Yan\u001c#bi\u00064\u0016\r\\;f!\u0015Y\u0014QCA\r\u0013\r\t9\u0002\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007m\nY\"C\u0002\u0002\u001eq\u0012a\u0001R8vE2,\u0017aC5oi\u0016\u0014\bO]3u\u0003N$2!SA\u0012\u0011\u0019\tIA\u0007a\u0001O\u0006\u0019Q.\u00199\u0015\t\u0005%\u0012Q\u0007\u000b\u0004\u0013\u0006-\u0002bBA\u00177\u0001\u0007\u0011qF\u0001\u0002MB11(!\r[5jK1!a\r=\u0005%1UO\\2uS>t'\u0007C\u0004\u00028m\u0001\r!!\u000f\u0002\rM,(m]3u!\u0015\tY$a\u0012[\u001d\r\ti$ \b\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111I\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0014\u0002BA%\u0003\u0003\u00111aU3r\u0003%i\u0017\r\u001d#pk\ndW\r\u0006\u0003\u0002P\u0005UCcA%\u0002R!9\u0011Q\u0006\u000fA\u0002\u0005M\u0003\u0003C\u001e\u00022i\u000bI\"!\u0007\t\u000f\u0005]B\u00041\u0001\u0002:Q\u0019\u0011*!\u0017\t\u000f\u00055R\u00041\u0001\u00020Q\u0019\u0011*!\u0018\t\u000f\u00055b\u00041\u0001\u0002TQ!\u0011\u0011MA6)\rI\u00151\r\u0005\b\u0003[y\u0002\u0019AA3!\u0015Y\u0014q\r.[\u0013\r\tI\u0007\u0010\u0002\n\rVt7\r^5p]FBa!!\u001c \u0001\u0004Q\u0016A\u000121)\u0011\t\t(a\u001e\u0015\u0007%\u000b\u0019\bC\u0004\u0002.\u0001\u0002\r!!\u001e\u0011\u000fm\n9'!\u0007\u0002\u001a!1\u0011Q\u000e\u0011A\u0002i\u000bqAZ8sK\u0006\u001c\u0007\u000eF\u0002a\u0003{Bq!!\f\"\u0001\u0004\ty\b\u0005\u0004<\u0003cQ&\fY\u0001\u000eM>\u0014X-Y2i\t>,(\r\\3\u0015\u0007\u0001\f)\tC\u0004\u0002.\t\u0002\r!a\"\u0011\u000fm\n\tDWA\rAR!\u00111RAI)\r\u0001\u0017Q\u0012\u0005\b\u0003[\u0019\u0003\u0019AAH!\u0015Y\u0014q\r.a\u0011\u0019\tig\ta\u00015R!\u0011QSAN)\r\u0001\u0017q\u0013\u0005\b\u0003[!\u0003\u0019AAM!\u0019Y\u0014qMA\rA\"1\u0011Q\u000e\u0013A\u0002i#2\u0001YAP\u0011\u001d\ti#\na\u0001\u0003C\u0003baOA4\u0003G\u0003\u0007cA\u001eR5R\u0019\u0001-a*\t\u000f\u00055b\u00051\u0001\u0002*B11(a\u001a\u0002,\u0002\u0004BaO)\u0002\u001a\u000591m\\7cS:,G\u0003BAY\u0003o#2aUAZ\u0011\u001d\tic\na\u0001\u0003k\u0003baOA4\u0003sQ\u0006bBA\u001cO\u0001\u0007\u0011\u0011H\u0001\u000eG>l'-\u001b8f\t>,(\r\\3\u0015\t\u0005u\u0016Q\u0019\u000b\u0004'\u0006}\u0006bBA\u0017Q\u0001\u0007\u0011\u0011\u0019\t\bw\u0005\u001d\u00141YA\r!\u0019\tY$a\u0012\u0002\u001a!9\u0011q\u0007\u0015A\u0002\u0005eBcA*\u0002J\"9\u0011QF\u0015A\u0002\u0005-\u0007CB\u001e\u0002h\u0005\r&\f\u0006\u0004\u0002P\u0006M\u0017Q\u001b\u000b\u0004'\u0006E\u0007bBA\u0017U\u0001\u0007\u0011q\u0006\u0005\u0007\u0003[R\u0003\u0019\u0001.\t\r\u0005]'\u00061\u0001[\u0003\t\u0011\u0017\u0007\u0006\u0003\u0002\\\u0006\u0005\bcA\u001c\u0002^&\u0019\u0011q\\\u0019\u0003!5+H/\u00192mK\u0006\u0013(/Y=US2,\u0007bBA\u0017W\u0001\u0007\u00111\u001d\t\bw\u0005\u001d\u00141VA\r)\u0019\t9/!<\u0002pR\u00191+!;\t\u000f\u00055B\u00061\u0001\u0002lBI1(!\r\u0002\u001a\u0005e\u0011\u0011\u0004\u0005\u0007\u0003[b\u0003\u0019\u0001.\t\r\u0005]G\u00061\u0001[\u0003-\u0019XOY:fi\n\u000bg\u000eZ:\u0015\u0007\u001d\u000b)\u0010C\u0004\u0002x6\u0002\r!!\u000f\u0002\u0019\t\fg\u000eZ*fcV,gnY3\u0002\r\u0015\fX/\u00197t)\u0011\tiPa\u0001\u0011\u0007m\ny0C\u0002\u0003\u0002q\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0003\u00069\u0002\rAa\u0002\u0002\u000b=$\b.\u001a:\u0011\u0007m\u0012I!C\u0002\u0003\fq\u00121!\u00118z\u0003!!xn\u0015;sS:<GC\u0001B\t!\u0011\u0011\u0019Ba\u0007\u000f\t\tU!q\u0003\t\u0004\u0003\u007fa\u0014b\u0001B\ry\u00051\u0001K]3eK\u001aLAA!\b\u0003 \t11\u000b\u001e:j]\u001eT1A!\u0007=\u0011\u0019I8\u00011\u0001\u0003$A!1H!\nT\u0013\r\u00119\u0003\u0010\u0002\u000byI,\u0007/Z1uK\u0012tDcA$\u0003,!1\u0011\u0010\u0002a\u0001\u0005[\u0001R!a\u000f\u00030MKAA!\r\u0002\u0002\tYAK]1wKJ\u001c\u0018M\u00197f)\r9%Q\u0007\u0005\u0006s\u0016\u0001\r\u0001U\u0001\u0006C2dwn\u0019\u000b\n\u000f\nm\"q\bB!\u0005\u0007BaA!\u0010\u0007\u0001\u00049\u0017!\u0001;\t\u000be4\u0001\u0019\u0001.\t\u000b=4\u0001\u0019\u0001.\t\u000bE4\u0001\u0019\u0001.\u0002\u000b\u0015l\u0007\u000f^=\u0015\u0013\u001d\u0013IEa\u0013\u0003N\t=\u0003B\u0002B\u001f\u000f\u0001\u0007q\rC\u0003z\u000f\u0001\u0007!\fC\u0003p\u000f\u0001\u0007!\fC\u0003r\u000f\u0001\u0007!,A\u0006sK\u0006$'+Z:pYZ,GC\u0001B+!\u0011\u00119F!\u0019\u000e\u0005\te#\u0002\u0002B.\u0005;\nA\u0001\\1oO*\u0011!qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003d\te#AB(cU\u0016\u001cG\u000f")
public class ArrayMultibandTile
extends MultibandTile
implements MacroMultibandCombiners {
    private final Tile[] _bands;
    private final int bandCount;
    private final DataType cellType;
    private final int cols;
    private final int rows;

    public static ArrayMultibandTile empty(DataType dataType, int n, int n2, int n3) {
        return ArrayMultibandTile$.MODULE$.empty(dataType, n, n2, n3);
    }

    public static ArrayMultibandTile alloc(DataType dataType, int n, int n2, int n3) {
        return ArrayMultibandTile$.MODULE$.alloc(dataType, n, n2, n3);
    }

    public static ArrayMultibandTile apply(Tile[] tileArray) {
        return ArrayMultibandTile$.MODULE$.apply(tileArray);
    }

    public static ArrayMultibandTile apply(Traversable<Tile> traversable) {
        return ArrayMultibandTile$.MODULE$.apply(traversable);
    }

    public static ArrayMultibandTile apply(Seq<Tile> seq) {
        return ArrayMultibandTile$.MODULE$.apply(seq);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner3 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner3 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner4 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner4 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner5 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner5 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner6 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner6 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner7 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner7 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner8 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner8 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner9 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner9 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner10 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner10 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    private void validateBand(int i) {
        Predef$.MODULE$.assert(i < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Band index out of bounds. Band Count: ").append(this.bandCount()).append(" Requested Band Index: ").append(i).toString());
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public ArrayMultibandTile toArrayTile() {
        return this;
    }

    @Override
    public Tile band(int bandIndex) {
        if (bandIndex >= this.bandCount()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Band ").append(bandIndex).append(" does not exist").toString());
        }
        return this._bands[bandIndex];
    }

    @Override
    public Vector<Tile> bands() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._bands)).toVector();
    }

    @Override
    public MultibandTile convert(DataType newCellType) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        for (int index$macro$1 = 0; index$macro$1 < this.bandCount(); ++index$macro$1) {
            newBands[index$macro$1] = this.band(index$macro$1).convert(newCellType);
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile withNoData(Option<Object> noDataValue) {
        return new ArrayMultibandTile((Tile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._bands)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.withNoData(noDataValue), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class))));
    }

    @Override
    public MultibandTile interpretAs(DataType newCellType) {
        return new ArrayMultibandTile((Tile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._bands)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.interpretAs(newCellType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class))));
    }

    @Override
    public MultibandTile map(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        Set set = subset.toSet();
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> {
            newBands$1[b] = set.contains((Object)BoxesRunTime.boxToInteger((int)b)) ? this.band(b).map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> f.apply$mcIII$sp(b, z)) : this.band(b);
        });
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        Set set = subset.toSet();
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> {
            newBands$2[b] = set.contains((Object)BoxesRunTime.boxToInteger((int)b)) ? this.band(b).mapDouble((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> f.apply$mcDID$sp(b, z)) : this.band(b);
        });
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile map(Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef index$macro$1 = IntRef.create((int)0);
        while (index$macro$1.elem < this.bandCount()) {
            newBands[index$macro$1.elem] = this.band(index$macro$1.elem).map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> f.apply$mcIII$sp(index$macro$1$2.elem, z));
            ++index$macro$1.elem;
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef index$macro$1 = IntRef.create((int)0);
        while (index$macro$1.elem < this.bandCount()) {
            newBands[index$macro$1.elem] = this.band(index$macro$1.elem).mapDouble((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> f.apply$mcDID$sp(index$macro$1$3.elem, z));
            ++index$macro$1.elem;
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile map(int b0, Function1<Object, Object> f) {
        this.validateBand(b0);
        Tile[] newBands = (Tile[])this._bands.clone();
        newBands[b0] = this.band(b0).map(f);
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(int b0, Function1<Object, Object> f) {
        this.validateBand(b0);
        Tile[] newBands = (Tile[])this._bands.clone();
        newBands[b0] = this.band(b0).mapDouble(f);
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        IntRef index$macro$1 = IntRef.create((int)0);
        while (index$macro$1.elem < this.bandCount()) {
            this.band(index$macro$1.elem).foreach((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)z -> f.apply$mcVII$sp(index$macro$1$4.elem, z));
            ++index$macro$1.elem;
        }
    }

    @Override
    public void foreachDouble(Function2<Object, Object, BoxedUnit> f) {
        IntRef index$macro$1 = IntRef.create((int)0);
        while (index$macro$1.elem < this.bandCount()) {
            this.band(index$macro$1.elem).foreachDouble((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)z -> f.apply$mcVID$sp(index$macro$1$5.elem, z));
            ++index$macro$1.elem;
        }
    }

    @Override
    public void foreach(int b0, Function1<Object, BoxedUnit> f) {
        this.validateBand(b0);
        this.band(b0).foreach(f);
    }

    @Override
    public void foreachDouble(int b0, Function1<Object, BoxedUnit> f) {
        this.validateBand(b0);
        this.band(b0).foreachDouble(f);
    }

    @Override
    public void foreach(Function1<int[], BoxedUnit> f) {
        int i = 0;
        for (int index$macro$3 = 0; index$macro$3 < this.cols(); ++index$macro$3) {
            for (int index$macro$2 = 0; index$macro$2 < this.rows(); ++index$macro$2) {
                int[] bandValues = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
                for (int index$macro$1 = 0; index$macro$1 < this.bandCount(); ++index$macro$1) {
                    bandValues[index$macro$1] = ((Tile)this.bands().apply(index$macro$1)).get(index$macro$3, index$macro$2);
                }
                f.apply((Object)bandValues);
                ++i;
            }
        }
    }

    @Override
    public void foreachDouble(Function1<double[], BoxedUnit> f) {
        int i = 0;
        for (int index$macro$3 = 0; index$macro$3 < this.cols(); ++index$macro$3) {
            for (int index$macro$2 = 0; index$macro$2 < this.rows(); ++index$macro$2) {
                double[] bandValues = (double[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Double());
                for (int index$macro$1 = 0; index$macro$1 < this.bandCount(); ++index$macro$1) {
                    bandValues[index$macro$1] = ((Tile)this.bands().apply(index$macro$1)).getDouble(index$macro$3, index$macro$2);
                }
                f.apply((Object)bandValues);
                ++i;
            }
        }
    }

    @Override
    public Tile combine(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        int subsetSize = subset.size();
        int[] subsetArray = (int[])subset.toArray(ClassTag$.MODULE$.Int());
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] values = (int[])Array$.MODULE$.ofDim(subsetSize, ClassTag$.MODULE$.Int());
        for (int index$macro$3 = 0; index$macro$3 < this.rows(); ++index$macro$3) {
            for (int index$macro$2 = 0; index$macro$2 < this.cols(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < subsetSize; ++index$macro$1) {
                    values[index$macro$1] = this._bands[subsetArray[index$macro$1]].get(index$macro$2, index$macro$3);
                }
                result.set(index$macro$2, index$macro$3, BoxesRunTime.unboxToInt((Object)f.apply((Object)Predef$.MODULE$.wrapIntArray(values))));
            }
        }
        return result;
    }

    @Override
    public Tile combineDouble(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        int subsetSize = subset.size();
        int[] subsetArray = (int[])subset.toArray(ClassTag$.MODULE$.Int());
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        double[] values = (double[])Array$.MODULE$.ofDim(subsetSize, ClassTag$.MODULE$.Double());
        for (int index$macro$3 = 0; index$macro$3 < this.rows(); ++index$macro$3) {
            for (int index$macro$2 = 0; index$macro$2 < this.cols(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < subsetSize; ++index$macro$1) {
                    values[index$macro$1] = this._bands[subsetArray[index$macro$1]].getDouble(index$macro$2, index$macro$3);
                }
                result.setDouble(index$macro$2, index$macro$3, BoxesRunTime.unboxToDouble((Object)f.apply((Object)Predef$.MODULE$.wrapDoubleArray(values))));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Function1<int[], Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] arr = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
        for (int index$macro$3 = 0; index$macro$3 < this.rows(); ++index$macro$3) {
            for (int index$macro$2 = 0; index$macro$2 < this.cols(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < this.bandCount(); ++index$macro$1) {
                    arr[index$macro$1] = this.band(index$macro$1).get(index$macro$2, index$macro$3);
                }
                result.set(index$macro$2, index$macro$3, BoxesRunTime.unboxToInt((Object)f.apply((Object)arr)));
            }
        }
        return var2_2;
    }

    @Override
    public Tile combine(int b0, int b1, Function2<Object, Object, Object> f) {
        Tile band1 = this.band(b0);
        Tile band2 = this.band(b1);
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        for (int index$macro$2 = 0; index$macro$2 < this.rows(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols(); ++index$macro$1) {
                result.set(index$macro$1, index$macro$2, f.apply$mcIII$sp(band1.get(index$macro$1, index$macro$2), band2.get(index$macro$1, index$macro$2)));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableArrayTile combineDouble(Function1<double[], Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        double[] arr = (double[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Double());
        for (int index$macro$3 = 0; index$macro$3 < this.rows(); ++index$macro$3) {
            for (int index$macro$2 = 0; index$macro$2 < this.cols(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < this.bandCount(); ++index$macro$1) {
                    arr[index$macro$1] = this.band(index$macro$1).getDouble(index$macro$2, index$macro$3);
                }
                result.setDouble(index$macro$2, index$macro$3, BoxesRunTime.unboxToDouble((Object)f.apply((Object)arr)));
            }
        }
        return var2_2;
    }

    @Override
    public Tile combineDouble(int b0, int b1, Function2<Object, Object, Object> f) {
        Tile band1 = this.band(b0);
        Tile band2 = this.band(b1);
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] nArray = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
        for (int index$macro$2 = 0; index$macro$2 < this.rows(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols(); ++index$macro$1) {
                result.setDouble(index$macro$1, index$macro$2, f.apply$mcDDD$sp(band1.getDouble(index$macro$1, index$macro$2), band2.getDouble(index$macro$1, index$macro$2)));
            }
        }
        return result;
    }

    @Override
    public ArrayMultibandTile subsetBands(Seq<Object> bandSequence) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(bandSequence.size(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef i = IntRef.create((int)0);
        Predef$.MODULE$.require(bandSequence.size() <= this.bandCount());
        bandSequence.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            newBands$3[i$2.elem] = this.band(j);
            ++i$2.elem;
        });
        return new ArrayMultibandTile(newBands);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ArrayMultibandTile) {
            ArrayMultibandTile arrayMultibandTile = (ArrayMultibandTile)object;
            boolean result = this.bandCount() == arrayMultibandTile.bandCount();
            for (int index$macro$1 = 0; result && index$macro$1 < this.bandCount(); ++index$macro$1) {
                Tile tile = this.band(index$macro$1);
                Tile tile2 = arrayMultibandTile.band(index$macro$1);
                if (!(tile == null ? tile2 != null : !tile.equals(tile2))) continue;
                result = false;
            }
            bl = result;
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return new StringBuilder(23).append("ArrayMultibandTile(").append(this.cols()).append(",").append(this.rows()).append(",").append(this.bandCount()).append(",").append(this.cellType()).append(")").toString();
    }

    public ArrayMultibandTile(Tile[] _bands) {
        this._bands = _bands;
        MacroMultibandCombiners.$init$(this);
        this.bandCount = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_bands)).size();
        Predef$.MODULE$.assert(this.bandCount() > 0, (Function0 & Serializable & scala.Serializable)() -> "Band count must be greater than 0");
        this.cellType = _bands[0].cellType();
        this.cols = BoxesRunTime.unboxToInt(_bands[0].cols());
        this.rows = BoxesRunTime.unboxToInt(_bands[0].rows());
        IntRef index$macro$1 = IntRef.create((int)0);
        while (index$macro$1.elem < this.bandCount()) {
            DataType dataType = _bands[index$macro$1.elem].cellType();
            DataType dataType2 = this.cellType();
            Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Band ").append(index$macro$1$1.elem).append(" cell type does not match, ").append($this._bands[index$macro$1$1.elem].cellType()).append(" != ").append(this.cellType()).toString());
            Predef$.MODULE$.assert(BoxesRunTime.unboxToInt(_bands[index$macro$1.elem].cols()) == this.cols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Band ").append(index$macro$1$1.elem).append(" cols does not match, ").append($this._bands[index$macro$1$1.elem].cols()).append(" != ").append(this.cols()).toString());
            Predef$.MODULE$.assert(BoxesRunTime.unboxToInt(_bands[index$macro$1.elem].rows()) == this.rows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Band ").append(index$macro$1$1.elem).append(" rows does not match, ").append($this._bands[index$macro$1$1.elem].rows()).append(" != ").append(this.rows()).toString());
            ++index$macro$1.elem;
        }
    }
}

