/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CompositeTile;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.CroppedTile;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t-d!B\u0015+\u0003\u0003y\u0003\"\u0002\u001e\u0001\t\u0003Y\u0004\"B\u001f\u0001\t\u0003Y\u0004\"\u0002 \u0001\t\u0003y\u0004\"B%\u0001\r\u0003Q\u0005\"B*\u0001\r\u0003!\u0006\"B,\u0001\t\u0003A\u0006\"\u00023\u0001\t\u0003)\u0007\"\u00025\u0001\t\u0003I\u0007\"B8\u0001\t\u0003\u0001\b\"B;\u0001\t\u00031\b\"B=\u0001\t\u0003Q\b\"B?\u0001\t\u0003q\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t)\u0002\u0001C\u0001\u0003OAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00020\u0001!\t!a\u000f\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011Q\u000b\u0001\u0007\u0002\u0005]\u0003bBA/\u0001\u0019\u0005\u0011q\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a\u001e\u0001\r\u0003\tI\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003C\u0003A\u0011IAR\u000f\u001d\tYL\u000bE\u0001\u0003{3a!\u000b\u0016\t\u0002\u0005}\u0006B\u0002\u001e\u001f\t\u0003\t9\rC\u0004\u0002Jz!\t!a3\t\u000f\u0005}g\u0004\"\u0001\u0002b\"9\u0011\u0011\u001e\u0010\u0005\u0002\u0005-\bbBA+=\u0011\u0005\u0011q \u0005\b\u0003+rB\u0011\u0001B\b\u0011\u001d\t)F\bC\u0001\u0005KAq!!\u0016\u001f\t\u0003\u0011\u0019\u0004C\u0004\u0002Vy!\tA!\u0013\t\u0013\t]c$!A\u0005\n\te#!C!se\u0006LH+\u001b7f\u0015\tYC&\u0001\u0004sCN$XM\u001d\u0006\u0002[\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001\u0001\r\u001b\u0011\u0005E\u0012T\"\u0001\u0016\n\u0005MR#\u0001\u0002+jY\u0016\u0004\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001\u001f\u0011\u0005E\u0002\u0011a\u0003;p\u0003J\u0014\u0018-\u001f+jY\u0016\fqaY8om\u0016\u0014H\u000f\u0006\u0002=\u0001\")\u0011i\u0001a\u0001\u0005\u0006qA/\u0019:hKR\u001cU\r\u001c7UsB,\u0007CA\"G\u001d\t\tD)\u0003\u0002FU\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005!\u0019U\r\u001c7UsB,'BA#+\u0003)9\u0018\u000e\u001e5O_\u0012\u000bG/\u0019\u000b\u0003a-CQ\u0001\u0014\u0003A\u00025\u000b1B\\8ECR\fg+\u00197vKB\u0019QG\u0014)\n\u0005=3$AB(qi&|g\u000e\u0005\u00026#&\u0011!K\u000e\u0002\u0007\t>,(\r\\3\u0002\u0017%tG/\u001a:qe\u0016$\u0018i\u001d\u000b\u0003aUCQAV\u0003A\u0002\t\u000b1B\\3x\u0007\u0016dG\u000eV=qK\u00069am\u001c:fC\u000eDGCA-]!\t)$,\u0003\u0002\\m\t!QK\\5u\u0011\u0015if\u00011\u0001_\u0003\u00051\u0007\u0003B\u001b`CfK!\u0001\u0019\u001c\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u001bc\u0013\t\u0019gGA\u0002J]R\fQBZ8sK\u0006\u001c\u0007\u000eR8vE2,GCA-g\u0011\u0015iv\u00011\u0001h!\u0011)t\fU-\u0002#\u0019|'/Z1dQ&sGOV5tSR|'\u000f\u0006\u0002ZU\")1\u000e\u0003a\u0001Y\u00069a/[:ji>\u0014\bCA\"n\u0013\tq\u0007J\u0001\bJ]R$\u0016\u000e\\3WSNLGo\u001c:\u0002)\u0019|'/Z1dQ\u0012{WO\u00197f-&\u001c\u0018\u000e^8s)\tI\u0016\u000fC\u0003l\u0013\u0001\u0007!\u000f\u0005\u0002Dg&\u0011A\u000f\u0013\u0002\u0012\t>,(\r\\3US2,g+[:ji>\u0014\u0018aA7baR\u0011\u0001g\u001e\u0005\u0006;*\u0001\r\u0001\u001f\t\u0005k}\u000b\u0017-A\u0005nCB$u.\u001e2mKR\u0011\u0001g\u001f\u0005\u0006;.\u0001\r\u0001 \t\u0005k}\u0003\u0006+\u0001\u0007nCBLe\u000e^'baB,'\u000f\u0006\u00021\u007f\"9\u0011\u0011\u0001\u0007A\u0002\u0005\r\u0011AB7baB,'\u000fE\u0002D\u0003\u000bI1!a\u0002I\u00055Ie\u000e\u001e+jY\u0016l\u0015\r\u001d9fe\u0006yQ.\u00199E_V\u0014G.Z'baB,'\u000fF\u00021\u0003\u001bAq!!\u0001\u000e\u0001\u0004\ty\u0001E\u0002D\u0003#I1!a\u0005I\u0005A!u.\u001e2mKRKG.Z'baB,'/A\u0004d_6\u0014\u0017N\\3\u0015\t\u0005e\u00111\u0005\u000b\u0004y\u0005m\u0001BB/\u000f\u0001\u0004\ti\u0002\u0005\u00046\u0003?\t\u0017-Y\u0005\u0004\u0003C1$!\u0003$v]\u000e$\u0018n\u001c83\u0011\u0019\t)C\u0004a\u0001y\u0005)q\u000e\u001e5feR!\u0011\u0011FA\u0017)\r\u0001\u00141\u0006\u0005\u0007;>\u0001\r!!\b\t\r\u0005\u0015r\u00021\u00011\u00035\u0019w.\u001c2j]\u0016$u.\u001e2mKR!\u00111GA\u001d)\ra\u0014Q\u0007\u0005\u0007;B\u0001\r!a\u000e\u0011\rU\ny\u0002\u0015)Q\u0011\u0019\t)\u0003\u0005a\u0001yQ!\u0011QHA!)\r\u0001\u0014q\b\u0005\u0007;F\u0001\r!a\u000e\t\r\u0005\u0015\u0012\u00031\u00011\u0003\u0019)\u0017/^1mgR!\u0011qIA'!\r)\u0014\u0011J\u0005\u0004\u0003\u00172$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003K\u0011\u0002\u0019AA(!\r)\u0014\u0011K\u0005\u0004\u0003'2$aA!os\u0006)\u0011\r\u001d9msR\u0019\u0011-!\u0017\t\r\u0005m3\u00031\u0001b\u0003\u0005I\u0017aC1qa2LHi\\;cY\u0016$2\u0001UA1\u0011\u0019\tY\u0006\u0006a\u0001C\u0006\u0019q-\u001a;\u0015\u000b\u0005\f9'a\u001b\t\r\u0005%T\u00031\u0001b\u0003\r\u0019w\u000e\u001c\u0005\u0007\u0003[*\u0002\u0019A1\u0002\u0007I|w/A\u0005hKR$u.\u001e2mKR)\u0001+a\u001d\u0002v!1\u0011\u0011\u000e\fA\u0002\u0005Da!!\u001c\u0017\u0001\u0004\t\u0017\u0001B2paf,\u0012\u0001P\u0001\u0007i>d\u0015n\u001d;\u0016\u0005\u0005}\u0004#BAA\u0003\u000b\u000bgbA\u001b\u0002\u0004&\u0011QIN\u0005\u0005\u0003\u000f\u000bII\u0001\u0003MSN$(BA#7\u00031!x\u000eT5ti\u0012{WO\u00197f+\t\ty\tE\u0003\u0002\u0002\u0006\u0015\u0005+A\u0004u_\u0006\u0013(/Y=\u0015\u0005\u0005U\u0005\u0003B\u001b\u0002\u0018\u0006L1!!'7\u0005\u0015\t%O]1z\u00035!x.\u0011:sCf$u.\u001e2mKR\u0011\u0011q\u0014\t\u0005k\u0005]\u0005+\u0001\u0005u_N#(/\u001b8h)\t\t)\u000b\u0005\u0003\u0002(\u0006Uf\u0002BAU\u0003c\u00032!a+7\u001b\t\tiKC\u0002\u00020:\na\u0001\u0010:p_Rt\u0014bAAZm\u00051\u0001K]3eK\u001aLA!a.\u0002:\n11\u000b\u001e:j]\u001eT1!a-7\u0003%\t%O]1z)&dW\r\u0005\u00022=M!a$!15!\r)\u00141Y\u0005\u0004\u0003\u000b4$AB!osJ+g\r\u0006\u0002\u0002>\u0006)\u0011\r\u001c7pGRA\u0011QZAj\u0003/\fY\u000eE\u00022\u0003\u001fL1!!5+\u0005AiU\u000f^1cY\u0016\f%O]1z)&dW\r\u0003\u0004\u0002V\u0002\u0002\rAQ\u0001\u0002i\"1\u0011\u0011\u001c\u0011A\u0002\u0005\fAaY8mg\"1\u0011Q\u001c\u0011A\u0002\u0005\fAA]8xg\u0006)Q-\u001c9usRA\u0011QZAr\u0003K\f9\u000f\u0003\u0004\u0002V\u0006\u0002\rA\u0011\u0005\u0007\u00033\f\u0003\u0019A1\t\r\u0005u\u0017\u00051\u0001b\u0003%1'o\\7CsR,7\u000f\u0006\u0006\u0002N\u00065\u0018\u0011`A~\u0003{Dq!a<#\u0001\u0004\t\t0A\u0003csR,7\u000fE\u00036\u0003/\u000b\u0019\u0010E\u00026\u0003kL1!a>7\u0005\u0011\u0011\u0015\u0010^3\t\r\u0005U'\u00051\u0001C\u0011\u0019\tIN\ta\u0001C\"1\u0011Q\u001c\u0012A\u0002\u0005$\u0002B!\u0001\u0003\b\t-!Q\u0002\t\u0004c\t\r\u0011b\u0001B\u0003U\tY\")\u001f;f\u0007>t7\u000f^1oi:{G)\u0019;b\u0003J\u0014\u0018-\u001f+jY\u0016DqA!\u0003$\u0001\u0004\t\t0A\u0002beJDa!!7$\u0001\u0004\t\u0007BBAoG\u0001\u0007\u0011\r\u0006\u0005\u0003\u0012\t]!\u0011\u0005B\u0012!\r\t$1C\u0005\u0004\u0005+Q#\u0001H*i_J$8i\u001c8ti\u0006tGOT8ECR\f\u0017I\u001d:bsRKG.\u001a\u0005\b\u0005\u0013!\u0003\u0019\u0001B\r!\u0015)\u0014q\u0013B\u000e!\r)$QD\u0005\u0004\u0005?1$!B*i_J$\bBBAmI\u0001\u0007\u0011\r\u0003\u0004\u0002^\u0012\u0002\r!\u0019\u000b\t\u0005O\u0011iCa\f\u00032A\u0019\u0011G!\u000b\n\u0007\t-\"F\u0001\u000eJ]R\u001cuN\\:uC:$hj\u001c#bi\u0006\f%O]1z)&dW\rC\u0004\u0003\n\u0015\u0002\r!!&\t\r\u0005eW\u00051\u0001b\u0011\u0019\ti.\na\u0001CRA!Q\u0007B\u001e\u0005\u000b\u00129\u0005E\u00022\u0005oI1A!\u000f+\u0005q1En\\1u\u0007>t7\u000f^1oi:{G)\u0019;b\u0003J\u0014\u0018-\u001f+jY\u0016DqA!\u0003'\u0001\u0004\u0011i\u0004E\u00036\u0003/\u0013y\u0004E\u00026\u0005\u0003J1Aa\u00117\u0005\u00151En\\1u\u0011\u0019\tIN\na\u0001C\"1\u0011Q\u001c\u0014A\u0002\u0005$\u0002Ba\u0013\u0003R\tM#Q\u000b\t\u0004c\t5\u0013b\u0001B(U\tiBi\\;cY\u0016\u001cuN\\:uC:$hj\u001c#bi\u0006\f%O]1z)&dW\rC\u0004\u0003\n\u001d\u0002\r!a(\t\r\u0005ew\u00051\u0001b\u0011\u0019\tin\na\u0001C\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0006\u0005\u0003\u0003^\t\u001dTB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\t1\fgn\u001a\u0006\u0003\u0005K\nAA[1wC&!!\u0011\u000eB0\u0005\u0019y%M[3di\u0002")
public abstract class ArrayTile
extends Tile {
    public static MutableArrayTile fromBytes(byte[] byArray, DataType dataType, int n, int n2) {
        return ArrayTile$.MODULE$.fromBytes(byArray, dataType, n, n2);
    }

    public static MutableArrayTile empty(DataType dataType, int n, int n2) {
        return ArrayTile$.MODULE$.empty(dataType, n, n2);
    }

    public static MutableArrayTile alloc(DataType dataType, int n, int n2) {
        return ArrayTile$.MODULE$.alloc(dataType, n, n2);
    }

    @Override
    public ArrayTile toArrayTile() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayTile convert(DataType targetCellType) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        if (!this.cellType().isFloatingPoint()) {
            for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                    tile.set(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2));
                }
            }
        } else {
            for (int index$macro$4 = 0; index$macro$4 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$4) {
                for (int index$macro$3 = 0; index$macro$3 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$3) {
                    tile.setDouble(index$macro$3, index$macro$4, this.getDouble(index$macro$3, index$macro$4));
                }
            }
        }
        return var2_2;
    }

    @Override
    public abstract Tile withNoData(Option<Object> var1);

    @Override
    public abstract Tile interpretAs(DataType var1);

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVI$sp(this.apply(i));
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVD$sp(this.applyDouble(i));
        }
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2));
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile output = ArrayTile$.MODULE$.alloc(this.cellType(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            output.update(i, f.apply$mcII$sp(this.apply(i)));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var3_3;
        int len = BoxesRunTime.unboxToInt(this.size());
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        for (int i = 0; i < len; ++i) {
            tile.updateDouble(i, f.apply$mcDD$sp(this.applyDouble(i)));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                tile.set(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                tile.setDouble(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile output = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            output.update(i, f.apply$mcIII$sp(this.apply(i), other.apply(i)));
        }
        return var3_3;
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        Tile tile;
        Tile tile2 = other;
        if (tile2 instanceof ArrayTile) {
            ArrayTile arrayTile = (ArrayTile)tile2;
            tile = this.combine(arrayTile, f);
        } else if (tile2 instanceof ConstantTile) {
            ConstantTile constantTile = (ConstantTile)tile2;
            tile = constantTile.combine(this, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcIII$sp(z2, z1));
        } else if (tile2 instanceof CompositeTile) {
            CompositeTile compositeTile = (CompositeTile)tile2;
            tile = compositeTile.combine(this, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcIII$sp(z2, z1));
        } else if (tile2 instanceof CroppedTile) {
            CroppedTile croppedTile = (CroppedTile)tile2;
            tile = croppedTile.combine(this, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcIII$sp(z2, z1));
        } else {
            tile = this.mapIntMapper(new IntTileMapper(null, f, tile2){
                private final Function2 f$1;
                private final Tile x1$1;

                public int apply(int col, int row, int z) {
                    return this.f$1.apply$mcIII$sp(z, this.x1$1.get(col, row));
                }
                {
                    this.f$1 = f$1;
                    this.x1$1 = x1$1;
                }
            });
        }
        return tile;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile output = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            output.updateDouble(i, f.apply$mcDDD$sp(this.applyDouble(i), other.applyDouble(i)));
        }
        return var3_3;
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        Tile tile;
        Tile tile2 = other;
        if (tile2 instanceof ArrayTile) {
            ArrayTile arrayTile = (ArrayTile)tile2;
            tile = this.combineDouble(arrayTile, f);
        } else if (tile2 instanceof ConstantTile) {
            ConstantTile constantTile = (ConstantTile)tile2;
            tile = constantTile.combineDouble(this, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcDDD$sp(z2, z1));
        } else if (tile2 instanceof CompositeTile) {
            CompositeTile compositeTile = (CompositeTile)tile2;
            tile = compositeTile.combineDouble(this, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcDDD$sp(z2, z1));
        } else {
            tile = this.mapDoubleMapper(new DoubleTileMapper(null, f, tile2){
                private final Function2 f$2;
                private final Tile x1$2;

                public double apply(int col, int row, double z) {
                    return this.f$2.apply$mcDDD$sp(z, this.x1$2.getDouble(col, row));
                }
                {
                    this.f$2 = f$2;
                    this.x1$2 = x1$2;
                }
            });
        }
        return tile;
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ArrayTile) {
            int i;
            ArrayTile arrayTile = (ArrayTile)object;
            if (arrayTile == null) {
                return false;
            }
            if (BoxesRunTime.unboxToInt(arrayTile.cols()) != BoxesRunTime.unboxToInt(this.cols()) || BoxesRunTime.unboxToInt(arrayTile.rows()) != BoxesRunTime.unboxToInt(this.rows())) {
                return false;
            }
            DataType dataType = arrayTile.cellType();
            DataType dataType2 = this.cellType();
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                return false;
            }
            if (this.cellType().isFloatingPoint()) {
                for (i = 0; i < BoxesRunTime.unboxToInt(this.size()); ++i) {
                    double value = this.applyDouble(i);
                    double otherValue = arrayTile.applyDouble(i);
                    if (!Double.isNaN(value) && !Double.isNaN(otherValue) && value != otherValue) {
                        return false;
                    }
                    if ((Double.isNaN(value) || !Double.isNaN(otherValue)) && (!Double.isNaN(value) || Double.isNaN(otherValue))) continue;
                    return false;
                }
            } else {
                while (i < BoxesRunTime.unboxToInt(this.size())) {
                    if (this.apply(i) != arrayTile.apply(i)) {
                        return false;
                    }
                    ++i;
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public abstract int apply(int var1);

    public abstract double applyDouble(int var1);

    @Override
    public int get(int col, int row) {
        return this.apply(row * BoxesRunTime.unboxToInt(this.cols()) + col);
    }

    @Override
    public double getDouble(int col, int row) {
        return this.applyDouble(row * BoxesRunTime.unboxToInt(this.cols()) + col);
    }

    public abstract ArrayTile copy();

    public List<Object> toList() {
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.toArray())).toList();
    }

    public List<Object> toListDouble() {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.toArrayDouble())).toList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray() {
        void var2_2;
        int len = BoxesRunTime.unboxToInt(this.size());
        int[] arr = (int[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Int());
        for (int i = 0; i < len; ++i) {
            arr[i] = this.apply(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArrayDouble() {
        void var2_2;
        int len = BoxesRunTime.unboxToInt(this.size());
        double[] arr = (double[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Double());
        for (int i = 0; i < len; ++i) {
            arr[i] = this.applyDouble(i);
        }
        return var2_2;
    }

    public String toString() {
        return new StringBuilder(13).append("ArrayTile(").append(this.cols()).append(",").append(this.rows()).append(",").append(this.cellType()).append(")").toString();
    }
}

