/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile;
import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0014)\u00056B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005{!AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\tE\t\u0015!\u0003G\u0011!Q\u0005A!f\u0001\n\u0003)\u0005\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002$\t\u000b1\u0003A\u0011A'\t\u000fI\u0003!\u0019!C\u0001'\"1q\u000b\u0001Q\u0001\nQCQ\u0001\u0017\u0001\u0005\u0002eCQ\u0001\u0018\u0001\u0005\u0002uCQ\u0001\u001a\u0001\u0005\u0002\u0015DQA\u001b\u0001\u0005\u0002-DQA\u001c\u0001\u0005B=DQ\u0001\u001f\u0001\u0005BeDQ\u0001 \u0001\u0005\u0002uDQA \u0001\u0005\u0002}Dq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u0013\u0005\u0015\u0002!!A\u0005B\u0005\u001d\u0002\u0002CA\u001d\u0001\u0005\u0005I\u0011A#\t\u0013\u0005m\u0002!!A\u0005\u0002\u0005u\u0002\"CA%\u0001\u0005\u0005I\u0011IA&\u0011%\tI\u0006AA\u0001\n\u0003\tY\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h\u001d9\u0011\u0011\u000e\u0015\t\u0002\u0005-dAB\u0014)\u0011\u0003\ti\u0007\u0003\u0004M7\u0011\u0005\u0011Q\u000f\u0005\u00079n!\t!a\u001e\t\r)\\B\u0011AAA\u0011\u001d\tIi\u0007C\u0001\u0003\u0017Cq!!%\u001c\t\u0003\t\u0019\nC\u0004\u0002\u001an!\t!a'\t\u000f\u0005e5\u0004\"\u0001\u0002&\"9\u0011QV\u000e\u0005\u0002\u0005=\u0006\u0002\u0003-\u001c\u0003\u0003%\t)!/\t\u0013\u0005\u00057$!A\u0005\u0002\u0006\r\u0007\"CAi7\u0005\u0005I\u0011BAj\u00051\u0011\u0015\u000e^!se\u0006LH+\u001b7f\u0015\tI#&\u0001\u0004sCN$XM\u001d\u0006\u0002W\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M!\u0001A\f\u001a9!\ty\u0003'D\u0001)\u0013\t\t\u0004F\u0001\tNkR\f'\r\\3BeJ\f\u0017\u0010V5mKB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9\u0001K]8ek\u000e$\bCA\u001a:\u0013\tQDG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003beJ\f\u00170F\u0001>!\r\u0019d\bQ\u0005\u0003\u007fQ\u0012Q!\u0011:sCf\u0004\"aM!\n\u0005\t#$\u0001\u0002\"zi\u0016\fa!\u0019:sCf\u0004\u0013\u0001B2pYN,\u0012A\u0012\t\u0003g\u001dK!\u0001\u0013\u001b\u0003\u0007%sG/A\u0003d_2\u001c\b%\u0001\u0003s_^\u001c\u0018!\u0002:poN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003O\u001fB\u000b\u0006CA\u0018\u0001\u0011\u0015Yt\u00011\u0001>\u0011\u0015!u\u00011\u0001G\u0011\u0015Qu\u00011\u0001G\u0003!\u0019W\r\u001c7UsB,W#\u0001+\u000f\u0005=*\u0016B\u0001,)\u0003-\u0011\u0015\u000e^\"fY2$\u0016\u0010]3\u0002\u0013\r,G\u000e\u001c+za\u0016\u0004\u0013!B1qa2LHC\u0001$[\u0011\u0015Y&\u00021\u0001G\u0003\u0005I\u0017AB;qI\u0006$X\rF\u0002_C\n\u0004\"aM0\n\u0005\u0001$$\u0001B+oSRDQaW\u0006A\u0002\u0019CQaY\u0006A\u0002\u0019\u000b\u0011A_\u0001\fCB\u0004H.\u001f#pk\ndW\r\u0006\u0002gSB\u00111gZ\u0005\u0003QR\u0012a\u0001R8vE2,\u0007\"B.\r\u0001\u00041\u0015\u0001D;qI\u0006$X\rR8vE2,Gc\u00010m[\")1,\u0004a\u0001\r\")1-\u0004a\u0001M\u0006\u0019Q.\u00199\u0015\u0005A\u001c\bCA\u0018r\u0013\t\u0011\bF\u0001\u0003US2,\u0007\"\u0002;\u000f\u0001\u0004)\u0018!\u00014\u0011\tM2hIR\u0005\u0003oR\u0012\u0011BR;oGRLwN\\\u0019\u0002\u00135\f\u0007\u000fR8vE2,GC\u00019{\u0011\u0015!x\u00021\u0001|!\u0011\u0019dO\u001a4\u0002\t\r|\u0007/_\u000b\u0002\u001d\u00069Ao\u001c\"zi\u0016\u001cH#A\u001f\u0002\u0015]LG\u000f\u001b(p\t\u0006$\u0018\rF\u0002q\u0003\u000bAq!a\u0002\u0013\u0001\u0004\tI!A\u0006o_\u0012\u000bG/\u0019,bYV,\u0007\u0003B\u001a\u0002\f\u0019L1!!\u00045\u0005\u0019y\u0005\u000f^5p]\u0006Y\u0011N\u001c;feB\u0014X\r^!t)\r\u0001\u00181\u0003\u0005\b\u0003+\u0019\u0002\u0019AA\f\u0003-qWm^\"fY2$\u0016\u0010]3\u0011\t\u0005e\u0011q\u0004\b\u0004_\u0005m\u0011bAA\u000fQ\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0011\u0003G\u0011\u0001bQ3mYRK\b/\u001a\u0006\u0004\u0003;A\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001\u00027b]\u001eT!!a\r\u0002\t)\fg/Y\u0005\u0005\u0003o\tiC\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty$!\u0012\u0011\u0007M\n\t%C\u0002\u0002DQ\u00121!\u00118z\u0011!\t9EFA\u0001\u0002\u00041\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002NA1\u0011qJA+\u0003\u007fi!!!\u0015\u000b\u0007\u0005MC'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0016\u0002R\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti&a\u0019\u0011\u0007M\ny&C\u0002\u0002bQ\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002Ha\t\t\u00111\u0001\u0002@\u0005A\u0001.Y:i\u0007>$W\rF\u0001G\u00031\u0011\u0015\u000e^!se\u0006LH+\u001b7f!\ty3d\u0005\u0003\u001c\u0003_B\u0004cA\u001a\u0002r%\u0019\u00111\u000f\u001b\u0003\r\u0005s\u0017PU3g)\t\tY\u0007F\u0004_\u0003s\ni(a \t\r\u0005mT\u00041\u0001>\u0003\r\t'O\u001d\u0005\u00067v\u0001\rA\u0012\u0005\u0006Gv\u0001\rA\u0012\u000b\b=\u0006\r\u0015QQAD\u0011\u0019\tYH\ba\u0001{!)1L\ba\u0001\r\")1M\ba\u0001M\u0006)qN\u001a#j[R)a*!$\u0002\u0010\")Ai\ba\u0001\r\")!j\ba\u0001\r\u0006)Q-\u001c9usR)a*!&\u0002\u0018\")A\t\ta\u0001\r\")!\n\ta\u0001\r\u0006!a-\u001b7m)\u001dq\u0015QTAQ\u0003GCa!a(\"\u0001\u00041\u0015!\u0001<\t\u000b\u0011\u000b\u0003\u0019\u0001$\t\u000b)\u000b\u0003\u0019\u0001$\u0015\u000f9\u000b9+!+\u0002,\"9\u0011q\u0014\u0012A\u0002\u0005u\u0003\"\u0002##\u0001\u00041\u0005\"\u0002&#\u0001\u00041\u0015!\u00034s_6\u0014\u0015\u0010^3t)\u001dq\u0015\u0011WA[\u0003oCa!a-$\u0001\u0004i\u0014!\u00022zi\u0016\u001c\b\"\u0002#$\u0001\u00041\u0005\"\u0002&$\u0001\u00041Ec\u0002(\u0002<\u0006u\u0016q\u0018\u0005\u0006w\u0011\u0002\r!\u0010\u0005\u0006\t\u0012\u0002\rA\u0012\u0005\u0006\u0015\u0012\u0002\rAR\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)-!4\u0011\u000bM\nY!a2\u0011\rM\nI-\u0010$G\u0013\r\tY\r\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005=W%!AA\u00029\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0007\u0003BA\u0016\u0003/LA!!7\u0002.\t1qJ\u00196fGR\u0004")
public final class BitArrayTile
extends MutableArrayTile
implements Product {
    private final byte[] array;
    private final int cols;
    private final int rows;
    private final BitCellType$ cellType;

    public static Option<Tuple3<byte[], Object, Object>> unapply(BitArrayTile bitArrayTile) {
        return BitArrayTile$.MODULE$.unapply(bitArrayTile);
    }

    public static BitArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return BitArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static BitArrayTile fill(boolean bl, int n, int n2) {
        return BitArrayTile$.MODULE$.fill(bl, n, n2);
    }

    public static BitArrayTile fill(int n, int n2, int n3) {
        return BitArrayTile$.MODULE$.fill(n, n2, n3);
    }

    public static BitArrayTile empty(int n, int n2) {
        return BitArrayTile$.MODULE$.empty(n, n2);
    }

    public static BitArrayTile ofDim(int n, int n2) {
        return BitArrayTile$.MODULE$.ofDim(n, n2);
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public BitCellType$ cellType() {
        return this.cellType;
    }

    @Override
    public int apply(int i) {
        return this.array()[i >> 3] >> (i & 7) & 1;
    }

    @Override
    public void update(int i, int z) {
        BitArrayTile$.MODULE$.update(this.array(), i, z);
    }

    @Override
    public double applyDouble(int i) {
        int n = this.apply(i);
        return n == Integer.MIN_VALUE ? Double.NaN : (double)n;
    }

    @Override
    public void updateDouble(int i, double z) {
        BitArrayTile$.MODULE$.updateDouble(this.array(), i, z);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        Tile tile;
        int f0 = f.apply$mcII$sp(0) & 1;
        int f1 = f.apply$mcII$sp(1) & 1;
        if (f0 == 0 && f1 == 0) {
            tile = new BitConstantTile(false, this.cols(), this.rows());
        } else if (f0 == 1 && f1 == 1) {
            tile = new BitConstantTile(true, this.cols(), this.rows());
        } else if (f0 == 0 && f1 == 1) {
            tile = this;
        } else {
            byte[] clone = (byte[])this.array().clone();
            int len = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.array())).size();
            for (int i = 0; i < len; ++i) {
                clone[i] = ~this.array()[i];
            }
            tile = new BitArrayTile(clone, this.cols(), this.rows());
        }
        return tile;
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return this.map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> {
            int n = z;
            double n2 = f.apply$mcDD$sp(n == Integer.MIN_VALUE ? Double.NaN : (double)n);
            return Double.isNaN(n2) ? Integer.MIN_VALUE : (int)n2;
        });
    }

    @Override
    public BitArrayTile copy() {
        return new BitArrayTile((byte[])this.array().clone(), this.cols(), this.rows());
    }

    @Override
    public byte[] toBytes() {
        return (byte[])this.array().clone();
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return new BitArrayTile(this.array(), this.cols(), this.rows());
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        DataType dataType = newCellType;
        if (dataType instanceof ByteCells) {
            ByteCells byteCells = (ByteCells)((Object)dataType);
            tile = ByteArrayTile$.MODULE$.apply(this.array(), this.cols(), this.rows(), byteCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public String productPrefix() {
        return "BitArrayTile";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.array();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitArrayTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.array()));
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public BitArrayTile(byte[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Product.$init$((Product)this);
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size() != (BoxesRunTime.unboxToInt(this.size()) + 7) / 8) {
            throw package$.MODULE$.error(new StringBuilder(40).append("BitArrayTile array length must be ").append((BoxesRunTime.unboxToInt(this.size()) + 7) / 8).append(", was ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size()).toString());
        }
        this.cellType = BitCellType$.MODULE$;
    }
}

