/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteCells;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteUserDefinedNoDataCellType;
import geotrellis.raster.CellTypeEncoding;
import geotrellis.raster.CellTypeEncoding$bool$;
import geotrellis.raster.CellTypeEncoding$float32$;
import geotrellis.raster.CellTypeEncoding$float32raw$;
import geotrellis.raster.CellTypeEncoding$float32ud$;
import geotrellis.raster.CellTypeEncoding$float64$;
import geotrellis.raster.CellTypeEncoding$float64raw$;
import geotrellis.raster.CellTypeEncoding$float64ud$;
import geotrellis.raster.CellTypeEncoding$int16$;
import geotrellis.raster.CellTypeEncoding$int16raw$;
import geotrellis.raster.CellTypeEncoding$int16ud$;
import geotrellis.raster.CellTypeEncoding$int32$;
import geotrellis.raster.CellTypeEncoding$int32raw$;
import geotrellis.raster.CellTypeEncoding$int32ud$;
import geotrellis.raster.CellTypeEncoding$int8$;
import geotrellis.raster.CellTypeEncoding$int8raw$;
import geotrellis.raster.CellTypeEncoding$int8ud$;
import geotrellis.raster.CellTypeEncoding$uint16$;
import geotrellis.raster.CellTypeEncoding$uint16raw$;
import geotrellis.raster.CellTypeEncoding$uint16ud$;
import geotrellis.raster.CellTypeEncoding$uint8$;
import geotrellis.raster.CellTypeEncoding$uint8raw$;
import geotrellis.raster.CellTypeEncoding$uint8ud$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.FloatCells;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatUserDefinedNoDataCellType;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortUserDefinedNoDataCellType;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteUserDefinedNoDataCellType;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import geotrellis.raster.WideIntNoData;
import geotrellis.raster.WidenedNoData;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class CellType$ {
    public static CellType$ MODULE$;
    private final Seq<DataType> noNoDataCellTypes;
    private final Seq<DataType> constantNoDataCellTypes;
    private final Seq<DataType> celltypes;

    static {
        new CellType$();
    }

    public DataType fromName(String name) {
        DataType dataType;
        String string = name;
        boolean bl = "bool".equals(string) ? true : "boolraw".equals(string);
        if (bl) {
            dataType = BitCellType$.MODULE$;
        } else if ("int8raw".equals(string)) {
            dataType = ByteCellType$.MODULE$;
        } else if ("uint8raw".equals(string)) {
            dataType = UByteCellType$.MODULE$;
        } else if ("int16raw".equals(string)) {
            dataType = ShortCellType$.MODULE$;
        } else if ("uint16raw".equals(string)) {
            dataType = UShortCellType$.MODULE$;
        } else if ("float32raw".equals(string)) {
            dataType = FloatCellType$.MODULE$;
        } else if ("float64raw".equals(string)) {
            dataType = DoubleCellType$.MODULE$;
        } else if ("int8".equals(string)) {
            dataType = ByteConstantNoDataCellType$.MODULE$;
        } else if ("uint8".equals(string)) {
            dataType = UByteConstantNoDataCellType$.MODULE$;
        } else if ("int16".equals(string)) {
            dataType = ShortConstantNoDataCellType$.MODULE$;
        } else if ("uint16".equals(string)) {
            dataType = UShortConstantNoDataCellType$.MODULE$;
        } else if ("int32".equals(string)) {
            dataType = IntConstantNoDataCellType$.MODULE$;
        } else if ("int32raw".equals(string)) {
            dataType = IntCellType$.MODULE$;
        } else if ("float32".equals(string)) {
            dataType = FloatConstantNoDataCellType$.MODULE$;
        } else if ("float64".equals(string)) {
            dataType = DoubleConstantNoDataCellType$.MODULE$;
        } else {
            Option<WidenedNoData> option = CellTypeEncoding$int8ud$.MODULE$.unapply(string);
            if (!option.isEmpty()) {
                WidenedNoData nd = (WidenedNoData)option.get();
                dataType = new ByteUserDefinedNoDataCellType((byte)nd.asInt());
            } else {
                Option<WidenedNoData> option2 = CellTypeEncoding$uint8ud$.MODULE$.unapply(string);
                if (!option2.isEmpty()) {
                    WidenedNoData nd = (WidenedNoData)option2.get();
                    dataType = new UByteUserDefinedNoDataCellType((byte)nd.asInt());
                } else {
                    Option<WidenedNoData> option3 = CellTypeEncoding$int16ud$.MODULE$.unapply(string);
                    if (!option3.isEmpty()) {
                        WidenedNoData nd = (WidenedNoData)option3.get();
                        dataType = new ShortUserDefinedNoDataCellType((short)nd.asInt());
                    } else {
                        Option<WidenedNoData> option4 = CellTypeEncoding$uint16ud$.MODULE$.unapply(string);
                        if (!option4.isEmpty()) {
                            WidenedNoData nd = (WidenedNoData)option4.get();
                            dataType = new UShortUserDefinedNoDataCellType((short)nd.asInt());
                        } else {
                            Option<WidenedNoData> option5 = CellTypeEncoding$int32ud$.MODULE$.unapply(string);
                            if (!option5.isEmpty()) {
                                WidenedNoData nd = (WidenedNoData)option5.get();
                                dataType = new IntUserDefinedNoDataCellType(nd.asInt());
                            } else {
                                Option<WidenedNoData> option6 = CellTypeEncoding$float32ud$.MODULE$.unapply(string);
                                if (!option6.isEmpty()) {
                                    WidenedNoData nd = (WidenedNoData)option6.get();
                                    dataType = Predef$.MODULE$.double2Double(nd.asDouble()).isNaN() ? FloatConstantNoDataCellType$.MODULE$ : new FloatUserDefinedNoDataCellType((float)nd.asDouble());
                                } else {
                                    Option<WidenedNoData> option7 = CellTypeEncoding$float64ud$.MODULE$.unapply(string);
                                    if (!option7.isEmpty()) {
                                        WidenedNoData nd = (WidenedNoData)option7.get();
                                        dataType = Predef$.MODULE$.double2Double(nd.asDouble()).isNaN() ? DoubleConstantNoDataCellType$.MODULE$ : new DoubleUserDefinedNoDataCellType(nd.asDouble());
                                    } else {
                                        throw new IllegalArgumentException(new StringBuilder(27).append("Cell type ").append(name).append(" is not supported").toString());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return dataType;
    }

    public String toName(DataType cellType) {
        Product product;
        DataType dataType = cellType;
        if (BitCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$bool$.MODULE$;
        } else if (ByteCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$int8raw$.MODULE$;
        } else if (UByteCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$uint8raw$.MODULE$;
        } else if (ShortCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$int16raw$.MODULE$;
        } else if (UShortCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$uint16raw$.MODULE$;
        } else if (IntCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$int32raw$.MODULE$;
        } else if (FloatCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$float32raw$.MODULE$;
        } else if (DoubleCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$float64raw$.MODULE$;
        } else if (ByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$int8$.MODULE$;
        } else if (UByteConstantNoDataCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$uint8$.MODULE$;
        } else if (ShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$int16$.MODULE$;
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$uint16$.MODULE$;
        } else if (IntConstantNoDataCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$int32$.MODULE$;
        } else if (FloatConstantNoDataCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$float32$.MODULE$;
        } else if (DoubleConstantNoDataCellType$.MODULE$.equals(dataType)) {
            product = CellTypeEncoding$float64$.MODULE$;
        } else if (dataType instanceof ByteUserDefinedNoDataCellType) {
            ByteUserDefinedNoDataCellType byteUserDefinedNoDataCellType = (ByteUserDefinedNoDataCellType)dataType;
            product = CellTypeEncoding$int8ud$.MODULE$.apply(BoxesRunTime.boxToInteger((int)byteUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.ByteIsIntegral$.MODULE$).asInt()));
        } else if (dataType instanceof UByteUserDefinedNoDataCellType) {
            UByteUserDefinedNoDataCellType uByteUserDefinedNoDataCellType = (UByteUserDefinedNoDataCellType)dataType;
            product = CellTypeEncoding$uint8ud$.MODULE$.apply(BoxesRunTime.boxToInteger((int)((WideIntNoData)uByteUserDefinedNoDataCellType.widenedNoData((Numeric)Numeric.ByteIsIntegral$.MODULE$)).asInt()));
        } else if (dataType instanceof ShortUserDefinedNoDataCellType) {
            ShortUserDefinedNoDataCellType shortUserDefinedNoDataCellType = (ShortUserDefinedNoDataCellType)dataType;
            product = CellTypeEncoding$int16ud$.MODULE$.apply(BoxesRunTime.boxToInteger((int)shortUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.ShortIsIntegral$.MODULE$).asInt()));
        } else if (dataType instanceof UShortUserDefinedNoDataCellType) {
            UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)dataType;
            product = CellTypeEncoding$uint16ud$.MODULE$.apply(BoxesRunTime.boxToInteger((int)((WideIntNoData)uShortUserDefinedNoDataCellType.widenedNoData((Numeric)Numeric.ShortIsIntegral$.MODULE$)).asInt()));
        } else if (dataType instanceof IntUserDefinedNoDataCellType) {
            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)dataType;
            product = CellTypeEncoding$int32ud$.MODULE$.apply(BoxesRunTime.boxToInteger((int)intUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.IntIsIntegral$.MODULE$).asInt()));
        } else if (dataType instanceof FloatUserDefinedNoDataCellType) {
            FloatUserDefinedNoDataCellType floatUserDefinedNoDataCellType = (FloatUserDefinedNoDataCellType)dataType;
            product = CellTypeEncoding$float32ud$.MODULE$.apply(BoxesRunTime.boxToDouble((double)floatUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.FloatIsFractional$.MODULE$).asDouble()));
        } else if (dataType instanceof DoubleUserDefinedNoDataCellType) {
            DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)dataType;
            product = CellTypeEncoding$float64ud$.MODULE$.apply(BoxesRunTime.boxToDouble((double)doubleUserDefinedNoDataCellType.widenedNoData((Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$).asDouble()));
        } else {
            throw new MatchError((Object)dataType);
        }
        CellTypeEncoding$bool$ encoding = product;
        return ((CellTypeEncoding.CellTypeEncoding)encoding).name();
    }

    public DataType fromAwtType(int awtType) {
        DataType dataType;
        int n = awtType;
        switch (n) {
            case 0: {
                dataType = UByteConstantNoDataCellType$.MODULE$;
                break;
            }
            case 2: {
                dataType = ShortConstantNoDataCellType$.MODULE$;
                break;
            }
            case 3: {
                dataType = IntConstantNoDataCellType$.MODULE$;
                break;
            }
            case 4: {
                dataType = FloatConstantNoDataCellType$.MODULE$;
                break;
            }
            case 5: {
                dataType = DoubleConstantNoDataCellType$.MODULE$;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(26).append("AWT type ").append(awtType).append(" is not supported").toString());
            }
        }
        return dataType;
    }

    public int toAwtType(DataType cellType) {
        int n;
        DataType dataType = cellType;
        if (dataType instanceof BitCells) {
            n = 0;
        } else if (dataType instanceof ByteCells) {
            n = 0;
        } else if (dataType instanceof UByteCells) {
            n = 0;
        } else if (dataType instanceof ShortCells) {
            n = 2;
        } else if (dataType instanceof UShortCells) {
            n = 2;
        } else if (dataType instanceof IntCells) {
            n = 3;
        } else if (dataType instanceof FloatCells) {
            n = 4;
        } else if (dataType instanceof DoubleCells) {
            n = 5;
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    public Seq<DataType> noNoDataCellTypes() {
        return this.noNoDataCellTypes;
    }

    public Seq<DataType> constantNoDataCellTypes() {
        return this.constantNoDataCellTypes;
    }

    public Seq<DataType> celltypes() {
        return this.celltypes;
    }

    private CellType$() {
        MODULE$ = this;
        this.noNoDataCellTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{BitCellType$.MODULE$, ByteCellType$.MODULE$, UByteCellType$.MODULE$, ShortCellType$.MODULE$, UShortCellType$.MODULE$, IntCellType$.MODULE$, FloatCellType$.MODULE$, DoubleCellType$.MODULE$}));
        this.constantNoDataCellTypes = (Seq)new .colon.colon((Object)ByteConstantNoDataCellType$.MODULE$, (List)new .colon.colon((Object)UByteConstantNoDataCellType$.MODULE$, (List)new .colon.colon((Object)ShortConstantNoDataCellType$.MODULE$, (List)new .colon.colon((Object)UShortConstantNoDataCellType$.MODULE$, (List)new .colon.colon((Object)IntConstantNoDataCellType$.MODULE$, (List)new .colon.colon((Object)FloatConstantNoDataCellType$.MODULE$, (List)new .colon.colon((Object)DoubleConstantNoDataCellType$.MODULE$, (List)Nil$.MODULE$)))))));
        this.celltypes = (Seq)this.noNoDataCellTypes().$plus$plus(this.constantNoDataCellTypes(), Seq$.MODULE$.canBuildFrom());
    }
}

