/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CompositeTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\rx!B\u001f?\u0011\u0003\u0019e!B#?\u0011\u00031\u0005\"\u0002)\u0002\t\u0003\t\u0006\"\u0002*\u0002\t\u0003\u0019\u0006b\u0002BO\u0003\u0011\u0005!q\u0014\u0005\b\u0005;\u000bA\u0011\u0001BU\u0011\u001d\u0011i*\u0001C\u0001\u0005kCqA!(\u0002\t\u0003\u0011Y\f\u0003\u0005S\u0003\u0005\u0005I\u0011\u0011Bb\u0011%\u0011I-AA\u0001\n\u0003\u0013Y\rC\u0005\u0003Z\u0006\t\t\u0011\"\u0003\u0003\\\u001a!QI\u0010!V\u0011!a6B!f\u0001\n\u0003i\u0006\u0002\u00036\f\u0005#\u0005\u000b\u0011\u00020\t\u0011-\\!Q3A\u0005\u00021D\u0001\u0002]\u0006\u0003\u0012\u0003\u0006I!\u001c\u0005\u0006!.!\t!\u001d\u0005\bi.\u0011\r\u0011\"\u0001v\u0011\u0019I8\u0002)A\u0005m\"9!p\u0003b\u0001\n\u0003)\bBB>\fA\u0003%a\u000fC\u0004}\u0017\t\u0007I\u0011B?\t\u000f\u0005\u00151\u0002)A\u0005}\"A\u0011qA\u0006C\u0002\u0013%Q\u000fC\u0004\u0002\n-\u0001\u000b\u0011\u0002<\t\u000f\u0005-1\u0002\"\u0003\u0002\u000e!I\u0011qC\u0006C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003OY\u0001\u0015!\u0003\u0002\u001c!9\u0011\u0011F\u0006\u0005\u0002\u0005-\u0002bBA\u0019\u0017\u0011\u0005\u00111\u0007\u0005\b\u0003\u000bZA\u0011AA$\u0011\u001d\tYe\u0003C\u0001\u0003\u001bBq!!\u0016\f\t\u0003\t9\u0006C\u0004\u0002V-!\t!a\u0018\t\u000f\u0005\r4\u0002\"\u0001\u0002f!9\u0011QN\u0006\u0005\u0002\u0005=\u0004bBA:\u0017\u0011\u0005\u0011Q\u000f\u0005\b\u0003\u007fZA\u0011AAA\u0011\u001d\tYi\u0003C\u0001\u0003\u001bCq!a%\f\t\u0003\t)\nC\u0004\u0002(.!\t!!+\t\u000f\u0005=6\u0002\"\u0001\u00022\"9\u0011QX\u0006\u0005\u0002\u0005}\u0006bBAe\u0017\u0011\u0005\u00111\u001a\u0005\b\u0003#\\A\u0011AAj\u0011\u001d\tIn\u0003C\u0001\u00037Dq!a:\f\t\u0003\tI\u000fC\u0004\u0002t.!\t!!>\t\u000f\t\u00151\u0002\"\u0001\u0003\b!9!\u0011C\u0006\u0005\u0002\tM\u0001\"\u0003B\u0013\u0017\u0005\u0005I\u0011\u0001B\u0014\u0011%\u0011icCI\u0001\n\u0003\u0011y\u0003C\u0005\u0003F-\t\n\u0011\"\u0001\u0003H!I!1J\u0006\u0002\u0002\u0013\u0005#Q\n\u0005\t\u0005;Z\u0011\u0011!C\u0001k\"I!qL\u0006\u0002\u0002\u0013\u0005!\u0011\r\u0005\n\u0005[Z\u0011\u0011!C!\u0005_B\u0011B! \f\u0003\u0003%\tAa \t\u0013\t%5\"!A\u0005B\t-\u0005\"\u0003BG\u0017\u0005\u0005I\u0011\tBH\u0011%\u0011\tjCA\u0001\n\u0003\u0012\u0019*A\u0007D_6\u0004xn]5uKRKG.\u001a\u0006\u0003\u007f\u0001\u000baA]1ti\u0016\u0014(\"A!\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0011\u0005\u0011\u000bQ\"\u0001 \u0003\u001b\r{W\u000e]8tSR,G+\u001b7f'\r\tq)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!s\u0015BA(J\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\t1)A\u0003baBd\u0017\u0010F\u0003U\u0005/\u0013Y\n\u0005\u0002E\u0017M!1BV-N!\t!u+\u0003\u0002Y}\t!A+\u001b7f!\tA%,\u0003\u0002\\\u0013\n9\u0001K]8ek\u000e$\u0018!\u0002;jY\u0016\u001cX#\u00010\u0011\u0007};gK\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111MQ\u0001\u0007yI|w\u000e\u001e \n\u0003)K!AZ%\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\u0004'\u0016\f(B\u00014J\u0003\u0019!\u0018\u000e\\3tA\u0005QA/\u001b7f\u0019\u0006Lx.\u001e;\u0016\u00035\u0004\"\u0001\u00128\n\u0005=t$A\u0003+jY\u0016d\u0015-_8vi\u0006YA/\u001b7f\u0019\u0006Lx.\u001e;!)\r!&o\u001d\u0005\u00069B\u0001\rA\u0018\u0005\u0006WB\u0001\r!\\\u0001\u0005G>d7/F\u0001w!\tAu/\u0003\u0002y\u0013\n\u0019\u0011J\u001c;\u0002\u000b\r|Gn\u001d\u0011\u0002\tI|wo]\u0001\u0006e><8\u000fI\u0001\ti&dW\rT5tiV\ta\u0010\u0005\u0003\u0000\u0003\u00031fB\u0001%f\u0013\r\t\u0019!\u001b\u0002\u0005\u0019&\u001cH/A\u0005uS2,G*[:uA\u0005AA/\u001b7f\u0007>d7/A\u0005uS2,7i\u001c7tA\u00059q-\u001a;US2,G#\u0002,\u0002\u0010\u0005M\u0001BBA\t3\u0001\u0007a/\u0001\u0003uG>d\u0007BBA\u000b3\u0001\u0007a/\u0001\u0003ue><\u0018\u0001C2fY2$\u0016\u0010]3\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Cq1\u0001RA\u0010\u0013\t1g(\u0003\u0003\u0002$\u0005\u0015\"\u0001C\"fY2$\u0016\u0010]3\u000b\u0005\u0019t\u0014!C2fY2$\u0016\u0010]3!\u0003\u001d\u0019wN\u001c<feR$2AVA\u0017\u0011\u001d\ty\u0003\ba\u0001\u00037\ta\u0002^1sO\u0016$8)\u001a7m)f\u0004X-\u0001\u0006xSRDgj\u001c#bi\u0006$2\u0001VA\u001b\u0011\u001d\t9$\ba\u0001\u0003s\t1B\\8ECR\fg+\u00197vKB)\u0001*a\u000f\u0002@%\u0019\u0011QH%\u0003\r=\u0003H/[8o!\rA\u0015\u0011I\u0005\u0004\u0003\u0007J%A\u0002#pk\ndW-A\u0006j]R,'\u000f\u001d:fi\u0006\u001bHc\u0001+\u0002J!9\u0011q\u0006\u0010A\u0002\u0005m\u0011a\u0003;p\u0003J\u0014\u0018-\u001f+jY\u0016$\"!a\u0014\u0011\u0007\u0011\u000b\t&C\u0002\u0002Ty\u0012\u0011\"\u0011:sCf$\u0016\u000e\\3\u0002\u000f5,H/\u00192mKR\u0011\u0011\u0011\f\t\u0004\t\u0006m\u0013bAA/}\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u000b\u0005\u00033\n\t\u0007C\u0004\u00020\u0005\u0002\r!a\u0007\u0002\u000fQ|\u0017I\u001d:bsR\u0011\u0011q\r\t\u0005\u0011\u0006%d/C\u0002\u0002l%\u0013Q!\u0011:sCf\fQ\u0002^8BeJ\f\u0017\u0010R8vE2,GCAA9!\u0015A\u0015\u0011NA \u0003\u001d!xNQ=uKN$\"!a\u001e\u0011\u000b!\u000bI'!\u001f\u0011\u0007!\u000bY(C\u0002\u0002~%\u0013AAQ=uK\u0006\u0019q-\u001a;\u0015\u000bY\f\u0019)a\"\t\r\u0005\u0015U\u00051\u0001w\u0003\r\u0019w\u000e\u001c\u0005\u0007\u0003\u0013+\u0003\u0019\u0001<\u0002\u0007I|w/A\u0005hKR$u.\u001e2mKR1\u0011qHAH\u0003#Ca!!\"'\u0001\u00041\bBBAEM\u0001\u0007a/A\u0004g_J,\u0017m\u00195\u0015\t\u0005]\u0015Q\u0014\t\u0004\u0011\u0006e\u0015bAAN\u0013\n!QK\\5u\u0011\u001d\tyj\na\u0001\u0003C\u000b\u0011A\u001a\t\u0007\u0011\u0006\rf/a&\n\u0007\u0005\u0015\u0016JA\u0005Gk:\u001cG/[8oc\u0005iam\u001c:fC\u000eDGi\\;cY\u0016$B!a&\u0002,\"9\u0011q\u0014\u0015A\u0002\u00055\u0006c\u0002%\u0002$\u0006}\u0012qS\u0001\u0012M>\u0014X-Y2i\u0013:$h+[:ji>\u0014H\u0003BAL\u0003gCq!!.*\u0001\u0004\t9,A\u0004wSNLGo\u001c:\u0011\t\u0005u\u0011\u0011X\u0005\u0005\u0003w\u000b)C\u0001\bJ]R$\u0016\u000e\\3WSNLGo\u001c:\u0002)\u0019|'/Z1dQ\u0012{WO\u00197f-&\u001c\u0018\u000e^8s)\u0011\t9*!1\t\u000f\u0005U&\u00061\u0001\u0002DB!\u0011QDAc\u0013\u0011\t9-!\n\u0003#\u0011{WO\u00197f)&dWMV5tSR|'/A\u0002nCB$2AVAg\u0011\u001d\tyj\u000ba\u0001\u0003\u001f\u0004R\u0001SARmZ\f\u0011\"\\1q\t>,(\r\\3\u0015\u0007Y\u000b)\u000eC\u0004\u0002 2\u0002\r!a6\u0011\u000f!\u000b\u0019+a\u0010\u0002@\u0005aQ.\u00199J]Rl\u0015\r\u001d9feR\u0019a+!8\t\u000f\u0005}W\u00061\u0001\u0002b\u00061Q.\u00199qKJ\u0004B!!\b\u0002d&!\u0011Q]A\u0013\u00055Ie\u000e\u001e+jY\u0016l\u0015\r\u001d9fe\u0006yQ.\u00199E_V\u0014G.Z'baB,'\u000fF\u0002W\u0003WDq!a8/\u0001\u0004\ti\u000f\u0005\u0003\u0002\u001e\u0005=\u0018\u0002BAy\u0003K\u0011\u0001\u0003R8vE2,G+\u001b7f\u001b\u0006\u0004\b/\u001a:\u0002\u000f\r|WNY5oKR!\u0011q\u001fB\u0001)\r1\u0016\u0011 \u0005\b\u0003?{\u0003\u0019AA~!\u0019A\u0015Q <wm&\u0019\u0011q`%\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004B\u0002B\u0002_\u0001\u0007a+A\u0003pi\",'/A\u0007d_6\u0014\u0017N\\3E_V\u0014G.\u001a\u000b\u0005\u0005\u0013\u0011y\u0001F\u0002W\u0005\u0017Aq!a(1\u0001\u0004\u0011i\u0001E\u0005I\u0003{\fy$a\u0010\u0002@!1!1\u0001\u0019A\u0002Y\u000b\u0011\"Y:dS&$%/Y<\u0015\u0005\tU\u0001\u0003\u0002B\f\u0005?qAA!\u0007\u0003\u001cA\u0011\u0011-S\u0005\u0004\u0005;I\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003\"\t\r\"AB*ue&twMC\u0002\u0003\u001e%\u000bAaY8qsR)AK!\u000b\u0003,!9AL\rI\u0001\u0002\u0004q\u0006bB63!\u0003\u0005\r!\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tDK\u0002_\u0005gY#A!\u000e\u0011\t\t]\"\u0011I\u0007\u0003\u0005sQAAa\u000f\u0003>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u007fI\u0015AC1o]>$\u0018\r^5p]&!!1\tB\u001d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IEK\u0002n\u0005g\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B(!\u0011\u0011\tFa\u0017\u000e\u0005\tM#\u0002\u0002B+\u0005/\nA\u0001\\1oO*\u0011!\u0011L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\"\tM\u0013\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005G\u0012I\u0007E\u0002I\u0005KJ1Aa\u001aJ\u0005\r\te.\u001f\u0005\t\u0005W:\u0014\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u001d\u0011\r\tM$\u0011\u0010B2\u001b\t\u0011)HC\u0002\u0003x%\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YH!\u001e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0003\u00139\tE\u0002I\u0005\u0007K1A!\"J\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\u001b:\u0003\u0003\u0005\rAa\u0019\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012A^\u0001\ti>\u001cFO]5oOR\u0011!qJ\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u0005%Q\u0013\u0005\n\u0005Wb\u0014\u0011!a\u0001\u0005GBaA!'\u0004\u0001\u00041\u0016\u0001\u0002;jY\u0016DQa[\u0002A\u00025\fAa\u001e:baR9AK!)\u0003$\n\u0015\u0006B\u0002BM\t\u0001\u0007a\u000b\u0003\u0004\u0002\b\u0011\u0001\rA\u001e\u0005\u0007\u0005O#\u0001\u0019\u0001<\u0002\u0011QLG.\u001a*poN$\u0012\u0002\u0016BV\u0005[\u0013yK!-\t\r\teU\u00011\u0001W\u0011\u0019\t9!\u0002a\u0001m\"1!qU\u0003A\u0002YDqAa-\u0006\u0001\u0004\u0011\t)A\u0004de>\u0004\b/\u001a3\u0015\u000bQ\u00139L!/\t\r\tee\u00011\u0001W\u0011\u0015Yg\u00011\u0001n)\u001d!&Q\u0018B`\u0005\u0003DaA!'\b\u0001\u00041\u0006\"B6\b\u0001\u0004i\u0007b\u0002BZ\u000f\u0001\u0007!\u0011\u0011\u000b\u0006)\n\u0015'q\u0019\u0005\u00069\"\u0001\rA\u0018\u0005\u0006W\"\u0001\r!\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iM!6\u0011\u000b!\u000bYDa4\u0011\u000b!\u0013\tNX7\n\u0007\tM\u0017J\u0001\u0004UkBdWM\r\u0005\t\u0005/L\u0011\u0011!a\u0001)\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0004BA!\u0015\u0003`&!!\u0011\u001dB*\u0005\u0019y%M[3di\u0002")
public class CompositeTile
extends Tile
implements Product {
    private final Seq<Tile> tiles;
    private final TileLayout tileLayout;
    private final int cols;
    private final int rows;
    private final List<Tile> tileList;
    private final int tileCols;
    private final DataType cellType;

    public static Option<Tuple2<Seq<Tile>, TileLayout>> unapply(CompositeTile compositeTile) {
        return CompositeTile$.MODULE$.unapply(compositeTile);
    }

    public static CompositeTile apply(Seq<Tile> seq, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.apply(seq, tileLayout);
    }

    public static CompositeTile wrap(Tile tile, TileLayout tileLayout, boolean bl) {
        return CompositeTile$.MODULE$.wrap(tile, tileLayout, bl);
    }

    public static CompositeTile wrap(Tile tile, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.wrap(tile, tileLayout);
    }

    public static CompositeTile wrap(Tile tile, int n, int n2, boolean bl) {
        return CompositeTile$.MODULE$.wrap(tile, n, n2, bl);
    }

    public static CompositeTile wrap(Tile tile, int n, int n2) {
        return CompositeTile$.MODULE$.wrap(tile, n, n2);
    }

    public static CompositeTile apply(Tile tile, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.apply(tile, tileLayout);
    }

    public Seq<Tile> tiles() {
        return this.tiles;
    }

    public TileLayout tileLayout() {
        return this.tileLayout;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    private List<Tile> tileList() {
        return this.tileList;
    }

    private int tileCols() {
        return this.tileCols;
    }

    private Tile getTile(int tcol, int trow) {
        return (Tile)this.tileList().apply(trow * this.tileCols() + tcol);
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    @Override
    public Tile convert(DataType targetCellType) {
        return this.mutable(targetCellType);
    }

    @Override
    public CompositeTile withNoData(Option<Object> noDataValue) {
        return new CompositeTile((Seq<Tile>)((Seq)this.tiles().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withNoData(noDataValue), Seq$.MODULE$.canBuildFrom())), this.tileLayout());
    }

    @Override
    public CompositeTile interpretAs(DataType targetCellType) {
        return new CompositeTile((Seq<Tile>)((Seq)this.tiles().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.interpretAs(targetCellType), Seq$.MODULE$.canBuildFrom())), this.tileLayout());
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return this.mutable(this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    public MutableArrayTile mutable(DataType targetCellType) {
        void var2_2;
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, this.cols(), this.rows());
        int n = this.cols() * this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        if (!this.cellType().isFloatingPoint()) {
            for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
                for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                    Tile sourceTile = this.getTile(index$macro$3, index$macro$4);
                    for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                        for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                            int acol = tileCols * index$macro$3 + index$macro$1;
                            int arow = tileRows * index$macro$4 + index$macro$2;
                            tile.set(acol, arow, sourceTile.get(index$macro$1, index$macro$2));
                        }
                    }
                }
            }
        } else {
            for (int index$macro$8 = 0; index$macro$8 < layoutRows; ++index$macro$8) {
                for (int index$macro$7 = 0; index$macro$7 < layoutCols; ++index$macro$7) {
                    Tile sourceTile = this.getTile(index$macro$7, index$macro$8);
                    for (int index$macro$6 = 0; index$macro$6 < tileRows; ++index$macro$6) {
                        for (int index$macro$5 = 0; index$macro$5 < tileCols; ++index$macro$5) {
                            int acol = tileCols * index$macro$7 + index$macro$5;
                            int arow = tileRows * index$macro$8 + index$macro$6;
                            tile.setDouble(acol, arow, sourceTile.getDouble(index$macro$5, index$macro$6));
                        }
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray() {
        void var1_1;
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        int[] arr = (int[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Int());
        int n = this.cols() * this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        int totalCols = layoutCols * tileCols;
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        arr[arow * totalCols + acol] = tile.get(index$macro$1, index$macro$2);
                    }
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArrayDouble() {
        void var1_1;
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        double[] arr = (double[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Double());
        int n = this.cols() * this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        int totalCols = layoutCols * tileCols;
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        arr[arow * totalCols + acol] = tile.getDouble(index$macro$1, index$macro$2);
                    }
                }
            }
        }
        return var1_1;
    }

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    @Override
    public int get(int col, int row) {
        int tcol = col / this.tileLayout().tileCols();
        int trow = row / this.tileLayout().tileRows();
        int pcol = col % this.tileLayout().tileCols();
        int prow = row % this.tileLayout().tileRows();
        return this.getTile(tcol, trow).get(pcol, prow);
    }

    @Override
    public double getDouble(int col, int row) {
        int tcol = col / this.tileLayout().tileCols();
        int trow = row / this.tileLayout().tileRows();
        int pcol = col % this.tileLayout().tileCols();
        int prow = row % this.tileLayout().tileRows();
        return this.getTile(tcol, trow).getDouble(pcol, prow);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        f.apply$mcVI$sp(tile.get(index$macro$1, index$macro$2));
                    }
                }
            }
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        f.apply$mcVD$sp(tile.getDouble(index$macro$1, index$macro$2));
                    }
                }
            }
        }
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        visitor.apply(acol, arow, tile.get(index$macro$1, index$macro$2));
                    }
                }
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        visitor.apply(acol, arow, tile.getDouble(index$macro$1, index$macro$2));
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        result.set(acol, arow, f.apply$mcII$sp(tile.get(index$macro$1, index$macro$2)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        result.setDouble(acol, arow, f.apply$mcDD$sp(tile.getDouble(index$macro$1, index$macro$2)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        result.set(acol, arow, mapper.apply(acol, arow, tile.get(index$macro$1, index$macro$2)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        result.setDouble(acol, arow, mapper.apply(acol, arow, tile.getDouble(index$macro$1, index$macro$2)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        result.set(acol, arow, f.apply$mcIII$sp(tile.get(index$macro$1, index$macro$2), other.get(acol, arow)));
                    }
                }
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$4 = 0; index$macro$4 < layoutRows; ++index$macro$4) {
            for (int index$macro$3 = 0; index$macro$3 < layoutCols; ++index$macro$3) {
                Tile tile = this.getTile(index$macro$3, index$macro$4);
                for (int index$macro$2 = 0; index$macro$2 < tileRows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < tileCols; ++index$macro$1) {
                        int acol = tileCols * index$macro$3 + index$macro$1;
                        int arow = tileRows * index$macro$4 + index$macro$2;
                        result.setDouble(acol, arow, f.apply$mcDDD$sp(tile.getDouble(index$macro$1, index$macro$2), other.getDouble(acol, arow)));
                    }
                }
            }
        }
        return var3_3;
    }

    public String asciiDraw() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.tileLayout().layoutRows()).foreach((Function1 & Serializable & scala.Serializable)layoutRow -> CompositeTile.$anonfun$asciiDraw$1(this, sb, BoxesRunTime.unboxToInt((Object)layoutRow)));
        return sb.toString();
    }

    public CompositeTile copy(Seq<Tile> tiles, TileLayout tileLayout) {
        return new CompositeTile(tiles, tileLayout);
    }

    public Seq<Tile> copy$default$1() {
        return this.tiles();
    }

    public TileLayout copy$default$2() {
        return this.tileLayout();
    }

    public String productPrefix() {
        return "CompositeTile";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tiles();
                break;
            }
            case 1: {
                object = this.tileLayout();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompositeTile;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompositeTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompositeTile compositeTile = (CompositeTile)x$1;
        Seq<Tile> seq = this.tiles();
        Seq<Tile> seq2 = compositeTile.tiles();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        TileLayout tileLayout = this.tileLayout();
        TileLayout tileLayout2 = compositeTile.tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return false;
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return false;
        if (!compositeTile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$asciiDraw$4(Tile tile$1, int row$1, scala.collection.mutable.StringBuilder sb$1, int col) {
        int v = tile$1.get(col, row$1);
        String s = v == Integer.MIN_VALUE ? "ND" : String.valueOf(BoxesRunTime.boxToInteger((int)v));
        String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(scala.math.package$.MODULE$.max(6 - new StringOps(Predef$.MODULE$.augmentString(s)).size(), 0));
        return sb$1.append(new StringBuilder(0).append(pad).append(s).toString());
    }

    public static final /* synthetic */ Object $anonfun$asciiDraw$3(CompositeTile $this, int layoutRow$1, int row$1, scala.collection.mutable.StringBuilder sb$1, int layoutCol) {
        BoxedUnit boxedUnit;
        Tile tile = $this.getTile(layoutCol, layoutRow$1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.tileLayout().tileCols()).foreach((Function1 & Serializable & scala.Serializable)col -> CompositeTile.$anonfun$asciiDraw$4(tile, row$1, sb$1, BoxesRunTime.unboxToInt((Object)col)));
        if (layoutCol != $this.tileLayout().layoutCols() - 1) {
            String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(5);
            boxedUnit = sb$1.append(new StringBuilder(2).append(pad).append("| ").toString()).r();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$asciiDraw$2(CompositeTile $this, int layoutRow$1, scala.collection.mutable.StringBuilder sb$1, int row) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.tileLayout().layoutCols()).foreach((Function1 & Serializable & scala.Serializable)layoutCol -> CompositeTile.$anonfun$asciiDraw$3($this, layoutRow$1, row, sb$1, BoxesRunTime.unboxToInt((Object)layoutCol)));
        return sb$1.append("\n");
    }

    public static final /* synthetic */ Object $anonfun$asciiDraw$1(CompositeTile $this, scala.collection.mutable.StringBuilder sb$1, int layoutRow) {
        BoxedUnit boxedUnit;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.tileLayout().tileRows()).foreach((Function1 & Serializable & scala.Serializable)row -> CompositeTile.$anonfun$asciiDraw$2($this, layoutRow, sb$1, BoxesRunTime.unboxToInt((Object)row)));
        if (layoutRow != $this.tileLayout().layoutRows() - 1) {
            String rowDiv = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6 * $this.tileLayout().tileCols() * $this.tileLayout().layoutCols() - 2)).append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6 * $this.tileLayout().layoutCols())).toString();
            boxedUnit = sb$1.append(new StringBuilder(3).append("  ").append(rowDiv).append("\n").toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public CompositeTile(Seq<Tile> tiles, TileLayout tileLayout) {
        this.tiles = tiles;
        this.tileLayout = tileLayout;
        Product.$init$((Product)this);
        Predef$.MODULE$.assert(RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(tileLayout.totalCols())), (Function0 & Serializable & scala.Serializable)() -> "Total cols is not integer, cannot create such a large composite tile.");
        Predef$.MODULE$.assert(RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(tileLayout.totalRows())), (Function0 & Serializable & scala.Serializable)() -> "Total rows is not integer, cannot create such a large composite tile.");
        this.cols = (int)tileLayout.totalCols();
        this.rows = (int)tileLayout.totalRows();
        this.tileList = tiles.toList();
        this.tileCols = tileLayout.layoutCols();
        this.cellType = ((CellGrid)tiles.apply(0)).cellType();
    }
}

