/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile;
import geotrellis.raster.ByteCells;
import geotrellis.raster.ByteConstantTile;
import geotrellis.raster.ConstantTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleConstantTile;
import geotrellis.raster.FloatCells;
import geotrellis.raster.FloatConstantTile;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntConstantTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.ShortConstantTile;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UByteConstantTile;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortConstantTile;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.package$IntArrayFiller$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055d!B\r\u001b\u0003\u0003y\u0002\"\u0002\u0013\u0001\t\u0003)\u0003bB\u0014\u0001\u0005\u00045\t\u0002\u000b\u0005\b_\u0001\u0011\rQ\"\u00051\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015\u0001\bA\"\u0001r\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015i\bA\"\u0001\u007f\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002\u001e\u0001!\t!a\b\b\u000f\u0005%\"\u0004#\u0001\u0002,\u00191\u0011D\u0007E\u0001\u0003[Aa\u0001J\u000b\u0005\u0002\u0005m\u0002bBA\u001f+\u0011\u0005\u0011q\b\u0005\n\u00033*\u0012\u0011!C\u0005\u00037\u0012AbQ8ogR\fg\u000e\u001e+jY\u0016T!a\u0007\u000f\u0002\rI\f7\u000f^3s\u0015\u0005i\u0012AC4f_R\u0014X\r\u001c7jg\u000e\u00011C\u0001\u0001!!\t\t#%D\u0001\u001b\u0013\t\u0019#D\u0001\u0003US2,\u0017A\u0002\u001fj]&$h\bF\u0001'!\t\t\u0003!\u0001\u0003j-\u0006dW#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\u0007%sG/\u0001\u0003e-\u0006dW#A\u0019\u0011\u0005)\u0012\u0014BA\u001a,\u0005\u0019!u.\u001e2mK\u0006\u0019q-\u001a;\u0015\u0007%2\u0004\bC\u00038\t\u0001\u0007\u0011&A\u0002d_2DQ!\u000f\u0003A\u0002%\n1A]8x\u0003%9W\r\u001e#pk\ndW\rF\u00022yuBQaN\u0003A\u0002%BQ!O\u0003A\u0002%\nq\u0001^8BeJ\f\u0017\u0010F\u0001A!\rQ\u0013)K\u0005\u0003\u0005.\u0012Q!\u0011:sCf\fQ\u0002^8BeJ\f\u0017\u0010R8vE2,G#A#\u0011\u0007)\n\u0015'A\u0004d_:4XM\u001d;\u0015\u0005\u0001B\u0005\"B%\t\u0001\u0004Q\u0015a\u00028foRK\b/\u001a\t\u0003\u0017:s!!\t'\n\u00055S\u0012a\u00029bG.\fw-Z\u0005\u0003\u001fB\u0013\u0001bQ3mYRK\b/\u001a\u0006\u0003\u001bj\t1\"\u001b8uKJ\u0004(/\u001a;BgR\u0011\u0001e\u0015\u0005\u0006)&\u0001\rAS\u0001\f]\u0016<8)\u001a7m)f\u0004X-A\u0004g_J,\u0017m\u00195\u0015\u0005]S\u0006C\u0001\u0016Y\u0013\tI6F\u0001\u0003V]&$\b\"B.\u000b\u0001\u0004a\u0016!\u00014\u0011\t)j\u0016fV\u0005\u0003=.\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001b\u0019|'/Z1dQ\u0012{WO\u00197f)\t9\u0016\rC\u0003\\\u0017\u0001\u0007!\r\u0005\u0003+;F:\u0016!\u00054pe\u0016\f7\r[%oiZK7/\u001b;peR\u0011q+\u001a\u0005\u0006M2\u0001\raZ\u0001\bm&\u001c\u0018\u000e^8s!\tY\u0005.\u0003\u0002j!\nq\u0011J\u001c;US2,g+[:ji>\u0014\u0018\u0001\u00064pe\u0016\f7\r\u001b#pk\ndWMV5tSR|'\u000f\u0006\u0002XY\")a-\u0004a\u0001[B\u00111J\\\u0005\u0003_B\u0013\u0011\u0003R8vE2,G+\u001b7f-&\u001c\u0018\u000e^8s\u0003\ri\u0017\r\u001d\u000b\u0003AIDQa\u0017\bA\u0002M\u0004BAK/*S\u000591m\\7cS:,GC\u0001<|)\t\u0001s\u000fC\u0003\\\u001f\u0001\u0007\u0001\u0010E\u0003+s&J\u0013&\u0003\u0002{W\tIa)\u001e8di&|gN\r\u0005\u0006y>\u0001\r\u0001I\u0001\u0006_RDWM]\u0001\n[\u0006\u0004Hi\\;cY\u0016$\"\u0001I@\t\rm\u0003\u0002\u0019AA\u0001!\u0011QS,M\u0019\u0002\u001b\r|WNY5oK\u0012{WO\u00197f)\u0011\t9!!\u0004\u0015\u0007\u0001\nI\u0001\u0003\u0004\\#\u0001\u0007\u00111\u0002\t\u0006Ue\f\u0014'\r\u0005\u0006yF\u0001\r\u0001I\u0001\r[\u0006\u0004\u0018J\u001c;NCB\u0004XM\u001d\u000b\u0004A\u0005M\u0001bBA\u000b%\u0001\u0007\u0011qC\u0001\u0007[\u0006\u0004\b/\u001a:\u0011\u0007-\u000bI\"C\u0002\u0002\u001cA\u0013Q\"\u00138u)&dW-T1qa\u0016\u0014\u0018aD7ba\u0012{WO\u00197f\u001b\u0006\u0004\b/\u001a:\u0015\u0007\u0001\n\t\u0003C\u0004\u0002\u0016M\u0001\r!a\t\u0011\u0007-\u000b)#C\u0002\u0002(A\u0013\u0001\u0003R8vE2,G+\u001b7f\u001b\u0006\u0004\b/\u001a:\u0002\u0019\r{gn\u001d;b]R$\u0016\u000e\\3\u0011\u0005\u0005*2#B\u000b\u00020\u0005U\u0002c\u0001\u0016\u00022%\u0019\u00111G\u0016\u0003\r\u0005s\u0017PU3g!\rQ\u0013qG\u0005\u0004\u0003sY#\u0001D*fe&\fG.\u001b>bE2,GCAA\u0016\u0003%1'o\\7CsR,7\u000fF\u0005'\u0003\u0003\ni%!\u0015\u0002V!9\u00111I\fA\u0002\u0005\u0015\u0013!\u00022zi\u0016\u001c\b\u0003\u0002\u0016B\u0003\u000f\u00022AKA%\u0013\r\tYe\u000b\u0002\u0005\u0005f$X\r\u0003\u0004\u0002P]\u0001\rAS\u0001\u0002i\"1\u00111K\fA\u0002%\nAaY8mg\"1\u0011qK\fA\u0002%\nAA]8xg\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003O\nAA[1wC&!\u00111NA1\u0005\u0019y%M[3di\u0002")
public abstract class ConstantTile
extends Tile {
    public static ConstantTile fromBytes(byte[] byArray, DataType dataType, int n, int n2) {
        return ConstantTile$.MODULE$.fromBytes(byArray, dataType, n, n2);
    }

    public abstract int iVal();

    public abstract double dVal();

    @Override
    public int get(int col, int row) {
        return this.iVal();
    }

    @Override
    public double getDouble(int col, int row) {
        return this.dVal();
    }

    @Override
    public int[] toArray() {
        return package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt(this.cols()) * BoxesRunTime.unboxToInt(this.rows()), ClassTag$.MODULE$.Int())), this.iVal());
    }

    @Override
    public double[] toArrayDouble() {
        return package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt(this.cols()) * BoxesRunTime.unboxToInt(this.rows()), ClassTag$.MODULE$.Double())), this.dVal());
    }

    @Override
    public Tile convert(DataType newType) {
        ConstantTile constantTile;
        DataType dataType = newType;
        if (BitCellType$.MODULE$.equals(dataType)) {
            constantTile = new BitConstantTile(this.iVal() != 0, BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        } else if (dataType instanceof ByteCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new ByteConstantTile((byte)this.iVal(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()), (ByteCells)((Object)noDataHandling));
        } else if (dataType instanceof UByteCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new UByteConstantTile((byte)this.iVal(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()), (UByteCells)((Object)noDataHandling));
        } else if (dataType instanceof ShortCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new ShortConstantTile((short)this.iVal(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()), (ShortCells)((Object)noDataHandling));
        } else if (dataType instanceof UShortCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new UShortConstantTile((short)this.iVal(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()), (UShortCells)((Object)noDataHandling));
        } else if (dataType instanceof IntCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new IntConstantTile(this.iVal(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()), (IntCells)((Object)noDataHandling));
        } else if (dataType instanceof FloatCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new FloatConstantTile((float)this.dVal(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()), (FloatCells)((Object)noDataHandling));
        } else if (dataType instanceof DoubleCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new DoubleConstantTile(this.dVal(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()), (DoubleCells)((Object)noDataHandling));
        } else {
            throw new MatchError((Object)dataType);
        }
        return constantTile;
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVI$sp(this.iVal());
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVD$sp(this.dVal());
        }
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.iVal());
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.dVal());
            }
        }
    }

    @Override
    public abstract Tile map(Function1<Object, Object> var1);

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return other.map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> f.apply$mcIII$sp(this.iVal(), z));
    }

    @Override
    public abstract Tile mapDouble(Function1<Object, Object> var1);

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return other.mapDouble((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> f.apply$mcDDD$sp(this.dVal(), z));
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                tile.set(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), BoxesRunTime.unboxToInt(this.cols()), BoxesRunTime.unboxToInt(this.rows()));
        for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt(this.rows()); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt(this.cols()); ++index$macro$1) {
                tile.setDouble(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }
}

