/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CellSize;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$mcI$sp;
import geotrellis.raster.GridExtent;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.TileLayout;
import geotrellis.vector.Extent;
import org.locationtech.jts.geom.Point;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import spire.implicits$;
import spire.math.Integral;
import spire.math.Integral$;

public class GridExtent$mcI$sp
extends GridExtent<Object> {
    public final int cols$mcI$sp;
    public final int rows$mcI$sp;
    public final Integral<Object> evidence$1$mcI$sp;

    @Override
    public int cols$mcI$sp() {
        return this.cols$mcI$sp;
    }

    @Override
    public int cols() {
        return this.cols$mcI$sp();
    }

    @Override
    public int rows$mcI$sp() {
        return this.rows$mcI$sp;
    }

    @Override
    public int rows() {
        return this.rows$mcI$sp();
    }

    @Override
    public GridExtent<Object> combine(GridExtent<Object> that) {
        return this.combine$mcI$sp(that);
    }

    @Override
    public GridExtent<Object> combine$mcI$sp(GridExtent<Object> that) {
        if (this.cellwidth() != that.cellwidth()) {
            throw new GeoAttrsError(new StringBuilder(25).append("illegal cellwidths: ").append(this.cellwidth()).append(" and ").append(that.cellwidth()).toString());
        }
        if (this.cellheight() != that.cellheight()) {
            throw new GeoAttrsError(new StringBuilder(26).append("illegal cellheights: ").append(this.cellheight()).append(" and ").append(that.cellheight()).toString());
        }
        Extent newExtent = this.extent().combine(that.extent());
        return GridExtent$.MODULE$.apply(newExtent, new CellSize(this.cellwidth(), this.cellheight()), this.evidence$1$mcI$sp);
    }

    @Override
    public final int mapXToGrid(double x) {
        return this.mapXToGrid$mcI$sp(x);
    }

    @Override
    public final int mapXToGrid$mcI$sp(double x) {
        return Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromDouble$mcI$sp(GridExtent$.MODULE$.floorWithTolerance(this.mapXToGridDouble(x)));
    }

    @Override
    public final int mapYToGrid(double y) {
        return this.mapYToGrid$mcI$sp(y);
    }

    @Override
    public final int mapYToGrid$mcI$sp(double y) {
        return Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromDouble$mcI$sp(GridExtent$.MODULE$.floorWithTolerance(this.mapYToGridDouble(y)));
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid(double x, double y) {
        return this.mapToGrid$mcI$sp(x, y);
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid$mcI$sp(double x, double y) {
        int col = (int)GridExtent$.MODULE$.floorWithTolerance((x - this.extent().xmin()) / this.cellwidth());
        int row = (int)GridExtent$.MODULE$.floorWithTolerance((this.extent().ymax() - y) / this.cellheight());
        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)implicits$.MODULE$.intToA(col, this.evidence$1$mcI$sp)), BoxesRunTime.unboxToInt((Object)implicits$.MODULE$.intToA(row, this.evidence$1$mcI$sp)));
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid$mcI$sp(mapCoord);
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid$mcI$sp(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid$mcI$sp(mapCoord._1$mcD$sp(), mapCoord._2$mcD$sp());
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid(Point p) {
        return this.mapToGrid$mcI$sp(p);
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid$mcI$sp(Point p) {
        return this.mapToGrid$mcI$sp(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).y());
    }

    @Override
    public final Tuple2<Object, Object> gridToMap(int col, int row) {
        return this.gridToMap$mcI$sp(col, row);
    }

    @Override
    public final Tuple2<Object, Object> gridToMap$mcI$sp(int col, int row) {
        return new Tuple2.mcDD.sp(this.gridColToMap$mcI$sp(col), this.gridRowToMap$mcI$sp(row));
    }

    @Override
    public final double gridColToMap(int col) {
        return this.gridColToMap$mcI$sp(col);
    }

    @Override
    public final double gridColToMap$mcI$sp(int col) {
        return this.evidence$1$mcI$sp.toDouble$mcI$sp(col) * this.cellwidth() + this.extent().xmin() + this.cellwidth() / (double)2;
    }

    @Override
    public final double gridRowToMap(int row) {
        return this.gridRowToMap$mcI$sp(row);
    }

    @Override
    public final double gridRowToMap$mcI$sp(int row) {
        return this.extent().ymax() - this.evidence$1$mcI$sp.toDouble$mcI$sp(row) * this.cellheight() - this.cellheight() / (double)2;
    }

    @Override
    public GridExtent<Object> withResolution(double targetCellWidth, double targetCellHeight) {
        return this.withResolution$mcI$sp(targetCellWidth, targetCellHeight);
    }

    @Override
    public GridExtent<Object> withResolution$mcI$sp(double targetCellWidth, double targetCellHeight) {
        long newCols = package$.MODULE$.round((this.extent().xmax() - this.extent().xmin()) / targetCellWidth);
        long newRows = package$.MODULE$.round((this.extent().ymax() - this.extent().ymin()) / targetCellHeight);
        return new GridExtent$mcI$sp(this.extent(), targetCellWidth, targetCellHeight, Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromLong$mcI$sp(newCols), Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromLong$mcI$sp(newRows), this.evidence$1$mcI$sp);
    }

    @Override
    public GridExtent<Object> withResolution(CellSize cellSize) {
        return this.withResolution$mcI$sp(cellSize);
    }

    @Override
    public GridExtent<Object> withResolution$mcI$sp(CellSize cellSize) {
        return this.withResolution$mcI$sp(cellSize.width(), cellSize.height());
    }

    @Override
    public GridExtent<Object> withDimensions(int targetCols, int targetRows) {
        return this.withDimensions$mcI$sp(targetCols, targetRows);
    }

    @Override
    public GridExtent<Object> withDimensions$mcI$sp(int targetCols, int targetRows) {
        return new GridExtent$mcI$sp(this.extent(), targetCols, targetRows, this.evidence$1$mcI$sp);
    }

    @Override
    public GridBounds<Object> gridBoundsFor(Extent subExtent, boolean clamp) {
        return this.gridBoundsFor$mcI$sp(subExtent, clamp);
    }

    @Override
    public GridBounds<Object> gridBoundsFor$mcI$sp(Extent subExtent, boolean clamp) {
        double colMaxDouble;
        int colMin = this.mapXToGrid$mcI$sp(subExtent.xmin());
        int rowMin = this.mapYToGrid$mcI$sp(subExtent.ymax());
        int colMax = Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromLong$mcI$sp(package$.MODULE$.abs((colMaxDouble = this.mapXToGridDouble(subExtent.xmax())) - GridExtent$.MODULE$.floorWithTolerance(colMaxDouble)) < 1.0E-7 ? (long)colMaxDouble - 1L : (long)colMaxDouble);
        double rowMaxDouble = this.mapYToGridDouble(subExtent.ymin());
        int rowMax = Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromLong$mcI$sp(package$.MODULE$.abs(rowMaxDouble - GridExtent$.MODULE$.floorWithTolerance(rowMaxDouble)) < 1.0E-7 ? (long)rowMaxDouble - 1L : (long)rowMaxDouble);
        return clamp ? new GridBounds$mcI$sp(this.evidence$1$mcI$sp.min$mcI$sp(this.evidence$1$mcI$sp.max$mcI$sp(colMin, this.evidence$1$mcI$sp.fromInt$mcI$sp(0)), this.evidence$1$mcI$sp.minus$mcI$sp(this.cols(), this.evidence$1$mcI$sp.fromInt$mcI$sp(1))), this.evidence$1$mcI$sp.min$mcI$sp(this.evidence$1$mcI$sp.max$mcI$sp(rowMin, this.evidence$1$mcI$sp.fromInt$mcI$sp(0)), this.evidence$1$mcI$sp.minus$mcI$sp(this.rows(), this.evidence$1$mcI$sp.fromInt$mcI$sp(1))), this.evidence$1$mcI$sp.min$mcI$sp(this.evidence$1$mcI$sp.max$mcI$sp(colMax, this.evidence$1$mcI$sp.fromInt$mcI$sp(0)), this.evidence$1$mcI$sp.minus$mcI$sp(this.cols(), this.evidence$1$mcI$sp.fromInt$mcI$sp(1))), this.evidence$1$mcI$sp.min$mcI$sp(this.evidence$1$mcI$sp.max$mcI$sp(rowMax, this.evidence$1$mcI$sp.fromInt$mcI$sp(0)), this.evidence$1$mcI$sp.minus$mcI$sp(this.rows(), this.evidence$1$mcI$sp.fromInt$mcI$sp(1))), this.evidence$1$mcI$sp) : new GridBounds$mcI$sp(colMin, rowMin, colMax, rowMax, this.evidence$1$mcI$sp);
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent(Extent targetExtent) {
        return this.createAlignedGridExtent$mcI$sp(targetExtent);
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent$mcI$sp(Extent targetExtent) {
        return this.createAlignedGridExtent$mcI$sp(targetExtent, this.extent().northWest());
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent(Extent targetExtent, Point alignmentPoint) {
        return this.createAlignedGridExtent$mcI$sp(targetExtent, alignmentPoint);
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent$mcI$sp(Extent targetExtent, Point alignmentPoint) {
        double xmin = GridExtent$mcI$sp.left$2(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmin(), this.cellwidth());
        double xmax = GridExtent$mcI$sp.right$2(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmax(), this.cellwidth());
        double ymin = GridExtent$mcI$sp.left$2(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymin(), this.cellheight());
        double ymax = GridExtent$mcI$sp.right$2(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymax(), this.cellheight());
        Extent alignedExtent = new Extent(xmin, ymin, xmax, ymax);
        long cols = package$.MODULE$.round(alignedExtent.width() / this.cellwidth());
        long rows = package$.MODULE$.round(alignedExtent.height() / this.cellheight());
        int ncols = Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromDouble$mcI$sp((double)cols);
        int nrows = Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromDouble$mcI$sp((double)rows);
        return new GridExtent$mcI$sp(alignedExtent, this.cellwidth(), this.cellheight(), ncols, nrows, this.evidence$1$mcI$sp);
    }

    @Override
    public GridExtent<Object> alignTargetPixels() {
        return this.alignTargetPixels$mcI$sp();
    }

    @Override
    public GridExtent<Object> alignTargetPixels$mcI$sp() {
        Extent extent = this.extent();
        CellSize cellSize = this.cellSize();
        if (cellSize == null) {
            throw new MatchError((Object)cellSize);
        }
        double width = cellSize.width();
        double height = cellSize.height();
        Tuple3 tuple3 = new Tuple3((Object)cellSize, (Object)BoxesRunTime.boxToDouble((double)width), (Object)BoxesRunTime.boxToDouble((double)height));
        Tuple3 tuple32 = tuple3;
        CellSize cellSize2 = (CellSize)tuple32._1();
        double width2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double height2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        return GridExtent$.MODULE$.apply(new Extent(package$.MODULE$.floor(extent.xmin() / width2) * width2, package$.MODULE$.floor(extent.ymin() / height2) * height2, package$.MODULE$.ceil(extent.xmax() / width2) * width2, package$.MODULE$.ceil(extent.ymax() / height2) * height2), cellSize2, this.evidence$1$mcI$sp);
    }

    @Override
    public Extent extentFor(GridBounds<Object> cellBounds, boolean clamp) {
        return this.extentFor$mcI$sp(cellBounds, clamp);
    }

    @Override
    public Extent extentFor$mcI$sp(GridBounds<Object> cellBounds, boolean clamp) {
        double xmin = (double)this.evidence$1$mcI$sp.toLong$mcI$sp(cellBounds.colMin$mcI$sp()) * this.cellwidth() + this.extent().xmin();
        double ymax = this.extent().ymax() - (double)this.evidence$1$mcI$sp.toLong$mcI$sp(cellBounds.rowMin$mcI$sp()) * this.cellheight();
        double xmax = xmin + (double)this.evidence$1$mcI$sp.toLong$mcI$sp(cellBounds.width$mcI$sp()) * this.cellwidth();
        double ymin = ymax - (double)this.evidence$1$mcI$sp.toLong$mcI$sp(cellBounds.height$mcI$sp()) * this.cellheight();
        return clamp ? new Extent(package$.MODULE$.max(package$.MODULE$.min(xmin, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymin, this.extent().ymax()), this.extent().ymin()), package$.MODULE$.max(package$.MODULE$.min(xmax, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymax, this.extent().ymax()), this.extent().ymin())) : new Extent(xmin, ymin, xmax, ymax);
    }

    @Override
    public GridExtent<Object> adjustTo(TileLayout tileLayout) {
        return this.adjustTo$mcI$sp(tileLayout);
    }

    @Override
    public GridExtent<Object> adjustTo$mcI$sp(TileLayout tileLayout) {
        long totalCols = (long)tileLayout.tileCols() * (long)tileLayout.layoutCols();
        long totalRows = (long)tileLayout.tileRows() * (long)tileLayout.layoutRows();
        Extent resampledExtent = new Extent(this.extent().xmin(), this.extent().ymax() - this.cellheight() * (double)totalRows, this.extent().xmin() + this.cellwidth() * (double)totalCols, this.extent().ymax());
        return new GridExtent$mcI$sp(resampledExtent, this.cellwidth(), this.cellheight(), Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromLong$mcI$sp(totalCols), Integral$.MODULE$.apply(this.evidence$1$mcI$sp).fromLong$mcI$sp(totalRows), this.evidence$1$mcI$sp);
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    private static final double left$2(double reference, double actual, double unit) {
        return reference + package$.MODULE$.floor((actual - reference) / unit) * unit;
    }

    private static final double right$2(double reference, double actual, double unit) {
        return reference + package$.MODULE$.ceil((actual - reference) / unit) * unit;
    }

    public GridExtent$mcI$sp(Extent extent, double cellwidth, double cellheight, int cols$mcI$sp, int rows$mcI$sp, Integral<Object> evidence$1$mcI$sp) {
        this.cols$mcI$sp = cols$mcI$sp;
        this.rows$mcI$sp = rows$mcI$sp;
        this.evidence$1$mcI$sp = evidence$1$mcI$sp;
        super(extent, cellwidth, cellheight, null, null, evidence$1$mcI$sp);
        if (this.evidence$1.lteqv(this.cols(), this.evidence$1.fromInt(0))) {
            throw new GeoAttrsError(new StringBuilder(14).append("invalid cols: ").append(this.cols()).toString());
        }
        if (this.evidence$1.lteqv(this.rows(), this.evidence$1.fromInt(0))) {
            throw new GeoAttrsError(new StringBuilder(14).append("invalid rows: ").append(this.rows()).toString());
        }
        Predef$.MODULE$.require(BoxesRunTime.equals((Object)this.cols(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.width() / cellwidth))) && BoxesRunTime.equals((Object)this.rows(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.height() / cellheight))), () -> GridExtent.geotrellis$raster$GridExtent$$$anonfun$new$1(this));
    }

    public GridExtent$mcI$sp(Extent extent, int cols$mcI$sp, int rows$mcI$sp, Integral<Object> evidence$2$mcI$sp) {
        this(extent, extent.width() / evidence$2$mcI$sp.toDouble((Object)BoxesRunTime.boxToInteger((int)cols$mcI$sp)), extent.height() / evidence$2$mcI$sp.toDouble((Object)BoxesRunTime.boxToInteger((int)rows$mcI$sp)), cols$mcI$sp, rows$mcI$sp, evidence$2$mcI$sp);
    }

    public GridExtent$mcI$sp(Extent extent, CellSize cellSize, Integral<Object> evidence$3$mcI$sp) {
        this(extent, cellSize.width(), cellSize.height(), BoxesRunTime.unboxToInt((Object)Integral$.MODULE$.apply(evidence$3$mcI$sp).fromDouble((double)package$.MODULE$.round(extent.width() / cellSize.width()))), BoxesRunTime.unboxToInt((Object)Integral$.MODULE$.apply(evidence$3$mcI$sp).fromDouble((double)package$.MODULE$.round(extent.height() / cellSize.height()))), evidence$3$mcI$sp);
    }
}

