/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CellSize;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$mcJ$sp;
import geotrellis.raster.GridExtent;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.TileLayout;
import geotrellis.vector.Extent;
import org.locationtech.jts.geom.Point;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import spire.implicits$;
import spire.math.Integral;
import spire.math.Integral$;

public class GridExtent$mcJ$sp
extends GridExtent<Object> {
    public final long cols$mcJ$sp;
    public final long rows$mcJ$sp;
    public final Integral<Object> evidence$1$mcJ$sp;

    @Override
    public long cols$mcJ$sp() {
        return this.cols$mcJ$sp;
    }

    @Override
    public long cols() {
        return this.cols$mcJ$sp();
    }

    @Override
    public long rows$mcJ$sp() {
        return this.rows$mcJ$sp;
    }

    @Override
    public long rows() {
        return this.rows$mcJ$sp();
    }

    @Override
    public GridExtent<Object> combine(GridExtent<Object> that) {
        return this.combine$mcJ$sp(that);
    }

    @Override
    public GridExtent<Object> combine$mcJ$sp(GridExtent<Object> that) {
        if (this.cellwidth() != that.cellwidth()) {
            throw new GeoAttrsError(new StringBuilder(25).append("illegal cellwidths: ").append(this.cellwidth()).append(" and ").append(that.cellwidth()).toString());
        }
        if (this.cellheight() != that.cellheight()) {
            throw new GeoAttrsError(new StringBuilder(26).append("illegal cellheights: ").append(this.cellheight()).append(" and ").append(that.cellheight()).toString());
        }
        Extent newExtent = this.extent().combine(that.extent());
        return GridExtent$.MODULE$.apply(newExtent, new CellSize(this.cellwidth(), this.cellheight()), this.evidence$1$mcJ$sp);
    }

    @Override
    public final long mapXToGrid(double x) {
        return this.mapXToGrid$mcJ$sp(x);
    }

    @Override
    public final long mapXToGrid$mcJ$sp(double x) {
        return Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromDouble$mcJ$sp(GridExtent$.MODULE$.floorWithTolerance(this.mapXToGridDouble(x)));
    }

    @Override
    public final long mapYToGrid(double y) {
        return this.mapYToGrid$mcJ$sp(y);
    }

    @Override
    public final long mapYToGrid$mcJ$sp(double y) {
        return Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromDouble$mcJ$sp(GridExtent$.MODULE$.floorWithTolerance(this.mapYToGridDouble(y)));
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid(double x, double y) {
        return this.mapToGrid$mcJ$sp(x, y);
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid$mcJ$sp(double x, double y) {
        int col = (int)GridExtent$.MODULE$.floorWithTolerance((x - this.extent().xmin()) / this.cellwidth());
        int row = (int)GridExtent$.MODULE$.floorWithTolerance((this.extent().ymax() - y) / this.cellheight());
        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)implicits$.MODULE$.intToA(col, this.evidence$1$mcJ$sp)), BoxesRunTime.unboxToLong((Object)implicits$.MODULE$.intToA(row, this.evidence$1$mcJ$sp)));
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid$mcJ$sp(mapCoord);
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid$mcJ$sp(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid$mcJ$sp(mapCoord._1$mcD$sp(), mapCoord._2$mcD$sp());
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid(Point p) {
        return this.mapToGrid$mcJ$sp(p);
    }

    @Override
    public final Tuple2<Object, Object> mapToGrid$mcJ$sp(Point p) {
        return this.mapToGrid$mcJ$sp(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).y());
    }

    @Override
    public final Tuple2<Object, Object> gridToMap(long col, long row) {
        return this.gridToMap$mcJ$sp(col, row);
    }

    @Override
    public final Tuple2<Object, Object> gridToMap$mcJ$sp(long col, long row) {
        return new Tuple2.mcDD.sp(this.gridColToMap$mcJ$sp(col), this.gridRowToMap$mcJ$sp(row));
    }

    @Override
    public final double gridColToMap(long col) {
        return this.gridColToMap$mcJ$sp(col);
    }

    @Override
    public final double gridColToMap$mcJ$sp(long col) {
        return this.evidence$1$mcJ$sp.toDouble$mcJ$sp(col) * this.cellwidth() + this.extent().xmin() + this.cellwidth() / (double)2;
    }

    @Override
    public final double gridRowToMap(long row) {
        return this.gridRowToMap$mcJ$sp(row);
    }

    @Override
    public final double gridRowToMap$mcJ$sp(long row) {
        return this.extent().ymax() - this.evidence$1$mcJ$sp.toDouble$mcJ$sp(row) * this.cellheight() - this.cellheight() / (double)2;
    }

    @Override
    public GridExtent<Object> withResolution(double targetCellWidth, double targetCellHeight) {
        return this.withResolution$mcJ$sp(targetCellWidth, targetCellHeight);
    }

    @Override
    public GridExtent<Object> withResolution$mcJ$sp(double targetCellWidth, double targetCellHeight) {
        long newCols = package$.MODULE$.round((this.extent().xmax() - this.extent().xmin()) / targetCellWidth);
        long newRows = package$.MODULE$.round((this.extent().ymax() - this.extent().ymin()) / targetCellHeight);
        return new GridExtent$mcJ$sp(this.extent(), targetCellWidth, targetCellHeight, Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromLong$mcJ$sp(newCols), Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromLong$mcJ$sp(newRows), this.evidence$1$mcJ$sp);
    }

    @Override
    public GridExtent<Object> withResolution(CellSize cellSize) {
        return this.withResolution$mcJ$sp(cellSize);
    }

    @Override
    public GridExtent<Object> withResolution$mcJ$sp(CellSize cellSize) {
        return this.withResolution$mcJ$sp(cellSize.width(), cellSize.height());
    }

    @Override
    public GridExtent<Object> withDimensions(long targetCols, long targetRows) {
        return this.withDimensions$mcJ$sp(targetCols, targetRows);
    }

    @Override
    public GridExtent<Object> withDimensions$mcJ$sp(long targetCols, long targetRows) {
        return new GridExtent$mcJ$sp(this.extent(), targetCols, targetRows, this.evidence$1$mcJ$sp);
    }

    @Override
    public GridBounds<Object> gridBoundsFor(Extent subExtent, boolean clamp) {
        return this.gridBoundsFor$mcJ$sp(subExtent, clamp);
    }

    @Override
    public GridBounds<Object> gridBoundsFor$mcJ$sp(Extent subExtent, boolean clamp) {
        double colMaxDouble;
        long colMin = this.mapXToGrid$mcJ$sp(subExtent.xmin());
        long rowMin = this.mapYToGrid$mcJ$sp(subExtent.ymax());
        long colMax = Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromLong$mcJ$sp(package$.MODULE$.abs((colMaxDouble = this.mapXToGridDouble(subExtent.xmax())) - GridExtent$.MODULE$.floorWithTolerance(colMaxDouble)) < 1.0E-7 ? (long)colMaxDouble - 1L : (long)colMaxDouble);
        double rowMaxDouble = this.mapYToGridDouble(subExtent.ymin());
        long rowMax = Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromLong$mcJ$sp(package$.MODULE$.abs(rowMaxDouble - GridExtent$.MODULE$.floorWithTolerance(rowMaxDouble)) < 1.0E-7 ? (long)rowMaxDouble - 1L : (long)rowMaxDouble);
        return clamp ? new GridBounds$mcJ$sp(this.evidence$1$mcJ$sp.min$mcJ$sp(this.evidence$1$mcJ$sp.max$mcJ$sp(colMin, this.evidence$1$mcJ$sp.fromInt$mcJ$sp(0)), this.evidence$1$mcJ$sp.minus$mcJ$sp(this.cols(), this.evidence$1$mcJ$sp.fromInt$mcJ$sp(1))), this.evidence$1$mcJ$sp.min$mcJ$sp(this.evidence$1$mcJ$sp.max$mcJ$sp(rowMin, this.evidence$1$mcJ$sp.fromInt$mcJ$sp(0)), this.evidence$1$mcJ$sp.minus$mcJ$sp(this.rows(), this.evidence$1$mcJ$sp.fromInt$mcJ$sp(1))), this.evidence$1$mcJ$sp.min$mcJ$sp(this.evidence$1$mcJ$sp.max$mcJ$sp(colMax, this.evidence$1$mcJ$sp.fromInt$mcJ$sp(0)), this.evidence$1$mcJ$sp.minus$mcJ$sp(this.cols(), this.evidence$1$mcJ$sp.fromInt$mcJ$sp(1))), this.evidence$1$mcJ$sp.min$mcJ$sp(this.evidence$1$mcJ$sp.max$mcJ$sp(rowMax, this.evidence$1$mcJ$sp.fromInt$mcJ$sp(0)), this.evidence$1$mcJ$sp.minus$mcJ$sp(this.rows(), this.evidence$1$mcJ$sp.fromInt$mcJ$sp(1))), this.evidence$1$mcJ$sp) : new GridBounds$mcJ$sp(colMin, rowMin, colMax, rowMax, this.evidence$1$mcJ$sp);
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent(Extent targetExtent) {
        return this.createAlignedGridExtent$mcJ$sp(targetExtent);
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent$mcJ$sp(Extent targetExtent) {
        return this.createAlignedGridExtent$mcJ$sp(targetExtent, this.extent().northWest());
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent(Extent targetExtent, Point alignmentPoint) {
        return this.createAlignedGridExtent$mcJ$sp(targetExtent, alignmentPoint);
    }

    @Override
    public GridExtent<Object> createAlignedGridExtent$mcJ$sp(Extent targetExtent, Point alignmentPoint) {
        double xmin = GridExtent$mcJ$sp.left$3(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmin(), this.cellwidth());
        double xmax = GridExtent$mcJ$sp.right$3(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmax(), this.cellwidth());
        double ymin = GridExtent$mcJ$sp.left$3(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymin(), this.cellheight());
        double ymax = GridExtent$mcJ$sp.right$3(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymax(), this.cellheight());
        Extent alignedExtent = new Extent(xmin, ymin, xmax, ymax);
        long cols = package$.MODULE$.round(alignedExtent.width() / this.cellwidth());
        long rows = package$.MODULE$.round(alignedExtent.height() / this.cellheight());
        long ncols = Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromDouble$mcJ$sp((double)cols);
        long nrows = Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromDouble$mcJ$sp((double)rows);
        return new GridExtent$mcJ$sp(alignedExtent, this.cellwidth(), this.cellheight(), ncols, nrows, this.evidence$1$mcJ$sp);
    }

    @Override
    public GridExtent<Object> alignTargetPixels() {
        return this.alignTargetPixels$mcJ$sp();
    }

    @Override
    public GridExtent<Object> alignTargetPixels$mcJ$sp() {
        Extent extent = this.extent();
        CellSize cellSize = this.cellSize();
        if (cellSize == null) {
            throw new MatchError((Object)cellSize);
        }
        double width = cellSize.width();
        double height = cellSize.height();
        Tuple3 tuple3 = new Tuple3((Object)cellSize, (Object)BoxesRunTime.boxToDouble((double)width), (Object)BoxesRunTime.boxToDouble((double)height));
        Tuple3 tuple32 = tuple3;
        CellSize cellSize2 = (CellSize)tuple32._1();
        double width2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double height2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        return GridExtent$.MODULE$.apply(new Extent(package$.MODULE$.floor(extent.xmin() / width2) * width2, package$.MODULE$.floor(extent.ymin() / height2) * height2, package$.MODULE$.ceil(extent.xmax() / width2) * width2, package$.MODULE$.ceil(extent.ymax() / height2) * height2), cellSize2, this.evidence$1$mcJ$sp);
    }

    @Override
    public Extent extentFor(GridBounds<Object> cellBounds, boolean clamp) {
        return this.extentFor$mcJ$sp(cellBounds, clamp);
    }

    @Override
    public Extent extentFor$mcJ$sp(GridBounds<Object> cellBounds, boolean clamp) {
        double xmin = (double)this.evidence$1$mcJ$sp.toLong$mcJ$sp(cellBounds.colMin$mcJ$sp()) * this.cellwidth() + this.extent().xmin();
        double ymax = this.extent().ymax() - (double)this.evidence$1$mcJ$sp.toLong$mcJ$sp(cellBounds.rowMin$mcJ$sp()) * this.cellheight();
        double xmax = xmin + (double)this.evidence$1$mcJ$sp.toLong$mcJ$sp(cellBounds.width$mcJ$sp()) * this.cellwidth();
        double ymin = ymax - (double)this.evidence$1$mcJ$sp.toLong$mcJ$sp(cellBounds.height$mcJ$sp()) * this.cellheight();
        return clamp ? new Extent(package$.MODULE$.max(package$.MODULE$.min(xmin, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymin, this.extent().ymax()), this.extent().ymin()), package$.MODULE$.max(package$.MODULE$.min(xmax, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymax, this.extent().ymax()), this.extent().ymin())) : new Extent(xmin, ymin, xmax, ymax);
    }

    @Override
    public GridExtent<Object> adjustTo(TileLayout tileLayout) {
        return this.adjustTo$mcJ$sp(tileLayout);
    }

    @Override
    public GridExtent<Object> adjustTo$mcJ$sp(TileLayout tileLayout) {
        long totalCols = (long)tileLayout.tileCols() * (long)tileLayout.layoutCols();
        long totalRows = (long)tileLayout.tileRows() * (long)tileLayout.layoutRows();
        Extent resampledExtent = new Extent(this.extent().xmin(), this.extent().ymax() - this.cellheight() * (double)totalRows, this.extent().xmin() + this.cellwidth() * (double)totalCols, this.extent().ymax());
        return new GridExtent$mcJ$sp(resampledExtent, this.cellwidth(), this.cellheight(), Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromLong$mcJ$sp(totalCols), Integral$.MODULE$.apply(this.evidence$1$mcJ$sp).fromLong$mcJ$sp(totalRows), this.evidence$1$mcJ$sp);
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    private static final double left$3(double reference, double actual, double unit) {
        return reference + package$.MODULE$.floor((actual - reference) / unit) * unit;
    }

    private static final double right$3(double reference, double actual, double unit) {
        return reference + package$.MODULE$.ceil((actual - reference) / unit) * unit;
    }

    public GridExtent$mcJ$sp(Extent extent, double cellwidth, double cellheight, long cols$mcJ$sp, long rows$mcJ$sp, Integral<Object> evidence$1$mcJ$sp) {
        this.cols$mcJ$sp = cols$mcJ$sp;
        this.rows$mcJ$sp = rows$mcJ$sp;
        this.evidence$1$mcJ$sp = evidence$1$mcJ$sp;
        super(extent, cellwidth, cellheight, null, null, evidence$1$mcJ$sp);
        if (this.evidence$1.lteqv(this.cols(), this.evidence$1.fromInt(0))) {
            throw new GeoAttrsError(new StringBuilder(14).append("invalid cols: ").append(this.cols()).toString());
        }
        if (this.evidence$1.lteqv(this.rows(), this.evidence$1.fromInt(0))) {
            throw new GeoAttrsError(new StringBuilder(14).append("invalid rows: ").append(this.rows()).toString());
        }
        Predef$.MODULE$.require(BoxesRunTime.equals((Object)this.cols(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.width() / cellwidth))) && BoxesRunTime.equals((Object)this.rows(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.height() / cellheight))), () -> GridExtent.geotrellis$raster$GridExtent$$$anonfun$new$1(this));
    }

    public GridExtent$mcJ$sp(Extent extent, long cols$mcJ$sp, long rows$mcJ$sp, Integral<Object> evidence$2$mcJ$sp) {
        this(extent, extent.width() / evidence$2$mcJ$sp.toDouble((Object)BoxesRunTime.boxToLong((long)cols$mcJ$sp)), extent.height() / evidence$2$mcJ$sp.toDouble((Object)BoxesRunTime.boxToLong((long)rows$mcJ$sp)), cols$mcJ$sp, rows$mcJ$sp, evidence$2$mcJ$sp);
    }

    public GridExtent$mcJ$sp(Extent extent, CellSize cellSize, Integral<Object> evidence$3$mcJ$sp) {
        this(extent, cellSize.width(), cellSize.height(), BoxesRunTime.unboxToLong((Object)Integral$.MODULE$.apply(evidence$3$mcJ$sp).fromDouble((double)package$.MODULE$.round(extent.width() / cellSize.width()))), BoxesRunTime.unboxToLong((Object)Integral$.MODULE$.apply(evidence$3$mcJ$sp).fromDouble((double)package$.MODULE$.round(extent.height() / cellSize.height()))), evidence$3$mcJ$sp);
    }
}

