/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.proj4.CRS;
import geotrellis.proj4.Transform$;
import geotrellis.raster.CellSize;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.TileLayout;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.Reproject$Options$;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.util.Constants$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.locationtech.jts.geom.Point;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import spire.implicits$;
import spire.math.Integral;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\rEe\u0001\u0002!B\u0001\u0019C\u0001\u0002\u001d\u0001\u0003\u0006\u0004%\t!\u001d\u0005\tq\u0002\u0011\t\u0011)A\u0005e\"A\u0011\u0010\u0001BC\u0002\u0013\u0005!\u0010\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003|\u0011!y\bA!b\u0001\n\u0003Q\b\"CA\u0001\u0001\t\u0005\t\u0015!\u0003|\u0011)\t\u0019\u0001\u0001BC\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u0003\u000f\u0001!\u0011!Q\u0001\n1C!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0003\u0011%\tY\u0001\u0001B\u0001B\u0003%A\n\u0003\u0006\u0002\u000e\u0001\u0011\u0019\u0011)A\u0006\u0003\u001fAq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002 \u0001!\t!a\r\t\u000f\u0005}\u0001\u0001\"\u0001\u0002B!9\u0011Q\n\u0001\u0005\u0002\u0005U\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003?\u0002AQAA1\u0011\u001d\t9\u0007\u0001C\u0003\u0003SBq!a\u001c\u0001\t\u000b\t\t\bC\u0004\u0002v\u0001!)!a\u001e\t\u000f\u0005m\u0004\u0001\"\u0002\u0002~!9\u00111\u0010\u0001\u0005\u0006\u0005%\u0005bBA>\u0001\u0011\u0015\u0011\u0011\u0013\u0005\b\u0003[\u0003AQAAX\u0011\u001d\tI\f\u0001C\u0003\u0003wCq!a0\u0001\t\u000b\t\t\rC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002R\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\n\u0003s\u0004\u0011\u0013!C\u0001\u0003wDqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u001c\u0001!\tA!\b\t\u000f\tm\u0001\u0001\"\u0001\u0003$!9!1\u0006\u0001\u0005\u0002\t5\u0002b\u0002B\u0018\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wA\u0011Ba\u0011\u0001#\u0003%\t!a?\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003H!9!1\u000b\u0001\u0005\u0002\tU\u0003b\u0002B.\u0001\u0011\u0005#Q\f\u0005\b\u0005C\u0002A\u0011\tB2\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005[BqAa \u0001\t\u0003\u0012\tiB\u0004\u0003\u0014\u0006C\tA!&\u0007\r\u0001\u000b\u0005\u0012\u0001BL\u0011\u001d\tyb\fC\u0001\u0005?C\u0011B!)0\u0005\u0004%)Aa)\t\u0011\t%v\u0006)A\u0007\u0005KCqAa+0\t\u0003\u0011i\u000bC\u0004\u0003,>\"\tAa1\t\u000f\t-v\u0006\"\u0001\u0003\\\"9!Q_\u0018\u0005\u0004\t]\bbBB\u0004_\u0011\u00051\u0011\u0002\u0004\u0007\u0007\u001fy\u0013a!\u0005\t\u0015\rU\u0001H!A!\u0002\u0013\u00199\u0002\u0003\u0006\u0004\u001ea\u0012\u0019\u0011)A\u0006\u0007?Aq!a\b9\t\u0003\u0019\t\u0003C\u0004\u0004.a\"\taa\f\t\u000f\r5\u0002\b\"\u0001\u0004b!I1qM\u0018\u0002\u0002\u0013\r1\u0011\u000e\u0005\n\u0007{z\u0013\u0011!C\u0005\u0007\u007f\u0012!b\u0012:jI\u0016CH/\u001a8u\u0015\t\u00115)\u0001\u0004sCN$XM\u001d\u0006\u0002\t\u0006Qq-Z8ue\u0016dG.[:\u0004\u0001U\u0011qIT\n\u0004\u0001!k\u0007cA%K\u00196\t\u0011)\u0003\u0002L\u0003\n!qI]5e!\tie\n\u0004\u0001\u0005\u0013=\u0003\u0001\u0015!A\u0001\u0006\u0004\u0001&!\u0001(\u0012\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&a\u0002(pi\"Lgn\u001a\t\u0003%bK!!W*\u0003\u0007\u0005s\u0017\u0010\u000b\u0003O7zC\u0007C\u0001*]\u0013\ti6KA\u0006ta\u0016\u001c\u0017.\u00197ju\u0016$\u0017'B\u0012`A\n\fgB\u0001*a\u0013\t\t7+A\u0002J]R\fD\u0001J2h):\u0011AmZ\u0007\u0002K*\u0011a-R\u0001\u0007yI|w\u000e\u001e \n\u0003Q\u000bTaI5kY.t!A\u00156\n\u0005-\u001c\u0016\u0001\u0002'p]\u001e\fD\u0001J2h)B\u0011!K\\\u0005\u0003_N\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa!\u001a=uK:$X#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u001c\u0015A\u0002<fGR|'/\u0003\u0002xi\n1Q\t\u001f;f]R\fq!\u001a=uK:$\b%A\u0005dK2dw/\u001b3uQV\t1\u0010\u0005\u0002Sy&\u0011Qp\u0015\u0002\u0007\t>,(\r\\3\u0002\u0015\r,G\u000e\\<jIRD\u0007%\u0001\u0006dK2d\u0007.Z5hQR\f1bY3mY\",\u0017n\u001a5uA\u0005!1m\u001c7t+\u0005a\u0015!B2pYN\u0004\u0013\u0001\u0002:poN\fQA]8xg\u0002\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015\t\t\"a\u0007M\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001B7bi\"T!!!\u0007\u0002\u000bM\u0004\u0018N]3\n\t\u0005u\u00111\u0003\u0002\t\u0013:$Xm\u001a:bY\u00061A(\u001b8jiz\"B\"a\t\u0002*\u0005-\u0012QFA\u0018\u0003c!B!!\n\u0002(A\u0019\u0011\n\u0001'\t\u000f\u00055A\u0002q\u0001\u0002\u0010!)\u0001\u000f\u0004a\u0001e\")\u0011\u0010\u0004a\u0001w\")q\u0010\u0004a\u0001w\"1\u00111\u0001\u0007A\u00021Ca!!\u0003\r\u0001\u0004aE\u0003CA\u001b\u0003w\ti$a\u0010\u0015\t\u0005\u0015\u0012q\u0007\u0005\n\u0003si\u0011\u0011!a\u0002\u0003\u001f\t!\"\u001a<jI\u0016t7-\u001a\u00133\u0011\u0015\u0001X\u00021\u0001s\u0011\u0019\t\u0019!\u0004a\u0001\u0019\"1\u0011\u0011B\u0007A\u00021#b!a\u0011\u0002J\u0005-C\u0003BA\u0013\u0003\u000bB\u0011\"a\u0012\u000f\u0003\u0003\u0005\u001d!a\u0004\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007C\u0003q\u001d\u0001\u0007!\u000fC\u0004\u0002N9\u0001\r!a\u0014\u0002\u0011\r,G\u000e\\*ju\u0016\u00042!SA)\u0013\r\t\u0019&\u0011\u0002\t\u0007\u0016dGnU5{KV\u0011\u0011qJ\u0001\bG>l'-\u001b8f)\u0011\t)#a\u0017\t\u000f\u0005u\u0003\u00031\u0001\u0002&\u0005!A\u000f[1u\u0003Ai\u0017\r\u001d-U_\u001e\u0013\u0018\u000e\u001a#pk\ndW\rF\u0002|\u0003GBa!!\u001a\u0012\u0001\u0004Y\u0018!\u0001=\u0002!5\f\u0007/\u0017+p\u000fJLG\rR8vE2,GcA>\u0002l!1\u0011Q\u000e\nA\u0002m\f\u0011!_\u0001\u000b[\u0006\u0004\b\fV8He&$Gc\u0001'\u0002t!1\u0011QM\nA\u0002m\f!\"\\1q3R{wI]5e)\ra\u0015\u0011\u0010\u0005\u0007\u0003[\"\u0002\u0019A>\u0002\u00135\f\u0007\u000fV8He&$GCBA@\u0003\u000b\u000b9\tE\u0003S\u0003\u0003cE*C\u0002\u0002\u0004N\u0013a\u0001V;qY\u0016\u0014\u0004BBA3+\u0001\u00071\u0010\u0003\u0004\u0002nU\u0001\ra\u001f\u000b\u0005\u0003\u007f\nY\tC\u0004\u0002\u000eZ\u0001\r!a$\u0002\u00115\f\u0007oQ8pe\u0012\u0004RAUAAwn$B!a \u0002\u0014\"9\u0011QS\fA\u0002\u0005]\u0015!\u00019\u0011\t\u0005e\u0015q\u0015\b\u0005\u00037\u000b\u0019K\u0004\u0003\u0002\u001e\u0006\u0005fb\u00013\u0002 &\tA)\u0003\u0002v\u0007&\u0019\u0011Q\u0015;\u0002\u000fA\f7m[1hK&!\u0011\u0011VAV\u0005\u0015\u0001v.\u001b8u\u0015\r\t)\u000b^\u0001\nOJLG\rV8NCB$b!a$\u00022\u0006U\u0006BBAZ1\u0001\u0007A*A\u0002d_2Da!a.\u0019\u0001\u0004a\u0015a\u0001:po\u0006aqM]5e\u0007>dGk\\'baR\u001910!0\t\r\u0005M\u0016\u00041\u0001M\u000319'/\u001b3S_^$v.T1q)\rY\u00181\u0019\u0005\u0007\u0003oS\u0002\u0019\u0001'\u0002\u001d]LG\u000f\u001b*fg>dW\u000f^5p]R1\u0011QEAe\u0003\u001bDa!a3\u001c\u0001\u0004Y\u0018a\u0004;be\u001e,GoQ3mY^KG\r\u001e5\t\r\u0005=7\u00041\u0001|\u0003A!\u0018M]4fi\u000e+G\u000e\u001c%fS\u001eDG\u000f\u0006\u0003\u0002&\u0005M\u0007bBA'9\u0001\u0007\u0011qJ\u0001\u000fo&$\b\u000eR5nK:\u001c\u0018n\u001c8t)\u0019\t)#!7\u0002^\"1\u00111\\\u000fA\u00021\u000b!\u0002^1sO\u0016$8i\u001c7t\u0011\u0019\ty.\ba\u0001\u0019\u0006QA/\u0019:hKR\u0014vn^:\u0002\u001b\u001d\u0014\u0018\u000e\u001a\"pk:$7OR8s)\u0019\t)/a;\u0002pB!\u0011*a:M\u0013\r\tI/\u0011\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\bBBAw=\u0001\u0007!/A\u0005tk\n,\u0005\u0010^3oi\"I\u0011\u0011\u001f\u0010\u0011\u0002\u0003\u0007\u00111_\u0001\u0006G2\fW\u000e\u001d\t\u0004%\u0006U\u0018bAA|'\n9!i\\8mK\u0006t\u0017aF4sS\u0012\u0014u.\u001e8eg\u001a{'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiP\u000b\u0003\u0002t\u0006}8F\u0001B\u0001!\u0011\u0011\u0019A!\u0004\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0005\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-1+\u0001\u0006b]:|G/\u0019;j_:LAAa\u0004\u0003\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001dQ|'+Y:uKJ,\u0005\u0010^3oiR\u0011!Q\u0003\t\u0004\u0013\n]\u0011b\u0001B\r\u0003\na!+Y:uKJ,\u0005\u0010^3oi\u000692M]3bi\u0016\fE.[4oK\u0012<%/\u001b3FqR,g\u000e\u001e\u000b\u0005\u0003K\u0011y\u0002\u0003\u0004\u0003\"\u0005\u0002\rA]\u0001\ri\u0006\u0014x-\u001a;FqR,g\u000e\u001e\u000b\u0007\u0003K\u0011)Ca\n\t\r\t\u0005\"\u00051\u0001s\u0011\u001d\u0011IC\ta\u0001\u0003/\u000ba\"\u00197jO:lWM\u001c;Q_&tG/A\njg\u001e\u0013\u0018\u000eZ#yi\u0016tG/\u00117jO:,G-\u0006\u0002\u0002t\u0006I2M]3bi\u0016\fE.[4oK\u0012\u0014\u0016m\u001d;fe\u0016CH/\u001a8u)\u0011\u0011)Ba\r\t\r\t\u0005B\u00051\u0001s\u0003E\tG.[4o)\u0006\u0014x-\u001a;QSb,Gn]\u000b\u0003\u0003K\t\u0011\"\u001a=uK:$hi\u001c:\u0015\u000bI\u0014iD!\u0011\t\u000f\t}b\u00051\u0001\u0002f\u0006Q1-\u001a7m\u0005>,h\u000eZ:\t\u0013\u0005Eh\u0005%AA\u0002\u0005M\u0018aE3yi\u0016tGOR8sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001C1eUV\u001cH\u000fV8\u0015\t\u0005\u0015\"\u0011\n\u0005\b\u0005\u0017B\u0003\u0019\u0001B'\u0003)!\u0018\u000e\\3MCf|W\u000f\u001e\t\u0004\u0013\n=\u0013b\u0001B)\u0003\nQA+\u001b7f\u0019\u0006Lx.\u001e;\u0002\u0011\r\fg.R9vC2$B!a=\u0003X!1!\u0011L\u0015A\u0002]\u000b\u0011!Y\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M(q\f\u0005\u0007\u0003;R\u0003\u0019A,\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u001a\u0011\u0007I\u00139'C\u0002\u0003jM\u00131!\u00138u\u0003)!xn\u0012:jIRK\b/Z\u000b\u0005\u0005_\u0012)\b\u0006\u0003\u0003r\te\u0004\u0003B%\u0001\u0005g\u00022!\u0014B;\t\u0019\u00119\b\fb\u0001!\n\tQ\nC\u0005\u0003|1\n\t\u0011q\u0001\u0003~\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\r\u0005E\u00111\u0004B:\u0003!!xn\u0015;sS:<GC\u0001BB!\u0011\u0011)I!$\u000f\t\t\u001d%\u0011\u0012\t\u0003INK1Aa#T\u0003\u0019\u0001&/\u001a3fM&!!q\u0012BI\u0005\u0019\u0019FO]5oO*\u0019!1R*\u0002\u0015\u001d\u0013\u0018\u000eZ#yi\u0016tG\u000f\u0005\u0002J_M!qF!'n!\r\u0011&1T\u0005\u0004\u0005;\u001b&AB!osJ+g\r\u0006\u0002\u0003\u0016\u00069Q\r]:jY>tWC\u0001BS\u001f\t\u00119\u000b\t\u0005?u^\u00170\u0014pXI\u0003!)\u0007o]5m_:\u0004\u0013!B1qa2LX\u0003\u0002BX\u0005o#bA!-\u0003@\n\u0005G\u0003\u0002BZ\u0005s\u0003B!\u0013\u0001\u00036B\u0019QJa.\u0005\u000b=\u001b$\u0019\u0001)\t\u0013\tm6'!AA\u0004\tu\u0016AC3wS\u0012,gnY3%kA1\u0011\u0011CA\u000e\u0005kCQ\u0001]\u001aA\u0002IDq!!\u00144\u0001\u0004\ty%\u0006\u0003\u0003F\n5G\u0003\u0003Bd\u0005+\u00149N!7\u0015\t\t%'q\u001a\t\u0005\u0013\u0002\u0011Y\rE\u0002N\u0005\u001b$Qa\u0014\u001bC\u0002AC\u0011B!55\u0003\u0003\u0005\u001dAa5\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007\u0005\u0004\u0002\u0012\u0005m!1\u001a\u0005\u0006aR\u0002\rA\u001d\u0005\b\u0003\u0007!\u0004\u0019\u0001Bf\u0011\u001d\tI\u0001\u000ea\u0001\u0005\u0017,BA!8\u0003fR1!q\u001cBw\u0005_$BA!9\u0003hB!\u0011\n\u0001Br!\ri%Q\u001d\u0003\u0006\u001fV\u0012\r\u0001\u0015\u0005\n\u0005S,\u0014\u0011!a\u0002\u0005W\f!\"\u001a<jI\u0016t7-\u001a\u00138!\u0019\t\t\"a\u0007\u0003d\")\u0001/\u000ea\u0001e\"9!\u0011_\u001bA\u0002\tM\u0018\u0001B4sS\u0012\u0004B!\u0013&\u0003d\u0006\u0019rM]5e\u0005>,h\u000eZ:J]R$v\u000eT8oOR!!\u0011`B\u0001!\u0015I\u0015q\u001dB~!\r\u0011&Q`\u0005\u0004\u0005\u007f\u001c&\u0001\u0002'p]\u001eDqaa\u00017\u0001\u0004\u0019)!\u0001\u0004c_VtGm\u001d\t\u0006\u0013\u0006\u001d(QM\u0001\u0013M2|wN],ji\"$v\u000e\\3sC:\u001cW\rF\u0002|\u0007\u0017Aaa!\u00048\u0001\u0004Y\u0018!\u0002<bYV,'!E4sS\u0012,\u0005\u0010^3oi6+G\u000f[8egV!11CB\u000e'\rA$\u0011T\u0001\u0005g\u0016dg\r\u0005\u0003J\u0001\re\u0001cA'\u0004\u001c\u0011)q\n\u000fb\u0001!\u0006QQM^5eK:\u001cW\r\n\u001d\u0011\r\u0005E\u00111DB\r)\u0011\u0019\u0019ca\u000b\u0015\t\r\u00152\u0011\u0006\t\u0006\u0007OA4\u0011D\u0007\u0002_!91QD\u001eA\u0004\r}\u0001bBB\u000bw\u0001\u00071qC\u0001\ne\u0016\u0004(o\u001c6fGR$\u0002ba\u0006\u00042\r\u00053Q\t\u0005\b\u0007ga\u0004\u0019AB\u001b\u0003\r\u0019(o\u0019\t\u0005\u0007o\u0019i$\u0004\u0002\u0004:)\u001911H\"\u0002\u000bA\u0014xN\u001b\u001b\n\t\r}2\u0011\b\u0002\u0004\u0007J\u001b\u0006bBB\"y\u0001\u00071QG\u0001\u0005I\u0016\u001cH\u000fC\u0004\u0004Hq\u0002\ra!\u0013\u0002\u000f=\u0004H/[8ogB!11JB.\u001d\u0011\u0019ie!\u0016\u000f\t\r=31\u000b\b\u0005\u0003;\u001b\t&\u0003\u0002C\u0007&\u00191QF!\n\t\r]3\u0011L\u0001\n%\u0016\u0004(o\u001c6fGRT1a!\fB\u0013\u0011\u0019ifa\u0018\u0003\u000f=\u0003H/[8og*!1qKB-)\u0019\u00199ba\u0019\u0004f!911G\u001fA\u0002\rU\u0002bBB\"{\u0001\u00071QG\u0001\u0012OJLG-\u0012=uK:$X*\u001a;i_\u0012\u001cX\u0003BB6\u0007g\"Ba!\u001c\u0004zQ!1qNB;!\u0015\u00199\u0003OB9!\ri51\u000f\u0003\u0006\u001fz\u0012\r\u0001\u0015\u0005\b\u0007;q\u00049AB<!\u0019\t\t\"a\u0007\u0004r!91Q\u0003 A\u0002\rm\u0004\u0003B%\u0001\u0007c\n1B]3bIJ+7o\u001c7wKR\u00111\u0011\u0011\t\u0005\u0007\u0007\u001bi)\u0004\u0002\u0004\u0006*!1qQBE\u0003\u0011a\u0017M\\4\u000b\u0005\r-\u0015\u0001\u00026bm\u0006LAaa$\u0004\u0006\n1qJ\u00196fGR\u0004")
public class GridExtent<N>
extends Grid<N> {
    private final Extent extent;
    private final double cellwidth;
    private final double cellheight;
    public final N cols;
    public final N rows;
    public final Integral<N> evidence$1;

    public static <N> gridExtentMethods<N> gridExtentMethods(GridExtent<N> gridExtent, Integral<N> integral) {
        return GridExtent$.MODULE$.gridExtentMethods(gridExtent, integral);
    }

    public static double floorWithTolerance(double d) {
        return GridExtent$.MODULE$.floorWithTolerance(d);
    }

    public static GridBounds<Object> gridBoundsIntToLong(GridBounds<Object> gridBounds) {
        return GridExtent$.MODULE$.gridBoundsIntToLong(gridBounds);
    }

    public static <N> GridExtent<N> apply(Extent extent, Grid<N> grid, Integral<N> integral) {
        return GridExtent$.MODULE$.apply(extent, grid, integral);
    }

    public static <N> GridExtent<N> apply(Extent extent, N n, N n2, Integral<N> integral) {
        return GridExtent$.MODULE$.apply(extent, n, n2, integral);
    }

    public static <N> GridExtent<N> apply(Extent extent, CellSize cellSize, Integral<N> integral) {
        return GridExtent$.MODULE$.apply(extent, cellSize, integral);
    }

    public static double epsilon() {
        return GridExtent$.MODULE$.epsilon();
    }

    public Extent extent() {
        return this.extent;
    }

    public double cellwidth() {
        return this.cellwidth;
    }

    public double cellheight() {
        return this.cellheight;
    }

    @Override
    public N cols() {
        return this.cols;
    }

    @Override
    public N rows() {
        return this.rows;
    }

    public CellSize cellSize() {
        return new CellSize(this.cellwidth(), this.cellheight());
    }

    public GridExtent<N> combine(GridExtent<N> that) {
        if (this.cellwidth() != that.cellwidth()) {
            throw new GeoAttrsError(new StringBuilder(25).append("illegal cellwidths: ").append(this.cellwidth()).append(" and ").append(that.cellwidth()).toString());
        }
        if (this.cellheight() != that.cellheight()) {
            throw new GeoAttrsError(new StringBuilder(26).append("illegal cellheights: ").append(this.cellheight()).append(" and ").append(that.cellheight()).toString());
        }
        Extent newExtent = this.extent().combine(that.extent());
        return GridExtent$.MODULE$.apply(newExtent, new CellSize(this.cellwidth(), this.cellheight()), this.evidence$1);
    }

    public final double mapXToGridDouble(double x) {
        return (x - this.extent().xmin()) / this.cellwidth();
    }

    public final double mapYToGridDouble(double y) {
        return (this.extent().ymax() - y) / this.cellheight();
    }

    public N mapXToGrid(double x) {
        return (N)Integral$.MODULE$.apply(this.evidence$1).fromDouble(GridExtent$.MODULE$.floorWithTolerance(this.mapXToGridDouble(x)));
    }

    public N mapYToGrid(double y) {
        return (N)Integral$.MODULE$.apply(this.evidence$1).fromDouble(GridExtent$.MODULE$.floorWithTolerance(this.mapYToGridDouble(y)));
    }

    public Tuple2<N, N> mapToGrid(double x, double y) {
        int col = (int)GridExtent$.MODULE$.floorWithTolerance((x - this.extent().xmin()) / this.cellwidth());
        int row = (int)GridExtent$.MODULE$.floorWithTolerance((this.extent().ymax() - y) / this.cellheight());
        return new Tuple2(implicits$.MODULE$.intToA(col, this.evidence$1), implicits$.MODULE$.intToA(row, this.evidence$1));
    }

    public Tuple2<N, N> mapToGrid(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid(mapCoord._1$mcD$sp(), mapCoord._2$mcD$sp());
    }

    public Tuple2<N, N> mapToGrid(Point p) {
        return this.mapToGrid(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).y());
    }

    public Tuple2<Object, Object> gridToMap(N col, N row) {
        return new Tuple2.mcDD.sp(this.gridColToMap(col), this.gridRowToMap(row));
    }

    public double gridColToMap(N col) {
        return this.evidence$1.toDouble(col) * this.cellwidth() + this.extent().xmin() + this.cellwidth() / (double)2;
    }

    public double gridRowToMap(N row) {
        return this.extent().ymax() - this.evidence$1.toDouble(row) * this.cellheight() - this.cellheight() / (double)2;
    }

    public GridExtent<N> withResolution(double targetCellWidth, double targetCellHeight) {
        long newCols = package$.MODULE$.round((this.extent().xmax() - this.extent().xmin()) / targetCellWidth);
        long newRows = package$.MODULE$.round((this.extent().ymax() - this.extent().ymin()) / targetCellHeight);
        return new GridExtent<Object>(this.extent(), targetCellWidth, targetCellHeight, Integral$.MODULE$.apply(this.evidence$1).fromLong(newCols), Integral$.MODULE$.apply(this.evidence$1).fromLong(newRows), this.evidence$1);
    }

    public GridExtent<N> withResolution(CellSize cellSize) {
        return this.withResolution(cellSize.width(), cellSize.height());
    }

    public GridExtent<N> withDimensions(N targetCols, N targetRows) {
        return new GridExtent<N>(this.extent(), targetCols, targetRows, this.evidence$1);
    }

    public GridBounds<N> gridBoundsFor(Extent subExtent, boolean clamp) {
        double colMaxDouble;
        N colMin = this.mapXToGrid(subExtent.xmin());
        N rowMin = this.mapYToGrid(subExtent.ymax());
        Object colMax = Integral$.MODULE$.apply(this.evidence$1).fromLong(package$.MODULE$.abs((colMaxDouble = this.mapXToGridDouble(subExtent.xmax())) - GridExtent$.MODULE$.floorWithTolerance(colMaxDouble)) < 1.0E-7 ? (long)colMaxDouble - 1L : (long)colMaxDouble);
        double rowMaxDouble = this.mapYToGridDouble(subExtent.ymin());
        Object rowMax = Integral$.MODULE$.apply(this.evidence$1).fromLong(package$.MODULE$.abs(rowMaxDouble - GridExtent$.MODULE$.floorWithTolerance(rowMaxDouble)) < 1.0E-7 ? (long)rowMaxDouble - 1L : (long)rowMaxDouble);
        return clamp ? new GridBounds<Object>(this.evidence$1.min(this.evidence$1.max(colMin, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.cols(), this.evidence$1.fromInt(1))), this.evidence$1.min(this.evidence$1.max(rowMin, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.rows(), this.evidence$1.fromInt(1))), this.evidence$1.min(this.evidence$1.max(colMax, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.cols(), this.evidence$1.fromInt(1))), this.evidence$1.min(this.evidence$1.max(rowMax, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.rows(), this.evidence$1.fromInt(1))), this.evidence$1) : new GridBounds<Object>(colMin, rowMin, colMax, rowMax, this.evidence$1);
    }

    public boolean gridBoundsFor$default$2() {
        return true;
    }

    public RasterExtent toRasterExtent() {
        if (this.evidence$1.gt(this.cols(), this.evidence$1.fromInt(Integer.MAX_VALUE))) {
            throw new GeoAttrsError(new StringBuilder(100).append("Cannot convert GridExtent into a RasterExtent: number of columns exceeds maximum integer value (").append(this.cols()).append(" > ").append(Integer.MAX_VALUE).append(")").toString());
        }
        if (this.evidence$1.gt(this.rows(), this.evidence$1.fromInt(Integer.MAX_VALUE))) {
            throw new GeoAttrsError(new StringBuilder(97).append("Cannot convert GridExtent into a RasterExtent: number of rows exceeds maximum integer value (").append(this.rows()).append(" > ").append(Integer.MAX_VALUE).append(")").toString());
        }
        return new RasterExtent(this.extent(), this.cellwidth(), this.cellheight(), this.evidence$1.toInt(this.cols()), this.evidence$1.toInt(this.rows()));
    }

    public GridExtent<N> createAlignedGridExtent(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent, this.extent().northWest());
    }

    public GridExtent<N> createAlignedGridExtent(Extent targetExtent, Point alignmentPoint) {
        double xmin = GridExtent.left$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmin(), this.cellwidth());
        double xmax = GridExtent.right$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmax(), this.cellwidth());
        double ymin = GridExtent.left$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymin(), this.cellheight());
        double ymax = GridExtent.right$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymax(), this.cellheight());
        Extent alignedExtent = new Extent(xmin, ymin, xmax, ymax);
        long cols = package$.MODULE$.round(alignedExtent.width() / this.cellwidth());
        long rows = package$.MODULE$.round(alignedExtent.height() / this.cellheight());
        Object ncols = Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)cols);
        Object nrows = Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)rows);
        return new GridExtent<Object>(alignedExtent, this.cellwidth(), this.cellheight(), ncols, nrows, this.evidence$1);
    }

    public boolean isGridExtentAligned() {
        return GridExtent.isWhole$1((this.extent().xmax() - this.extent().xmin()) / this.cellwidth()) && GridExtent.isWhole$1((this.extent().ymax() - this.extent().ymin()) / this.cellheight());
    }

    public RasterExtent createAlignedRasterExtent(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent).toRasterExtent();
    }

    public GridExtent<N> alignTargetPixels() {
        Extent extent = this.extent();
        CellSize cellSize = this.cellSize();
        if (cellSize == null) {
            throw new MatchError((Object)cellSize);
        }
        double width = cellSize.width();
        double height = cellSize.height();
        Tuple3 tuple3 = new Tuple3((Object)cellSize, (Object)BoxesRunTime.boxToDouble((double)width), (Object)BoxesRunTime.boxToDouble((double)height));
        Tuple3 tuple32 = tuple3;
        CellSize cellSize2 = (CellSize)tuple32._1();
        double width2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double height2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        return GridExtent$.MODULE$.apply(new Extent(package$.MODULE$.floor(extent.xmin() / width2) * width2, package$.MODULE$.floor(extent.ymin() / height2) * height2, package$.MODULE$.ceil(extent.xmax() / width2) * width2, package$.MODULE$.ceil(extent.ymax() / height2) * height2), cellSize2, this.evidence$1);
    }

    public Extent extentFor(GridBounds<N> cellBounds, boolean clamp) {
        double xmin = (double)this.evidence$1.toLong(cellBounds.colMin()) * this.cellwidth() + this.extent().xmin();
        double ymax = this.extent().ymax() - (double)this.evidence$1.toLong(cellBounds.rowMin()) * this.cellheight();
        double xmax = xmin + (double)this.evidence$1.toLong(cellBounds.width()) * this.cellwidth();
        double ymin = ymax - (double)this.evidence$1.toLong(cellBounds.height()) * this.cellheight();
        return clamp ? new Extent(package$.MODULE$.max(package$.MODULE$.min(xmin, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymin, this.extent().ymax()), this.extent().ymin()), package$.MODULE$.max(package$.MODULE$.min(xmax, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymax, this.extent().ymax()), this.extent().ymin())) : new Extent(xmin, ymin, xmax, ymax);
    }

    public boolean extentFor$default$2() {
        return true;
    }

    public GridExtent<N> adjustTo(TileLayout tileLayout) {
        long totalCols = (long)tileLayout.tileCols() * (long)tileLayout.layoutCols();
        long totalRows = (long)tileLayout.tileRows() * (long)tileLayout.layoutRows();
        Extent resampledExtent = new Extent(this.extent().xmin(), this.extent().ymax() - this.cellheight() * (double)totalRows, this.extent().xmin() + this.cellwidth() * (double)totalCols, this.extent().ymax());
        return new GridExtent<Object>(resampledExtent, this.cellwidth(), this.cellheight(), Integral$.MODULE$.apply(this.evidence$1).fromLong(totalCols), Integral$.MODULE$.apply(this.evidence$1).fromLong(totalRows), this.evidence$1);
    }

    public boolean canEqual(Object a) {
        return a instanceof GridExtent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof GridExtent)) return false;
        GridExtent gridExtent = (GridExtent)object;
        if (!gridExtent.canEqual(this)) return false;
        Extent extent = gridExtent.extent();
        Extent extent2 = this.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        CellSize cellSize = gridExtent.cellSize();
        CellSize cellSize2 = this.cellSize();
        if (cellSize == null) {
            if (cellSize2 != null) {
                return false;
            }
        } else if (!((Object)cellSize).equals(cellSize2)) return false;
        if (!BoxesRunTime.equals(gridExtent.cols(), this.cols())) return false;
        if (!BoxesRunTime.equals(gridExtent.rows(), this.rows())) return false;
        return true;
    }

    public int hashCode() {
        return ((31 + (this.extent() == null ? 0 : this.extent().hashCode())) * 31 + (int)this.cellheight()) * 31 + (int)this.cellwidth();
    }

    public <M> GridExtent<M> toGridType(Integral<M> evidence$4) {
        return new GridExtent<Object>(this.extent(), this.cellwidth(), this.cellheight(), Integral$.MODULE$.apply(this.evidence$1).toType(this.cols(), evidence$4), Integral$.MODULE$.apply(this.evidence$1).toType(this.rows(), evidence$4), evidence$4);
    }

    public String toString() {
        return new StringBuilder(17).append("GridExtent(").append(this.extent()).append(", ").append(this.cellSize()).append(", ").append(this.cols()).append("x").append(this.rows()).append(")").toString();
    }

    public int cols$mcI$sp() {
        return BoxesRunTime.unboxToInt(this.cols());
    }

    public long cols$mcJ$sp() {
        return BoxesRunTime.unboxToLong(this.cols());
    }

    public int rows$mcI$sp() {
        return BoxesRunTime.unboxToInt(this.rows());
    }

    public long rows$mcJ$sp() {
        return BoxesRunTime.unboxToLong(this.rows());
    }

    public GridExtent<Object> combine$mcI$sp(GridExtent<Object> that) {
        return this.combine(that);
    }

    public GridExtent<Object> combine$mcJ$sp(GridExtent<Object> that) {
        return this.combine(that);
    }

    public int mapXToGrid$mcI$sp(double x) {
        return BoxesRunTime.unboxToInt(this.mapXToGrid(x));
    }

    public long mapXToGrid$mcJ$sp(double x) {
        return BoxesRunTime.unboxToLong(this.mapXToGrid(x));
    }

    public int mapYToGrid$mcI$sp(double y) {
        return BoxesRunTime.unboxToInt(this.mapYToGrid(y));
    }

    public long mapYToGrid$mcJ$sp(double y) {
        return BoxesRunTime.unboxToLong(this.mapYToGrid(y));
    }

    public Tuple2<Object, Object> mapToGrid$mcI$sp(double x, double y) {
        return this.mapToGrid(x, y);
    }

    public Tuple2<Object, Object> mapToGrid$mcJ$sp(double x, double y) {
        return this.mapToGrid(x, y);
    }

    public Tuple2<Object, Object> mapToGrid$mcI$sp(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid(mapCoord);
    }

    public Tuple2<Object, Object> mapToGrid$mcJ$sp(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid(mapCoord);
    }

    public Tuple2<Object, Object> mapToGrid$mcI$sp(Point p) {
        return this.mapToGrid(p);
    }

    public Tuple2<Object, Object> mapToGrid$mcJ$sp(Point p) {
        return this.mapToGrid(p);
    }

    public Tuple2<Object, Object> gridToMap$mcI$sp(int col, int row) {
        return this.gridToMap(BoxesRunTime.boxToInteger((int)col), BoxesRunTime.boxToInteger((int)row));
    }

    public Tuple2<Object, Object> gridToMap$mcJ$sp(long col, long row) {
        return this.gridToMap(BoxesRunTime.boxToLong((long)col), BoxesRunTime.boxToLong((long)row));
    }

    public double gridColToMap$mcI$sp(int col) {
        return this.gridColToMap(BoxesRunTime.boxToInteger((int)col));
    }

    public double gridColToMap$mcJ$sp(long col) {
        return this.gridColToMap(BoxesRunTime.boxToLong((long)col));
    }

    public double gridRowToMap$mcI$sp(int row) {
        return this.gridRowToMap(BoxesRunTime.boxToInteger((int)row));
    }

    public double gridRowToMap$mcJ$sp(long row) {
        return this.gridRowToMap(BoxesRunTime.boxToLong((long)row));
    }

    public GridExtent<Object> withResolution$mcI$sp(double targetCellWidth, double targetCellHeight) {
        return this.withResolution(targetCellWidth, targetCellHeight);
    }

    public GridExtent<Object> withResolution$mcJ$sp(double targetCellWidth, double targetCellHeight) {
        return this.withResolution(targetCellWidth, targetCellHeight);
    }

    public GridExtent<Object> withResolution$mcI$sp(CellSize cellSize) {
        return this.withResolution(cellSize);
    }

    public GridExtent<Object> withResolution$mcJ$sp(CellSize cellSize) {
        return this.withResolution(cellSize);
    }

    public GridExtent<Object> withDimensions$mcI$sp(int targetCols, int targetRows) {
        return this.withDimensions(BoxesRunTime.boxToInteger((int)targetCols), BoxesRunTime.boxToInteger((int)targetRows));
    }

    public GridExtent<Object> withDimensions$mcJ$sp(long targetCols, long targetRows) {
        return this.withDimensions(BoxesRunTime.boxToLong((long)targetCols), BoxesRunTime.boxToLong((long)targetRows));
    }

    public GridBounds<Object> gridBoundsFor$mcI$sp(Extent subExtent, boolean clamp) {
        return this.gridBoundsFor(subExtent, clamp);
    }

    public GridBounds<Object> gridBoundsFor$mcJ$sp(Extent subExtent, boolean clamp) {
        return this.gridBoundsFor(subExtent, clamp);
    }

    public GridExtent<Object> createAlignedGridExtent$mcI$sp(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent);
    }

    public GridExtent<Object> createAlignedGridExtent$mcJ$sp(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent);
    }

    public GridExtent<Object> createAlignedGridExtent$mcI$sp(Extent targetExtent, Point alignmentPoint) {
        return this.createAlignedGridExtent(targetExtent, alignmentPoint);
    }

    public GridExtent<Object> createAlignedGridExtent$mcJ$sp(Extent targetExtent, Point alignmentPoint) {
        return this.createAlignedGridExtent(targetExtent, alignmentPoint);
    }

    public GridExtent<Object> alignTargetPixels$mcI$sp() {
        return this.alignTargetPixels();
    }

    public GridExtent<Object> alignTargetPixels$mcJ$sp() {
        return this.alignTargetPixels();
    }

    public Extent extentFor$mcI$sp(GridBounds<Object> cellBounds, boolean clamp) {
        return this.extentFor(cellBounds, clamp);
    }

    public Extent extentFor$mcJ$sp(GridBounds<Object> cellBounds, boolean clamp) {
        return this.extentFor(cellBounds, clamp);
    }

    public GridExtent<Object> adjustTo$mcI$sp(TileLayout tileLayout) {
        return this.adjustTo(tileLayout);
    }

    public GridExtent<Object> adjustTo$mcJ$sp(TileLayout tileLayout) {
        return this.adjustTo(tileLayout);
    }

    public boolean specInstance$() {
        return false;
    }

    private static final double left$1(double reference, double actual, double unit) {
        return reference + package$.MODULE$.floor((actual - reference) / unit) * unit;
    }

    private static final double right$1(double reference, double actual, double unit) {
        return reference + package$.MODULE$.ceil((actual - reference) / unit) * unit;
    }

    private static final boolean isWhole$1(double x) {
        return package$.MODULE$.abs((double)package$.MODULE$.round(x) - x) < Constants$.MODULE$.FLOAT_EPSILON();
    }

    public GridExtent(Extent extent, double cellwidth, double cellheight, N cols, N rows, Integral<N> evidence$1) {
        this.extent = extent;
        this.cellwidth = cellwidth;
        this.cellheight = cellheight;
        this.cols = cols;
        this.rows = rows;
        this.evidence$1 = evidence$1;
        super(evidence$1);
        if (!this.specInstance$()) {
            if (this.evidence$1.lteqv(this.cols(), this.evidence$1.fromInt(0))) {
                throw new GeoAttrsError(new StringBuilder(14).append("invalid cols: ").append(this.cols()).toString());
            }
            if (this.evidence$1.lteqv(this.rows(), this.evidence$1.fromInt(0))) {
                throw new GeoAttrsError(new StringBuilder(14).append("invalid rows: ").append(this.rows()).toString());
            }
            Predef$.MODULE$.require(BoxesRunTime.equals(this.cols(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.width() / cellwidth))) && BoxesRunTime.equals(this.rows(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.height() / cellheight))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(this.extent()).append(" at ").append(this.cellSize()).append(" does not match ").append(this.dimensions()).toString());
        }
    }

    public GridExtent(Extent extent, N cols, N rows, Integral<N> evidence$2) {
        this(extent, extent.width() / evidence$2.toDouble(cols), extent.height() / evidence$2.toDouble(rows), cols, rows, evidence$2);
    }

    public GridExtent(Extent extent, CellSize cellSize, Integral<N> evidence$3) {
        this(extent, cellSize.width(), cellSize.height(), Integral$.MODULE$.apply(evidence$3).fromDouble((double)package$.MODULE$.round(extent.width() / cellSize.width())), Integral$.MODULE$.apply(evidence$3).fromDouble((double)package$.MODULE$.round(extent.height() / cellSize.height())), evidence$3);
    }

    public static class gridExtentMethods<N> {
        private final GridExtent<N> self;
        private final Integral<N> evidence$8;

        public GridExtent<N> reproject(CRS src, CRS dest, Reproject.Options options) {
            GridExtent gridExtent;
            CRS cRS = src;
            CRS cRS2 = dest;
            if (!(cRS != null ? !cRS.equals(cRS2) : cRS2 != null)) {
                gridExtent = this.self;
            } else {
                Function2 transform = Transform$.MODULE$.apply(src, dest);
                gridExtent = (GridExtent)options.targetRasterExtent().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toGridType($this.evidence$8)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReprojectRasterExtent$.MODULE$.apply($this.self, (Function2<Object, Object, Tuple2<Object, Object>>)transform, options, $this.evidence$8));
            }
            return gridExtent;
        }

        public GridExtent<N> reproject(CRS src, CRS dest) {
            return this.reproject(src, dest, Reproject$Options$.MODULE$.DEFAULT());
        }

        public gridExtentMethods(GridExtent<N> self, Integral<N> evidence$8) {
            this.self = self;
            this.evidence$8 = evidence$8;
        }
    }
}

