/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import cats.data.NonEmptyList;
import cats.implicits$;
import cats.kernel.Semigroup;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellSize;
import geotrellis.raster.EmptyName$;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridExtent;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.MosaicRasterSource;
import geotrellis.raster.MosaicRasterSource$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.RasterMetadata;
import geotrellis.raster.RasterSource;
import geotrellis.raster.SourceName;
import geotrellis.raster.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import spire.math.Integral;
import spire.math.Integral$;

public final class MosaicRasterSource$
implements scala.Serializable {
    public static MosaicRasterSource$ MODULE$;
    private final Semigroup<Raster<MultibandTile>> rasterSemigroup;

    static {
        new MosaicRasterSource$();
    }

    public Semigroup<Raster<MultibandTile>> rasterSemigroup() {
        return this.rasterSemigroup;
    }

    public <N> Semigroup<GridExtent<N>> gridExtentSemigroup(Integral<N> evidence$1) {
        return new Semigroup<GridExtent<N>>(evidence$1){
            private final Integral evidence$1$1;

            public double combine$mcD$sp(double x, double y) {
                return Semigroup.combine$mcD$sp$((Semigroup)this, (double)x, (double)y);
            }

            public float combine$mcF$sp(float x, float y) {
                return Semigroup.combine$mcF$sp$((Semigroup)this, (float)x, (float)y);
            }

            public int combine$mcI$sp(int x, int y) {
                return Semigroup.combine$mcI$sp$((Semigroup)this, (int)x, (int)y);
            }

            public long combine$mcJ$sp(long x, long y) {
                return Semigroup.combine$mcJ$sp$((Semigroup)this, (long)x, (long)y);
            }

            public Object combineN(Object a, int n) {
                return Semigroup.combineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Semigroup.combineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Semigroup.combineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Semigroup.combineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Semigroup.combineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Option<GridExtent<N>> combineAllOption(TraversableOnce<GridExtent<N>> as) {
                return Semigroup.combineAllOption$((Semigroup)this, as);
            }

            public GridExtent<N> combine(GridExtent<N> l, GridExtent<N> r) {
                if (l.cellwidth() != r.cellwidth()) {
                    throw new GeoAttrsError(new StringBuilder(25).append("illegal cellwidths: ").append(l.cellwidth()).append(" and ").append(r.cellwidth()).toString());
                }
                if (l.cellheight() != r.cellheight()) {
                    throw new GeoAttrsError(new StringBuilder(26).append("illegal cellheights: ").append(l.cellheight()).append(" and ").append(r.cellheight()).toString());
                }
                Extent newExtent = l.extent().combine(r.extent());
                Object newRows = Integral$.MODULE$.apply(this.evidence$1$1).fromDouble((double)scala.math.package$.MODULE$.round(newExtent.height() / l.cellheight()));
                Object newCols = Integral$.MODULE$.apply(this.evidence$1$1).fromDouble((double)scala.math.package$.MODULE$.round(newExtent.width() / l.cellwidth()));
                return new GridExtent<Object>(newExtent, l.cellwidth(), l.cellheight(), newCols, newRows, this.evidence$1$1);
            }
            {
                this.evidence$1$1 = evidence$1$1;
                Semigroup.$init$((Semigroup)this);
            }
        };
    }

    public MosaicRasterSource instance(NonEmptyList<RasterSource> sourcesList, CRS targetCRS, GridExtent<Object> targetGridExtent, SourceName sourceName) {
        return new MosaicRasterSource(sourcesList, targetCRS, targetGridExtent, sourceName){
            private final NonEmptyList<RasterSource> sources;
            private final CRS crs;
            private final SourceName name;
            private final GridExtent targetGridExtent$1;

            public NonEmptyList<RasterSource> sources() {
                return this.sources;
            }

            public CRS crs() {
                return this.crs;
            }

            public GridExtent<Object> gridExtent() {
                return this.targetGridExtent$1;
            }

            public SourceName name() {
                return this.name;
            }
            {
                this.targetGridExtent$1 = targetGridExtent$1;
                this.sources = sourcesList$1;
                this.crs = targetCRS$2;
                this.name = sourceName$1;
            }
        };
    }

    public MosaicRasterSource instance(NonEmptyList<RasterSource> sourcesList, CRS targetCRS, SourceName sourceName) {
        Extent combinedExtent = (Extent)sourcesList.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.extent()).toList().reduce((Function2 & Serializable & scala.Serializable)(x$12, x$13) -> x$12.combine(x$13));
        CellSize minCellSize = (CellSize)sourcesList.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.cellSize()).toList().maxBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToDouble((double)x$15.resolution()), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForDouble()));
        GridExtent<Object> combinedGridExtent = GridExtent$.MODULE$.apply(combinedExtent, minCellSize, Integral$.MODULE$.LongIsIntegral());
        return this.instance(sourcesList, targetCRS, combinedGridExtent, sourceName);
    }

    public MosaicRasterSource instance(NonEmptyList<RasterSource> sourcesList, CRS targetCRS) {
        return this.instance(sourcesList, targetCRS, EmptyName$.MODULE$);
    }

    public MosaicRasterSource instance(NonEmptyList<RasterSource> sourcesList, CRS targetCRS, GridExtent<Object> targetGridExtent) {
        return this.instance(sourcesList, targetCRS, targetGridExtent, EmptyName$.MODULE$);
    }

    public MosaicRasterSource apply(NonEmptyList<RasterSource> sourcesList, CRS targetCRS, GridExtent<Object> targetGridExtent) {
        return this.apply(sourcesList, targetCRS, targetGridExtent, EmptyName$.MODULE$);
    }

    public MosaicRasterSource apply(NonEmptyList<RasterSource> sourcesList, CRS targetCRS, GridExtent<Object> targetGridExtent, SourceName rasterSourceName) {
        return new MosaicRasterSource(rasterSourceName, sourcesList, targetCRS, targetGridExtent){
            private final SourceName name;
            private final NonEmptyList<RasterSource> sources;
            private final CRS crs;
            private final CRS targetCRS$3;
            private final GridExtent targetGridExtent$2;

            public SourceName name() {
                return this.name;
            }

            public NonEmptyList<RasterSource> sources() {
                return this.sources;
            }

            public CRS crs() {
                return this.crs;
            }

            public GridExtent<Object> gridExtent() {
                return this.targetGridExtent$2;
            }
            {
                this.targetCRS$3 = targetCRS$3;
                this.targetGridExtent$2 = targetGridExtent$2;
                this.name = rasterSourceName$1;
                this.sources = sourcesList$2.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.reprojectToGrid($this.targetCRS$3, this.gridExtent(), x$16.reprojectToGrid$default$3(), x$16.reprojectToGrid$default$4()));
                this.crs = targetCRS$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$sources$1(geotrellis.raster.MosaicRasterSource$$anon$4 geotrellis.raster.RasterSource )}, serializedLambda);
            }
        };
    }

    public MosaicRasterSource apply(NonEmptyList<RasterSource> sourcesList, CRS targetCRS) {
        return this.apply(sourcesList, targetCRS, EmptyName$.MODULE$);
    }

    public MosaicRasterSource apply(NonEmptyList<RasterSource> sourcesList, CRS targetCRS, SourceName rasterSourceName) {
        return new MosaicRasterSource(rasterSourceName, sourcesList, targetCRS){
            private final SourceName name;
            private final NonEmptyList<RasterSource> sources;
            private final CRS crs;
            private final NonEmptyList sourcesList$3;
            private final CRS targetCRS$4;

            public SourceName name() {
                return this.name;
            }

            public NonEmptyList<RasterSource> sources() {
                return this.sources;
            }

            public CRS crs() {
                return this.crs;
            }

            public GridExtent<Object> gridExtent() {
                List reprojectedSources = this.sources().toList();
                Extent combinedExtent = (Extent)((TraversableOnce)reprojectedSources.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.extent(), List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$19, x$20) -> x$19.combine(x$20));
                CellSize minCellSize = (CellSize)((TraversableOnce)reprojectedSources.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.cellSize(), List$.MODULE$.canBuildFrom())).maxBy((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToDouble((double)anon.5.$anonfun$gridExtent$4(x$22)), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForDouble()));
                return GridExtent$.MODULE$.apply(combinedExtent, minCellSize, Integral$.MODULE$.LongIsIntegral());
            }

            public static final /* synthetic */ double $anonfun$gridExtent$4(CellSize x$22) {
                return x$22.resolution();
            }
            {
                this.sourcesList$3 = sourcesList$3;
                this.targetCRS$4 = targetCRS$4;
                this.name = rasterSourceName$2;
                this.sources = sourcesList$3.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.reprojectToGrid($this.targetCRS$4, ((RasterMetadata)$this.sourcesList$3.head()).gridExtent(), x$17.reprojectToGrid$default$3(), x$17.reprojectToGrid$default$4()));
                this.crs = targetCRS$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$gridExtent$1(geotrellis.raster.RasterSource ), $anonfun$gridExtent$2(geotrellis.vector.Extent geotrellis.vector.Extent ), $anonfun$gridExtent$3(geotrellis.raster.RasterSource ), $anonfun$gridExtent$4$adapted(geotrellis.raster.CellSize ), $anonfun$sources$2(geotrellis.raster.MosaicRasterSource$$anon$5 geotrellis.raster.RasterSource )}, serializedLambda);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicRasterSource$() {
        MODULE$ = this;
        this.rasterSemigroup = new Semigroup<Raster<MultibandTile>>(){

            public double combine$mcD$sp(double x, double y) {
                return Semigroup.combine$mcD$sp$((Semigroup)this, (double)x, (double)y);
            }

            public float combine$mcF$sp(float x, float y) {
                return Semigroup.combine$mcF$sp$((Semigroup)this, (float)x, (float)y);
            }

            public int combine$mcI$sp(int x, int y) {
                return Semigroup.combine$mcI$sp$((Semigroup)this, (int)x, (int)y);
            }

            public long combine$mcJ$sp(long x, long y) {
                return Semigroup.combine$mcJ$sp$((Semigroup)this, (long)x, (long)y);
            }

            public Object combineN(Object a, int n) {
                return Semigroup.combineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Semigroup.combineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Semigroup.combineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Semigroup.combineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Semigroup.combineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Option<Raster<MultibandTile>> combineAllOption(TraversableOnce<Raster<MultibandTile>> as) {
                return Semigroup.combineAllOption$((Semigroup)this, as);
            }

            public Raster<MultibandTile> combine(Raster<MultibandTile> l, Raster<MultibandTile> r) {
                RasterExtent targetRE = RasterExtent$.MODULE$.apply(l.rasterExtent().extent().combine(r.rasterExtent().extent()), (CellSize)new .colon.colon((Object)l.rasterExtent().cellSize(), (List)new .colon.colon((Object)r.rasterExtent().cellSize(), (List)Nil$.MODULE$)).maxBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)anon.1.$anonfun$combine$1(x$10)), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForDouble())));
                Raster<MultibandTile> result = package$.MODULE$.withMultibandRasterMergeMethod(package$.MODULE$.withMultibandRasterResampleMethods(l).resample(targetRE)).merge(package$.MODULE$.withMultibandRasterResampleMethods(r).resample(targetRE));
                return result;
            }

            public static final /* synthetic */ double $anonfun$combine$1(CellSize x$10) {
                return x$10.resolution();
            }
            {
                Semigroup.$init$((Semigroup)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$combine$1$adapted(geotrellis.raster.CellSize )}, serializedLambda);
            }
        };
    }
}

