/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.ConvertTargetCellType;
import geotrellis.raster.DataType;
import geotrellis.raster.DefaultTarget$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent;
import geotrellis.raster.InterpretAsTargetCellType;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterMetadata;
import geotrellis.raster.RasterSource$;
import geotrellis.raster.ResampleTarget;
import geotrellis.raster.TargetAlignment;
import geotrellis.raster.TargetCellType;
import geotrellis.raster.TargetDimensions;
import geotrellis.raster.TargetRegion;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.io.geotiff.OverviewStrategy$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.ResampleMethod$;
import geotrellis.util.GetComponent;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\t=f!B\u00193\u0003\u00039\u0004\"B#\u0001\t\u00031\u0005\"\u0002%\u0001\r\u0003I\u0005\"\u0002&\u0001\r#Y\u0005b\u00027\u0001#\u0003%\t\"\u001c\u0005\bq\u0002\t\n\u0011\"\u0005z\u0011\u001dY\b!%A\u0005\u0012qDQA \u0001\u0005\u0002}D\u0001\"!\u0003\u0001#\u0003%\t!\u001c\u0005\t\u0003\u0017\u0001\u0011\u0013!C\u0001s\"A\u0011Q\u0002\u0001\u0012\u0002\u0013\u0005A\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u0011\u0005\r\u0002!%A\u0005\u0002eD\u0001\"!\n\u0001#\u0003%\t\u0001 \u0005\b\u0003O\u0001A\u0011AA\u0015\u0011!\tY\u0004AI\u0001\n\u0003I\b\u0002CA\u001f\u0001E\u0005I\u0011\u0001?\t\u000f\u0005}\u0002A\"\u0001\u0002B!9\u0011q\b\u0001\u0005\u0002\u0005%\u0003\u0002CA,\u0001E\u0005I\u0011A=\t\u0011\u0005e\u0003!%A\u0005\u0002qDq!a\u0017\u0001\t\u0003\ti\u0006\u0003\u0005\u0002f\u0001\t\n\u0011\"\u0001z\u0011!\t9\u0007AI\u0001\n\u0003a\bbBA5\u0001\u0011\u0005\u00111\u000e\u0005\t\u0003g\u0002\u0011\u0013!C\u0001s\"A\u0011Q\u000f\u0001\u0012\u0002\u0013\u0005A\u0010C\u0004\u0002x\u00011\t!!\u001f\t\u000f\u0005]\u0004A\"\u0001\u0002P\"9\u0011q\u000f\u0001\u0005\u0002\u0005}\u0007bBA<\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003o\u0002A\u0011AAt\u0011\u001d\t9\b\u0001C\u0001\u0003SDq!!<\u0001\t\u0003\ty\u000fC\u0004\u0002n\u0002!\tAa\u0001\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!9!q\u0001\u0001\u0005\u0002\tE\u0001\u0002\u0003B\u000b\u0001\u0019\u0005!Ga\u0006\t\u0015\t\u0005\u0002\u0001#b\u0001\n#\u0011\u0019\u0003\u0003\u0006\u0003.\u0001A)\u0019!C\t\u0005_AqAa\u000e\u0001\r\u0003\u0011I\u0004C\u0004\u00038\u0001!\tA!\u0010\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D\u001d9!q\t\u001a\t\u0002\t%cAB\u00193\u0011\u0003\u0011Y\u0005\u0003\u0004FY\u0011\u0005!\u0011\f\u0005\b\u00057bC1\u0001B/\u0011\u001d\u0011\u0019\t\fC\u0001\u0005\u000bC\u0011Ba'-\u0003\u0003%IA!(\u0003\u0019I\u000b7\u000f^3s'>,(oY3\u000b\u0005M\"\u0014A\u0002:bgR,'OC\u00016\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001\u0001H\u0011\t\u0004sibT\"\u0001\u001a\n\u0005m\u0012$\u0001C\"fY2<%/\u001b3\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\t1{gn\u001a\t\u0003s\rK!\u0001\u0012\u001a\u0003\u001dI\u000b7\u000f^3s\u001b\u0016$\u0018\rZ1uC\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003s\u0001\t\u0001\"\\3uC\u0012\fG/Y\u000b\u0002\u0005\u0006a!/\u001a9s_*,7\r^5p]R)q\t\u0014+ZE\")Qj\u0001a\u0001\u001d\u0006IA/\u0019:hKR\u001c%k\u0015\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#R\nQ\u0001\u001d:pURJ!a\u0015)\u0003\u0007\r\u00136\u000bC\u0004V\u0007A\u0005\t\u0019\u0001,\u0002\u001dI,7/Y7qY\u0016$\u0016M]4fiB\u0011\u0011hV\u0005\u00031J\u0012aBU3tC6\u0004H.\u001a+be\u001e,G\u000fC\u0004[\u0007A\u0005\t\u0019A.\u0002\r5,G\u000f[8e!\tavL\u0004\u0002:;&\u0011aLM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0017M\u0001\bSKN\fW\u000e\u001d7f\u001b\u0016$\bn\u001c3\u000b\u0005y\u0013\u0004bB2\u0004!\u0003\u0005\r\u0001Z\u0001\tgR\u0014\u0018\r^3hsB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\bO\u0016|G/\u001b4g\u0015\tI''\u0001\u0002j_&\u00111N\u001a\u0002\u0011\u001fZ,'O^5foN#(/\u0019;fOf\faC]3qe>TWm\u0019;j_:$C-\u001a4bk2$HEM\u000b\u0002]*\u0012ak\\\u0016\u0002aB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001e \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002xe\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-I,\u0007O]8kK\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*\u0012A\u001f\u0016\u00037>\faC]3qe>TWm\u0019;j_:$C-\u001a4bk2$H\u0005N\u000b\u0002{*\u0012Am\\\u0001\ne\u0016\u0004(o\u001c6fGR$\u0012bRA\u0001\u0003\u0007\t)!a\u0002\t\u000b5;\u0001\u0019\u0001(\t\u000fU;\u0001\u0013!a\u0001-\"9!l\u0002I\u0001\u0002\u0004Y\u0006bB2\b!\u0003\u0005\r\u0001Z\u0001\u0014e\u0016\u0004(o\u001c6fGR$C-\u001a4bk2$HEM\u0001\u0014e\u0016\u0004(o\u001c6fGR$C-\u001a4bk2$HeM\u0001\u0014e\u0016\u0004(o\u001c6fGR$C-\u001a4bk2$H\u0005N\u0001\u0010e\u0016\u0004(o\u001c6fGR$vn\u0012:jIRIq)a\u0005\u0002\u0016\u0005}\u0011\u0011\u0005\u0005\u0006\u001b.\u0001\rA\u0014\u0005\b\u0003/Y\u0001\u0019AA\r\u0003\u00119'/\u001b3\u0011\te\nY\u0002P\u0005\u0004\u0003;\u0011$AC$sS\u0012,\u0005\u0010^3oi\"9!l\u0003I\u0001\u0002\u0004Y\u0006bB2\f!\u0003\u0005\r\u0001Z\u0001\u001ae\u0016\u0004(o\u001c6fGR$vn\u0012:jI\u0012\"WMZ1vYR$3'A\rsKB\u0014xN[3diR{wI]5eI\u0011,g-Y;mi\u0012\"\u0014!\u0005:faJ|'.Z2u)>\u0014VmZ5p]RIq)a\u000b\u0002.\u0005]\u0012\u0011\b\u0005\u0006\u001b:\u0001\rA\u0014\u0005\b\u0003_q\u0001\u0019AA\u0019\u0003\u0019\u0011XmZ5p]B\u0019\u0011(a\r\n\u0007\u0005U\"G\u0001\u0007SCN$XM]#yi\u0016tG\u000fC\u0004[\u001dA\u0005\t\u0019A.\t\u000f\rt\u0001\u0013!a\u0001I\u0006Y\"/\u001a9s_*,7\r\u001e+p%\u0016<\u0017n\u001c8%I\u00164\u0017-\u001e7uIM\n1D]3qe>TWm\u0019;U_J+w-[8oI\u0011,g-Y;mi\u0012\"\u0014\u0001\u0003:fg\u0006l\u0007\u000f\\3\u0015\u000f\u001d\u000b\u0019%!\u0012\u0002H!)Q+\u0005a\u0001-\")!,\u0005a\u00017\")1-\u0005a\u0001IRIq)a\u0013\u0002P\u0005M\u0013Q\u000b\u0005\u0007\u0003\u001b\u0012\u0002\u0019\u0001\u001f\u0002\u0015Q\f'oZ3u\u0007>d7\u000f\u0003\u0004\u0002RI\u0001\r\u0001P\u0001\u000bi\u0006\u0014x-\u001a;S_^\u001c\bb\u0002.\u0013!\u0003\u0005\ra\u0017\u0005\bGJ\u0001\n\u00111\u0001e\u0003I\u0011Xm]1na2,G\u0005Z3gCVdG\u000fJ\u001a\u0002%I,7/Y7qY\u0016$C-\u001a4bk2$H\u0005N\u0001\u000fe\u0016\u001c\u0018-\u001c9mKR{wI]5e)\u001d9\u0015qLA1\u0003GBq!a\u0006\u0016\u0001\u0004\tI\u0002C\u0004[+A\u0005\t\u0019A.\t\u000f\r,\u0002\u0013!a\u0001I\u0006A\"/Z:b[BdW\rV8He&$G\u0005Z3gCVdG\u000f\n\u001a\u00021I,7/Y7qY\u0016$vn\u0012:jI\u0012\"WMZ1vYR$3'\u0001\tsKN\fW\u000e\u001d7f)>\u0014VmZ5p]R9q)!\u001c\u0002p\u0005E\u0004bBA\u00181\u0001\u0007\u0011\u0011\u0004\u0005\b5b\u0001\n\u00111\u0001\\\u0011\u001d\u0019\u0007\u0004%AA\u0002\u0011\f!D]3tC6\u0004H.\u001a+p%\u0016<\u0017n\u001c8%I\u00164\u0017-\u001e7uII\n!D]3tC6\u0004H.\u001a+p%\u0016<\u0017n\u001c8%I\u00164\u0017-\u001e7uIM\nAA]3bIR1\u00111PAG\u0003;\u0003R!PA?\u0003\u0003K1!a ?\u0005\u0019y\u0005\u000f^5p]B)\u0011(a!\u0002\b&\u0019\u0011Q\u0011\u001a\u0003\rI\u000b7\u000f^3s!\rI\u0014\u0011R\u0005\u0004\u0003\u0017\u0013$!D'vYRL'-\u00198e)&dW\rC\u0004\u0002\u0010n\u0001\r!!%\u0002\r\u0015DH/\u001a8u!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAALi\u00051a/Z2u_JLA!a'\u0002\u0016\n1Q\t\u001f;f]RDq!a(\u001c\u0001\u0004\t\t+A\u0003cC:$7\u000f\u0005\u0004\u0002$\u0006E\u0016q\u0017\b\u0005\u0003K\u000byK\u0004\u0003\u0002(\u00065VBAAU\u0015\r\tYKN\u0001\u0007yI|w\u000e\u001e \n\u0003}J!A\u0018 \n\t\u0005M\u0016Q\u0017\u0002\u0004'\u0016\f(B\u00010?!\ri\u0014\u0011X\u0005\u0004\u0003ws$aA%oi\"*1$a0\u0002LB)Q(!1\u0002F&\u0019\u00111\u0019 \u0003\rQD'o\\<t!\u0011\t\u0019+a2\n\t\u0005%\u0017Q\u0017\u0002\u001a\u0013:$W\r_(vi>3'i\\;oIN,\u0005pY3qi&|g.\t\u0002\u0002N\u0006y\u0012N\u001a\u0011sKF,Xm\u001d;fI\u0002\u0012\u0017M\u001c3tA\u0011|\u0007E\\8uA\u0015D\u0018n\u001d;\u0015\r\u0005m\u0014\u0011[An\u0011\u001d\t\u0019\u000e\ba\u0001\u0003+\faAY8v]\u0012\u001c\b\u0003B\u001d\u0002XrJ1!!73\u0005)9%/\u001b3C_VtGm\u001d\u0005\b\u0003?c\u0002\u0019AAQQ\u0015a\u0012qXAf)\u0011\tY(!9\t\u000f\u0005=U\u00041\u0001\u0002\u0012R!\u00111PAs\u0011\u001d\t\u0019N\ba\u0001\u0003+$\"!a\u001f\u0015\t\u0005m\u00141\u001e\u0005\b\u0003?\u0003\u0003\u0019AAQ\u0003-\u0011X-\u00193FqR,g\u000e^:\u0015\r\u0005E\u0018q\u001fB\u0001!\u0019\t\u0019+a=\u0002\u0002&!\u0011Q_A[\u0005!IE/\u001a:bi>\u0014\bbBA}C\u0001\u0007\u00111`\u0001\bKb$XM\u001c;t!\u0019\t\u0019+!@\u0002\u0012&!\u0011q`A[\u0005-!&/\u0019<feN\f'\r\\3\t\u000f\u0005}\u0015\u00051\u0001\u0002\"R!\u0011\u0011\u001fB\u0003\u0011\u001d\tIP\ta\u0001\u0003w\f!B]3bI\n{WO\u001c3t)\u0019\t\tPa\u0003\u0003\u0010!9\u00111[\u0012A\u0002\t5\u0001CBAR\u0003{\f)\u000eC\u0004\u0002 \u000e\u0002\r!!)\u0015\t\u0005E(1\u0003\u0005\b\u0003'$\u0003\u0019\u0001B\u0007\u00039!\u0018M]4fi\u000e+G\u000e\u001c+za\u0016,\"A!\u0007\u0011\u000bu\niHa\u0007\u0011\u0007e\u0012i\"C\u0002\u0003 I\u0012a\u0002V1sO\u0016$8)\u001a7m)f\u0004X-A\u0006egR\u001cU\r\u001c7UsB,WC\u0001B\u0013!\u0015i\u0014Q\u0010B\u0014!\ra&\u0011F\u0005\u0004\u0005W\t'\u0001C\"fY2$\u0016\u0010]3\u0002\u001b\r|gN^3siJ\u000b7\u000f^3s+\t\u0011\t\u0004E\u0004>\u0005g\t\t)!!\n\u0007\tUbHA\u0005Gk:\u001cG/[8oc\u000591m\u001c8wKJ$HcA$\u0003<!9!Q\u0003\u0015A\u0002\tmAcA$\u0003@!9!QC\u0015A\u0002\t\u001d\u0012aC5oi\u0016\u0014\bO]3u\u0003N$2a\u0012B#\u0011\u001d\u0011)B\u000ba\u0001\u0005O\tABU1ti\u0016\u00148k\\;sG\u0016\u0004\"!\u000f\u0017\u0014\u000b1\u0012iEa\u0015\u0011\u0007u\u0012y%C\u0002\u0003Ry\u0012a!\u00118z%\u00164\u0007cA\u001f\u0003V%\u0019!q\u000b \u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\t%\u0013\u0001\u00079s_*,7\r^3e\u000bb$XM\u001c;D_6\u0004xN\\3oiV!!q\fB9+\t\u0011\t\u0007\u0005\u0005\u0003d\t%$Q\u000eB?\u001b\t\u0011)GC\u0002\u0003hQ\nA!\u001e;jY&!!1\u000eB3\u000519U\r^\"p[B|g.\u001a8u!\u0011\u0011yG!\u001d\r\u0001\u00119!1\u000f\u0018C\u0002\tU$!\u0001+\u0012\u0007\t]t\tE\u0002>\u0005sJ1Aa\u001f?\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a%\u0003\u0000%!!\u0011QAK\u0005=\u0001&o\u001c6fGR,G-\u0012=uK:$\u0018!B1qa2LHcA$\u0003\b\"9!\u0011R\u0018A\u0002\t-\u0015\u0001\u00029bi\"\u0004BA!$\u0003\u0016:!!q\u0012BI!\r\t9KP\u0005\u0004\u0005's\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0018\ne%AB*ue&twMC\u0002\u0003\u0014z\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0014\t\u0005\u0005C\u0013Y+\u0004\u0002\u0003$*!!Q\u0015BT\u0003\u0011a\u0017M\\4\u000b\u0005\t%\u0016\u0001\u00026bm\u0006LAA!,\u0003$\n1qJ\u00196fGR\u0004")
public abstract class RasterSource
extends CellGrid<Object>
implements RasterMetadata {
    private Option<DataType> dstCellType;
    private Function1<Raster<MultibandTile>, Raster<MultibandTile>> convertRaster;
    private volatile byte bitmap$0;

    public static RasterSource apply(String string) {
        return RasterSource$.MODULE$.apply(string);
    }

    public static <T extends RasterSource> GetComponent<T, ProjectedExtent> projectedExtentComponent() {
        return RasterSource$.MODULE$.projectedExtentComponent();
    }

    @Override
    public CellSize cellSize() {
        return RasterMetadata.cellSize$(this);
    }

    @Override
    public Extent extent() {
        return RasterMetadata.extent$(this);
    }

    @Override
    public long cols() {
        return RasterMetadata.cols$(this);
    }

    @Override
    public long rows() {
        return RasterMetadata.rows$(this);
    }

    public abstract RasterMetadata metadata();

    public abstract RasterSource reprojection(CRS var1, ResampleTarget var2, ResampleMethod var3, OverviewStrategy var4);

    public RasterSource reproject(CRS targetCRS, ResampleTarget resampleTarget, ResampleMethod method, OverviewStrategy strategy) {
        CRS cRS = targetCRS;
        CRS cRS2 = this.crs();
        return !(cRS != null ? !cRS.equals(cRS2) : cRS2 != null) ? this : this.reprojection(targetCRS, resampleTarget, method, strategy);
    }

    public ResampleTarget reprojection$default$2() {
        return DefaultTarget$.MODULE$;
    }

    public ResampleMethod reprojection$default$3() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    public OverviewStrategy reprojection$default$4() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    public ResampleTarget reproject$default$2() {
        return DefaultTarget$.MODULE$;
    }

    public ResampleMethod reproject$default$3() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    public OverviewStrategy reproject$default$4() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    /*
     * Enabled aggressive block sorting
     */
    public RasterSource reprojectToGrid(CRS targetCRS, GridExtent<Object> grid, ResampleMethod method, OverviewStrategy strategy) {
        RasterSource rasterSource;
        CRS cRS = targetCRS;
        CRS cRS2 = this.crs();
        if (!(cRS != null ? !cRS.equals(cRS2) : cRS2 != null)) {
            GridExtent<Object> gridExtent = grid;
            GridExtent gridExtent2 = this.gridExtent();
            if (!(gridExtent != null ? !((Object)gridExtent).equals(gridExtent2) : gridExtent2 != null)) {
                rasterSource = this;
                return rasterSource;
            }
        }
        CRS cRS3 = targetCRS;
        CRS cRS4 = this.crs();
        if (!(cRS3 != null ? !cRS3.equals(cRS4) : cRS4 != null)) {
            rasterSource = this.resampleToGrid(grid, method, strategy);
            return rasterSource;
        }
        rasterSource = this.reprojection(targetCRS, new TargetAlignment(grid), method, strategy);
        return rasterSource;
    }

    public ResampleMethod reprojectToGrid$default$3() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    public OverviewStrategy reprojectToGrid$default$4() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    /*
     * Enabled aggressive block sorting
     */
    public RasterSource reprojectToRegion(CRS targetCRS, RasterExtent region, ResampleMethod method, OverviewStrategy strategy) {
        RasterSource rasterSource;
        CRS cRS = targetCRS;
        CRS cRS2 = this.crs();
        if (!(cRS != null ? !cRS.equals(cRS2) : cRS2 != null)) {
            RasterExtent rasterExtent = region;
            GridExtent gridExtent = this.gridExtent();
            if (!(rasterExtent != null ? !((Object)rasterExtent).equals(gridExtent) : gridExtent != null)) {
                rasterSource = this;
                return rasterSource;
            }
        }
        CRS cRS3 = targetCRS;
        CRS cRS4 = this.crs();
        if (!(cRS3 != null ? !cRS3.equals(cRS4) : cRS4 != null)) {
            rasterSource = this.resampleToRegion(region.toGridType(Integral$.MODULE$.LongIsIntegral()), method, strategy);
            return rasterSource;
        }
        rasterSource = this.reprojection(targetCRS, new TargetRegion(region.toGridType(Integral$.MODULE$.LongIsIntegral())), method, strategy);
        return rasterSource;
    }

    public ResampleMethod reprojectToRegion$default$3() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    public OverviewStrategy reprojectToRegion$default$4() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    public abstract RasterSource resample(ResampleTarget var1, ResampleMethod var2, OverviewStrategy var3);

    public RasterSource resample(long targetCols, long targetRows, ResampleMethod method, OverviewStrategy strategy) {
        return this.resample(new TargetDimensions(targetCols, targetRows), method, strategy);
    }

    public ResampleMethod resample$default$3() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    public OverviewStrategy resample$default$4() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    public RasterSource resampleToGrid(GridExtent<Object> grid, ResampleMethod method, OverviewStrategy strategy) {
        return this.resample(new TargetAlignment(grid), method, strategy);
    }

    public ResampleMethod resampleToGrid$default$2() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    public OverviewStrategy resampleToGrid$default$3() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    public RasterSource resampleToRegion(GridExtent<Object> region, ResampleMethod method, OverviewStrategy strategy) {
        return this.resample(new TargetRegion(region), method, strategy);
    }

    public ResampleMethod resampleToRegion$default$2() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    public OverviewStrategy resampleToRegion$default$3() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    public abstract Option<Raster<MultibandTile>> read(Extent var1, Seq<Object> var2) throws IndexOutOfBoundsException;

    public abstract Option<Raster<MultibandTile>> read(GridBounds<Object> var1, Seq<Object> var2) throws IndexOutOfBoundsException;

    public Option<Raster<MultibandTile>> read(Extent extent) {
        return this.read(extent, (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()));
    }

    public Option<Raster<MultibandTile>> read(GridBounds<Object> bounds) {
        return this.read(bounds, (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()));
    }

    public Option<Raster<MultibandTile>> read() {
        return this.read(this.extent(), (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()));
    }

    public Option<Raster<MultibandTile>> read(Seq<Object> bands) {
        return this.read(this.extent(), bands);
    }

    public Iterator<Raster<MultibandTile>> readExtents(Traversable<Extent> extents, Seq<Object> bands) {
        return extents.toIterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(this.read((Extent)x$1, bands)).toIterator());
    }

    public Iterator<Raster<MultibandTile>> readExtents(Traversable<Extent> extents) {
        return this.readExtents(extents, (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()));
    }

    public Iterator<Raster<MultibandTile>> readBounds(Traversable<GridBounds<Object>> bounds, Seq<Object> bands) {
        return bounds.toIterator().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.read((GridBounds<Object>)x$2, bands)).toIterator());
    }

    public Iterator<Raster<MultibandTile>> readBounds(Traversable<GridBounds<Object>> bounds) {
        return bounds.toIterator().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(this.read((GridBounds<Object>)x$3, (Seq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()))).toIterator());
    }

    public abstract Option<TargetCellType> targetCellType();

    private Option<DataType> dstCellType$lzycompute() {
        RasterSource rasterSource = this;
        synchronized (rasterSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                None$ none$;
                Option<TargetCellType> option = this.targetCellType();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TargetCellType target = (TargetCellType)some.value();
                    none$ = new Some((Object)target.cellType());
                } else if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
                this.dstCellType = none$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dstCellType;
    }

    public Option<DataType> dstCellType() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dstCellType$lzycompute() : this.dstCellType;
    }

    private Function1<Raster<MultibandTile>, Raster<MultibandTile>> convertRaster$lzycompute() {
        RasterSource rasterSource = this;
        synchronized (rasterSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                Some some;
                TargetCellType target;
                Option<TargetCellType> option = this.targetCellType();
                if (option instanceof Some && (target = (TargetCellType)(some = (Some)option).value()) != null) {
                    TargetCellType targetCellType = target;
                    intersect = (Function1 & Serializable & scala.Serializable)raster -> targetCellType.apply((Function0<Raster<MultibandTile>>)(Function0 & Serializable & scala.Serializable)() -> raster);
                } else {
                    intersect = (Function1 & Serializable & scala.Serializable)raster -> raster;
                }
                this.convertRaster = intersect;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.convertRaster;
    }

    public Function1<Raster<MultibandTile>, Raster<MultibandTile>> convertRaster() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.convertRaster$lzycompute() : this.convertRaster;
    }

    public abstract RasterSource convert(TargetCellType var1);

    public RasterSource convert(DataType targetCellType) {
        return this.convert(new ConvertTargetCellType(targetCellType));
    }

    public RasterSource interpretAs(DataType targetCellType) {
        return this.convert(new InterpretAsTargetCellType(targetCellType));
    }

    public RasterSource() {
        super(Integral$.MODULE$.LongIsIntegral());
        RasterMetadata.$init$(this);
    }
}

