/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.density;

import geotrellis.raster.DataType;
import geotrellis.raster.Dimensions;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.density.DoubleKernelStamper$;
import geotrellis.raster.density.KernelStamper;
import geotrellis.raster.mapalgebra.focal.Kernel;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u0015*\u0001BB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005S\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dA\u0006A1A\u0005\u0002eCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%\ta\u0018\u0005\u0007G\u0002\u0001\u000b\u0011\u00021\t\u000f\u0011\u0004!\u0019!C\u0001?\"1Q\r\u0001Q\u0001\n\u0001DqA\u001a\u0001C\u0002\u0013\u0005q\r\u0003\u0004p\u0001\u0001\u0006I\u0001\u001b\u0005\u000ba\u0002\u0001\n\u0011aA!\u0002\u0013\t\bb\u0002;\u0001\u0005\u0004%\ta\u0018\u0005\u0007k\u0002\u0001\u000b\u0011\u00021\t\u000fY\u0004!\u0019!C\u0001?\"1q\u000f\u0001Q\u0001\n\u0001DQ\u0001\u001f\u0001\u0005\u0002eDq!a\u0002\u0001\t\u0003\tI\u0001\u0003\u0004\u0002\u0018\u0001!\tA\u0011\u0005\n\u00033\u0001\u0011\u0011!C\u0001\u00037A\u0011\"!\t\u0001#\u0003%\t!a\t\t\u0013\u0005e\u0002!%A\u0005\u0002\u0005m\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011!\t\u0019\u0006AA\u0001\n\u0003y\u0006\"CA+\u0001\u0005\u0005I\u0011AA,\u0011%\t\u0019\u0007AA\u0001\n\u0003\n)\u0007C\u0005\u0002t\u0001\t\t\u0011\"\u0001\u0002v!I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u0007\u0003\u0011\u0011!C!\u0003\u000bC\u0011\"a\"\u0001\u0003\u0003%\t%!#\b\u0013\u00055\u0015&!A\t\u0002\u0005=e\u0001\u0003\u0015*\u0003\u0003E\t!!%\t\rM\u0013C\u0011AAP\u0011%\t\u0019IIA\u0001\n\u000b\n)\tC\u0005\u0002\"\n\n\t\u0011\"!\u0002$\"I\u0011\u0011\u0016\u0012\u0002\u0002\u0013\u0005\u00151\u0016\u0005\n\u0003s\u0013\u0013\u0011!C\u0005\u0003w\u00131\u0003R8vE2,7*\u001a:oK2\u001cF/Y7qKJT!AK\u0016\u0002\u000f\u0011,gn]5us*\u0011A&L\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u00039\n!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019R\u0001A\u00198wy\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007C\u0001\u001d:\u001b\u0005I\u0013B\u0001\u001e*\u00055YUM\u001d8fYN#\u0018-\u001c9feB\u0011!\u0007P\u0005\u0003{M\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00023\u007f%\u0011\u0001i\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005i&dW-F\u0001D!\t!U)D\u0001,\u0013\t15F\u0001\tNkR\f'\r\\3BeJ\f\u0017\u0010V5mK\u0006)A/\u001b7fA\u0005\t1.F\u0001K!\tY\u0005+D\u0001M\u0015\tie*A\u0003g_\u000e\fGN\u0003\u0002PW\u0005QQ.\u00199bY\u001e,'M]1\n\u0005Ec%AB&fe:,G.\u0001\u0002lA\u00051A(\u001b8jiz\"2!\u0016,X!\tA\u0004\u0001C\u0003B\u000b\u0001\u00071\tC\u0003I\u000b\u0001\u0007!*A\u0003li&dW-F\u0001[!\t!5,\u0003\u0002]W\t!A+\u001b7f\u0003\u0019YG/\u001b7fA\u0005Q1.\u001a:oK2\u001cw\u000e\\:\u0016\u0003\u0001\u0004\"AM1\n\u0005\t\u001c$aA%oi\u0006Y1.\u001a:oK2\u001cw\u000e\\:!\u0003)YWM\u001d8fYJ|wo]\u0001\fW\u0016\u0014h.\u001a7s_^\u001c\b%\u0001\u0005dK2dG+\u001f9f+\u0005A\u0007CA5m\u001d\t!%.\u0003\u0002lW\u00059\u0001/Y2lC\u001e,\u0017BA7o\u0005!\u0019U\r\u001c7UsB,'BA6,\u0003%\u0019W\r\u001c7UsB,\u0007%A\u0002yIM\u0002BA\r:aA&\u00111o\r\u0002\u0007)V\u0004H.\u001a\u001a\u0002\t\r|Gn]\u0001\u0006G>d7\u000fI\u0001\u0005e><8/A\u0003s_^\u001c\b%A\u0006ti\u0006l\u0007oS3s]\u0016dG#\u0002>~\u007f\u0006\r\u0001C\u0001\u001a|\u0013\ta8G\u0001\u0003V]&$\b\"\u0002@\u0014\u0001\u0004\u0001\u0017aA2pY\"1\u0011\u0011A\nA\u0002\u0001\f1A]8x\u0011\u0019\t)a\u0005a\u0001A\u0006\t!0A\tti\u0006l\u0007oS3s]\u0016dGi\\;cY\u0016$rA_A\u0006\u0003\u001b\ty\u0001C\u0003\u007f)\u0001\u0007\u0001\r\u0003\u0004\u0002\u0002Q\u0001\r\u0001\u0019\u0005\b\u0003\u000b!\u0002\u0019AA\t!\r\u0011\u00141C\u0005\u0004\u0003+\u0019$A\u0002#pk\ndW-\u0001\u0004sKN,H\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003V\u0003;\ty\u0002C\u0004B-A\u0005\t\u0019A\"\t\u000f!3\u0002\u0013!a\u0001\u0015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0013U\r\u0019\u0015qE\u0016\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0005v]\u000eDWmY6fI*\u0019\u00111G\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00055\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u001fU\rQ\u0015qE\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005Y\u0006twM\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\u0011\t\t&a\u0012\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0017\u0002`A\u0019!'a\u0017\n\u0007\u0005u3GA\u0002B]fD\u0001\"!\u0019\u001c\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0004CBA5\u0003_\nI&\u0004\u0002\u0002l)\u0019\u0011QN\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002r\u0005-$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001e\u0002~A\u0019!'!\u001f\n\u0007\u0005m4GA\u0004C_>dW-\u00198\t\u0013\u0005\u0005T$!AA\u0002\u0005e\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0001\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\na!Z9vC2\u001cH\u0003BA<\u0003\u0017C\u0011\"!\u0019!\u0003\u0003\u0005\r!!\u0017\u0002'\u0011{WO\u00197f\u0017\u0016\u0014h.\u001a7Ti\u0006l\u0007/\u001a:\u0011\u0005a\u00123\u0003\u0002\u0012\u0002\u0014z\u0002r!!&\u0002\u001c\u000eSU+\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\u001a\u0002\u000fI,h\u000e^5nK&!\u0011QTAL\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u001f\u000bQ!\u00199qYf$R!VAS\u0003OCQ!Q\u0013A\u0002\rCQ\u0001S\u0013A\u0002)\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002.\u0006U\u0006#\u0002\u001a\u00020\u0006M\u0016bAAYg\t1q\n\u001d;j_:\u0004BA\r:D\u0015\"A\u0011q\u0017\u0014\u0002\u0002\u0003\u0007Q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0018\t\u0005\u0003\u000b\ny,\u0003\u0003\u0002B\u0006\u001d#AB(cU\u0016\u001cG\u000f")
public class DoubleKernelStamper
implements KernelStamper,
Product,
Serializable {
    private final MutableArrayTile tile;
    private final Kernel k;
    private final Tile ktile;
    private final int kernelcols;
    private final int kernelrows;
    private final DataType cellType;
    private final /* synthetic */ Tuple2 x$3;
    private final int cols;
    private final int rows;

    public static Option<Tuple2<MutableArrayTile, Kernel>> unapply(DoubleKernelStamper doubleKernelStamper) {
        return DoubleKernelStamper$.MODULE$.unapply(doubleKernelStamper);
    }

    public static DoubleKernelStamper apply(MutableArrayTile mutableArrayTile, Kernel kernel) {
        return DoubleKernelStamper$.MODULE$.apply(mutableArrayTile, kernel);
    }

    public static Function1<Tuple2<MutableArrayTile, Kernel>, DoubleKernelStamper> tupled() {
        return DoubleKernelStamper$.MODULE$.tupled();
    }

    public static Function1<MutableArrayTile, Function1<Kernel, DoubleKernelStamper>> curried() {
        return DoubleKernelStamper$.MODULE$.curried();
    }

    @Override
    public void stampKernel(Tuple2<Object, Object> tup, int z) {
        KernelStamper.stampKernel$(this, tup, z);
    }

    @Override
    public void stampKernelDouble(Tuple2<Object, Object> tup, double z) {
        KernelStamper.stampKernelDouble$(this, tup, z);
    }

    public MutableArrayTile tile() {
        return this.tile;
    }

    public Kernel k() {
        return this.k;
    }

    public Tile ktile() {
        return this.ktile;
    }

    public int kernelcols() {
        return this.kernelcols;
    }

    public int kernelrows() {
        return this.kernelrows;
    }

    public DataType cellType() {
        return this.cellType;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    @Override
    public void stampKernel(int col, int row, int z) {
        if (z == 0) {
            int o = this.tile().get(col, row);
            this.tile().set(col, row, o == Integer.MIN_VALUE ? 0 : o);
        } else {
            int rowmin = row - this.kernelrows() / 2;
            int rowmax = package$.MODULE$.min(row + this.kernelrows() / 2 + 1, this.rows());
            int colmin = col - this.kernelcols() / 2;
            int colmax = package$.MODULE$.min(col + this.kernelcols() / 2 + 1, this.cols());
            int kcol = 0;
            int krow = 0;
            int r = rowmin;
            int c = colmin;
            while (r < rowmax) {
                while (c < colmax) {
                    double k;
                    if (r >= 0 && c >= 0 && r < this.rows() && c < this.cols() && kcol >= 0 && krow >= 0 && kcol < this.kernelcols() && krow < this.kernelrows() && !Double.isNaN(k = this.ktile().getDouble(kcol, krow))) {
                        int o = this.tile().get(c, r);
                        double w = o == Integer.MIN_VALUE ? k * (double)z : (double)o + k * (double)z;
                        this.tile().set(c, r, (int)w);
                    }
                    ++c;
                    ++kcol;
                }
                kcol = 0;
                c = colmin;
                ++r;
                ++krow;
            }
        }
    }

    @Override
    public void stampKernelDouble(int col, int row, double z) {
        if (z == 0.0) {
            double o = this.tile().getDouble(col, row);
            this.tile().setDouble(col, row, Double.isNaN(o) ? 0.0 : o);
        } else {
            int rowmin = row - this.kernelrows() / 2;
            int rowmax = package$.MODULE$.min(row + this.kernelrows() / 2 + 1, this.rows());
            int colmin = col - this.kernelcols() / 2;
            int colmax = package$.MODULE$.min(col + this.kernelcols() / 2 + 1, this.cols());
            int kcol = 0;
            int krow = 0;
            int r = rowmin;
            int c = colmin;
            while (r < rowmax) {
                while (c < colmax) {
                    double k;
                    if (r >= 0 && c >= 0 && r < this.rows() && c < this.cols() && kcol >= 0 && krow >= 0 && kcol < this.kernelcols() && krow < this.kernelrows() && !Double.isNaN(k = this.ktile().getDouble(kcol, krow))) {
                        double o = this.tile().getDouble(c, r);
                        double w = Double.isNaN(o) ? k * z : o + k * z;
                        this.tile().setDouble(c, r, w);
                    }
                    ++c;
                    ++kcol;
                }
                kcol = 0;
                c = colmin;
                ++r;
                ++krow;
            }
        }
    }

    @Override
    public MutableArrayTile result() {
        return this.tile();
    }

    public DoubleKernelStamper copy(MutableArrayTile tile, Kernel k) {
        return new DoubleKernelStamper(tile, k);
    }

    public MutableArrayTile copy$default$1() {
        return this.tile();
    }

    public Kernel copy$default$2() {
        return this.k();
    }

    public String productPrefix() {
        return "DoubleKernelStamper";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.tile();
                break;
            }
            case 1: {
                serializable = this.k();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return serializable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DoubleKernelStamper;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DoubleKernelStamper)) return false;
        boolean bl = true;
        if (!bl) return false;
        DoubleKernelStamper doubleKernelStamper = (DoubleKernelStamper)x$1;
        MutableArrayTile mutableArrayTile = this.tile();
        MutableArrayTile mutableArrayTile2 = doubleKernelStamper.tile();
        if (mutableArrayTile == null) {
            if (mutableArrayTile2 != null) {
                return false;
            }
        } else if (!((Object)mutableArrayTile).equals(mutableArrayTile2)) return false;
        Kernel kernel = this.k();
        Kernel kernel2 = doubleKernelStamper.k();
        if (kernel == null) {
            if (kernel2 != null) {
                return false;
            }
        } else if (!((Object)kernel).equals(kernel2)) return false;
        if (!doubleKernelStamper.canEqual(this)) return false;
        return true;
    }

    public DoubleKernelStamper(MutableArrayTile tile, Kernel k) {
        this.tile = tile;
        this.k = k;
        KernelStamper.$init$(this);
        Product.$init$((Product)this);
        this.ktile = k.tile();
        this.kernelcols = BoxesRunTime.unboxToInt(this.ktile().cols());
        this.kernelrows = BoxesRunTime.unboxToInt(this.ktile().rows());
        this.cellType = tile.cellType();
        Dimensions dimensions = tile.dimensions();
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int cols = dimensions.cols$mcI$sp();
        int rows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        this.x$3 = sp2;
        this.cols = this.x$3._1$mcI$sp();
        this.rows = this.x$3._2$mcI$sp();
    }
}

