/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.geotiff;

import geotrellis.proj4.CRS;
import geotrellis.proj4.Proj4Transform$;
import geotrellis.proj4.Transform$;
import geotrellis.raster.ArrayMultibandTile;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.DefaultTarget$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.RasterSource;
import geotrellis.raster.ResampleTarget;
import geotrellis.raster.TargetCellType;
import geotrellis.raster.geotiff.GeoTiffMetadata;
import geotrellis.raster.geotiff.GeoTiffPath;
import geotrellis.raster.geotiff.GeoTiffReprojectRasterSource$;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.io.geotiff.OverviewStrategy$;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader$;
import geotrellis.raster.reproject.RasterRegionReproject;
import geotrellis.raster.reproject.RasterRegionReproject$;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.Reproject$Options$;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.raster.resample.ResampleMethod$;
import geotrellis.util.ByteReader;
import geotrellis.util.RangeReader$;
import geotrellis.vector.Extent;
import geotrellis.vector.Extent$;
import geotrellis.vector.package$;
import java.io.Serializable;
import org.locationtech.jts.geom.Envelope;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001B\u001f?\u0001\u0015C\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003T\u0011!Q\u0006A!b\u0001\n\u0003Y\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tS\u0002\u0011)\u0019!C\u0001U\"A!\u000f\u0001B\u0001B\u0003%1\u000e\u0003\u0005t\u0001\t\u0015\r\u0011\"\u0001u\u0011!Y\bA!A!\u0002\u0013)\b\"\u0003?\u0001\u0005\u000b\u0007I\u0011\u0001!~\u0011%\tI\u0001\u0001B\u0001B\u0003%a\u0010C\u0006\u0002\f\u0001\u0011)\u0019!C\u0001\u0001\u00065\u0001BCA\f\u0001\t\u0005\t\u0015!\u0003\u0002\u0010!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002BBA\u001c\u0001\u0011\u00051\nC\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003o\u0002A\u0011AA=\u0011\u001d\t\t\n\u0001C\u0001\u0003'C\u0011\"!'\u0001\u0011\u000b\u0007I\u0011\u0003*\t\u0015\u0005m\u0005\u0001#b\u0001\n#\ti\n\u0003\u0006\u0002,\u0002A)\u0019!C!\u0003;C!\"!,\u0001\u0011\u000b\u0007I\u0011AAX\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!a2\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\u0002\u0001!\tEa\u0001\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002\"\u0003B\u0019\u0001E\u0005I\u0011\u0001B\u001a\u0011%\u0011I\u0005AI\u0001\n\u0003\u0011Y\u0005C\u0005\u0003P\u0001\t\n\u0011\"\u0001\u0003R!1Q\r\u0001C\u0001\u0005+BqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0004\u0003d\u0001!\tE!\u001a\t\u0015\t\u001d\u0004\u0001#b\u0001\n\u0003\u0011I\u0007\u0003\u0006\u0003n\u0001A)\u0019!C\t\u0005_B!Ba \u0001\u0011\u000b\u0007I\u0011\u0003B8\u0011-\u0011\u0019\t\u0001EC\u0002\u0013\u0005\u0001I!\"\b\u000f\t=e\b#\u0001\u0003\u0012\u001a1QH\u0010E\u0001\u0005'Cq!!\t.\t\u0003\u0011\t\u000bC\u0004\u0003$6\"\tA!*\t\u0013\t]V&%A\u0005\u0002\tM\u0002\"\u0003B][E\u0005I\u0011\u0001B&\u0011%\u0011Y,LI\u0001\n\u0003\u0011\t\u0006C\u0005\u0003>6\n\n\u0011\"\u0001\u0003@\"I!1Y\u0017\u0012\u0002\u0013\u0005!Q\u0019\u0005\n\u0005\u0013l\u0013\u0013!C\u0001\u0005\u0017D\u0011Ba4.#\u0003%\tAa\r\t\u0013\tEW&%A\u0005\u0002\t-\u0003\"\u0003Bj[E\u0005I\u0011\u0001B)\u0011%\u0011).LI\u0001\n\u0003\u0011y\fC\u0005\u0003X6\n\n\u0011\"\u0001\u0003F\"I!\u0011\\\u0017\u0012\u0002\u0013\u0005!1\u001a\u0005\n\u00057l\u0013\u0011!C\u0005\u0005;\u0014AdR3p)&4gMU3qe>TWm\u0019;SCN$XM]*pkJ\u001cWM\u0003\u0002@\u0001\u00069q-Z8uS\u001a4'BA!C\u0003\u0019\u0011\u0018m\u001d;fe*\t1)\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001a\u0005\u0002\u0001\rB\u0011q\tS\u0007\u0002\u0001&\u0011\u0011\n\u0011\u0002\r%\u0006\u001cH/\u001a:T_V\u00148-Z\u0001\tI\u0006$\u0018\rU1uQV\tA\n\u0005\u0002N\u001d6\ta(\u0003\u0002P}\tYq)Z8US\u001a4\u0007+\u0019;i\u0003%!\u0017\r^1QCRD\u0007%A\u0002deN,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\n\u000bQ\u0001\u001d:pURJ!\u0001W+\u0003\u0007\r\u00136+\u0001\u0003deN\u0004\u0013A\u0004:fg\u0006l\u0007\u000f\\3UCJ<W\r^\u000b\u00029B\u0011q)X\u0005\u0003=\u0002\u0013aBU3tC6\u0004H.\u001a+be\u001e,G/A\bsKN\fW\u000e\u001d7f)\u0006\u0014x-\u001a;!\u00039\u0011Xm]1na2,W*\u001a;i_\u0012,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u0002\u000b\u0001B]3tC6\u0004H.Z\u0005\u0003O\u0012\u0014aBU3tC6\u0004H.Z'fi\"|G-A\bsKN\fW\u000e\u001d7f\u001b\u0016$\bn\u001c3!\u0003!\u0019HO]1uK\u001eLX#A6\u0011\u00051\u0004X\"A7\u000b\u0005}r'BA8A\u0003\tIw.\u0003\u0002r[\n\u0001rJ^3sm&,wo\u0015;sCR,w-_\u0001\ngR\u0014\u0018\r^3hs\u0002\na\"\u001a:s_J$\u0006N]3tQ>dG-F\u0001v!\t1\u00180D\u0001x\u0015\u0005A\u0018!B:dC2\f\u0017B\u0001>x\u0005\u0019!u.\u001e2mK\u0006yQM\u001d:peRC'/Z:i_2$\u0007%\u0001\buCJ<W\r^\"fY2$\u0016\u0010]3\u0016\u0003y\u0004BA^@\u0002\u0004%\u0019\u0011\u0011A<\u0003\r=\u0003H/[8o!\r9\u0015QA\u0005\u0004\u0003\u000f\u0001%A\u0004+be\u001e,GoQ3mYRK\b/Z\u0001\u0010i\u0006\u0014x-\u001a;DK2dG+\u001f9fA\u0005A!-Y:f)&4g-\u0006\u0002\u0002\u0010A!ao`A\t!\ra\u00171C\u0005\u0004\u0003+i'\u0001E'vYRL'-\u00198e\u000f\u0016|G+\u001b4g\u0003%\u0011\u0017m]3US\u001a4\u0007\u0005K\u0002\u0011\u00037\u00012A^A\u000f\u0013\r\tyb\u001e\u0002\niJ\fgn]5f]R\fa\u0001P5oSRtDCEA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\u0001\"!\u0014\u0001\t\u000b)\u000b\u0002\u0019\u0001'\t\u000bE\u000b\u0002\u0019A*\t\u000fi\u000b\u0002\u0013!a\u00019\"9\u0001-\u0005I\u0001\u0002\u0004\u0011\u0007bB5\u0012!\u0003\u0005\ra\u001b\u0005\bgF\u0001\n\u00111\u0001v\u0011\u001da\u0018\u0003%AA\u0002yD\u0011\"a\u0003\u0012!\u0003\u0005\r!a\u0004\u0002\t9\fW.Z\u0001\nE\u0006tGmQ8v]R,\"!!\u0010\u0011\u0007Y\fy$C\u0002\u0002B]\u00141!\u00138u\u0003!\u0019W\r\u001c7UsB,WCAA$!\u0011\tI%!\u0018\u000f\t\u0005-\u0013\u0011\f\b\u0005\u0003\u001b\n9F\u0004\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019\u0006R\u0001\u0007yI|w\u000e\u001e \n\u0003\rK!!\u0011\"\n\u0007\u0005m\u0003)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0013\u0011\r\u0002\t\u0007\u0016dG\u000eV=qK*\u0019\u00111\f!\u0002\tQ\fwm]\u000b\u0003\u0003O\u00022\u0001\\A5\u0013\r\tY'\u001c\u0002\u0005)\u0006<7/\u0001\u0005nKR\fG-\u0019;b+\t\t\t\bE\u0002N\u0003gJ1!!\u001e?\u0005=9Um\u001c+jM\u001alU\r^1eCR\f\u0017AC1uiJL'-\u001e;fgV\u0011\u00111\u0010\t\t\u0003{\n))a#\u0002\f:!\u0011qPAA!\r\tye^\u0005\u0004\u0003\u0007;\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0006%%aA'ba*\u0019\u00111Q<\u0011\t\u0005u\u0014QR\u0005\u0005\u0003\u001f\u000bII\u0001\u0004TiJLgnZ\u0001\u0012CR$(/\u001b2vi\u0016\u001chi\u001c:CC:$G\u0003BA>\u0003+Cq!a&\u0019\u0001\u0004\ti$\u0001\u0003cC:$\u0017a\u00022bg\u0016\u001c%kU\u0001\u000fE\u0006\u001cXm\u0012:jI\u0016CH/\u001a8u+\t\ty\nE\u0003H\u0003C\u000b)+C\u0002\u0002$\u0002\u0013!b\u0012:jI\u0016CH/\u001a8u!\r1\u0018qU\u0005\u0004\u0003S;(\u0001\u0002'p]\u001e\f!b\u001a:jI\u0016CH/\u001a8u\u0003-\u0011Xm]8mkRLwN\\:\u0016\u0005\u0005E\u0006CBAZ\u0003w\u000b\tM\u0004\u0003\u00026\u0006ef\u0002BA(\u0003oK\u0011\u0001_\u0005\u0004\u00037:\u0018\u0002BA_\u0003\u007f\u0013A\u0001T5ti*\u0019\u00111L<\u0011\u0007\u001d\u000b\u0019-C\u0002\u0002F\u0002\u0013\u0001bQ3mYNK'0Z\u0001\u0005e\u0016\fG\r\u0006\u0004\u0002L\u0006e\u0017\u0011\u001e\t\u0005m~\fi\rE\u0003H\u0003\u001f\f\u0019.C\u0002\u0002R\u0002\u0013aAU1ti\u0016\u0014\bcA$\u0002V&\u0019\u0011q\u001b!\u0003\u001b5+H\u000e^5cC:$G+\u001b7f\u0011\u001d\tY.\ba\u0001\u0003;\fa!\u001a=uK:$\b\u0003BAp\u0003Kl!!!9\u000b\u0007\u0005\r()\u0001\u0004wK\u000e$xN]\u0005\u0005\u0003O\f\tO\u0001\u0004FqR,g\u000e\u001e\u0005\b\u0003Wl\u0002\u0019AAw\u0003\u0015\u0011\u0017M\u001c3t!\u0019\t\u0019,a<\u0002>%!\u0011\u0011_A`\u0005\r\u0019V-\u001d\u000b\u0007\u0003\u0017\f)0a@\t\u000f\u0005]h\u00041\u0001\u0002z\u00061!m\\;oIN\u0004RaRA~\u0003KK1!!@A\u0005)9%/\u001b3C_VtGm\u001d\u0005\b\u0003Wt\u0002\u0019AAw\u0003-\u0011X-\u00193FqR,g\u000e^:\u0015\r\t\u0015!1\u0002B\u000b!\u0019\t\u0019La\u0002\u0002N&!!\u0011BA`\u0005!IE/\u001a:bi>\u0014\bb\u0002B\u0007?\u0001\u0007!qB\u0001\bKb$XM\u001c;t!\u0019\t\u0019L!\u0005\u0002^&!!1CA`\u0005-!&/\u0019<feN\f'\r\\3\t\u000f\u0005-x\u00041\u0001\u0002n\u0006Q!/Z1e\u0005>,h\u000eZ:\u0015\r\t\u0015!1\u0004B\u0010\u0011\u001d\t9\u0010\ta\u0001\u0005;\u0001b!a-\u0003\u0012\u0005e\bbBAvA\u0001\u0007\u0011Q^\u0001\re\u0016\u0004(o\u001c6fGRLwN\u001c\u000b\n\r\n\u0015\"\u0011\u0006B\u0016\u0005_AaAa\n\"\u0001\u0004\u0019\u0016!\u0003;be\u001e,Go\u0011*T\u0011\u001dQ\u0016\u0005%AA\u0002qC\u0001B!\f\"!\u0003\u0005\rAY\u0001\u0007[\u0016$\bn\u001c3\t\u000f%\f\u0003\u0013!a\u0001W\u00061\"/\u001a9s_*,7\r^5p]\u0012\"WMZ1vYR$#'\u0006\u0002\u00036)\u001aALa\u000e,\u0005\te\u0002\u0003\u0002B\u001e\u0005\u000bj!A!\u0010\u000b\t\t}\"\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0011x\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000f\u0012iDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faC]3qe>TWm\u0019;j_:$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001bR3A\u0019B\u001c\u0003Y\u0011X\r\u001d:pU\u0016\u001cG/[8oI\u0011,g-Y;mi\u0012\"TC\u0001B*U\rY'q\u0007\u000b\b\r\n]#\u0011\fB.\u0011\u0015QV\u00051\u0001]\u0011\u0019\u0011i#\na\u0001E\")\u0011.\na\u0001W\u000691m\u001c8wKJ$Hc\u0001$\u0003b!1AP\na\u0001\u0003\u0007\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0017\u000bA\u0001^5gMV\u0011\u0011\u0011\u0003\u0015\u0004Q\u0005m\u0011!\u0003;sC:\u001chm\u001c:n+\t\u0011\t\bE\u0004w\u0005g*XOa\u001e\n\u0007\tUtOA\u0005Gk:\u001cG/[8oeA)aO!\u001fvk&\u0019!1P<\u0003\rQ+\b\u000f\\33Q\rI\u00131D\u0001\u000eE\u0006\u001c7\u000e\u0016:b]N4wN]7)\u0007)\nY\"A\ndY>\u001cXm\u001d;US\u001a4wJ^3sm&,w/\u0006\u0002\u0003\bB)AN!#\u0002T&\u0019!1R7\u0003\u000f\u001d+w\u000eV5gM\"\u001a1&a\u0007\u00029\u001d+w\u000eV5gMJ+\u0007O]8kK\u000e$(+Y:uKJ\u001cv.\u001e:dKB\u0011Q*L\n\u0006[\tU%1\u0014\t\u0004m\n]\u0015b\u0001BMo\n1\u0011I\\=SK\u001a\u00042A\u001eBO\u0013\r\u0011yj\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005#\u000bQ!\u00199qYf$\"#!\n\u0003(\n%&1\u0016BW\u0005_\u0013\tLa-\u00036\")!j\fa\u0001\u0019\")\u0011k\fa\u0001'\"9!l\fI\u0001\u0002\u0004a\u0006b\u000210!\u0003\u0005\rA\u0019\u0005\bS>\u0002\n\u00111\u0001l\u0011\u001d\u0019x\u0006%AA\u0002UDq\u0001`\u0018\u0011\u0002\u0003\u0007a\u0010C\u0005\u0002\f=\u0002\n\u00111\u0001\u0002\u0010\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t\u0005'fA;\u00038\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$s'\u0006\u0002\u0003H*\u001aaPa\u000e\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIa*\"A!4+\t\u0005=!qG\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bp!\u0011\u0011\tOa;\u000e\u0005\t\r(\u0002\u0002Bs\u0005O\fA\u0001\\1oO*\u0011!\u0011^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003n\n\r(AB(cU\u0016\u001cG\u000f")
public class GeoTiffReprojectRasterSource
extends RasterSource {
    private CRS baseCRS;
    private GridExtent<Object> baseGridExtent;
    private GridExtent<Object> gridExtent;
    private List<CellSize> resolutions;
    private transient MultibandGeoTiff tiff;
    private transient Function2<Object, Object, Tuple2<Object, Object>> transform;
    private transient Function2<Object, Object, Tuple2<Object, Object>> backTransform;
    private transient GeoTiff<MultibandTile> closestTiffOverview;
    private final GeoTiffPath dataPath;
    private final CRS crs;
    private final ResampleTarget resampleTarget;
    private final ResampleMethod resampleMethod;
    private final OverviewStrategy strategy;
    private final double errorThreshold;
    private final Option<TargetCellType> targetCellType;
    private final transient Option<MultibandGeoTiff> baseTiff;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<MultibandGeoTiff> $lessinit$greater$default$8() {
        return GeoTiffReprojectRasterSource$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<TargetCellType> $lessinit$greater$default$7() {
        return GeoTiffReprojectRasterSource$.MODULE$.$lessinit$greater$default$7();
    }

    public static double $lessinit$greater$default$6() {
        return GeoTiffReprojectRasterSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static OverviewStrategy $lessinit$greater$default$5() {
        return GeoTiffReprojectRasterSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static ResampleMethod $lessinit$greater$default$4() {
        return GeoTiffReprojectRasterSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static ResampleTarget $lessinit$greater$default$3() {
        return GeoTiffReprojectRasterSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<MultibandGeoTiff> apply$default$8() {
        return GeoTiffReprojectRasterSource$.MODULE$.apply$default$8();
    }

    public static Option<TargetCellType> apply$default$7() {
        return GeoTiffReprojectRasterSource$.MODULE$.apply$default$7();
    }

    public static double apply$default$6() {
        return GeoTiffReprojectRasterSource$.MODULE$.apply$default$6();
    }

    public static OverviewStrategy apply$default$5() {
        return GeoTiffReprojectRasterSource$.MODULE$.apply$default$5();
    }

    public static ResampleMethod apply$default$4() {
        return GeoTiffReprojectRasterSource$.MODULE$.apply$default$4();
    }

    public static ResampleTarget apply$default$3() {
        return GeoTiffReprojectRasterSource$.MODULE$.apply$default$3();
    }

    public static GeoTiffReprojectRasterSource apply(GeoTiffPath geoTiffPath, CRS cRS, ResampleTarget resampleTarget, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy, double d, Option<TargetCellType> option, Option<MultibandGeoTiff> option2) {
        return GeoTiffReprojectRasterSource$.MODULE$.apply(geoTiffPath, cRS, resampleTarget, resampleMethod, overviewStrategy, d, option, option2);
    }

    public GeoTiffPath dataPath() {
        return this.dataPath;
    }

    @Override
    public CRS crs() {
        return this.crs;
    }

    public ResampleTarget resampleTarget() {
        return this.resampleTarget;
    }

    public ResampleMethod resampleMethod() {
        return this.resampleMethod;
    }

    public OverviewStrategy strategy() {
        return this.strategy;
    }

    public double errorThreshold() {
        return this.errorThreshold;
    }

    @Override
    public Option<TargetCellType> targetCellType() {
        return this.targetCellType;
    }

    public Option<MultibandGeoTiff> baseTiff() {
        return this.baseTiff;
    }

    @Override
    public GeoTiffPath name() {
        return this.dataPath();
    }

    private MultibandGeoTiff tiff$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tiff = (MultibandGeoTiff)Option$.MODULE$.apply(this.baseTiff()).flatten(Predef$.MODULE$.$conforms()).getOrElse((Function0 & Serializable & scala.Serializable)() -> GeoTiffReader$.MODULE$.readMultiband((ByteReader)RangeReader$.MODULE$.rangeReaderToStreamingByteReader(RangeReader$.MODULE$.apply(this.dataPath().value())), true, true, (Option<ByteReader>)RangeReader$.MODULE$.rangeReaderToStreamingByteReaderOpt(RangeReader$.MODULE$.validated(this.dataPath().externalOverviews()))));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.tiff;
    }

    public MultibandGeoTiff tiff() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tiff$lzycompute() : this.tiff;
    }

    @Override
    public int bandCount() {
        return this.tiff().bandCount();
    }

    @Override
    public DataType cellType() {
        return (DataType)this.dstCellType().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.tiff().cellType());
    }

    public Tags tags() {
        return this.tiff().tags();
    }

    @Override
    public GeoTiffMetadata metadata() {
        return new GeoTiffMetadata(this.name(), this.crs(), this.bandCount(), this.cellType(), this.gridExtent(), this.resolutions(), this.tags());
    }

    @Override
    public Map<String, String> attributes() {
        return this.tags().headTags();
    }

    @Override
    public Map<String, String> attributesForBand(int band) {
        return (Map)((Option)this.tags().bandTags().lift().apply((Object)BoxesRunTime.boxToInteger((int)band))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private CRS baseCRS$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.baseCRS = this.tiff().crs();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.baseCRS;
    }

    public CRS baseCRS() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.baseCRS$lzycompute() : this.baseCRS;
    }

    private GridExtent<Object> baseGridExtent$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.baseGridExtent = this.tiff().rasterExtent().toGridType(Integral$.MODULE$.LongIsIntegral());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.baseGridExtent;
    }

    public GridExtent<Object> baseGridExtent() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.baseGridExtent$lzycompute() : this.baseGridExtent;
    }

    private Function2<Object, Object, Tuple2<Object, Object>> transform$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.transform = Transform$.MODULE$.apply(this.baseCRS(), this.crs());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.transform;
    }

    public Function2<Object, Object, Tuple2<Object, Object>> transform() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.transform$lzycompute() : this.transform;
    }

    private Function2<Object, Object, Tuple2<Object, Object>> backTransform$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.backTransform = Transform$.MODULE$.apply(this.crs(), this.baseCRS());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.backTransform;
    }

    public Function2<Object, Object, Tuple2<Object, Object>> backTransform() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.backTransform$lzycompute() : this.backTransform;
    }

    private GridExtent<Object> gridExtent$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                LazyRef reprojectedRasterExtent$lzy = new LazyRef();
                this.gridExtent = this.resampleTarget().apply((Function0 & Serializable & scala.Serializable)() -> this.reprojectedRasterExtent$1(reprojectedRasterExtent$lzy), Integral$.MODULE$.LongIsIntegral());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.gridExtent;
    }

    @Override
    public GridExtent<Object> gridExtent() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.gridExtent$lzycompute() : this.gridExtent;
    }

    private List<CellSize> resolutions$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                CellSize cellSize = ReprojectRasterExtent$.MODULE$.apply(this.tiff().rasterExtent(), this.transform(), Reproject$Options$.MODULE$.DEFAULT()).cellSize();
                this.resolutions = ((List)this.tiff().overviews().map((Function1 & Serializable & scala.Serializable)ovr -> ReprojectRasterExtent$.MODULE$.apply(ovr.rasterExtent(), this.transform(), Reproject$Options$.MODULE$.DEFAULT()).cellSize(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)cellSize);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.resolutions;
    }

    @Override
    public List<CellSize> resolutions() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.resolutions$lzycompute() : this.resolutions;
    }

    private GeoTiff<MultibandTile> closestTiffOverview$lzycompute() {
        GeoTiffReprojectRasterSource geoTiffReprojectRasterSource = this;
        synchronized (geoTiffReprojectRasterSource) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                GeoTiff<MultibandTile> geoTiff;
                ResampleTarget resampleTarget = this.resampleTarget();
                if (DefaultTarget$.MODULE$.equals(resampleTarget)) {
                    geoTiff = this.tiff().getClosestOverview(this.baseGridExtent().cellSize(), this.strategy());
                } else {
                    GridExtent<Object> estimatedSource = ReprojectRasterExtent$.MODULE$.apply(this.gridExtent(), this.backTransform(), Integral$.MODULE$.LongIsIntegral());
                    geoTiff = this.tiff().getClosestOverview(estimatedSource.cellSize(), this.strategy());
                }
                this.closestTiffOverview = geoTiff;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.closestTiffOverview;
    }

    public GeoTiff<MultibandTile> closestTiffOverview() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.closestTiffOverview$lzycompute() : this.closestTiffOverview;
    }

    @Override
    public Option<Raster<MultibandTile>> read(Extent extent, Seq<Object> bands) {
        GridBounds<Object> bounds = this.gridExtent().gridBoundsFor$mcJ$sp(extent, false);
        return this.read(bounds, bands);
    }

    @Override
    public Option<Raster<MultibandTile>> read(GridBounds<Object> bounds, Seq<Object> bands) {
        None$ none$;
        Iterator<Raster<MultibandTile>> it = this.readBounds((Traversable<GridBounds<Object>>)new .colon.colon(bounds, (List)Nil$.MODULE$), bands);
        MultibandGeoTiff multibandGeoTiff = this.tiff();
        synchronized (multibandGeoTiff) {
            none$ = it.hasNext() ? new Some(it.next()) : None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Iterator<Raster<MultibandTile>> readExtents(Traversable<Extent> extents, Seq<Object> bands) {
        Traversable bounds = (Traversable)extents.map((Function1 & Serializable & scala.Serializable)x$2 -> this.gridExtent().gridBoundsFor$mcJ$sp((Extent)x$2, this.gridExtent().gridBoundsFor$default$2()), Traversable$.MODULE$.canBuildFrom());
        return this.readBounds((Traversable<GridBounds<Object>>)bounds, bands);
    }

    @Override
    public Iterator<Raster<MultibandTile>> readBounds(Traversable<GridBounds<Object>> bounds, Seq<Object> bands) {
        GeoTiffMultibandTile geoTiffTile = (GeoTiffMultibandTile)this.closestTiffOverview().tile();
        Map intersectingWindows = ((TraversableOnce)bounds.flatMap((Function1 & Serializable & scala.Serializable)queryPixelBounds -> Option$.MODULE$.option2Iterable(queryPixelBounds.intersection$mcJ$sp(this.dimensions()).map((Function1 & Serializable & scala.Serializable)targetPixelBounds -> {
            Envelope envelope;
            Extent targetExtent = this.gridExtent().extentFor$mcJ$sp((GridBounds<Object>)targetPixelBounds, this.gridExtent().extentFor$default$2());
            RasterExtent targetRasterExtent = RasterExtent$.MODULE$.apply(targetExtent, (int)targetPixelBounds.width$mcJ$sp(), (int)targetPixelBounds.height$mcJ$sp());
            Extent bufferedTargetExtent = targetExtent.buffer(this.cellSize().width(), this.cellSize().height());
            Proj4Transform$ proj4Transform$ = Proj4Transform$.MODULE$;
            synchronized (proj4Transform$) {
                envelope = package$.MODULE$.ReprojectExtent(bufferedTargetExtent).reprojectAsPolygon(this.backTransform(), 0.001).getEnvelopeInternal();
            }
            Envelope sourceExtent = envelope;
            RasterExtent qual$1 = this.closestTiffOverview().rasterExtent();
            Extent x$1 = Extent$.MODULE$.envelope2Extent(sourceExtent);
            boolean x$2 = qual$1.gridBoundsFor$default$2();
            GridBounds<Object> sourcePixelBounds = qual$1.gridBoundsFor$mcI$sp(x$1, x$2);
            return new Tuple2(sourcePixelBounds, (Object)targetRasterExtent);
        })), Traversable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return geoTiffTile.crop((Seq<GridBounds<Object>>)intersectingWindows.keys().toSeq(), (int[])bands.toArray(ClassTag$.MODULE$.Int())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GridBounds sourcePixelBounds = (GridBounds)tuple2._1();
            ArrayMultibandTile tile = (ArrayMultibandTile)tuple2._2();
            RasterExtent targetRasterExtent = (RasterExtent)intersectingWindows.apply((Object)sourcePixelBounds);
            RasterExtent qual$2 = this.closestTiffOverview().rasterExtent();
            GridBounds x$3 = sourcePixelBounds;
            boolean x$4 = qual$2.extentFor$default$2();
            Raster<ArrayMultibandTile> sourceRaster = new Raster<ArrayMultibandTile>(tile, qual$2.extentFor$mcI$sp(x$3, x$4));
            RasterRegionReproject rr = (RasterRegionReproject)Predef$.MODULE$.implicitly(RasterRegionReproject$.MODULE$.multibandInstance());
            Raster<ArrayMultibandTile> raster = rr.regionReproject(sourceRaster, this.baseCRS(), this.crs(), targetRasterExtent, targetRasterExtent.extent().toPolygon(), this.resampleMethod(), this.errorThreshold());
            return raster;
        }).map(this.convertRaster());
    }

    @Override
    public RasterSource reprojection(CRS targetCRS, ResampleTarget resampleTarget, ResampleMethod method, OverviewStrategy strategy) {
        GeoTiffPath x$1 = this.dataPath();
        CRS x$2 = targetCRS;
        ResampleTarget x$3 = resampleTarget;
        ResampleMethod x$4 = method;
        OverviewStrategy x$5 = strategy;
        Option<TargetCellType> x$6 = this.targetCellType();
        Some x$7 = new Some((Object)this.tiff());
        double x$8 = GeoTiffReprojectRasterSource$.MODULE$.apply$default$6();
        return GeoTiffReprojectRasterSource$.MODULE$.apply(x$1, x$2, x$3, x$4, x$5, x$8, x$6, (Option<MultibandGeoTiff>)x$7);
    }

    @Override
    public ResampleTarget reprojection$default$2() {
        return DefaultTarget$.MODULE$;
    }

    @Override
    public ResampleMethod reprojection$default$3() {
        return ResampleMethod$.MODULE$.DEFAULT();
    }

    @Override
    public OverviewStrategy reprojection$default$4() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    @Override
    public RasterSource resample(ResampleTarget resampleTarget, ResampleMethod method, OverviewStrategy strategy) {
        GeoTiffPath x$1 = this.dataPath();
        CRS x$2 = this.crs();
        ResampleTarget x$3 = resampleTarget;
        ResampleMethod x$4 = method;
        OverviewStrategy x$5 = strategy;
        Option<TargetCellType> x$6 = this.targetCellType();
        Some x$7 = new Some((Object)this.tiff());
        double x$8 = GeoTiffReprojectRasterSource$.MODULE$.apply$default$6();
        return GeoTiffReprojectRasterSource$.MODULE$.apply(x$1, x$2, x$3, x$4, x$5, x$8, x$6, (Option<MultibandGeoTiff>)x$7);
    }

    @Override
    public RasterSource convert(TargetCellType targetCellType) {
        GeoTiffPath x$1 = this.dataPath();
        CRS x$2 = this.crs();
        ResampleTarget x$3 = this.resampleTarget();
        ResampleMethod x$4 = this.resampleMethod();
        OverviewStrategy x$5 = this.strategy();
        Some x$6 = new Some((Object)targetCellType);
        double x$7 = GeoTiffReprojectRasterSource$.MODULE$.apply$default$6();
        Option<MultibandGeoTiff> x$8 = GeoTiffReprojectRasterSource$.MODULE$.apply$default$8();
        return GeoTiffReprojectRasterSource$.MODULE$.apply(x$1, x$2, x$3, x$4, x$5, x$7, (Option<TargetCellType>)x$6, x$8);
    }

    public String toString() {
        return new StringBuilder(36).append("GeoTiffReprojectRasterSource(").append(this.dataPath().value()).append(", ").append(this.crs()).append(", ").append(this.resampleTarget()).append(", ").append(this.resampleMethod()).append(")").toString();
    }

    private final /* synthetic */ GridExtent reprojectedRasterExtent$lzycompute$1(LazyRef reprojectedRasterExtent$lzy$1) {
        GridExtent gridExtent;
        LazyRef lazyRef = reprojectedRasterExtent$lzy$1;
        synchronized (lazyRef) {
            GridExtent gridExtent2;
            if (reprojectedRasterExtent$lzy$1.initialized()) {
                gridExtent2 = (GridExtent)reprojectedRasterExtent$lzy$1.value();
            } else {
                Reproject.Options qual$1 = Reproject$Options$.MODULE$.DEFAULT();
                ResampleMethod x$1 = this.resampleMethod();
                double x$2 = this.errorThreshold();
                Option<GridExtent<Object>> x$3 = qual$1.copy$default$3();
                Option<RasterExtent> x$4 = qual$1.copy$default$4();
                Option<CellSize> x$5 = qual$1.copy$default$5();
                gridExtent2 = (GridExtent)reprojectedRasterExtent$lzy$1.initialize(ReprojectRasterExtent$.MODULE$.apply(this.baseGridExtent(), this.transform(), qual$1.copy(x$1, x$2, x$3, x$4, x$5), Integral$.MODULE$.LongIsIntegral()));
            }
            gridExtent = gridExtent2;
        }
        return gridExtent;
    }

    private final GridExtent reprojectedRasterExtent$1(LazyRef reprojectedRasterExtent$lzy$1) {
        return reprojectedRasterExtent$lzy$1.initialized() ? (GridExtent)reprojectedRasterExtent$lzy$1.value() : this.reprojectedRasterExtent$lzycompute$1(reprojectedRasterExtent$lzy$1);
    }

    public GeoTiffReprojectRasterSource(GeoTiffPath dataPath, CRS crs, ResampleTarget resampleTarget, ResampleMethod resampleMethod, OverviewStrategy strategy, double errorThreshold, Option<TargetCellType> targetCellType, Option<MultibandGeoTiff> baseTiff) {
        this.dataPath = dataPath;
        this.crs = crs;
        this.resampleTarget = resampleTarget;
        this.resampleMethod = resampleMethod;
        this.strategy = strategy;
        this.errorThreshold = errorThreshold;
        this.targetCellType = targetCellType;
        this.baseTiff = baseTiff;
    }
}

