/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.hydrology;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.CursorCalculation;
import geotrellis.raster.mapalgebra.focal.DoubleArrayTileResult;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import scala.Function2;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001}3A\u0001C\u0005\u0001!!I\u0001\u0005\u0001B\u0001B\u0003%\u0011$\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!I1\u0007\u0001B\u0001B\u0003%A\u0007\u0011\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Ia\t\u0001B\u0001B\u0003%qI\u0013\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u0006)\u0002!\t!\u0016\u0002\u0015\u0007V\u00148o\u001c:GS2d7)\u00197d\t>,(\r\\3\u000b\u0005)Y\u0011!\u00035zIJ|Gn\\4z\u0015\taQ\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u001d\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001!E\u000f\u0011\u0007I9\u0012$D\u0001\u0014\u0015\t!R#A\u0003g_\u000e\fGN\u0003\u0002\u0017\u0017\u0005QQ.\u00199bY\u001e,'M]1\n\u0005a\u0019\"!E\"veN|'oQ1mGVd\u0017\r^5p]B\u0011!dG\u0007\u0002\u0017%\u0011Ad\u0003\u0002\u0005)&dW\r\u0005\u0002\u0013=%\u0011qd\u0005\u0002\u0016\t>,(\r\\3BeJ\f\u0017\u0010V5mKJ+7/\u001e7u\u0003\u0005\u0011\u0018B\u0001\u0011#\u0013\t\u00193C\u0001\tG_\u000e\fGnQ1mGVd\u0017\r^5p]\u0006\ta\u000e\u0005\u0002'a9\u0011qE\f\b\u0003Q5r!!\u000b\u0017\u000e\u0003)R!aK\b\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011B\u0001\u0007\u000e\u0013\ty3\"A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0012$\u0001\u0004(fS\u001eD'm\u001c:i_>$'BA\u0018\f\u0003\u0019\u0011w.\u001e8egB\u0019Q\u0007\u000f\u001e\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012aa\u00149uS>t\u0007c\u0001\u000e<{%\u0011Ah\u0003\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\bCA\u001b?\u0013\tydGA\u0002J]RL!!Q\f\u0002\u0019\u0005t\u0017\r\\=tSN\f%/Z1\u0002\u0013QD'/Z:i_2$\u0007CA\u001bE\u0013\t)eG\u0001\u0004E_V\u0014G.Z\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0005\u0019B\u0015BA%3\u0005)!\u0016M]4fi\u000e+G\u000e\\\u0005\u0003\r\n\na\u0001P5oSRtDCB'P!F\u00136\u000b\u0005\u0002O\u00015\t\u0011\u0002C\u0003!\r\u0001\u0007\u0011\u0004C\u0003%\r\u0001\u0007Q\u0005C\u00034\r\u0001\u0007A\u0007C\u0003C\r\u0001\u00071\tC\u0003G\r\u0001\u0007q)\u0001\u0003dC2\u001cGc\u0001,Z5B\u0011QgV\u0005\u00031Z\u0012A!\u00168ji\")\u0001e\u0002a\u00013!)1l\u0002a\u00019\u0006\t1\r\u0005\u0002\u0013;&\u0011al\u0005\u0002\u0007\u0007V\u00148o\u001c:")
public class CursorFillCalcDouble
extends CursorCalculation<Tile>
implements DoubleArrayTileResult {
    private final double threshold;
    private final int cols;
    private final int rows;
    private final DoubleArrayTile resultTile;
    private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

    @Override
    public DoubleArrayTile result() {
        return DoubleArrayTileResult.result$(this);
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public DoubleArrayTile resultTile() {
        return this.resultTile;
    }

    @Override
    public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
        return this.copyOriginalValue;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$cols_$eq(int x$1) {
        this.cols = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$rows_$eq(int x$1) {
        this.rows = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$resultTile_$eq(DoubleArrayTile x$1) {
        this.resultTile = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$DoubleArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
        this.copyOriginalValue = x$1;
    }

    @Override
    public void calc(Tile r, Cursor c) {
        IntRef count = IntRef.create((int)0);
        IntRef totalCount = IntRef.create((int)0);
        DoubleRef sum = DoubleRef.create((double)0.0);
        double cVal = r.getDouble(c.col(), c.row());
        c.allCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & java.io.Serializable & Serializable)(col, row) -> {
            block1: {
                if (c.col() == col && c.row() == row) break block1;
                if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(r.getDouble(col, row) - cVal)) > $this.threshold) {
                    ++count$1.elem;
                }
                ++totalCount$1.elem;
                sum$1.elem += (double)r.get(col, row);
            }
        });
        if (count.elem == totalCount.elem) {
            this.resultTile().setDouble(c.col(), c.row(), sum.elem / (double)totalCount.elem);
        } else {
            this.resultTile().setDouble(c.col(), c.row(), cVal);
        }
    }

    public CursorFillCalcDouble(Tile r, Neighborhood n, Option<GridBounds<Object>> bounds, double threshold, TargetCell target) {
        this.threshold = threshold;
        super(r, n, bounds, target);
        DoubleArrayTileResult.$init$(this);
    }
}

