/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.ascii;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3qa\u0003\u0007\u0011\u0002\u0007\u0005Q\u0003C\u0003\u001d\u0001\u0011\u0005Q\u0004C\u0004\"\u0001\t\u0007i\u0011\u0001\u0012\t\u000f\u001d\u0002!\u0019!D\u0001E!)\u0001\u0006\u0001D\u0001S!)\u0001\b\u0001C\u0001s!1A\t\u0001Q\u0007\u0012\u0015CaA\u0013\u0001!\u000e#Y\u0005\"\u0002*\u0001\t\u0003i\u0002BB*\u0001A\u0013EA\u000bC\u0003X\u0001\u0011\u0005\u0001LA\u0005SK\u0006$7\u000b^1uK*\u0011QBD\u0001\u0006CN\u001c\u0017.\u001b\u0006\u0003\u001fA\t!![8\u000b\u0005E\u0011\u0012A\u0002:bgR,'OC\u0001\u0014\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003y\u0001\"aF\u0010\n\u0005\u0001B\"\u0001B+oSR\fAB]1ti\u0016\u0014X\t\u001f;f]R,\u0012a\t\t\u0003I\u0015j\u0011\u0001E\u0005\u0003MA\u0011ABU1ti\u0016\u0014X\t\u001f;f]R\fa\u0001^1sO\u0016$\u0018aB4fiRK\b/Z\u000b\u0002UA\u00111&\u000e\b\u0003YMr!!\f\u001a\u000f\u00059\nT\"A\u0018\u000b\u0005A\"\u0012A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t\t\"#\u0003\u00025!\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001c8\u0005!\u0019U\r\u001c7UsB,'B\u0001\u001b\u0011\u0003)\u0019'/Z1uKRKG.\u001a\u000b\u0004uu\u0012\u0005C\u0001\u0013<\u0013\ta\u0004C\u0001\tNkR\f'\r\\3BeJ\f\u0017\u0010V5mK\")a(\u0002a\u0001\u007f\u0005!1m\u001c7t!\t9\u0002)\u0003\u0002B1\t\u0019\u0011J\u001c;\t\u000b\r+\u0001\u0019A \u0002\tI|wo]\u0001\u000bS:LGoU8ve\u000e,Gc\u0001\u0010G\u0011\")qI\u0002a\u0001\u007f\u0005A\u0001o\\:ji&|g\u000eC\u0003J\r\u0001\u0007q(\u0001\u0003tSj,\u0017\u0001E1tg&<gN\u0012:p[N{WO]2f)\u0011qBJ\u0014)\t\u000b5;\u0001\u0019A \u0002\u0017M|WO]2f\u0013:$W\r\u001f\u0005\u0006\u001f\u001e\u0001\rAO\u0001\u0005I\u0016\u001cH\u000fC\u0003R\u000f\u0001\u0007q(A\u0005eKN$\u0018J\u001c3fq\u00069A-Z:ue>L\u0018!\u0003;sC:\u001cH.\u0019;f)\tqR\u000bC\u0003W\u0013\u0001\u0007!(\u0001\u0003eCR\f\u0017A\u00037pC\u0012\u0014\u0016m\u001d;feR\t\u0011\f\u0005\u0002%5&\u00111\f\u0005\u0002\u0005)&dW\r")
public interface ReadState {
    public RasterExtent rasterExtent();

    public RasterExtent target();

    public DataType getType();

    public static /* synthetic */ MutableArrayTile createTile$(ReadState $this, int cols, int rows) {
        return $this.createTile(cols, rows);
    }

    default public MutableArrayTile createTile(int cols, int rows) {
        return ArrayTile$.MODULE$.empty(this.getType(), cols, rows);
    }

    public void initSource(int var1, int var2);

    public void assignFromSource(int var1, MutableArrayTile var2, int var3);

    public static /* synthetic */ void destroy$(ReadState $this) {
        $this.destroy();
    }

    default public void destroy() {
    }

    public static /* synthetic */ void translate$(ReadState $this, MutableArrayTile data) {
        $this.translate(data);
    }

    default public void translate(MutableArrayTile data) {
    }

    public static /* synthetic */ Tile loadRaster$(ReadState $this) {
        return $this.loadRaster();
    }

    default public Tile loadRaster() {
        RasterExtent re = this.rasterExtent();
        double src_cellwidth = re.cellwidth();
        double src_cellheight = re.cellheight();
        int src_cols = re.cols();
        int src_rows = re.rows();
        double src_xmin = re.extent().xmin();
        double src_ymin = re.extent().ymin();
        double src_xmax = re.extent().xmax();
        double src_ymax = re.extent().ymax();
        int dst_cols = this.target().cols();
        int dst_rows = this.target().rows();
        double dst_cellwidth = (this.target().extent().xmax() - this.target().extent().xmin()) / (double)dst_cols;
        double dst_cellheight = (this.target().extent().ymax() - this.target().extent().ymin()) / (double)dst_rows;
        double xbase = this.target().extent().xmin() - src_xmin + dst_cellwidth / (double)2;
        double ybase = this.target().extent().ymax() - src_ymin - dst_cellheight / (double)2;
        double d = src_xmax - src_xmin;
        double d2 = src_ymax - src_ymin;
        int src_size = src_rows * src_cols;
        this.initSource(0, src_size);
        int n = dst_cols * dst_rows;
        MutableArrayTile resampled = this.createTile(dst_cols, dst_rows);
        int min_col = (int)(xbase / src_cellwidth);
        int max_col = (int)((xbase + (double)dst_cols * dst_cellwidth) / src_cellwidth);
        double y = ybase;
        for (int index$macro$2 = 0; index$macro$2 < dst_rows; ++index$macro$2) {
            int src_row = src_rows - (int)(y / src_cellheight) - 1;
            int src_span = src_row * src_cols;
            int dst_span = index$macro$2 * dst_cols;
            if (src_span + min_col < src_size && src_span + max_col >= 0) {
                double x = xbase;
                for (int index$macro$1 = 0; index$macro$1 < dst_cols; ++index$macro$1) {
                    int src_col = (int)(x / src_cellwidth);
                    int src_i = src_span + src_col;
                    if (src_col >= 0 && src_col < src_cols && src_i < src_size && src_i >= 0) {
                        int dst_i = dst_span + index$macro$1;
                        this.assignFromSource(src_i, resampled, dst_i);
                    }
                    x += dst_cellwidth;
                }
            }
            y -= dst_cellheight;
        }
        this.translate(resampled);
        return resampled;
    }

    public static void $init$(ReadState $this) {
    }
}

