/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.util.package$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001I4Aa\u0005\u000b\u0001;!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003+\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u000bY\u0002A\u0011A\u001c\t\u000fq\u0002!\u0019!C\u0001{!1a\b\u0001Q\u0001\nIBqa\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004A\u0001\u0001\u0006IA\r\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006#\u0002!\tA\u0015\u0005\u00061\u0002!\t!\u0017\u0005\u00069\u0002!\t!\u0018\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006]\u0002!\ta\u001c\u0002\u0012\u0005&$x)Z8US\u001a47+Z4nK:$(BA\u000b\u0017\u0003\u001d9Wm\u001c;jM\u001aT!a\u0006\r\u0002\u0005%|'BA\r\u001b\u0003\u0019\u0011\u0018m\u001d;fe*\t1$\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005!\u0012BA\u0014\u0015\u000599Um\u001c+jM\u001a\u001cVmZ7f]R\fQAY=uKN,\u0012A\u000b\t\u0004?-j\u0013B\u0001\u0017!\u0005\u0015\t%O]1z!\tyb&\u0003\u00020A\t!!)\u001f;f\u0003\u0019\u0011\u0017\u0010^3tA\u0005!1m\u001c7t!\ty2'\u0003\u00025A\t\u0019\u0011J\u001c;\u0002\tI|wo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\taJ$h\u000f\t\u0003K\u0001AQ\u0001K\u0003A\u0002)BQ!M\u0003A\u0002IBQ!N\u0003A\u0002I\nAa]5{KV\t!'A\u0003tSj,\u0007%\u0001\u0006qC\u0012$W\rZ\"pYN\f1\u0002]1eI\u0016$7i\u001c7tA\u00051q-\u001a;J]R$\"AM\"\t\u000b\u0011S\u0001\u0019\u0001\u001a\u0002\u0003%\f\u0011bZ3u\t>,(\r\\3\u0015\u0005\u001dS\u0005CA\u0010I\u0013\tI\u0005E\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\t.\u0001\rAM\u0001\u0006S:$W\r\u001f\u000b\u0003e5CQ\u0001\u0012\u0007A\u0002I\n1aZ3u)\ti\u0003\u000bC\u0003E\u001b\u0001\u0007!'A\u0002nCB$\"AK*\t\u000bQs\u0001\u0019A+\u0002\u0003\u0019\u0004Ba\b,3e%\u0011q\u000b\t\u0002\n\rVt7\r^5p]F\n\u0011\"\\1q\t>,(\r\\3\u0015\u0005)R\u0006\"\u0002+\u0010\u0001\u0004Y\u0006\u0003B\u0010W\u000f\u001e\u000b!CY=uKR{')\u001b8bef\u001cFO]5oOR\u0011aL\u001a\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA\u0001\\1oO*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005\u0019\u0019FO]5oO\")q\r\u0005a\u0001[\u0005\t!-\u0001\u0007nCB<\u0016\u000e\u001e5J]\u0012,\u0007\u0010\u0006\u0002+U\")A+\u0005a\u0001WB)q\u0004\u001c\u001a3e%\u0011Q\u000e\t\u0002\n\rVt7\r^5p]J\n!#\\1q\t>,(\r\\3XSRD\u0017J\u001c3fqR\u0011!\u0006\u001d\u0005\u0006)J\u0001\r!\u001d\t\u0006?1\u0014ti\u0012")
public class BitGeoTiffSegment
implements GeoTiffSegment {
    private final byte[] bytes;
    private final int cols;
    private final int rows;
    private final int size;
    private final int paddedCols;

    @Override
    public byte[] convert(DataType cellType) {
        return GeoTiffSegment.convert$(this, cellType);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public int size() {
        return this.size;
    }

    private int paddedCols() {
        return this.paddedCols;
    }

    @Override
    public int getInt(int i) {
        return this.get(i);
    }

    @Override
    public double getDouble(int i) {
        return this.get(i);
    }

    private int index(int i) {
        int col = i % this.cols;
        int row = i / this.cols;
        return row * this.paddedCols() + col;
    }

    public byte get(int i) {
        int i2 = this.index(i);
        return (byte)(package$.MODULE$.invertByte(this.bytes()[i2 >> 3]) >> (i2 & 7) & 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] map(Function1<Object, Object> f) {
        void var2_2;
        block4: {
            int f1;
            int f0;
            byte[] arr;
            block5: {
                block3: {
                    arr = (byte[])this.bytes().clone();
                    f0 = f.apply$mcII$sp(0) & 1;
                    f1 = f.apply$mcII$sp(1) & 1;
                    if (f0 != 0 || f1 != 0) break block3;
                    for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
                        arr[index$macro$1] = (byte)0;
                    }
                    break block4;
                }
                if (f0 != 1 || f1 != 1) break block5;
                for (int index$macro$2 = 0; index$macro$2 < this.size(); ++index$macro$2) {
                    arr[index$macro$2] = (byte)-1;
                }
                break block4;
            }
            if (f0 == 0 && f1 == 1) break block4;
            int len = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr)).size();
            for (int i = 0; i < len; ++i) {
                arr[i] = ~this.bytes()[i];
            }
        }
        return var2_2;
    }

    @Override
    public byte[] mapDouble(Function1<Object, Object> f) {
        return this.map((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)z -> {
            int n = z;
            double n2 = f.apply$mcDD$sp(n == Integer.MIN_VALUE ? Double.NaN : (double)n);
            return Double.isNaN(n2) ? Integer.MIN_VALUE : (int)n2;
        });
    }

    public String byteToBinaryString(byte b) {
        StringBuilder binaryStringBuilder = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & java.io.Serializable & Serializable)i -> binaryStringBuilder.append((128 >>> BoxesRunTime.unboxToInt((Object)i) & b) == 0 ? (char)'0' : '1'));
        return binaryStringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] mapWithIndex(Function2<Object, Object, Object> f) {
        void var2_2;
        byte[] arr = (byte[])this.bytes().clone();
        for (int index$macro$2 = 0; index$macro$2 < this.rows; ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols; ++index$macro$1) {
                int i = index$macro$2 * this.cols + index$macro$1;
                BitArrayTile$.MODULE$.update(arr, this.index(i), f.apply$mcIII$sp(i, this.getInt(i)));
            }
        }
        for (int index$macro$3 = 0; index$macro$3 < new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr)).size(); ++index$macro$3) {
            arr[index$macro$3] = package$.MODULE$.invertByte(arr[index$macro$3]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] mapDoubleWithIndex(Function2<Object, Object, Object> f) {
        void var2_2;
        byte[] arr = (byte[])this.bytes().clone();
        for (int index$macro$2 = 0; index$macro$2 < this.rows; ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols; ++index$macro$1) {
                int i = index$macro$2 * this.cols + index$macro$1;
                BitArrayTile$.MODULE$.updateDouble(arr, this.index(i), f.apply$mcDID$sp(i, this.getDouble(i)));
            }
        }
        for (int index$macro$3 = 0; index$macro$3 < new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr)).size(); ++index$macro$3) {
            arr[index$macro$3] = package$.MODULE$.invertByte(arr[index$macro$3]);
        }
        return var2_2;
    }

    public BitGeoTiffSegment(byte[] bytes, int cols, int rows) {
        this.bytes = bytes;
        this.cols = cols;
        this.rows = rows;
        GeoTiffSegment.$init$(this);
        this.size = cols * rows;
        int bytesWidth = (cols + 7) / 8;
        this.paddedCols = bytesWidth * 8;
    }
}

