/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A4Q!\u0005\n\u0002\u0002mA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\t]\u0001\u0011\t\u0011)A\u0005Q!)q\u0006\u0001C\u0001a!91\u0007\u0001b\u0001\n#!\u0004BB\u001f\u0001A\u0003%Q\u0007C\u0004?\u0001\t\u0007I\u0011A \t\r\r\u0003\u0001\u0015!\u0003A\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Y\u0005A\"\u0001M\u0011\u0015q\u0005A\"\u0001P\u0011\u0015!\u0006A\"\u0005V\u0011\u0015A\u0006A\"\u0005Z\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015a\u0007\u0001\"\u0001n\u0005U1En\\1ugI:Um\u001c+jM\u001a\u001cVmZ7f]RT!a\u0005\u000b\u0002\u000f\u001d,w\u000e^5gM*\u0011QCF\u0001\u0003S>T!a\u0006\r\u0002\rI\f7\u000f^3s\u0015\u0005I\u0012AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003II!!\n\n\u0003\u001d\u001d+w\u000eV5gMN+w-\\3oi\u0006)!-\u001f;fgV\t\u0001\u0006E\u0002\u001eS-J!A\u000b\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ua\u0013BA\u0017\u001f\u0005\u0011\u0011\u0015\u0010^3\u0002\r\tLH/Z:!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011G\r\t\u0003G\u0001AQAJ\u0002A\u0002!\naAY;gM\u0016\u0014X#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014a\u00018j_*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u0005-1En\\1u\u0005V4g-\u001a:\u0002\u000f\t,hMZ3sA\u0005!1/\u001b>f+\u0005\u0001\u0005CA\u000fB\u0013\t\u0011eDA\u0002J]R\fQa]5{K\u0002\n1aZ3u)\t1\u0015\n\u0005\u0002\u001e\u000f&\u0011\u0001J\b\u0002\u0006\r2|\u0017\r\u001e\u0005\u0006\u0015\"\u0001\r\u0001Q\u0001\u0002S\u00061q-\u001a;J]R$\"\u0001Q'\t\u000b)K\u0001\u0019\u0001!\u0002\u0013\u001d,G\u000fR8vE2,GC\u0001)T!\ti\u0012+\u0003\u0002S=\t1Ai\\;cY\u0016DQA\u0013\u0006A\u0002\u0001\u000bQ\"\u001b8u)>4En\\1u\u001fV$HC\u0001$W\u0011\u001596\u00021\u0001A\u0003\u00051\u0018\u0001\u00053pk\ndW\rV8GY>\fGoT;u)\t1%\fC\u0003X\u0019\u0001\u0007\u0001+A\u0002nCB$\"\u0001K/\t\u000byk\u0001\u0019A0\u0002\u0003\u0019\u0004B!\b1A\u0001&\u0011\u0011M\b\u0002\n\rVt7\r^5p]F\n\u0011\"\\1q\t>,(\r\\3\u0015\u0005!\"\u0007\"\u00020\u000f\u0001\u0004)\u0007\u0003B\u000fa!B\u000bA\"\\1q/&$\b.\u00138eKb$\"\u0001\u000b5\t\u000by{\u0001\u0019A5\u0011\u000buQ\u0007\t\u0011!\n\u0005-t\"!\u0003$v]\u000e$\u0018n\u001c83\u0003Ii\u0017\r\u001d#pk\ndWmV5uQ&sG-\u001a=\u0015\u0005!r\u0007\"\u00020\u0011\u0001\u0004y\u0007#B\u000fk\u0001B\u0003\u0006")
public abstract class Float32GeoTiffSegment
implements GeoTiffSegment {
    private final byte[] bytes;
    private final FloatBuffer buffer;
    private final int size;

    @Override
    public byte[] convert(DataType cellType) {
        return GeoTiffSegment.convert$(this, cellType);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    public FloatBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    public float get(int i) {
        return this.buffer().get(i);
    }

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract double getDouble(int var1);

    public abstract float intToFloatOut(int var1);

    public abstract float doubleToFloatOut(double var1);

    @Override
    public byte[] map(Function1<Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = this.intToFloatOut(f.apply$mcII$sp(this.getInt(index$macro$1)));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDouble(Function1<Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = (float)f.apply$mcDD$sp(this.getDouble(index$macro$1));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapWithIndex(Function2<Object, Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = this.intToFloatOut(f.apply$mcIII$sp(index$macro$1, this.getInt(index$macro$1)));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDoubleWithIndex(Function2<Object, Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = this.doubleToFloatOut(f.apply$mcDID$sp(index$macro$1, this.getDouble(index$macro$1)));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    public Float32GeoTiffSegment(byte[] bytes) {
        this.bytes = bytes;
        GeoTiffSegment.$init$(this);
        this.buffer = ByteBuffer.wrap(bytes).asFloatBuffer();
        this.size = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size() / 4;
    }
}

