/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.ArrayMultibandTile$;
import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.CroppedTile;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.IntCells;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.BitGeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.ByteGeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.Float32GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.Float64GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffOptions$;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.Int16GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.Int32GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.UByteGeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.UInt16GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.UInt32BandType$;
import geotrellis.raster.io.geotiff.UInt32GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GeoTiffMultibandTile$
implements scala.Serializable {
    public static GeoTiffMultibandTile$ MODULE$;

    static {
        new GeoTiffMultibandTile$();
    }

    public List<GeoTiffMultibandTile> $lessinit$greater$default$6() {
        return Nil$.MODULE$;
    }

    public GeoTiffMultibandTile apply(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, int bandCount, DataType cellType, Option<BandType> bandType, List<GeoTiffMultibandTile> overviews) {
        GeoTiffMultibandTile geoTiffMultibandTile;
        Some some;
        BandType bandType2;
        Option<BandType> option = bandType;
        if (option instanceof Some && UInt32BandType$.MODULE$.equals(bandType2 = (BandType)(some = (Some)option).value())) {
            DataType dataType = cellType;
            if (!(dataType instanceof FloatCells)) {
                throw new IllegalArgumentException("UInt32BandType should always resolve to Float celltype");
            }
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            UInt32GeoTiffMultibandTile uInt32GeoTiffMultibandTile = new UInt32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (FloatCells)((Object)noDataHandling), (List<UInt32GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$1, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof UInt32GeoTiffMultibandTile) {
                        UInt32GeoTiffMultibandTile uInt32GeoTiffMultibandTile = (UInt32GeoTiffMultibandTile)A1;
                        object = uInt32GeoTiffMultibandTile;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(GeoTiffMultibandTile x1) {
                    GeoTiffMultibandTile geoTiffMultibandTile = x1;
                    boolean bl = geoTiffMultibandTile instanceof UInt32GeoTiffMultibandTile;
                    return bl;
                }
            }, List$.MODULE$.canBuildFrom())));
            geoTiffMultibandTile = uInt32GeoTiffMultibandTile;
        } else {
            GeoTiffMultibandTile geoTiffMultibandTile2;
            DataType dataType = cellType;
            if (dataType instanceof BitCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new BitGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (BitCells)((Object)noDataHandling), (List<BitGeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$2, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof BitGeoTiffMultibandTile) {
                            BitGeoTiffMultibandTile bitGeoTiffMultibandTile = (BitGeoTiffMultibandTile)A1;
                            object = bitGeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x2) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x2;
                        boolean bl = geoTiffMultibandTile instanceof BitGeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new ByteGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (ByteCells)((Object)noDataHandling), (List<ByteGeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$3, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 instanceof ByteGeoTiffMultibandTile) {
                            ByteGeoTiffMultibandTile byteGeoTiffMultibandTile = (ByteGeoTiffMultibandTile)A1;
                            object = byteGeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x3);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x3) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x3;
                        boolean bl = geoTiffMultibandTile instanceof ByteGeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new UByteGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (UByteCells)((Object)noDataHandling), (List<UByteGeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$4, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x4;
                        if (A1 instanceof UByteGeoTiffMultibandTile) {
                            UByteGeoTiffMultibandTile uByteGeoTiffMultibandTile = (UByteGeoTiffMultibandTile)A1;
                            object = uByteGeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x4);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x4) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x4;
                        boolean bl = geoTiffMultibandTile instanceof UByteGeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Int16GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (ShortCells)((Object)noDataHandling), (List<Int16GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$5, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x5;
                        if (A1 instanceof Int16GeoTiffMultibandTile) {
                            Int16GeoTiffMultibandTile int16GeoTiffMultibandTile = (Int16GeoTiffMultibandTile)A1;
                            object = int16GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x5);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x5) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x5;
                        boolean bl = geoTiffMultibandTile instanceof Int16GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new UInt16GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (UShortCells)((Object)noDataHandling), (List<UInt16GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$6, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x6;
                        if (A1 instanceof UInt16GeoTiffMultibandTile) {
                            UInt16GeoTiffMultibandTile uInt16GeoTiffMultibandTile = (UInt16GeoTiffMultibandTile)A1;
                            object = uInt16GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x6);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x6) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x6;
                        boolean bl = geoTiffMultibandTile instanceof UInt16GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof IntCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Int32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (IntCells)((Object)noDataHandling), (List<Int32GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$7, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x7;
                        if (A1 instanceof Int32GeoTiffMultibandTile) {
                            Int32GeoTiffMultibandTile int32GeoTiffMultibandTile = (Int32GeoTiffMultibandTile)A1;
                            object = int32GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x7);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x7) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x7;
                        boolean bl = geoTiffMultibandTile instanceof Int32GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof FloatCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Float32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (FloatCells)((Object)noDataHandling), (List<Float32GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$8, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x8;
                        if (A1 instanceof Float32GeoTiffMultibandTile) {
                            Float32GeoTiffMultibandTile float32GeoTiffMultibandTile = (Float32GeoTiffMultibandTile)A1;
                            object = float32GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x8);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x8) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x8;
                        boolean bl = geoTiffMultibandTile instanceof Float32GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof DoubleCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Float64GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (DoubleCells)((Object)noDataHandling), (List<Float64GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$9, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x9;
                        if (A1 instanceof Float64GeoTiffMultibandTile) {
                            Float64GeoTiffMultibandTile float64GeoTiffMultibandTile = (Float64GeoTiffMultibandTile)A1;
                            object = float64GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x9);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x9) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x9;
                        boolean bl = geoTiffMultibandTile instanceof Float64GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else {
                throw new MatchError((Object)dataType);
            }
            geoTiffMultibandTile = geoTiffMultibandTile2;
        }
        return geoTiffMultibandTile;
    }

    public GeoTiffMultibandTile applyOverview(GeoTiffMultibandTile geoTiffTile, Compression compression, DataType cellType, Option<BandType> bandType) {
        GeoTiffMultibandTile geoTiffMultibandTile;
        Some some;
        BandType bandType2;
        int segmentCount = geoTiffTile.segmentCount();
        SegmentBytes segmentBytes = geoTiffTile.segmentBytes();
        GeoTiffSegmentLayout segmentLayout = geoTiffTile.segmentLayout();
        Compressor compressor = compression.createCompressor(segmentCount);
        Decompressor decompressor = compressor.createDecompressor();
        int bandCount = geoTiffTile.bandCount();
        List overviews = (List)geoTiffTile.overviews().map((Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$10, compression, cellType, bandType), List$.MODULE$.canBuildFrom());
        Option<BandType> option = bandType;
        if (option instanceof Some && UInt32BandType$.MODULE$.equals(bandType2 = (BandType)(some = (Some)option).value())) {
            DataType dataType = cellType;
            if (!(dataType instanceof FloatCells)) {
                throw new IllegalArgumentException("UInt32BandType should always resolve to Float celltype");
            }
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            UInt32GeoTiffMultibandTile uInt32GeoTiffMultibandTile = new UInt32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (FloatCells)((Object)noDataHandling), (List<UInt32GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$11, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof UInt32GeoTiffMultibandTile) {
                        UInt32GeoTiffMultibandTile uInt32GeoTiffMultibandTile = (UInt32GeoTiffMultibandTile)A1;
                        object = uInt32GeoTiffMultibandTile;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(GeoTiffMultibandTile x1) {
                    GeoTiffMultibandTile geoTiffMultibandTile = x1;
                    boolean bl = geoTiffMultibandTile instanceof UInt32GeoTiffMultibandTile;
                    return bl;
                }
            }, List$.MODULE$.canBuildFrom())));
            geoTiffMultibandTile = uInt32GeoTiffMultibandTile;
        } else {
            GeoTiffMultibandTile geoTiffMultibandTile2;
            DataType dataType = cellType;
            if (dataType instanceof BitCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new BitGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (BitCells)((Object)noDataHandling), (List<BitGeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$12, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof BitGeoTiffMultibandTile) {
                            BitGeoTiffMultibandTile bitGeoTiffMultibandTile = (BitGeoTiffMultibandTile)A1;
                            object = bitGeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x2) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x2;
                        boolean bl = geoTiffMultibandTile instanceof BitGeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new ByteGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (ByteCells)((Object)noDataHandling), (List<ByteGeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$13, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 instanceof ByteGeoTiffMultibandTile) {
                            ByteGeoTiffMultibandTile byteGeoTiffMultibandTile = (ByteGeoTiffMultibandTile)A1;
                            object = byteGeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x3);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x3) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x3;
                        boolean bl = geoTiffMultibandTile instanceof ByteGeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new UByteGeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (UByteCells)((Object)noDataHandling), (List<UByteGeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$14, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x4;
                        if (A1 instanceof UByteGeoTiffMultibandTile) {
                            UByteGeoTiffMultibandTile uByteGeoTiffMultibandTile = (UByteGeoTiffMultibandTile)A1;
                            object = uByteGeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x4);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x4) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x4;
                        boolean bl = geoTiffMultibandTile instanceof UByteGeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Int16GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (ShortCells)((Object)noDataHandling), (List<Int16GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$15, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x5;
                        if (A1 instanceof Int16GeoTiffMultibandTile) {
                            Int16GeoTiffMultibandTile int16GeoTiffMultibandTile = (Int16GeoTiffMultibandTile)A1;
                            object = int16GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x5);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x5) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x5;
                        boolean bl = geoTiffMultibandTile instanceof Int16GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new UInt16GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (UShortCells)((Object)noDataHandling), (List<UInt16GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$16 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$16, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x6;
                        if (A1 instanceof UInt16GeoTiffMultibandTile) {
                            UInt16GeoTiffMultibandTile uInt16GeoTiffMultibandTile = (UInt16GeoTiffMultibandTile)A1;
                            object = uInt16GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x6);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x6) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x6;
                        boolean bl = geoTiffMultibandTile instanceof UInt16GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof IntCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Int32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (IntCells)((Object)noDataHandling), (List<Int32GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$17, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x7;
                        if (A1 instanceof Int32GeoTiffMultibandTile) {
                            Int32GeoTiffMultibandTile int32GeoTiffMultibandTile = (Int32GeoTiffMultibandTile)A1;
                            object = int32GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x7);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x7) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x7;
                        boolean bl = geoTiffMultibandTile instanceof Int32GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof FloatCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Float32GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (FloatCells)((Object)noDataHandling), (List<Float32GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$18 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$18, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x8;
                        if (A1 instanceof Float32GeoTiffMultibandTile) {
                            Float32GeoTiffMultibandTile float32GeoTiffMultibandTile = (Float32GeoTiffMultibandTile)A1;
                            object = float32GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x8);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x8) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x8;
                        boolean bl = geoTiffMultibandTile instanceof Float32GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof DoubleCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffMultibandTile2 = new Float64GeoTiffMultibandTile(segmentBytes, decompressor, segmentLayout, compression, bandCount, (DoubleCells)((Object)noDataHandling), (List<Float64GeoTiffMultibandTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$19 -> MODULE$.applyOverview((GeoTiffMultibandTile)x$19, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffMultibandTile, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x9;
                        if (A1 instanceof Float64GeoTiffMultibandTile) {
                            Float64GeoTiffMultibandTile float64GeoTiffMultibandTile = (Float64GeoTiffMultibandTile)A1;
                            object = float64GeoTiffMultibandTile;
                        } else {
                            object = function1.apply(x9);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffMultibandTile x9) {
                        GeoTiffMultibandTile geoTiffMultibandTile = x9;
                        boolean bl = geoTiffMultibandTile instanceof Float64GeoTiffMultibandTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else {
                throw new MatchError((Object)dataType);
            }
            geoTiffMultibandTile = geoTiffMultibandTile2;
        }
        return geoTiffMultibandTile;
    }

    public GeoTiffMultibandTile apply(MultibandTile tile) {
        return this.apply(tile, GeoTiffOptions$.MODULE$.DEFAULT());
    }

    public GeoTiffMultibandTile apply(MultibandTile tile, GeoTiffOptions options) {
        BandType bandType = BandType$.MODULE$.forCellType(tile.cellType());
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(BoxesRunTime.unboxToInt(tile.cols()), BoxesRunTime.unboxToInt(tile.rows()), options.storageMethod(), options.interleaveMethod(), bandType);
        int segmentPixelCols = segmentLayout.tileLayout().tileCols();
        int segmentPixelRows = segmentLayout.tileLayout().tileRows();
        Iterator segments = package$.MODULE$.Iterator().range(0, BoxesRunTime.unboxToInt(tile.rows()), segmentPixelRows).flatMap((Function1 & Serializable & scala.Serializable)windowRowMin -> GeoTiffMultibandTile$.$anonfun$apply$19(tile, segmentPixelCols, segmentPixelRows, BoxesRunTime.unboxToInt((Object)windowRowMin)));
        return (GeoTiffMultibandTile)GeoTiffBuilder$.MODULE$.apply(GeoTiffBuilder$.MODULE$.multibandGeoTiffBuilder()).makeTile((Iterator<Tuple2<Product2<Object, Object>, MultibandTile>>)segments, segmentLayout, tile.cellType(), options.compression());
    }

    public Option<BandType> apply$default$7() {
        return None$.MODULE$;
    }

    public List<GeoTiffMultibandTile> apply$default$8() {
        return Nil$.MODULE$;
    }

    public Option<BandType> applyOverview$default$4() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ CroppedTile $anonfun$apply$21(MultibandTile tile$1, GridBounds bounds$1, int bandIndex) {
        return new CroppedTile(tile$1.band(bandIndex), bounds$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$20(int windowRowMin$1, int segmentPixelCols$1, int segmentPixelRows$1, MultibandTile tile$1, int windowColMin) {
        GridBounds<Object> bounds = GridBounds$.MODULE$.apply(windowColMin, windowRowMin$1, windowColMin + segmentPixelCols$1 - 1, windowRowMin$1 + segmentPixelRows$1 - 1);
        Tuple2.mcII.sp key = new Tuple2.mcII.sp(bounds.colMin$mcI$sp() / segmentPixelCols$1, bounds.rowMin$mcI$sp() / segmentPixelRows$1);
        Seq bands = (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tile$1.bandCount()).map((Function1 & Serializable & scala.Serializable)bandIndex -> GeoTiffMultibandTile$.$anonfun$apply$21(tile$1, bounds, BoxesRunTime.unboxToInt((Object)bandIndex)), IndexedSeq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)key, (Object)ArrayMultibandTile$.MODULE$.apply((Tile[])bands.toArray(ClassTag$.MODULE$.apply(Tile.class))));
    }

    public static final /* synthetic */ Iterator $anonfun$apply$19(MultibandTile tile$1, int segmentPixelCols$1, int segmentPixelRows$1, int windowRowMin) {
        return package$.MODULE$.Iterator().range(0, BoxesRunTime.unboxToInt(tile$1.cols()), segmentPixelCols$1).map((Function1 & Serializable & scala.Serializable)windowColMin -> GeoTiffMultibandTile$.$anonfun$apply$20(windowRowMin, segmentPixelCols$1, segmentPixelRows$1, tile$1, BoxesRunTime.unboxToInt((Object)windowColMin)));
    }

    private GeoTiffMultibandTile$() {
        MODULE$ = this;
    }
}

